/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class VfsImplUtil {
    private static final Logger LOG = Logger.getInstance(VfsImplUtil.class);
    private static final String FILE_SEPARATORS = "/" + (File.separatorChar == '/' ? "" : File.separator);
    private static final AtomicBoolean ourSubscribed = new AtomicBoolean(false);
    private static final Object ourLock = new Object();
    private static final Map<String, Pair<ArchiveFileSystem, ArchiveHandler>> ourHandlerCache = CollectionFactory.createFilePathMap();
    private static final Map<String, Set<String>> ourDominatorsMap = CollectionFactory.createFilePathMap();

    private VfsImplUtil() {
    }

    @Nullable
    public static NewVirtualFile findFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path2) {
        Pair<NewVirtualFile, Iterable<String>> data2;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            VfsImplUtil.$$$reportNull$$$0(1);
        }
        if ((data2 = VfsImplUtil.prepare(vfs, path2)) == null) {
            return null;
        }
        NewVirtualFile file2 = (NewVirtualFile)data2.first;
        for (String pathElement : (Iterable)data2.second) {
            NewVirtualFile canonicalFile;
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            file2 = "..".equals(pathElement) ? (file2.is(VFileProperty.SYMLINK) ? ((canonicalFile = file2.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : file2.getParent()) : file2.findChild(pathElement);
            if (file2 != null) continue;
            return null;
        }
        return file2;
    }

    @Nullable
    public static NewVirtualFile findFileByPathIfCached(@NotNull NewVirtualFileSystem vfs, @NotNull String path2) {
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            VfsImplUtil.$$$reportNull$$$0(3);
        }
        return (NewVirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)vfs, (String)path2).first;
    }

    @NotNull
    public static Pair<NewVirtualFile, NewVirtualFile> findCachedFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path2) {
        Pair<NewVirtualFile, Iterable<String>> data2;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(4);
        }
        if (path2 == null) {
            VfsImplUtil.$$$reportNull$$$0(5);
        }
        if ((data2 = VfsImplUtil.prepare(vfs, path2)) == null) {
            Pair pair = Pair.empty();
            if (pair == null) {
                VfsImplUtil.$$$reportNull$$$0(6);
            }
            return pair;
        }
        NewVirtualFile file2 = (NewVirtualFile)data2.first;
        for (String pathElement : (Iterable)data2.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            NewVirtualFile last = file2;
            if ("..".equals(pathElement)) {
                if (file2.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file2.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? (NewVirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)vfs, (String)canonicalPath).first : null;
                    file2 = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file2 = file2.getParent();
                }
            } else {
                file2 = file2.findChildIfCached(pathElement);
            }
            if (file2 != null) continue;
            return new Pair(null, (Object)last);
        }
        return new Pair((Object)file2, null);
    }

    @Nullable
    public static NewVirtualFile refreshAndFindFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path2) {
        Pair<NewVirtualFile, Iterable<String>> data2;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(7);
        }
        if (path2 == null) {
            VfsImplUtil.$$$reportNull$$$0(8);
        }
        if ((data2 = VfsImplUtil.prepare(vfs, path2)) == null) {
            return null;
        }
        NewVirtualFile file2 = (NewVirtualFile)data2.first;
        for (String pathElement : (Iterable)data2.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file2.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file2.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.refreshAndFindFileByPath(vfs, canonicalPath) : null;
                    file2 = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file2 = file2.getParent();
                }
            } else {
                file2 = file2.refreshAndFindChild(pathElement);
            }
            if (file2 != null) continue;
            return null;
        }
        return file2;
    }

    @Nullable
    private static Pair<NewVirtualFile, Iterable<String>> prepare(@NotNull NewVirtualFileSystem vfs, @NotNull String path2) {
        String normalizedPath;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(9);
        }
        if (path2 == null) {
            VfsImplUtil.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmptyOrSpaces((String)(normalizedPath = vfs.normalize(path2)))) {
            return null;
        }
        String basePath = vfs.extractRootPath(normalizedPath);
        if (StringUtil.isEmptyOrSpaces((String)basePath) || basePath.length() > normalizedPath.length()) {
            LOG.warn(vfs + " has extracted incorrect root '" + basePath + "' from '" + normalizedPath + "' (original '" + path2 + "')");
            return null;
        }
        NewVirtualFile root = ManagingFS.getInstance().findRoot(basePath, vfs);
        if (root == null || !root.exists()) {
            return null;
        }
        Iterable parts = StringUtil.tokenize((String)normalizedPath.substring(basePath.length()), (String)FILE_SEPARATORS);
        return new Pair((Object)root, (Object)parts);
    }

    public static void refresh(@NotNull NewVirtualFileSystem vfs, boolean asynchronous) {
        VirtualFile[] roots;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(11);
        }
        if ((roots = ManagingFS.getInstance().getRoots(vfs)).length > 0) {
            RefreshQueue.getInstance().refresh(asynchronous, true, null, roots);
        }
    }

    public static void forceSyncRefresh(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsImplUtil.$$$reportNull$$$0(12);
        }
        RefreshQueue.getInstance().processSingleEvent(false, (VFileEvent)new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T extends ArchiveHandler> T getHandler(@NotNull ArchiveFileSystem vfs, @NotNull VirtualFile entryFile, @NotNull Function<? super String, ? extends T> producer) {
        ArchiveHandler handler2;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(13);
        }
        if (entryFile == null) {
            VfsImplUtil.$$$reportNull$$$0(14);
        }
        if (producer == null) {
            VfsImplUtil.$$$reportNull$$$0(15);
        }
        String localPath = vfs.extractLocalPath(VfsUtilCore.getRootFile((VirtualFile)entryFile).getPath());
        VfsImplUtil.checkSubscription();
        Object object = ourLock;
        synchronized (object) {
            ArchiveHandler t;
            Pair record = ourHandlerCache.get(localPath);
            if (record == null) {
                handler2 = (ArchiveHandler)producer.fun((Object)localPath);
                record = new Pair((Object)vfs, (Object)handler2);
                ourHandlerCache.put(localPath, (Pair<ArchiveFileSystem, ArchiveHandler>)record);
                VfsImplUtil.forEachDirectoryComponent(localPath, containingDirectoryPath -> {
                    Set handlers = ourDominatorsMap.computeIfAbsent((String)containingDirectoryPath, __ -> new HashSet());
                    handlers.add(localPath);
                });
            }
            handler2 = t = (ArchiveHandler)record.second;
        }
        ArchiveHandler archiveHandler = handler2;
        if (archiveHandler == null) {
            VfsImplUtil.$$$reportNull$$$0(16);
        }
        return (T)archiveHandler;
    }

    private static void forEachDirectoryComponent(@NotNull String rootPath, @NotNull Consumer<? super String> consumer) {
        if (rootPath == null) {
            VfsImplUtil.$$$reportNull$$$0(17);
        }
        if (consumer == null) {
            VfsImplUtil.$$$reportNull$$$0(18);
        }
        int index2 = rootPath.lastIndexOf(47);
        while (index2 > 0) {
            String containingDirectoryPath = rootPath.substring(0, index2);
            consumer.accept(containingDirectoryPath);
            index2 = rootPath.lastIndexOf(47, index2 - 1);
        }
    }

    private static void checkSubscription() {
        if (ourSubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDisposed()) {
            return;
        }
        MessageBusConnection connection = app.getMessageBus().connect((Disposable)app);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                InvalidationState state = null;
                Object object = ourLock;
                synchronized (object) {
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
                        String path2 = vFileEvent.getPath();
                        VirtualFile file2 = vFileEvent.getFile();
                        if (file2 == null || !file2.isDirectory()) {
                            state = VfsImplUtil.invalidate(state, path2);
                            continue;
                        }
                        ArrayList affectedPaths = (ArrayList)((Object)ourDominatorsMap.get(path2));
                        if (affectedPaths == null) continue;
                        affectedPaths = new ArrayList(affectedPaths);
                        for (String affectedPath : affectedPaths) {
                            state = VfsImplUtil.invalidate(state, affectedPath);
                        }
                    }
                }
                if (state != null) {
                    state.scheduleRefresh();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/VfsImplUtil$1", "after"));
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                Object object = ourLock;
                synchronized (object) {
                    ourHandlerCache.clear();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/vfs/newvfs/VfsImplUtil$2", "pluginUnloaded"));
            }
        });
    }

    @Nullable
    private static InvalidationState invalidate(@Nullable InvalidationState state, @NotNull String path2) {
        Pair<ArchiveFileSystem, ArchiveHandler> handlerPair;
        if (path2 == null) {
            VfsImplUtil.$$$reportNull$$$0(19);
        }
        if ((handlerPair = ourHandlerCache.remove(path2)) != null) {
            ((ArchiveHandler)handlerPair.second).dispose();
            VfsImplUtil.forEachDirectoryComponent(path2, containingDirectoryPath -> {
                Set<String> handlers = ourDominatorsMap.get(containingDirectoryPath);
                if (handlers != null && handlers.remove(path2) && handlers.isEmpty()) {
                    ourDominatorsMap.remove(containingDirectoryPath);
                }
            });
            if (state == null) {
                state = new InvalidationState();
            }
            state.registerPathToRefresh(path2, (ArchiveFileSystem)handlerPair.first);
        }
        return state;
    }

    public static VFilePropertyChangeEvent generateCaseSensitivityChangedEventForUnknownCase(@NotNull VirtualFile parent, @NotNull String childName) {
        if (parent == null) {
            VfsImplUtil.$$$reportNull$$$0(20);
        }
        if (childName == null) {
            VfsImplUtil.$$$reportNull$$$0(21);
        }
        if (((VirtualDirectoryImpl)parent).getChildrenCaseSensitivity() != FileAttributes.CaseSensitivity.UNKNOWN) {
            return null;
        }
        FileAttributes.CaseSensitivity sensitivity = FileSystemUtil.readParentCaseSensitivity((File)new File(parent.getPath(), childName));
        return VfsImplUtil.generateCaseSensitivityChangedEvent(parent, sensitivity);
    }

    public static VFilePropertyChangeEvent generateCaseSensitivityChangedEvent(@NotNull VirtualFile dir, @NotNull FileAttributes.CaseSensitivity actualCaseSensitivity) {
        if (dir == null) {
            VfsImplUtil.$$$reportNull$$$0(22);
        }
        if (actualCaseSensitivity == null) {
            VfsImplUtil.$$$reportNull$$$0(23);
        }
        if (actualCaseSensitivity != FileAttributes.CaseSensitivity.UNKNOWN) {
            if (dir.getFileSystem().isCaseSensitive() != (actualCaseSensitivity == FileAttributes.CaseSensitivity.SENSITIVE)) {
                return new VFilePropertyChangeEvent(null, dir, "CHILDREN_CASE_SENSITIVITY", (Object)FileAttributes.CaseSensitivity.UNKNOWN, (Object)actualCaseSensitivity, true);
            }
            PersistentFSImpl.executeChangeCaseSensitivity(dir, actualCaseSensitivity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void releaseHandler(@NotNull String localPath) {
        if (localPath == null) {
            VfsImplUtil.$$$reportNull$$$0(24);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        Object object = ourLock;
        synchronized (object) {
            InvalidationState state = VfsImplUtil.invalidate(null, localPath);
            if (state == null) {
                throw new IllegalArgumentException(localPath + " not in " + ourHandlerCache.keySet());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VFileEvent> getJarInvalidationEvents(@NotNull VFileEvent event, @NotNull List<? super Runnable> outApplyActions) {
        List<String> jarPaths;
        if (event == null) {
            VfsImplUtil.$$$reportNull$$$0(25);
        }
        if (outApplyActions == null) {
            VfsImplUtil.$$$reportNull$$$0(26);
        }
        if (!(event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent || event instanceof VFilePropertyChangeEvent && "name".equals(((VFilePropertyChangeEvent)event).getPropertyName()))) {
            return Collections.emptyList();
        }
        String path2 = event instanceof VFilePropertyChangeEvent ? ((VFilePropertyChangeEvent)event).getOldPath() : (event instanceof VFileMoveEvent ? ((VFileMoveEvent)event).getOldPath() : event.getPath());
        VirtualFile file2 = event.getFile();
        if (file2 == null) {
            return Collections.emptyList();
        }
        VirtualFileSystem entryFileSystem = file2.getFileSystem();
        VirtualFile local = null;
        if (entryFileSystem instanceof ArchiveFileSystem) {
            local = ((ArchiveFileSystem)entryFileSystem).getLocalByEntry(file2);
            path2 = local == null ? ((ArchiveFileSystem)entryFileSystem).extractLocalPath(path2) : local.getPath();
        }
        Object object = ourLock;
        synchronized (object) {
            jarPaths = (List<String>)((Object)ourDominatorsMap.get(path2));
        }
        if (jarPaths == null) {
            jarPaths = Collections.singletonList(path2);
        }
        ArrayList<VFileEvent> events = new ArrayList<VFileEvent>(jarPaths.size());
        for (String jarPath : jarPaths) {
            Pair<ArchiveFileSystem, ArchiveHandler> handlerPair = ourHandlerCache.get(jarPath);
            if (handlerPair == null) continue;
            if (entryFileSystem instanceof LocalFileSystem) {
                ArchiveFileSystem fileSystem = (ArchiveFileSystem)handlerPair.first;
                NewVirtualFile root = ManagingFS.getInstance().findRoot(fileSystem.composeRootPath(jarPath), (NewVirtualFileSystem)fileSystem);
                if (root == null) continue;
                VFileDeleteEvent jarDeleteEvent = new VFileDeleteEvent(event.getRequestor(), (VirtualFile)root, event.isFromRefresh());
                Runnable runnable2 = () -> {
                    Pair<ArchiveFileSystem, ArchiveHandler> pair = ourHandlerCache.remove(jarPath);
                    if (pair != null) {
                        ((ArchiveHandler)pair.second).dispose();
                        Object object = ourLock;
                        synchronized (object) {
                            VfsImplUtil.forEachDirectoryComponent(jarPath, containingDirectoryPath -> {
                                Set<String> handlers = ourDominatorsMap.get(containingDirectoryPath);
                                if (handlers != null && handlers.remove(jarPath) && handlers.isEmpty()) {
                                    ourDominatorsMap.remove(containingDirectoryPath);
                                }
                            });
                        }
                    }
                };
                events.add((VFileEvent)jarDeleteEvent);
                outApplyActions.add(runnable2);
                continue;
            }
            if (local == null) continue;
            VFileDeleteEvent localJarDeleteEvent = file2.getParent() == null ? new VFileDeleteEvent(event.getRequestor(), local, event.isFromRefresh()) : new VFileContentChangeEvent(event.getRequestor(), local, local.getModificationStamp(), local.getModificationStamp(), event.isFromRefresh());
            events.add((VFileEvent)localJarDeleteEvent);
        }
        return events;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/VfsImplUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualCaseSensitivity";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outApplyActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/VfsImplUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findCachedFileByPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCachedFileByPath";
                break;
            }
            case 6: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forceSyncRefresh";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "forEachDirectoryComponent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generateCaseSensitivityChangedEventForUnknownCase";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generateCaseSensitivityChangedEvent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "releaseHandler";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getJarInvalidationEvents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InvalidationState {
        private Set<Pair<String, ArchiveFileSystem>> myRootsToRefresh;

        private InvalidationState() {
        }

        private void registerPathToRefresh(@NotNull String path2, @NotNull ArchiveFileSystem vfs) {
            if (path2 == null) {
                InvalidationState.$$$reportNull$$$0(0);
            }
            if (vfs == null) {
                InvalidationState.$$$reportNull$$$0(1);
            }
            if (this.myRootsToRefresh == null) {
                this.myRootsToRefresh = new HashSet<Pair<String, ArchiveFileSystem>>();
            }
            this.myRootsToRefresh.add((Pair<String, ArchiveFileSystem>)new Pair((Object)path2, (Object)vfs));
        }

        private void scheduleRefresh() {
            if (this.myRootsToRefresh != null) {
                List rootsToRefresh = ContainerUtil.mapNotNull(this.myRootsToRefresh, pathAndFs -> ManagingFS.getInstance().findRoot(((ArchiveFileSystem)pathAndFs.second).composeRootPath((String)pathAndFs.first), (NewVirtualFileSystem)pathAndFs.second));
                for (NewVirtualFile root : rootsToRefresh) {
                    root.markDirtyRecursively();
                }
                boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                RefreshQueue.getInstance().refresh(async, true, null, (Collection)rootsToRefresh);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vfs";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/newvfs/VfsImplUtil$InvalidationState";
            objectArray[2] = "registerPathToRefresh";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

