/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.annotations.Attribute;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileManagerImpl
extends VirtualFileManagerEx
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(VirtualFileManagerImpl.class);
    private static final ExtensionPointImpl<VirtualFileManagerListener> MANAGER_LISTENER_EP = ((ExtensionsAreaImpl)ApplicationManager.getApplication().getExtensionArea()).getExtensionPoint("com.intellij.virtualFileManagerListener");
    private final List<? extends VirtualFileSystem> myPreCreatedFileSystems;
    private final KeyedExtensionCollector<VirtualFileSystem, String> myCollector;
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster;
    private final List<VirtualFileManagerListener> myVirtualFileManagerListeners;
    private final List<AsyncFileListener> myAsyncFileListeners;
    private int myRefreshCount;

    public VirtualFileManagerImpl(@NotNull List<? extends VirtualFileSystem> preCreatedFileSystems) {
        if (preCreatedFileSystems == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(0);
        }
        this(preCreatedFileSystems, ApplicationManager.getApplication().getMessageBus());
    }

    public VirtualFileManagerImpl(@NotNull List<? extends VirtualFileSystem> preCreatedFileSystems, @NotNull MessageBus bus) {
        if (preCreatedFileSystems == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(1);
        }
        if (bus == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(2);
        }
        this.myCollector = new KeyedExtensionCollector(VirtualFileSystem.EP_NAME);
        this.myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
        this.myVirtualFileManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myAsyncFileListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPreCreatedFileSystems = new ArrayList<VirtualFileSystem>(preCreatedFileSystems);
        for (VirtualFileSystem virtualFileSystem : preCreatedFileSystems) {
            this.myCollector.addExplicitExtension((Object)virtualFileSystem.getProtocol(), (Object)virtualFileSystem);
            if (virtualFileSystem instanceof CachingVirtualFileSystem) continue;
            virtualFileSystem.addVirtualFileListener((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        if (LOG.isDebugEnabled() && !ApplicationManagerEx.isInStressTest()) {
            this.addVirtualFileListener(new LoggingListener());
        }
        bus.connect().subscribe(VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    @NotNull
    public List<VirtualFileSystem> getPhysicalFileSystems() {
        ArrayList<VirtualFileSystem> physicalFileSystems = new ArrayList<VirtualFileSystem>(this.myPreCreatedFileSystems);
        ExtensionPoint point = this.myCollector.getPoint();
        if (point != null) {
            for (KeyedLazyInstance bean : point.getExtensionList()) {
                if (!((VirtualFileSystemBean)bean).physical) continue;
                VirtualFileSystem fileSystem = (VirtualFileSystem)bean.getInstance();
                physicalFileSystems.add(fileSystem);
            }
        }
        ArrayList<VirtualFileSystem> arrayList = physicalFileSystems;
        if (arrayList == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void dispose() {
    }

    public long getStructureModificationCount() {
        return 0L;
    }

    @Nullable
    public VirtualFileSystem getFileSystem(@Nullable String protocol) {
        if (protocol == null) {
            return null;
        }
        List systems = this.myCollector.forKey((Object)protocol);
        return this.selectFileSystem(protocol, systems);
    }

    @Nullable
    protected VirtualFileSystem selectFileSystem(@NotNull String protocol, @NotNull List<? extends VirtualFileSystem> candidates) {
        int size;
        if (protocol == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(4);
        }
        if (candidates == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(5);
        }
        if ((size = candidates.size()) == 0) {
            return null;
        }
        if (size > 1) {
            LOG.error(protocol + ": " + candidates);
        }
        return candidates.get(0);
    }

    public long syncRefresh() {
        return this.doRefresh(false, null);
    }

    public long asyncRefresh(@Nullable Runnable postAction) {
        return this.doRefresh(true, postAction);
    }

    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        for (VirtualFileSystem fileSystem : this.getPhysicalFileSystems()) {
            if (fileSystem instanceof CachingVirtualFileSystem) continue;
            fileSystem.refresh(asynchronous);
        }
        return 0L;
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        for (VirtualFileSystem fileSystem : this.getPhysicalFileSystems()) {
            if (fileSystem instanceof CachingVirtualFileSystem) {
                ((CachingVirtualFileSystem)fileSystem).refreshWithoutFileWatcher(asynchronous);
                continue;
            }
            fileSystem.refresh(asynchronous);
        }
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(6);
        }
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener2);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(8);
        }
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(9);
        }
        this.myVirtualFileListenerMulticaster.removeListener((EventListener)listener2);
    }

    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(10);
        }
        this.myVirtualFileManagerListeners.add(listener2);
    }

    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(12);
        }
        this.addVirtualFileManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeVirtualFileManagerListener(listener2));
    }

    public void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(13);
        }
        this.myVirtualFileManagerListeners.remove(listener2);
    }

    public void addAsyncFileListener(@NotNull AsyncFileListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(14);
        }
        if (parentDisposable == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(15);
        }
        this.myAsyncFileListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myAsyncFileListeners.remove(listener2));
    }

    @ApiStatus.Internal
    public void addAsyncFileListenersTo(@NotNull List<? super AsyncFileListener> listeners2) {
        if (listeners2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(16);
        }
        listeners2.addAll(this.myAsyncFileListeners);
    }

    public void notifyPropertyChanged(@NotNull VirtualFile virtualFile2, @VirtualFile.PropName @NotNull String property2, Object oldValue, Object newValue2) {
        if (virtualFile2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(17);
        }
        if (property2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(18);
        }
        Application app = ApplicationManager.getApplication();
        ((AppUIExecutor)AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().expireWith((Disposable)app)).submit(() -> {
            if (virtualFile2.isValid()) {
                WriteAction.run(() -> {
                    List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, virtualFile2, property2, oldValue, newValue2, false));
                    BulkFileListener listener2 = (BulkFileListener)app.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                    listener2.before(events);
                    listener2.after(events);
                });
            }
        });
    }

    @Override
    public void fireBeforeRefreshStart(boolean asynchronous) {
        if (this.myRefreshCount++ != 0) {
            return;
        }
        for (VirtualFileManagerListener listener3 : this.myVirtualFileManagerListeners) {
            try {
                listener3.beforeRefreshStart(asynchronous);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        ExtensionProcessingHelper.forEachExtensionSafe(MANAGER_LISTENER_EP, listener2 -> listener2.beforeRefreshStart(asynchronous));
    }

    @Override
    public void fireAfterRefreshFinish(boolean asynchronous) {
        if (--this.myRefreshCount != 0) {
            return;
        }
        for (VirtualFileManagerListener listener3 : this.myVirtualFileManagerListeners) {
            try {
                listener3.afterRefreshFinish(asynchronous);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        ExtensionProcessingHelper.forEachExtensionSafe(MANAGER_LISTENER_EP, listener2 -> listener2.afterRefreshFinish(asynchronous));
    }

    public long getModificationCount() {
        return 0L;
    }

    public int storeName(@NotNull String name) {
        if (name == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(19);
        }
        throw new AbstractMethodError();
    }

    @NotNull
    public CharSequence getVFileName(int nameId) {
        throw new AbstractMethodError();
    }

    public VirtualFile findFileByUrl(@NotNull String url) {
        if (url == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(20);
        }
        return this.findByUrl(url, false);
    }

    public VirtualFile refreshAndFindFileByUrl(@NotNull String url) {
        if (url == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(21);
        }
        return this.findByUrl(url, true);
    }

    @Nullable
    private VirtualFile findByUrl(@NotNull String url, boolean refresh2) {
        int protocolSepIndex;
        VirtualFileSystem fileSystem;
        if (url == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(22);
        }
        VirtualFileSystem virtualFileSystem = fileSystem = (protocolSepIndex = url.indexOf("://")) < 0 ? null : this.getFileSystem(url.substring(0, protocolSepIndex));
        if (fileSystem == null) {
            return null;
        }
        String path2 = url.substring(protocolSepIndex + "://".length());
        return refresh2 ? fileSystem.refreshAndFindFileByPath(path2) : fileSystem.findFileByPath(path2);
    }

    @Nullable
    public VirtualFile findFileByNioPath(@NotNull Path path2) {
        if (path2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(23);
        }
        return this.findByNioPath(path2, false);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByNioPath(@NotNull Path path2) {
        if (path2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(24);
        }
        return this.findByNioPath(path2, true);
    }

    @Nullable
    private VirtualFile findByNioPath(@NotNull Path nioPath, boolean refresh2) {
        if (nioPath == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(25);
        }
        if (!FileSystems.getDefault().equals(nioPath.getFileSystem())) {
            return null;
        }
        VirtualFileSystem fileSystem = this.getFileSystem("file");
        if (fileSystem == null) {
            return null;
        }
        String path2 = nioPath.toString();
        return refresh2 ? fileSystem.refreshAndFindFileByPath(path2) : fileSystem.findFileByPath(path2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preCreatedFileSystems";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nioPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalFileSystems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectFileSystem";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFileListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeVirtualFileListener";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFileManagerListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeVirtualFileManagerListener";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAsyncFileListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addAsyncFileListenersTo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifyPropertyChanged";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "storeName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFileByUrl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByUrl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findByUrl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFileByNioPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByNioPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findByNioPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(0);
            }
            LOG.debug("propertyChanged: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(1);
            }
            LOG.debug("contentsChanged: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(2);
            }
            LOG.debug("fileCreated: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(3);
            }
            LOG.debug("fileDeleted: file = " + event.getFile() + ", parent = " + event.getParent() + ", requestor = " + event.getRequestor());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(4);
            }
            LOG.debug("fileMoved: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(5);
            }
            LOG.debug("fileCopied: file = " + event.getFile() + ", originalFile = " + event.getOriginalFile() + ", requestor = " + event.getRequestor());
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(6);
            }
            LOG.debug("beforeContentsChange: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(7);
            }
            LOG.debug("beforePropertyChange: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(8);
            }
            LOG.debug("beforeFileDeletion: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            LOG.assertTrue(event.getFile().isValid());
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(9);
            }
            LOG.debug("beforeFileMovement: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeContentsChange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VirtualFileSystemBean
    extends KeyedLazyInstanceEP<VirtualFileSystem> {
        @Attribute
        public boolean physical;

        private VirtualFileSystemBean() {
        }
    }
}

