/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DummyCachingFileSystem<T extends VirtualFile>
extends DummyFileSystem {
    private final String myProtocol;
    private final Map<String, T> myCachedFiles;
    private static final Key<Boolean> DISPOSE_CALLBACK = Key.create((String)"DISPOSE_CALLBACK");

    public DummyCachingFileSystem(@NotNull String protocol) {
        if (protocol == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(0);
        }
        this.myCachedFiles = ConcurrentFactoryMap.create(this::findFileByPathInner, ContainerUtil::createConcurrentWeakValueMap);
        this.myProtocol = protocol;
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                DummyCachingFileSystem.this.onProjectOpened(project);
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                DummyCachingFileSystem.this.registerDisposeCallback(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.initProjectMap();
    }

    @Override
    @NotNull
    public final String getProtocol() {
        String string = this.myProtocol;
        if (string == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public final VirtualFile createRoot(@NotNull String name) {
        if (name == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile2 = super.createRoot(name);
        if (virtualFile2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    public final T findFileByPath(@NotNull String path2) {
        if (path2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(4);
        }
        return (T)((VirtualFile)this.myCachedFiles.get(path2));
    }

    @Override
    @NotNull
    public String extractPresentableUrl(@NotNull String path2) {
        T file2;
        if (path2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(5);
        }
        String string = (file2 = this.findFileByPath(path2)) != null ? this.getPresentableUrl((VirtualFile)file2) : super.extractPresentableUrl(path2);
        if (string == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected String getPresentableUrl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(7);
        }
        return file2.getPresentableName();
    }

    protected abstract T findFileByPathInner(@NotNull String var1);

    protected void doRenameFile(@NotNull VirtualFile vFile, @NotNull String newName2) {
        if (vFile == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(8);
        }
        if (newName2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException("not implemented");
    }

    @Nullable
    public Project getProject(@NotNull String projectId) {
        if (projectId == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(10);
        }
        Project project = ProjectManager.getInstance().findOpenProjectByHash(projectId);
        if (ApplicationManager.getApplication().isUnitTestMode() && project != null) {
            this.registerDisposeCallback(project);
            DISPOSE_CALLBACK.set((UserDataHolder)project, (Object)Boolean.TRUE);
        }
        return project;
    }

    @NotNull
    public Collection<T> getCachedFiles() {
        Collection collection = this.myCachedFiles.values().stream().filter(Objects::nonNull).filter(VirtualFile::isValid).collect(Collectors.toList());
        if (collection == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(11);
        }
        return collection;
    }

    private void onProjectClosed() {
        this.clearCache();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.cleanup();
        }
    }

    public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(12);
        }
        this.clearCache();
    }

    private void registerDisposeCallback(@NotNull Project project) {
        if (project == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(13);
        }
        if (Boolean.TRUE.equals(DISPOSE_CALLBACK.get((UserDataHolder)project))) {
            return;
        }
        Disposer.register((Disposable)project, () -> this.onProjectClosed());
    }

    private void initProjectMap() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!project.isOpen()) continue;
            this.onProjectOpened(project);
        }
    }

    protected void clearCache() {
        this.retainFiles(VirtualFile::isValid);
    }

    protected void retainFiles(@NotNull Predicate<? super VirtualFile> c) {
        if (c == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(14);
        }
        for (Map.Entry<String, T> entry2 : this.myCachedFiles.entrySet()) {
            VirtualFile t = (VirtualFile)entry2.getValue();
            if (t != null && c.test((VirtualFile)t)) continue;
            this.myCachedFiles.remove(entry2.getKey());
        }
    }

    private void cleanup() {
        this.myCachedFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName2) {
        if (vFile == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(15);
        }
        if (newName2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(16);
        }
        String oldName = vFile.getName();
        this.beforeFileRename(vFile, requestor, oldName, newName2);
        try {
            this.doRenameFile(vFile, newName2);
        }
        finally {
            this.fileRenamed(vFile, requestor, oldName, newName2);
        }
    }

    protected void beforeFileRename(@NotNull VirtualFile file2, Object requestor, @NotNull String oldName, @NotNull String newName2) {
        if (file2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(17);
        }
        if (oldName == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(18);
        }
        if (newName2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(19);
        }
        this.fireBeforePropertyChange(requestor, file2, "name", oldName, newName2);
        this.myCachedFiles.remove(file2.getPath());
    }

    protected void fileRenamed(@NotNull VirtualFile file2, Object requestor, @NotNull String oldName, @NotNull String newName2) {
        if (file2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(20);
        }
        if (oldName == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(21);
        }
        if (newName2 == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(22);
        }
        this.myCachedFiles.put(file2.getPath(), file2);
        this.firePropertyChanged(requestor, file2, "name", oldName, newName2);
    }

    @NotNull
    protected static String escapeSlash(@NotNull String name) {
        if (name == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(23);
        }
        String string = StringUtil.replace((String)name, (String)"/", (String)"&slash;");
        if (string == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    protected static String unescapeSlash(@NotNull String name) {
        if (name == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(25);
        }
        String string = StringUtil.replace((String)name, (String)"&slash;", (String)"/");
        if (string == null) {
            DummyCachingFileSystem.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem";
                break;
            }
            case 2: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedFiles";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSlash";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSlash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 24: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableUrl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRenameFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerDisposeCallback";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "retainFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "beforeFileRename";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fileRenamed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlash";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSlash";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

