/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.GroupTreeNode;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class UpdateRootNode
extends GroupTreeNode {
    private final Project myProject;

    public UpdateRootNode(UpdatedFiles updatedFiles, Project project, @Nls String rootName, ActionInfo actionInfo) {
        super(rootName, false, SimpleTextAttributes.ERROR_ATTRIBUTES, project, Collections.emptyMap(), null);
        this.myProject = project;
        this.addGroupsToNode(updatedFiles.getTopLevelGroups(), this, actionInfo);
    }

    private void addGroupsToNode(List<? extends FileGroup> groups2, AbstractTreeNode owner, ActionInfo actionInfo) {
        for (FileGroup fileGroup : groups2) {
            GroupTreeNode node = this.addFileGroup(fileGroup, owner, actionInfo);
            if (node == null) continue;
            this.addGroupsToNode(fileGroup.getChildren(), node, actionInfo);
        }
    }

    @Nullable
    private GroupTreeNode addFileGroup(FileGroup fileGroup, AbstractTreeNode parent, ActionInfo actionInfo) {
        if (fileGroup.isEmpty()) {
            return null;
        }
        GroupTreeNode group2 = new GroupTreeNode(actionInfo.getGroupName(fileGroup), fileGroup.getSupportsDeletion(), fileGroup.getInvalidAttributes(), this.myProject, fileGroup.getErrorsMap(), fileGroup.getId());
        Disposer.register((Disposable)this, (Disposable)group2);
        parent.add(group2);
        for (String s : fileGroup.getFiles()) {
            group2.addFilePath(s);
        }
        return group2;
    }

    @Override
    public boolean getSupportsDeletion() {
        return false;
    }
}

