/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeUtils;", "", "()V", "putRevisionInfo", "", "contents", "", "Lcom/intellij/diff/contents/DiffContent;", "data", "Lcom/intellij/openapi/vcs/merge/MergeData;", "putRevisionInfos", "request", "Lcom/intellij/diff/merge/MergeRequest;", "Lcom/intellij/diff/requests/DiffRequest;", "intellij.platform.vcs.impl"})
public final class MergeUtils {
    @NotNull
    public static final MergeUtils INSTANCE;

    @JvmStatic
    public static final void putRevisionInfos(@NotNull MergeRequest request, @NotNull MergeData data2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (request instanceof ThreesideMergeRequest) {
            List list2 = ((ThreesideMergeRequest)request).getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"request.contents");
            List contents = list2;
            INSTANCE.putRevisionInfo(contents, data2);
        }
    }

    @JvmStatic
    public static final void putRevisionInfos(@NotNull DiffRequest request, @NotNull MergeData data2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (request instanceof ContentDiffRequest) {
            List list2 = ((ContentDiffRequest)request).getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"request.contents");
            List contents = list2;
            if (contents.size() == 3) {
                INSTANCE.putRevisionInfo(contents, data2);
            }
        }
    }

    private final void putRevisionInfo(List<? extends DiffContent> contents, MergeData data2) {
        for (ThreeSide side : ThreeSide.values()) {
            DiffContent content2 = (DiffContent)side.select(contents);
            FilePath filePath = (FilePath)side.select((Object)data2.CURRENT_FILE_PATH, (Object)data2.ORIGINAL_FILE_PATH, (Object)data2.LAST_FILE_PATH);
            VcsRevisionNumber revision = (VcsRevisionNumber)side.select((Object)data2.CURRENT_REVISION_NUMBER, (Object)data2.ORIGINAL_REVISION_NUMBER, (Object)data2.LAST_REVISION_NUMBER);
            if (filePath == null || revision == null) continue;
            content2.putUserData(DiffVcsDataKeys.REVISION_INFO, (Object)Pair.create((Object)filePath, (Object)revision));
        }
    }

    private MergeUtils() {
    }

    static {
        MergeUtils mergeUtils;
        INSTANCE = mergeUtils = new MergeUtils();
    }
}

