/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.FilePathMapping;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class NewMappings
implements Disposable {
    private static final Comparator<MappedRoot> ROOT_COMPARATOR = Comparator.comparing(it -> it.root.getPath());
    private static final Comparator<VcsDirectoryMapping> MAPPINGS_COMPARATOR = Comparator.comparing(VcsDirectoryMapping::getDirectory);
    private static final Logger LOG = Logger.getInstance(NewMappings.class);
    private final Object myUpdateLock;
    private FileWatchRequestsManager myFileWatchRequestsManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final Project myProject;
    @NotNull
    private Disposable myFilePointerDisposable;
    private volatile List<VcsDirectoryMapping> myMappings;
    private volatile List<MappedRoot> myMappedRoots;
    private volatile RootMapping myMappedRootsMapping;
    private volatile List<AbstractVcs> myActiveVcses;
    private volatile boolean myActivated;
    @NotNull
    private final MergingUpdateQueue myRootUpdateQueue;
    private final VirtualFilePointerListener myFilePointerListener;

    public NewMappings(@NotNull Project project, @NotNull ProjectLevelVcsManagerImpl vcsManager2) {
        if (project == null) {
            NewMappings.$$$reportNull$$$0(0);
        }
        if (vcsManager2 == null) {
            NewMappings.$$$reportNull$$$0(1);
        }
        this.myUpdateLock = new Object();
        this.myFilePointerDisposable = Disposer.newDisposable();
        this.myMappings = Collections.emptyList();
        this.myMappedRoots = Collections.emptyList();
        this.myMappedRootsMapping = new RootMapping(Collections.emptyList());
        this.myActiveVcses = Collections.emptyList();
        this.myActivated = false;
        this.myProject = project;
        this.myVcsManager = vcsManager2;
        this.myFileWatchRequestsManager = new FileWatchRequestsManager(this.myProject, this);
        this.myRootUpdateQueue = new MergingUpdateQueue("NewMappings", 1000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD).usePassThroughInUnitTestMode();
        this.myFilePointerListener = new VirtualFilePointerListener(){

            public void validityChanged(VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                NewMappings.this.scheduleMappedRootsUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$1", "validityChanged"));
            }
        };
        VcsRootChecker.EXTENSION_POINT_NAME.addChangeListener(() -> this.scheduleMappedRootsUpdate(), (Disposable)project);
    }

    @TestOnly
    public void setFileWatchRequestsManager(FileWatchRequestsManager fileWatchRequestsManager) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileWatchRequestsManager = fileWatchRequestsManager;
    }

    public AbstractVcs @NotNull [] getActiveVcses() {
        AbstractVcs[] abstractVcsArray = this.myActiveVcses.toArray(new AbstractVcs[0]);
        if (abstractVcsArray == null) {
            NewMappings.$$$reportNull$$$0(2);
        }
        return abstractVcsArray;
    }

    public boolean hasActiveVcss() {
        return !this.myActiveVcses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateActiveVcses() {
        Object object = this.myUpdateLock;
        synchronized (object) {
            if (this.myActivated) {
                return;
            }
            this.myActivated = true;
            LOG.debug("activated");
        }
        this.updateActiveVcses();
        this.updateMappedRoots(true);
    }

    private boolean updateActiveVcses() {
        MyVcsActivator activator = (MyVcsActivator)ReadAction.compute(() -> {
            Object object = this.myUpdateLock;
            synchronized (object) {
                return this.myActivated ? this.createVcsActivator() : null;
            }
        });
        if (activator != null) {
            activator.activate();
        }
        return activator != null;
    }

    public void setMapping(@NotNull String path2, @Nullable String activeVcsName) {
        if (path2 == null) {
            NewMappings.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setMapping path = '" + path2 + "' vcs = " + activeVcsName, new Throwable());
        }
        VcsDirectoryMapping newMapping = new VcsDirectoryMapping(path2, activeVcsName);
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping2 -> Objects.equals(mapping2.getDirectory(), newMapping.getDirectory()));
        newMappings.add(newMapping);
        this.updateVcsMappings(newMappings);
    }

    @TestOnly
    public void waitMappedRootsUpdate() {
        this.myRootUpdateQueue.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedVcsesImmediately() {
        LOG.debug("updateMappingsImmediately");
        if (!this.updateActiveVcses()) {
            return;
        }
        Object object = this.myUpdateLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myFilePointerDisposable = Disposer.newDisposable();
            this.myMappedRoots = Collections.emptyList();
            this.myMappedRootsMapping = new RootMapping(Collections.emptyList());
            this.dumpMappedRootsToLog();
        }
        this.mappingsChanged();
        this.scheduleMappedRootsUpdate();
    }

    public void scheduleMappedRootsUpdate() {
        this.myRootUpdateQueue.queue((Update)new DisposableUpdate(this, "update"){

            @Override
            public void doRun() {
                NewMappings.this.updateMappedRoots(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVcsMappings(@NotNull Collection<? extends VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(4);
        }
        this.myRootUpdateQueue.cancelAllUpdates();
        List newMappings = Collections.unmodifiableList(ContainerUtil.sorted(NewMappings.removeDuplicates(mappings), MAPPINGS_COMPARATOR));
        Object object = this.myUpdateLock;
        synchronized (object) {
            boolean mappingsChanged;
            boolean bl = mappingsChanged = !this.myMappings.equals(newMappings);
            if (!mappingsChanged) {
                return;
            }
            this.myMappings = newMappings;
            this.dumpMappingsToLog();
        }
        this.updateActiveVcses();
        this.updateMappedRoots(false);
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMappedRoots(boolean fireMappingsChangedEvent) {
        boolean mappedRootsChanged;
        this.myRootUpdateQueue.cancelAllUpdates();
        if (!this.myActivated) {
            return;
        }
        LOG.debug("updateMappedRoots");
        List<VcsDirectoryMapping> mappings = this.myMappings;
        Mappings newMappedRoots = this.collectMappedRoots(mappings);
        Object object = this.myUpdateLock;
        synchronized (object) {
            if (this.myMappings != mappings) {
                Disposer.dispose((Disposable)newMappedRoots.filePointerDisposable);
                return;
            }
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myFilePointerDisposable = newMappedRoots.filePointerDisposable;
            boolean bl = mappedRootsChanged = !this.myMappedRoots.equals(newMappedRoots.mappedRoots);
            if (mappedRootsChanged) {
                this.myMappedRoots = newMappedRoots.mappedRoots;
                this.myMappedRootsMapping = new RootMapping(newMappedRoots.mappedRoots);
                this.dumpMappedRootsToLog();
            }
        }
        if (fireMappingsChangedEvent && mappedRootsChanged) {
            this.mappingsChanged();
        }
    }

    private void refreshMainMenu() {
        ApplicationManager.getApplication().invokeLater(() -> {
            ProjectFrameHelper frame = WindowManagerEx.getInstanceEx().getFrameHelper(this.myProject);
            if (frame != null && !Disposer.isDisposed((Disposable)frame)) {
                frame.updateView();
            }
        });
    }

    @NotNull
    private static List<VcsDirectoryMapping> removeDuplicates(@NotNull Collection<? extends VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(5);
        }
        ArrayList<VcsDirectoryMapping> newMapping = new ArrayList<VcsDirectoryMapping>();
        HashSet<String> paths = new HashSet<String>();
        for (VcsDirectoryMapping mapping2 : ContainerUtil.reverse(new ArrayList<VcsDirectoryMapping>(mappings))) {
            if (!paths.add(mapping2.getDirectory())) continue;
            newMapping.add(mapping2);
        }
        ArrayList<VcsDirectoryMapping> arrayList = newMapping;
        if (arrayList == null) {
            NewMappings.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private Mappings collectMappedRoots(@NotNull List<VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(7);
        }
        VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
        HashMap mappedRoots = new HashMap();
        Disposable pointerDisposable = Disposer.newDisposable();
        try {
            AbstractVcs vcs;
            for (VcsDirectoryMapping mapping2 : mappings) {
                if (mapping2.isDefaultMapping()) continue;
                vcs = this.getMappingsVcs(mapping2);
                String rootPath = mapping2.getDirectory();
                ReadAction.run(() -> {
                    VirtualFile vcsRoot = LocalFileSystem.getInstance().findFileByPath(rootPath);
                    if (vcsRoot != null && vcsRoot.isDirectory()) {
                        if (this.checkMappedRoot(vcs, vcsRoot)) {
                            mappedRoots.putIfAbsent(vcsRoot, new MappedRoot(vcs, mapping2, vcsRoot));
                        } else {
                            mappedRoots.putIfAbsent(vcsRoot, new MappedRoot(null, mapping2, vcsRoot));
                        }
                    }
                    pointerManager.create(VfsUtilCore.pathToUrl((String)rootPath), pointerDisposable, this.myFilePointerListener);
                });
            }
            for (VcsDirectoryMapping mapping2 : mappings) {
                if (!mapping2.isDefaultMapping() || (vcs = this.getMappingsVcs(mapping2)) == null) continue;
                Collection<VirtualFile> defaultRoots = this.detectDefaultRootsFor(vcs, DefaultVcsRootPolicy.getInstance(this.myProject).getDefaultVcsRoots(), ContainerUtil.map2Set(mappedRoots.values(), it -> it.root));
                ReadAction.run(() -> {
                    for (VirtualFile vcsRoot : defaultRoots) {
                        if (vcsRoot == null || !vcsRoot.isDirectory()) continue;
                        mappedRoots.putIfAbsent(vcsRoot, new MappedRoot(vcs, mapping2, vcsRoot));
                        pointerManager.create(vcsRoot, pointerDisposable, this.myFilePointerListener);
                    }
                });
            }
            List<MappedRoot> result2 = Collections.unmodifiableList(ContainerUtil.sorted(mappedRoots.values(), ROOT_COMPARATOR));
            for (MappedRoot root : result2) {
                if (!this.myVcsManager.isIgnored(VcsUtil.getFilePath((VirtualFile)root.root))) continue;
                LOG.warn("Root mapping is under ignored root: " + root.root);
            }
            return new Mappings(result2, pointerDisposable);
        }
        catch (Throwable e) {
            Disposer.dispose((Disposable)pointerDisposable);
            ExceptionUtil.rethrow((Throwable)e);
            if (null == null) {
                NewMappings.$$$reportNull$$$0(8);
            }
            return null;
        }
    }

    @Nullable
    private AbstractVcs getMappingsVcs(@NotNull VcsDirectoryMapping mapping2) {
        if (mapping2 == null) {
            NewMappings.$$$reportNull$$$0(9);
        }
        return AllVcses.getInstance(this.myProject).getByName(mapping2.getVcs());
    }

    private boolean checkMappedRoot(@Nullable AbstractVcs vcs, @NotNull VirtualFile vcsRoot) {
        if (vcsRoot == null) {
            NewMappings.$$$reportNull$$$0(10);
        }
        try {
            if (vcs == null) {
                return false;
            }
            VcsRootChecker rootChecker = this.myVcsManager.getRootChecker(vcs);
            return rootChecker.validateRoot(vcsRoot.getPath());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return false;
        }
    }

    @NotNull
    private Collection<VirtualFile> detectDefaultRootsFor(@NotNull AbstractVcs vcs, @NotNull Collection<VirtualFile> projectRoots, @NotNull Set<VirtualFile> mappedDirs) {
        HashSet<VirtualFile> hashSet;
        block16: {
            if (vcs == null) {
                NewMappings.$$$reportNull$$$0(11);
            }
            if (projectRoots == null) {
                NewMappings.$$$reportNull$$$0(12);
            }
            if (mappedDirs == null) {
                NewMappings.$$$reportNull$$$0(13);
            }
            if (!vcs.needsLegacyDefaultMappings()) break block16;
            Collection<VirtualFile> collection = projectRoots;
            if (collection == null) {
                NewMappings.$$$reportNull$$$0(14);
            }
            return collection;
        }
        try {
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance(this.myProject);
            VcsRootChecker rootChecker = this.myVcsManager.getRootChecker(vcs);
            HashMap<VirtualFile, Boolean> checkedDirs = new HashMap<VirtualFile, Boolean>();
            HashSet<VirtualFile> vcsRoots = new HashSet<VirtualFile>();
            block4: for (VirtualFile f : projectRoots) {
                while (f != null && !vcsRoots.contains(f) && !mappedDirs.contains(f)) {
                    if (NewMappings.isVcsRoot(rootChecker, checkedDirs, f)) {
                        vcsRoots.add(f);
                        continue block4;
                    }
                    VirtualFile parent = f.getParent();
                    if (parent != null && !this.isUnderProject(directoryIndex, parent)) {
                        if (!rootChecker.areChildrenValidMappings()) continue block4;
                        while (parent != null && !vcsRoots.contains(parent) && !mappedDirs.contains(parent)) {
                            if (NewMappings.isVcsRoot(rootChecker, checkedDirs, parent)) {
                                vcsRoots.add(f);
                                continue block4;
                            }
                            parent = parent.getParent();
                        }
                        continue block4;
                    }
                    f = parent;
                }
            }
            hashSet = vcsRoots;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NewMappings.$$$reportNull$$$0(16);
            }
            return list2;
        }
        if (hashSet == null) {
            NewMappings.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    private static boolean isVcsRoot(@NotNull VcsRootChecker rootChecker, @NotNull Map<VirtualFile, Boolean> checkedDirs, @NotNull VirtualFile file2) {
        if (rootChecker == null) {
            NewMappings.$$$reportNull$$$0(17);
        }
        if (checkedDirs == null) {
            NewMappings.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            NewMappings.$$$reportNull$$$0(19);
        }
        ProgressManager.checkCanceled();
        return checkedDirs.computeIfAbsent(file2, key -> rootChecker.isRoot(key.getPath()));
    }

    private boolean isUnderProject(@NotNull DirectoryIndex directoryIndex, @NotNull VirtualFile f) {
        if (directoryIndex == null) {
            NewMappings.$$$reportNull$$$0(20);
        }
        if (f == null) {
            NewMappings.$$$reportNull$$$0(21);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return directoryIndex.getInfoForFile(f).isInProject(f);
        });
    }

    public void mappingsChanged() {
        ((VcsListener)BackgroundTaskUtil.syncPublisher(this.myProject, ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
        this.myFileWatchRequestsManager.ping();
    }

    private void dumpMappingsToLog() {
        for (VcsDirectoryMapping mapping2 : this.myMappings) {
            String path2 = mapping2.isDefaultMapping() ? "<Project>" : mapping2.getDirectory();
            String vcs = mapping2.getVcs();
            LOG.info(String.format("VCS Root: [%s] - [%s]", vcs, path2));
        }
    }

    private void dumpMappedRootsToLog() {
        if (LOG.isDebugEnabled()) {
            for (MappedRoot root : this.myMappedRoots) {
                LOG.debug(String.format("Mapped Root: [%s] - [%s]", root.vcs, root.root.getPath()));
            }
        } else if (this.haveDefaultMapping() != null) {
            LOG.info("Mapped Roots: " + this.myMappedRoots.size());
        }
    }

    public void setDirectoryMappings(@NotNull List<? extends VcsDirectoryMapping> items) {
        if (items == null) {
            NewMappings.$$$reportNull$$$0(22);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setDirectoryMappings, size: " + items.size(), new Throwable());
        }
        this.updateVcsMappings(items);
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable VirtualFile file2) {
        if (file2 == null || !file2.isInLocalFileSystem()) {
            return null;
        }
        if (this.myMappedRoots.isEmpty()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file2)) {
            return null;
        }
        return this.myMappedRootsMapping.getRootFor(file2);
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable FilePath file2) {
        if (file2 == null || file2.isNonLocal()) {
            return null;
        }
        if (this.myMappedRoots.isEmpty()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file2)) {
            return null;
        }
        return this.myMappedRootsMapping.getRootFor(file2);
    }

    @NotNull
    public List<VirtualFile> getMappingsAsFilesUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            NewMappings.$$$reportNull$$$0(23);
        }
        List list2 = ContainerUtil.mapNotNull(this.myMappedRoots, root -> vcs.equals((Object)root.vcs) ? root.root : null);
        if (list2 == null) {
            NewMappings.$$$reportNull$$$0(24);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        MyVcsActivator activator;
        LOG.debug("disposed");
        Object object = this.myUpdateLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myMappings = Collections.emptyList();
            this.myMappedRoots = Collections.emptyList();
            this.myFilePointerDisposable = Disposer.newDisposable();
            activator = this.createVcsActivator();
        }
        activator.activate();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings;
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(String vcsName) {
        return ContainerUtil.filter(this.myMappings, mapping2 -> Objects.equals(mapping2.getVcs(), vcsName));
    }

    @Nullable
    public String haveDefaultMapping() {
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(this.myMappings, mapping2 -> mapping2.isDefaultMapping());
        return defaultMapping != null ? defaultMapping.getVcs() : null;
    }

    public boolean isEmpty() {
        return ContainerUtil.all(this.myMappings, mapping2 -> mapping2.isNoneMapping());
    }

    public void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping2) {
        if (mapping2 == null) {
            NewMappings.$$$reportNull$$$0(25);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove mapping: " + mapping2.getDirectory(), new Throwable());
        }
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.remove(mapping2);
        this.updateVcsMappings(newMappings);
    }

    public void cleanupMappings() {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<VcsDirectoryMapping> oldMappings = new ArrayList<VcsDirectoryMapping>(this.getDirectoryMappings());
        ArrayList<VcsDirectoryMapping> filteredMappings = new ArrayList<VcsDirectoryMapping>();
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(oldMappings, it -> it.isDefaultMapping());
        if (defaultMapping != null) {
            oldMappings.remove(defaultMapping);
            filteredMappings.add(defaultMapping);
        }
        MultiMap groupedMappings = new MultiMap();
        for (VcsDirectoryMapping mapping2 : oldMappings) {
            groupedMappings.putValue((Object)mapping2.getVcs(), (Object)mapping2);
        }
        for (Map.Entry entry2 : groupedMappings.entrySet()) {
            String vcsName = (String)entry2.getKey();
            Collection mappings = (Collection)entry2.getValue();
            List objects = ContainerUtil.mapNotNull((Collection)mappings, dm -> {
                VirtualFile vf = lfs.refreshAndFindFileByPath(dm.getDirectory());
                return vf == null ? null : Pair.create((Object)vf, (Object)dm);
            });
            if (StringUtil.isEmptyOrSpaces((String)vcsName)) {
                filteredMappings.addAll(ContainerUtil.map((Collection)objects, (Function)Functions.pairSecond()));
                continue;
            }
            AbstractVcs vcs = this.myVcsManager.findVcsByName(vcsName);
            if (vcs == null) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, VcsBundle.message((String)"impl.notification.content.vcs.plugin.not.found.for.mapping.to", (Object[])new Object[]{vcsName}), MessageType.ERROR, new NamedRunnable[0]);
                filteredMappings.addAll(mappings);
                continue;
            }
            filteredMappings.addAll(ContainerUtil.map((Collection)vcs.filterUniqueRoots(objects, pair -> (VirtualFile)pair.getFirst()), (Function)Functions.pairSecond()));
        }
        this.updateVcsMappings(filteredMappings);
    }

    @NotNull
    private MyVcsActivator createVcsActivator() {
        Set newVcses = ContainerUtil.map2SetNotNull(this.myMappings, mapping2 -> this.getMappingsVcs((VcsDirectoryMapping)mapping2));
        List<AbstractVcs> oldVcses = this.myActiveVcses;
        this.myActiveVcses = Collections.unmodifiableList(new ArrayList(newVcses));
        this.refreshMainMenu();
        Collection toAdd = ContainerUtil.subtract(this.myActiveVcses, oldVcses);
        Collection toRemove2 = ContainerUtil.subtract(oldVcses, this.myActiveVcses);
        return new MyVcsActivator(toAdd, toRemove2);
    }

    public boolean haveActiveVcs(String name) {
        return ContainerUtil.exists(this.myActiveVcses, vcs -> Objects.equals(vcs.getName(), name));
    }

    public void beingUnregistered(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("beingUnregistered " + name, new Throwable());
        }
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping2 -> Objects.equals(mapping2.getVcs(), name));
        this.updateVcsMappings(newMappings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 9: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoots";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedDirs";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootChecker";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedDirs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveVcses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMappedRoots";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "detectDefaultRootsFor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsAsFilesUnderVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 24: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateVcsMappings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectMappedRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsVcs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkMappedRoot";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "detectDefaultRootsFor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isVcsRoot";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isUnderProject";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMappings";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsAsFilesUnderVcs";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeDirectoryMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RootMapping {
        private final Map<VirtualFile, MappedRoot> myVFMap;
        private final FilePathMapping<MappedRoot> myPathMapping;

        private RootMapping(@NotNull List<MappedRoot> mappedRoots) {
            if (mappedRoots == null) {
                RootMapping.$$$reportNull$$$0(0);
            }
            this.myVFMap = new HashMap<VirtualFile, MappedRoot>();
            this.myPathMapping = new FilePathMapping(SystemInfo.isFileSystemCaseSensitive);
            for (MappedRoot root : mappedRoots) {
                this.myVFMap.put(root.root, root);
                this.myPathMapping.add(root.root.getPath(), root);
            }
        }

        @Nullable
        public MappedRoot getRootFor(@NotNull VirtualFile file2) {
            if (file2 == null) {
                RootMapping.$$$reportNull$$$0(1);
            }
            while (file2 != null) {
                MappedRoot root = this.myVFMap.get(file2);
                if (root != null) {
                    return root;
                }
                file2 = file2.getParent();
            }
            return null;
        }

        @Nullable
        public MappedRoot getRootFor(@NotNull FilePath filePath) {
            if (filePath == null) {
                RootMapping.$$$reportNull$$$0(2);
            }
            return this.myPathMapping.getMappingFor(filePath.getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedRoots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$RootMapping";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRootFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Mappings {
        @NotNull
        public final List<MappedRoot> mappedRoots;
        @NotNull
        public final Disposable filePointerDisposable;

        private Mappings(@NotNull List<MappedRoot> mappedRoots, @NotNull Disposable filePointerDisposable) {
            if (mappedRoots == null) {
                Mappings.$$$reportNull$$$0(0);
            }
            if (filePointerDisposable == null) {
                Mappings.$$$reportNull$$$0(1);
            }
            this.mappedRoots = mappedRoots;
            this.filePointerDisposable = filePointerDisposable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mappedRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePointerDisposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$Mappings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MappedRoot {
        @Nullable
        public final AbstractVcs vcs;
        @NotNull
        public final VcsDirectoryMapping mapping;
        @NotNull
        public final VirtualFile root;

        private MappedRoot(@Nullable AbstractVcs vcs, @NotNull VcsDirectoryMapping mapping2, @NotNull VirtualFile root) {
            if (mapping2 == null) {
                MappedRoot.$$$reportNull$$$0(0);
            }
            if (root == null) {
                MappedRoot.$$$reportNull$$$0(1);
            }
            this.vcs = vcs;
            this.mapping = mapping2;
            this.root = root;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappedRoot other = (MappedRoot)o;
            return Objects.equals(this.vcs, other.vcs) && this.mapping.equals((Object)other.mapping) && this.root.equals(other.root);
        }

        public int hashCode() {
            return Objects.hash(this.vcs, this.mapping, this.root);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$MappedRoot";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyVcsActivator {
        @NotNull
        private final Collection<? extends AbstractVcs> myAddVcses;
        @NotNull
        private final Collection<? extends AbstractVcs> myRemoveVcses;

        private MyVcsActivator(@NotNull Collection<? extends AbstractVcs> addVcses, @NotNull Collection<? extends AbstractVcs> removeVcses) {
            if (addVcses == null) {
                MyVcsActivator.$$$reportNull$$$0(0);
            }
            if (removeVcses == null) {
                MyVcsActivator.$$$reportNull$$$0(1);
            }
            this.myAddVcses = addVcses;
            this.myRemoveVcses = removeVcses;
        }

        public void activate() {
            for (AbstractVcs abstractVcs : this.myAddVcses) {
                try {
                    abstractVcs.doActivate();
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                }
            }
            for (AbstractVcs abstractVcs : this.myRemoveVcses) {
                try {
                    abstractVcs.doDeactivate();
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "addVcses";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "removeVcses";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$MyVcsActivator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

