/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.impl.RepositoryBrowserPanel;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\b\"$\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"REPOSITORY_BROWSER_DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getREPOSITORY_BROWSER_DATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "TOOLWINDOW_ID", "", "registerRepositoriesToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "showRepositoryBrowser", "", "root", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "localRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "title", "intellij.platform.vcs.impl"})
public final class RepositoryBrowserKt {
    @NotNull
    public static final String TOOLWINDOW_ID = "Repositories";
    @NotNull
    private static final DataKey<RepositoryBrowserPanel> REPOSITORY_BROWSER_DATA_KEY;

    public static final void showRepositoryBrowser(@NotNull Project project, @NotNull AbstractVcsVirtualFile root, @NotNull VirtualFile localRoot, @NlsContexts.TabTitle @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)root), (String)"root");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            toolWindow = RepositoryBrowserKt.registerRepositoriesToolWindow(toolWindowManager, project);
        }
        ToolWindow repoToolWindow = toolWindow;
        ContentManager contentManager2 = repoToolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"repoToolWindow.contentManager");
        Content[] contentArray = contentManager2.getContents();
        int n = contentArray.length;
        for (int j = 0; j < n; ++j) {
            RepositoryBrowserPanel component2;
            Content content2;
            Content content3 = content2 = contentArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"content");
            JComponent jComponent = content3.getComponent();
            if (!(jComponent instanceof RepositoryBrowserPanel)) {
                jComponent = null;
            }
            if ((RepositoryBrowserPanel)jComponent == null) {
                continue;
            }
            if (!Intrinsics.areEqual((Object)((Object)component2.getRoot()), (Object)((Object)root))) continue;
            repoToolWindow.getContentManager().setSelectedContent(content2);
            return;
        }
        RepositoryBrowserPanel contentPanel2 = new RepositoryBrowserPanel(project, root, localRoot);
        Content content4 = ContentFactory.SERVICE.getInstance().createContent((JComponent)contentPanel2, title2, true);
        Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"ContentFactory.SERVICE.g\u2026ontentPanel, title, true)");
        Content content5 = content4;
        repoToolWindow.getContentManager().addContent(content5);
        repoToolWindow.getContentManager().setSelectedContent(content5, true);
        repoToolWindow.activate(null);
    }

    private static final ToolWindow registerRepositoriesToolWindow(ToolWindowManager toolWindowManager, Project project) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"ToolWindowAnchor.LEFT");
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(TOOLWINDOW_ID, true, toolWindowAnchor, (Disposable)project, true);
        ContentManagerWatcher.watchContentManager(toolWindow, toolWindow.getContentManager());
        return toolWindow;
    }

    @NotNull
    public static final DataKey<RepositoryBrowserPanel> getREPOSITORY_BROWSER_DATA_KEY() {
        return REPOSITORY_BROWSER_DATA_KEY;
    }

    static {
        DataKey dataKey = DataKey.create("com.intellij.openapi.vcs.impl.RepositoryBrowserPanel");
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DataKey.create<Repositor\u2026.RepositoryBrowserPanel\")");
        REPOSITORY_BROWSER_DATA_KEY = dataKey;
    }
}

