/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalLineStatusTrackerImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerContentLoader;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.impl.VcsFileStatusProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\"\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u001c\u0010\u0012\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/impl/BaseRevisionStatusTrackerContentLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;", "()V", "getContentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "handleLoadingError", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "isTrackedFile", "", "loadContent", "Lcom/intellij/openapi/vcs/impl/BaseRevisionStatusTrackerContentLoader$BaseRevisionContent;", "info", "setLoadedContent", "content", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "shouldBeUpdated", "oldInfo", "newInfo", "BaseRevisionContent", "BaseRevisionContentInfo", "intellij.platform.vcs.impl"})
abstract class BaseRevisionStatusTrackerContentLoader
implements LineStatusTrackerContentLoader {
    @Override
    public boolean isTrackedFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!VcsFileStatusProvider.getInstance(project).isSupported(file2)) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(file2);
        return !Intrinsics.areEqual((Object)status, (Object)FileStatus.ADDED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.DELETED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.UNKNOWN) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED);
    }

    @Override
    @Nullable
    public LineStatusTrackerContentLoader.ContentInfo getContentInfo(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VcsBaseContentProvider.BaseContent baseContent = VcsFileStatusProvider.getInstance(project).getBaseRevision(file2);
        if (baseContent == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)baseContent, (String)"VcsFileStatusProvider.ge\u2026sion(file) ?: return null");
        VcsBaseContentProvider.BaseContent baseContent2 = baseContent;
        Charset charset = file2.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"file.charset");
        return new BaseRevisionContentInfo(baseContent2, charset);
    }

    @Override
    public boolean shouldBeUpdated(@Nullable LineStatusTrackerContentLoader.ContentInfo oldInfo, @NotNull LineStatusTrackerContentLoader.ContentInfo newInfo) {
        Intrinsics.checkNotNullParameter((Object)newInfo, (String)"newInfo");
        BaseRevisionContentInfo cfr_ignored_0 = (BaseRevisionContentInfo)newInfo;
        return oldInfo == null || !(oldInfo instanceof BaseRevisionContentInfo) || Intrinsics.areEqual((Object)((BaseRevisionContentInfo)oldInfo).getBaseContent().getRevisionNumber(), (Object)((BaseRevisionContentInfo)newInfo).getBaseContent().getRevisionNumber()) ^ true || Intrinsics.areEqual((Object)((BaseRevisionContentInfo)oldInfo).getBaseContent().getRevisionNumber(), (Object)VcsRevisionNumber.NULL) || Intrinsics.areEqual((Object)((BaseRevisionContentInfo)oldInfo).getCharset(), (Object)((BaseRevisionContentInfo)newInfo).getCharset()) ^ true;
    }

    @Override
    @Nullable
    public BaseRevisionContent loadContent(@NotNull Project project, @NotNull LineStatusTrackerContentLoader.ContentInfo info2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        BaseRevisionContentInfo cfr_ignored_0 = (BaseRevisionContentInfo)info2;
        String string = ((BaseRevisionContentInfo)info2).getBaseContent().loadContent();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.baseContent.loadContent() ?: return null");
        String lastUpToDateContent = string;
        String string2 = StringUtil.convertLineSeparators((String)lastUpToDateContent);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.convertLineSe\u2026tors(lastUpToDateContent)");
        String correctedText = string2;
        return new BaseRevisionContent(correctedText);
    }

    @Override
    public void setLoadedContent(@NotNull LocalLineStatusTracker<?> tracker2, @NotNull LineStatusTrackerContentLoader.TrackerContent content2) {
        Intrinsics.checkNotNullParameter(tracker2, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        LocalLineStatusTrackerImpl cfr_ignored_0 = (LocalLineStatusTrackerImpl)tracker2;
        BaseRevisionContent cfr_ignored_1 = (BaseRevisionContent)content2;
        ((LocalLineStatusTrackerImpl)tracker2).setBaseRevision(((BaseRevisionContent)content2).getText());
    }

    @Override
    public void handleLoadingError(@NotNull LocalLineStatusTracker<?> tracker2) {
        Intrinsics.checkNotNullParameter(tracker2, (String)"tracker");
        LocalLineStatusTrackerImpl cfr_ignored_0 = (LocalLineStatusTrackerImpl)tracker2;
        ((LocalLineStatusTrackerImpl)tracker2).dropBaseRevision();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/BaseRevisionStatusTrackerContentLoader$BaseRevisionContentInfo;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "baseContent", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider$BaseContent;", "charset", "Ljava/nio/charset/Charset;", "(Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider$BaseContent;Ljava/nio/charset/Charset;)V", "getBaseContent", "()Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider$BaseContent;", "getCharset", "()Ljava/nio/charset/Charset;", "intellij.platform.vcs.impl"})
    private static final class BaseRevisionContentInfo
    implements LineStatusTrackerContentLoader.ContentInfo {
        @NotNull
        private final VcsBaseContentProvider.BaseContent baseContent;
        @NotNull
        private final Charset charset;

        @NotNull
        public final VcsBaseContentProvider.BaseContent getBaseContent() {
            return this.baseContent;
        }

        @NotNull
        public final Charset getCharset() {
            return this.charset;
        }

        public BaseRevisionContentInfo(@NotNull VcsBaseContentProvider.BaseContent baseContent, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)baseContent, (String)"baseContent");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            this.baseContent = baseContent;
            this.charset = charset;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/BaseRevisionStatusTrackerContentLoader$BaseRevisionContent;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "text", "", "(Ljava/lang/CharSequence;)V", "getText", "()Ljava/lang/CharSequence;", "intellij.platform.vcs.impl"})
    private static final class BaseRevisionContent
    implements LineStatusTrackerContentLoader.TrackerContent {
        @NotNull
        private final CharSequence text;

        @NotNull
        public final CharSequence getText() {
            return this.text;
        }

        public BaseRevisionContent(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }
    }
}

