/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusActionBase
extends DumbAwareAction {
    public static final DataKey<Integer> SELECTED_OFFSET_KEY = DataKey.create("VCS_LINE_MARKER_SELECTED_OFFSET_KEY");

    public void update(@NotNull AnActionEvent e) {
        int line;
        if (e == null) {
            LineStatusActionBase.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Integer selectedOffset = (Integer)e.getData(SELECTED_OFFSET_KEY);
        if (project == null || editor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        LineStatusTracker<?> tracker2 = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        if (!(tracker2 != null && tracker2.isValid() && tracker2.isAvailableAt(editor) && this.isEnabled(tracker2, editor))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean isEnabled = selectedOffset != null ? tracker2.getRangeForLine(line = editor.getDocument().getLineNumber(selectedOffset.intValue())) != null : LineStatusActionBase.isSomeChangeSelected(editor, tracker2);
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(isEnabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            LineStatusActionBase.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
        Integer selectedOffset = (Integer)e.getData(SELECTED_OFFSET_KEY);
        LineStatusTracker<?> tracker2 = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        assert (tracker2 != null);
        Range range2 = null;
        if (selectedOffset != null) {
            int line = editor.getDocument().getLineNumber(selectedOffset.intValue());
            range2 = (Range)tracker2.getRangeForLine(line);
        }
        this.doAction(tracker2, editor, range2);
    }

    private static boolean isSomeChangeSelected(@NotNull Editor editor, @NotNull LineStatusTrackerI<?> tracker2) {
        if (editor == null) {
            LineStatusActionBase.$$$reportNull$$$0(2);
        }
        if (tracker2 == null) {
            LineStatusActionBase.$$$reportNull$$$0(3);
        }
        return DiffUtil.isSomeRangeSelected(editor, (Condition<? super BitSet>)((Condition)lines2 -> !ContainerUtil.isEmpty(tracker2.getRangesForLines((BitSet)lines2))));
    }

    protected boolean isEnabled(@NotNull LineStatusTrackerI<?> tracker2, @NotNull Editor editor) {
        if (tracker2 == null) {
            LineStatusActionBase.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            LineStatusActionBase.$$$reportNull$$$0(5);
        }
        return true;
    }

    protected abstract void doAction(@NotNull LineStatusTrackerI<?> var1, @NotNull Editor var2, @Nullable Range var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSomeChangeSelected";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

