/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserModuleNode
extends ChangesBrowserNode<Module> {
    @NotNull
    private final FilePath myModuleRoot;

    protected ChangesBrowserModuleNode(Module userObject) {
        super(userObject);
        this.myModuleRoot = ChangesBrowserModuleNode.getModuleRootFilePath(userObject);
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected2, boolean expanded, boolean hasFocus) {
        Module module;
        if (renderer == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(0);
        }
        renderer.append((module = (Module)this.userObject).isDisposed() ? "" : module.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount(renderer);
        this.appendParentPath(renderer, this.myModuleRoot);
        if (module.isDisposed()) {
            renderer.setIcon(ModuleType.EMPTY.getIcon());
        } else {
            renderer.setIcon(ModuleType.get((Module)module).getIcon());
        }
    }

    @NotNull
    public FilePath getModuleRoot() {
        FilePath filePath = this.myModuleRoot;
        if (filePath == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(1);
        }
        return filePath;
    }

    @Override
    public String getTextPresentation() {
        return ((Module)this.getUserObject()).getName();
    }

    @Override
    public int getSortWeight() {
        return 4;
    }

    @Override
    public int compareUserObjects(Module o2) {
        return ChangesBrowserModuleNode.compareFileNames(((Module)this.getUserObject()).getName(), o2.getName());
    }

    @NotNull
    private static FilePath getModuleRootFilePath(Module module) {
        FilePath filePath = (FilePath)ReadAction.compute(() -> {
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (roots.length == 1) {
                return VcsUtil.getFilePath((VirtualFile)roots[0]);
            }
            return VcsUtil.getFilePath((String)ModuleUtilCore.getModuleDirPath((Module)module));
        });
        if (filePath == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(2);
        }
        return filePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserModuleNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserModuleNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRootFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

