/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserFileNode
extends ChangesBrowserNode<VirtualFile>
implements Comparable<ChangesBrowserFileNode> {
    @Nullable
    private final Project myProject;
    private final String myName;

    public ChangesBrowserFileNode(@Nullable Project project, @NotNull VirtualFile userObject) {
        if (userObject == null) {
            ChangesBrowserFileNode.$$$reportNull$$$0(0);
        }
        super(userObject);
        this.myName = userObject.getName();
        this.myProject = project;
    }

    @Override
    protected boolean isFile() {
        return !((VirtualFile)this.getUserObject()).isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        if (((VirtualFile)this.getUserObject()).isDirectory()) {
            return this.isLeaf() || this.getFileStatus() != FileStatus.NOT_CHANGED;
        }
        return false;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected2, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserFileNode.$$$reportNull$$$0(1);
        }
        VirtualFile file2 = (VirtualFile)this.getUserObject();
        FileStatus fileStatus = this.getFileStatus();
        renderer.appendFileName(file2, file2.getName(), fileStatus.getColor());
        if (renderer.isShowFlatten() && file2.isValid()) {
            this.appendParentPath(renderer, file2.getParent());
        }
        if (!renderer.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        renderer.setIcon(VcsUtil.getFilePath((VirtualFile)file2), file2.isDirectory());
    }

    @Override
    public String getTextPresentation() {
        return ((VirtualFile)this.getUserObject()).getName();
    }

    @Override
    public String toString() {
        return ((VirtualFile)this.getUserObject()).getPresentableUrl();
    }

    @Override
    public int getSortWeight() {
        return 8;
    }

    @Override
    public int compareTo(ChangesBrowserFileNode o) {
        return ChangesBrowserFileNode.compareFileNames(this.myName, o.myName);
    }

    @NotNull
    private FileStatus getFileStatus() {
        if (this.myProject == null || this.myProject.isDisposed()) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                ChangesBrowserFileNode.$$$reportNull$$$0(2);
            }
            return fileStatus;
        }
        FileStatus fileStatus = ChangeListManager.getInstance((Project)this.myProject).getStatus((VirtualFile)this.getUserObject());
        if (fileStatus == null) {
            ChangesBrowserFileNode.$$$reportNull$$$0(3);
        }
        return fileStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserFileNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserFileNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

