/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u0000 ,*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001,B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00070\f\u00a2\u0006\u0002\b\u001f2\u0006\u0010 \u001a\u00020\bH\u0014J\b\u0010!\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020$H\u0014J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0003\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010&J(\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$H\u0016J\b\u0010+\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode;", "U", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "userObject", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "(Ljava/lang/Object;Lcom/intellij/openapi/vcs/FileStatus;)V", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "originText", "", "getOriginText", "()Ljava/lang/String;", "getStatus", "()Lcom/intellij/openapi/vcs/FileStatus;", "textAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getTextAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "appendOriginText", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "compareUserObjects", "", "o2", "(Ljava/lang/Object;)I", "(Ljava/lang/Object;)Lcom/intellij/openapi/vcs/FilePath;", "getRelativePath", "Lcom/intellij/openapi/util/NlsSafe;", "path", "getSortWeight", "getTextPresentation", "isDirectory", "", "isFile", "(Ljava/lang/Object;)Ljava/lang/String;", "render", "selected", "expanded", "hasFocus", "toString", "Companion", "intellij.platform.vcs.impl"})
public abstract class AbstractChangesBrowserFilePathNode<U>
extends ChangesBrowserNode<U> {
    @Nullable
    private final FileStatus status;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final FilePath getFilePath() {
        return this.filePath(this.getUserObject());
    }

    private final String getOriginText() {
        return this.originText(this.getUserObject());
    }

    @NotNull
    protected abstract FilePath filePath(U var1);

    @Nullable
    protected String originText(U userObject) {
        return null;
    }

    @Override
    protected boolean isFile() {
        return !this.getFilePath().isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return this.getFilePath().isDirectory() && this.isLeaf();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected2, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        FilePath path2 = this.getFilePath();
        if (renderer.isShowFlatten() && this.isLeaf()) {
            renderer.append(path2.getName(), this.getTextAttributes());
            this.appendOriginText(renderer);
            this.appendParentPath(renderer, path2.getParentPath());
        } else {
            renderer.append(this.getRelativePath(path2), this.getTextAttributes());
            this.appendOriginText(renderer);
        }
        if (!this.isLeaf()) {
            this.appendCount(renderer);
        }
        renderer.setIcon(path2, path2.isDirectory() || !this.isLeaf());
    }

    private final void appendOriginText(ChangesBrowserNodeRenderer renderer) {
        block0: {
            String string = this.getOriginText();
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            renderer.append(FontUtil.spaceAndThinSpace() + this.getOriginText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private final SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes;
        if (this.status != null) {
            simpleTextAttributes = new SimpleTextAttributes(0, this.status.getColor());
        } else {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
        }
        return simpleTextAttributes;
    }

    @NotNull
    protected String getRelativePath(@NotNull FilePath path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        TreeNode treeNode = this.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"getParent()");
        return Companion.getRelativePath(Companion.safeCastToFilePath((ChangesBrowserNode<?>)treeNode), path2);
    }

    @Override
    @NotNull
    public String getTextPresentation() {
        return this.getRelativePath(this.getFilePath());
    }

    @Override
    @NotNull
    public String toString() {
        String string = FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDependentName(filePath.path)");
        return string;
    }

    @Override
    public int getSortWeight() {
        return this.getFilePath().isDirectory() ? 5 : 6;
    }

    @Override
    public int compareUserObjects(U o2) {
        return ChangesBrowserNode.compareFilePaths(this.getFilePath(), this.filePath(o2));
    }

    @Nullable
    public final FileStatus getStatus() {
        return this.status;
    }

    public AbstractChangesBrowserFilePathNode(U userObject, @Nullable FileStatus status) {
        super(userObject);
        this.status = status;
    }

    @JvmStatic
    @Nullable
    public static final FilePath safeCastToFilePath(@NotNull ChangesBrowserNode<?> node) {
        return Companion.safeCastToFilePath(node);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\b\u001a\u0004\u0018\u00010\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode$Companion;", "", "()V", "getRelativePath", "", "parent", "Lcom/intellij/openapi/vcs/FilePath;", "child", "safeCastToFilePath", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final FilePath safeCastToFilePath(@NotNull ChangesBrowserNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            if (node instanceof ChangesBrowserModuleNode) {
                return ((ChangesBrowserModuleNode)node).getModuleRoot();
            }
            Object o = node.getUserObject();
            if (o instanceof FilePath) {
                return (FilePath)o;
            }
            if (o instanceof Change) {
                return ChangesUtil.getAfterPath((Change)((Change)o));
            }
            return null;
        }

        @NotNull
        public final String getRelativePath(@Nullable FilePath parent, @NotNull FilePath child2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)child2, (String)"child");
            boolean isLocal = !child2.isNonLocal();
            boolean caseSensitive = isLocal && SystemInfo.isFileSystemCaseSensitive;
            String result2 = parent != null ? FileUtil.getRelativePath((String)parent.getPath(), (String)child2.getPath(), (char)'/', (boolean)caseSensitive) : null;
            String string2 = result2;
            if (string2 == null) {
                string2 = result2 = child2.getPath();
            }
            if (isLocal) {
                String string3 = FileUtil.toSystemDependentName((String)result2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FileUtil.toSystemDependentName(result)");
            } else {
                string = result2;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

