/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShelvedWrapper
implements PresentableChange {
    @Nullable
    private final ShelvedChange myShelvedChange;
    @Nullable
    private final ShelvedBinaryFile myBinaryFile;

    ShelvedWrapper(@NotNull ShelvedChange shelvedChange) {
        if (shelvedChange == null) {
            ShelvedWrapper.$$$reportNull$$$0(0);
        }
        this.myShelvedChange = shelvedChange;
        this.myBinaryFile = null;
    }

    ShelvedWrapper(@NotNull ShelvedBinaryFile binaryFile) {
        if (binaryFile == null) {
            ShelvedWrapper.$$$reportNull$$$0(1);
        }
        this.myShelvedChange = null;
        this.myBinaryFile = binaryFile;
    }

    @Nullable
    public ShelvedChange getShelvedChange() {
        return this.myShelvedChange;
    }

    @Nullable
    public ShelvedBinaryFile getBinaryFile() {
        return this.myBinaryFile;
    }

    public String getPath() {
        return (String)ObjectUtils.chooseNotNull((Object)this.getAfterPath(), (Object)this.getBeforePath());
    }

    @NlsSafe
    public String getRequestName() {
        return FileUtil.toSystemDependentName((String)this.getPath());
    }

    @NlsSafe
    @RequiresEdt
    @NotNull
    public String getPresentableName() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myShelvedChange == null) {
            String string = this.getRequestName();
            if (string == null) {
                ShelvedWrapper.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = ChangesUtil.getFilePath((Change)this.myShelvedChange.getChange()).getName();
        if (string == null) {
            ShelvedWrapper.$$$reportNull$$$0(3);
        }
        return string;
    }

    String getBeforePath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getBeforePath() : Objects.requireNonNull(this.myBinaryFile).BEFORE_PATH;
    }

    String getAfterPath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getAfterPath() : Objects.requireNonNull(this.myBinaryFile).AFTER_PATH;
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        Change change = this.myShelvedChange != null ? this.myShelvedChange.getChange() : null;
        FilePath filePath = change != null ? ChangesUtil.getFilePath((Change)change) : VcsUtil.getFilePath((String)this.getPath());
        if (filePath == null) {
            ShelvedWrapper.$$$reportNull$$$0(4);
        }
        return filePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = this.myShelvedChange != null ? this.myShelvedChange.getFileStatus() : Objects.requireNonNull(this.myBinaryFile).getFileStatus();
        if (fileStatus == null) {
            ShelvedWrapper.$$$reportNull$$$0(5);
        }
        return fileStatus;
    }

    Change getChange(@NotNull Project project) {
        if (project == null) {
            ShelvedWrapper.$$$reportNull$$$0(6);
        }
        return this.myShelvedChange != null ? this.myShelvedChange.getChange() : Objects.requireNonNull(this.myBinaryFile).createChange(project);
    }

    @Nullable
    public VirtualFile getBeforeVFUnderProject(@NotNull Project project) {
        if (project == null) {
            ShelvedWrapper.$$$reportNull$$$0(7);
        }
        if (this.getBeforePath() == null || project.getBasePath() == null) {
            return null;
        }
        File baseDir = new File(project.getBasePath());
        File file2 = new File(baseDir, this.getBeforePath());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapper";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeVFUnderProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

