/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LazyPatchContentRevision
implements ContentRevision {
    private final VirtualFile myVf;
    private final FilePath myNewFilePath;
    @NotNull
    private final String myRevision;
    private final TextFilePatch myPatch;
    private final NotNullLazyValue<Data> myData;

    public LazyPatchContentRevision(VirtualFile vf, FilePath newFilePath, @NotNull String revision, TextFilePatch patch2) {
        if (revision == null) {
            LazyPatchContentRevision.$$$reportNull$$$0(0);
        }
        this.myData = NotNullLazyValue.atomicLazy(this::loadContent);
        this.myVf = vf;
        this.myNewFilePath = newFilePath;
        this.myRevision = revision;
        this.myPatch = patch2;
    }

    private Data loadContent() {
        String localContext = (String)ReadAction.compute(() -> {
            Document doc = FileDocumentManager.getInstance().getDocument(this.myVf);
            return doc == null ? null : doc.getText();
        });
        if (localContext == null) {
            return new Data(null, true);
        }
        GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(localContext, this.myPatch.getHunks());
        if (appliedPatch != null) {
            return new Data(appliedPatch.patchedText, false);
        }
        return new Data(null, true);
    }

    @Nullable
    public String getContent() {
        return ((Data)this.myData.getValue()).content;
    }

    public boolean isPatchApplyFailed() {
        return ((Data)this.myData.getValue()).patchApplyFailed;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myNewFilePath;
        if (filePath == null) {
            LazyPatchContentRevision.$$$reportNull$$$0(1);
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return new VcsRevisionNumber(){

            @NotNull
            public String asString() {
                String string = LazyPatchContentRevision.this.myRevision;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public int compareTo(VcsRevisionNumber o) {
                return 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/LazyPatchContentRevision$1", "asString"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/LazyPatchContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/LazyPatchContentRevision";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Data {
        @Nullable
        public final String content;
        public final boolean patchApplyFailed;

        Data(@Nullable String content2, boolean patchApplyFailed) {
            this.content = content2;
            this.patchApplyFailed = patchApplyFailed;
        }
    }
}

