/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchFileHeaderInfo;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.MatchPatchPaths;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooserPanel;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.VcsUser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchDifferentiatedDialog
extends DialogWrapper {
    @ApiStatus.Internal
    public static final String DIMENSION_SERVICE_KEY = "vcs.ApplyPatchDifferentiatedDialog";
    private static final Logger LOG = Logger.getInstance(ApplyPatchDifferentiatedDialog.class);
    private final ZipperUpdater myLoadQueue;
    private final TextFieldWithBrowseButton myPatchFile;
    private final List<AbstractFilePatchInProgress<?>> myPatches;
    private final List<ShelvedBinaryFilePatch> myBinaryShelvedPatches;
    @NotNull
    private final EditorNotificationPanel myErrorNotificationPanel;
    @NotNull
    private final MyChangeTreeList myChangesTreeList;
    @NotNull
    private final JBLoadingPanel myChangesTreeLoadingPanel;
    @Nullable
    private final Collection<? extends Change> myPreselectedChanges;
    private final boolean myUseProjectRootAsPredefinedBase;
    private JComponent myCenterPanel;
    protected final Project myProject;
    private final AtomicReference<FilePresentationModel> myRecentPathFileChange;
    private final MyUpdater myUpdater;
    private final Runnable myReset;
    @Nullable
    private final ChangeListChooserPanel myChangeListChooser;
    private final ChangesLegendCalculator myInfoCalculator;
    private final CommitLegendPanel myCommitLegendPanel;
    private final ApplyPatchExecutor myCallback;
    private final List<? extends ApplyPatchExecutor> myExecutors;
    private boolean myContainBasedChanges;
    private JLabel myPatchFileLabel;
    private PatchReader myReader;
    private final boolean myCanChangePatchFile;
    private String myHelpId;
    private final boolean myShouldUpdateChangeListName;

    public ApplyPatchDifferentiatedDialog(Project project, ApplyPatchExecutor<?> callback2, List<? extends ApplyPatchExecutor<?>> executors, @NotNull ApplyPatchMode applyPatchMode, @NotNull VirtualFile patchFile) {
        if (applyPatchMode == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(0);
        }
        if (patchFile == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(1);
        }
        this(project, callback2, executors, applyPatchMode, patchFile, null, null, null, null, null, false);
    }

    public ApplyPatchDifferentiatedDialog(Project project, ApplyPatchExecutor<?> callback2, List<? extends ApplyPatchExecutor<?>> executors, @NotNull ApplyPatchMode applyPatchMode, @NotNull List<FilePatch> patches2, @Nullable ChangeList defaultList) {
        if (applyPatchMode == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(2);
        }
        if (patches2 == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(3);
        }
        this(project, callback2, executors, applyPatchMode, null, patches2, defaultList, null, null, null, false);
    }

    public ApplyPatchDifferentiatedDialog(Project project, ApplyPatchExecutor<?> callback2, List<? extends ApplyPatchExecutor<?>> executors, @NotNull ApplyPatchMode applyPatchMode, @Nullable VirtualFile patchFile, @Nullable List<FilePatch> patches2, @Nullable ChangeList defaultList, @Nullable List<ShelvedBinaryFilePatch> binaryShelvedPatches, @Nullable Collection<Change> preselectedChanges, @Nullable @NlsSafe String externalCommitMessage, boolean useProjectRootAsPredefinedBase) {
        if (applyPatchMode == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(4);
        }
        super(project, true);
        this.myHelpId = "reference.dialogs.vcs.patch.apply";
        this.myCallback = callback2;
        this.myExecutors = executors;
        this.myUseProjectRootAsPredefinedBase = useProjectRootAsPredefinedBase;
        this.setModal(false);
        this.setHorizontalStretch(2.0f);
        this.setVerticalStretch(2.0f);
        this.setTitle(applyPatchMode.getTitle());
        FileChooserDescriptor descriptor2 = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
        descriptor2.setTitle(VcsBundle.message((String)"patch.apply.select.title", (Object[])new Object[0]));
        this.myProject = project;
        this.myPatches = new ArrayList();
        this.myRecentPathFileChange = new AtomicReference();
        this.myBinaryShelvedPatches = binaryShelvedPatches;
        this.myPreselectedChanges = preselectedChanges;
        this.myErrorNotificationPanel = new EditorNotificationPanel(LightColors.RED);
        this.cleanNotifications();
        this.myChangesTreeList = new MyChangeTreeList(project, new Runnable(){

            @Override
            public void run() {
                NamedLegendStatuses includedNameStatuses = new NamedLegendStatuses();
                Collection includedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getIncludedChanges();
                HashSet<Couple> set2 = new HashSet<Couple>();
                for (AbstractFilePatchInProgress.PatchChange change : includedChanges) {
                    Object patch2 = change.getPatchInProgress().getPatch();
                    Couple pair = Couple.of((Object)patch2.getBeforeName(), (Object)patch2.getAfterName());
                    if (set2.contains(pair)) continue;
                    set2.add(pair);
                    ApplyPatchDifferentiatedDialog.acceptChange(includedNameStatuses, change);
                }
                ApplyPatchDifferentiatedDialog.this.myInfoCalculator.setIncluded(includedNameStatuses);
                ApplyPatchDifferentiatedDialog.this.myCommitLegendPanel.update();
                ApplyPatchDifferentiatedDialog.this.updateOkActions();
            }
        }, new MyChangeNodeDecorator());
        this.myChangesTreeList.setDoubleClickAndEnterKeyHandler(() -> {
            List selectedChanges = this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() == 1 && !((AbstractFilePatchInProgress.PatchChange)((Object)((Object)selectedChanges.get(0)))).isValid()) {
                this.myChangesTreeList.handleInvalidChangesAndToggle();
            }
            new MyShowDiff().showDiff();
        });
        this.myChangesTreeLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.myChangesTreeLoadingPanel.add((Component)((Object)this.myChangesTreeList), (Object)"Center");
        this.myShouldUpdateChangeListName = defaultList == null && externalCommitMessage == null;
        this.myUpdater = new MyUpdater();
        this.myPatchFile = new TextFieldWithBrowseButton();
        this.myPatchFile.addBrowseFolderListener(VcsBundle.message((String)"patch.apply.select.title", (Object[])new Object[0]), "", project, descriptor2);
        this.myPatchFile.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplyPatchDifferentiatedDialog.this.setPathFileChangeDefault();
                ApplyPatchDifferentiatedDialog.this.queueRequest();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$2", "textChanged"));
            }
        });
        this.myLoadQueue = new ZipperUpdater(500, Alarm.ThreadToUse.POOLED_THREAD, this.getDisposable());
        this.myCanChangePatchFile = applyPatchMode.isCanChangePatchFile();
        this.myReset = this.myCanChangePatchFile ? this::reset : EmptyRunnable.getInstance();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.areChangeListsEnabled()) {
            this.myChangeListChooser = new ChangeListChooserPanel(project, (Consumer<? super String>)new Consumer<String>(){

                @Override
                public void accept(@Nullable @NlsContexts.DialogMessage String errorMessage) {
                    ApplyPatchDifferentiatedDialog.this.setOKActionEnabled(errorMessage == null && ApplyPatchDifferentiatedDialog.this.isChangeTreeEnabled());
                    ApplyPatchDifferentiatedDialog.this.setErrorText(errorMessage, ApplyPatchDifferentiatedDialog.this.myChangeListChooser);
                }
            });
            if (defaultList != null) {
                this.myChangeListChooser.setDefaultSelection(defaultList);
            } else if (externalCommitMessage != null) {
                this.myChangeListChooser.setSuggestedName(externalCommitMessage);
            }
            this.myChangeListChooser.init();
        } else {
            this.myChangeListChooser = null;
        }
        this.myInfoCalculator = new ChangesLegendCalculator();
        this.myCommitLegendPanel = new CommitLegendPanel(this.myInfoCalculator){

            @Override
            public void update() {
                super.update();
                int inapplicable = ApplyPatchDifferentiatedDialog.this.myInfoCalculator.getInapplicable();
                if (inapplicable > 0) {
                    this.appendSpace();
                    this.append(inapplicable, FileStatus.MERGED_WITH_CONFLICTS, VcsBundle.message((String)"patch.apply.missing.base.file.label", (Object[])new Object[0]));
                }
            }
        };
        this.init();
        if (patchFile != null && patchFile.isValid()) {
            patchFile.refresh(false, false);
            this.init(patchFile);
        } else if (patches2 != null) {
            this.init(patches2);
        }
        this.myPatchFileLabel.setVisible(this.myCanChangePatchFile);
        this.myPatchFile.setVisible(this.myCanChangePatchFile);
        if (this.myCanChangePatchFile) {
            BulkFileListener listener2 = new BulkFileListener(){

                public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                    if (events == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                        ApplyPatchDifferentiatedDialog.this.syncUpdatePatchFileAndScheduleReloadIfNeeded(vFileEvent.getFile());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$5", "after"));
                }
            };
            ApplicationManager.getApplication().getMessageBus().connect(this.getDisposable()).subscribe(VirtualFileManager.VFS_CHANGES, (Object)listener2);
        }
        this.updateOkActions();
    }

    private void updateOkActions() {
        boolean changeTreeEnabled = this.isChangeTreeEnabled();
        this.setOKActionEnabled(changeTreeEnabled);
        if (changeTreeEnabled && this.myChangeListChooser != null) {
            this.myChangeListChooser.updateEnabled();
        }
    }

    private boolean isChangeTreeEnabled() {
        return !this.myChangesTreeList.getIncludedChanges().isEmpty();
    }

    private void queueRequest() {
        this.paintBusy(true);
        this.myLoadQueue.queue(this.myUpdater);
    }

    private void init(@NotNull List<FilePatch> patches2) {
        if (patches2 == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(5);
        }
        List<AbstractFilePatchInProgress<?>> matchedPatches = new MatchPatchPaths(this.myProject).execute(patches2, this.myUseProjectRootAsPredefinedBase);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myPatches.clear();
            this.myPatches.addAll(matchedPatches);
            this.updateTree(true);
        });
    }

    public static FileChooserDescriptor createSelectPatchDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                return FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)PatchFileType.INSTANCE) || FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)FileTypes.PLAIN_TEXT);
            }
        };
    }

    protected Action @NotNull [] createActions() {
        if (this.myExecutors.isEmpty()) {
            Action[] actionArray = super.createActions();
            if (actionArray == null) {
                ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(6);
            }
            return actionArray;
        }
        ArrayList<Action> actions2 = new ArrayList<Action>(4);
        actions2.add(this.getOKAction());
        int i2 = 0;
        while (i2 < this.myExecutors.size()) {
            final ApplyPatchExecutor executor = this.myExecutors.get(i2);
            final int finalI = i2++;
            actions2.add(new AbstractAction(executor.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplyPatchDifferentiatedDialog.this.runExecutor(executor);
                    ApplyPatchDifferentiatedDialog.this.close(2 + finalI);
                }
            });
        }
        actions2.add(this.getCancelAction());
        actions2.add(this.getHelpAction());
        Action[] actionArray = actions2.toArray(new Action[0]);
        if (actionArray == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(7);
        }
        return actionArray;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void runExecutor(ApplyPatchExecutor<AbstractFilePatchInProgress<?>> applyPatchExecutor) {
        void executor;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Collection<AbstractFilePatchInProgress<?>> included = this.getIncluded();
        if (included.isEmpty()) {
            return;
        }
        MultiMap patchGroups = new MultiMap();
        for (AbstractFilePatchInProgress<?> patchInProgress : included) {
            patchGroups.putValue((Object)patchInProgress.getBase(), patchInProgress);
        }
        LocalChangeList targetChangelist = this.getSelectedChangeList();
        FilePresentationModel presentation2 = this.myRecentPathFileChange.get();
        VirtualFile vf = presentation2 != null ? presentation2.getVf() : null;
        executor.apply(this.getOriginalRemaining(), patchGroups, targetChangelist, vf == null ? null : vf.getName(), this.myReader == null ? null : this.myReader.getAdditionalInfo(ApplyPatchDefaultExecutor.pathsFromGroups(patchGroups)));
    }

    @NotNull
    private List<FilePatch> getOriginalRemaining() {
        Collection notIncluded = ContainerUtil.subtract(this.myPatches, this.getIncluded());
        ArrayList<FilePatch> remainingOriginal = new ArrayList<FilePatch>();
        for (AbstractFilePatchInProgress progress2 : notIncluded) {
            progress2.reset();
            remainingOriginal.add((FilePatch)progress2.getPatch());
        }
        ArrayList<FilePatch> arrayList = remainingOriginal;
        if (arrayList == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY;
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myChangeListChooser != null) {
            return this.myChangeListChooser.getPreferredFocusedComponent();
        }
        return this.myChangesTreeList;
    }

    private void setPathFileChangeDefault() {
        this.myRecentPathFileChange.set(new FilePresentationModel(this.myPatchFile.getText()));
    }

    private void init(@NotNull VirtualFile patchFile) {
        if (patchFile == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(9);
        }
        this.myPatchFile.setText(patchFile.getPresentableUrl());
        this.myRecentPathFileChange.set(new FilePresentationModel(patchFile));
    }

    public void setHelpId(String s) {
        this.myHelpId = s;
    }

    @Nullable
    private String getSubjectFromMessage(@Nullable String message2) {
        return StringUtil.isEmptyOrSpaces((String)message2) ? null : ChangeListUtil.createNameForChangeList(this.myProject, message2);
    }

    @Nullable
    private PatchReader loadPatches(@NotNull VirtualFile patchFile) {
        if (patchFile == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(10);
        }
        try {
            String text2 = (String)ReadAction.compute(() -> {
                try (InputStreamReader inputStreamReader = new InputStreamReader(patchFile.getInputStream(), patchFile.getCharset());){
                    String string = StreamUtil.readText((Reader)inputStreamReader);
                    return string;
                }
            });
            PatchReader reader = new PatchReader(text2);
            reader.parseAllPatches();
            return reader;
        }
        catch (Exception e) {
            this.addNotificationAndWarn(VcsBundle.message((String)"patch.apply.cannot.read.patch", (Object[])new Object[]{patchFile.getPresentableName(), e.getMessage()}));
            return null;
        }
    }

    private void addNotificationAndWarn(@NotNull @NlsContexts.Label String errorMessage) {
        if (errorMessage == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(11);
        }
        LOG.warn(errorMessage);
        this.myErrorNotificationPanel.setText(errorMessage);
        this.myErrorNotificationPanel.setVisible(true);
    }

    private void cleanNotifications() {
        this.myErrorNotificationPanel.setText("");
        this.myErrorNotificationPanel.setVisible(false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void syncUpdatePatchFileAndScheduleReloadIfNeeded(@Nullable VirtualFile virtualFile2) {
        void eventFile;
        VirtualFile filePresentationVf;
        ApplicationManager.getApplication().assertIsDispatchThread();
        FilePresentationModel filePresentationModel = this.myRecentPathFileChange.get();
        VirtualFile virtualFile3 = filePresentationVf = filePresentationModel != null ? filePresentationModel.getVf() : null;
        if (filePresentationVf != null && (eventFile == null || filePresentationVf.equals(eventFile))) {
            filePresentationVf.refresh(false, false);
            this.queueRequest();
        }
    }

    private void reset() {
        this.myPatches.clear();
        this.myChangesTreeList.setChangesToDisplay(Collections.emptyList());
        this.myChangesTreeList.repaint();
        this.myContainBasedChanges = false;
        this.paintBusy(false);
    }

    protected JComponent createCenterPanel() {
        if (this.myCenterPanel == null) {
            this.myCenterPanel = new JPanel(new GridBagLayout());
            GridBagConstraints centralGb = ApplyPatchDifferentiatedDialog.createConstraints();
            this.myPatchFileLabel = new JLabel(VcsBundle.message((String)"patch.apply.file.name.field", (Object[])new Object[0]));
            this.myPatchFileLabel.setLabelFor((Component)this.myPatchFile);
            this.myCenterPanel.add((Component)this.myPatchFileLabel, centralGb);
            centralGb.fill = 2;
            ++centralGb.gridy;
            this.myCenterPanel.add((Component)this.myPatchFile, centralGb);
            JPanel treePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gb = ApplyPatchDifferentiatedDialog.createConstraints();
            DefaultActionGroup group2 = new DefaultActionGroup();
            MyShowDiff diffAction = new MyShowDiff();
            diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), this.getRootPane());
            group2.add((AnAction)diffAction);
            ActionGroup mapDirectoryActionGroup = new ActionGroup(VcsBundle.message((String)"patch.apply.change.directory.paths.group", (Object[])new Object[0]), null, AllIcons.Vcs.Folders){

                public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                    AnAction[] anActionArray = new AnAction[]{new MapDirectory(), new StripUp(IdeBundle.messagePointer((String)"action.Anonymous.text.remove.leading.directory", (Object[])new Object[0])), new ZeroStrip(), new StripDown(IdeBundle.messagePointer((String)"action.Anonymous.text.restore.leading.directory", (Object[])new Object[0])), new ResetStrip()};
                    if (anActionArray == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return anActionArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$8", "getChildren"));
                }
            };
            mapDirectoryActionGroup.setPopup(true);
            group2.add((AnAction)mapDirectoryActionGroup);
            if (this.myCanChangePatchFile) {
                group2.add((AnAction)new DumbAwareAction(VcsBundle.messagePointer((String)"action.DumbAware.ApplyPatchDifferentiatedDialog.text.refresh", (Object[])new Object[0]), VcsBundle.messagePointer((String)"action.DumbAware.ApplyPatchDifferentiatedDialog.description.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            9.$$$reportNull$$$0(0);
                        }
                        ApplyPatchDifferentiatedDialog.this.syncUpdatePatchFileAndScheduleReloadIfNeeded(null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$9", "actionPerformed"));
                    }
                });
            }
            group2.add((AnAction)Separator.getInstance());
            group2.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("APPLY_PATCH", (ActionGroup)group2, true);
            TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(toolbar, (ChangesTree)this.myChangesTreeList);
            gb.fill = 2;
            treePanel.add((Component)toolbarPanel, gb);
            ++gb.gridy;
            gb.weighty = 1.0;
            gb.fill = 1;
            BorderLayoutPanel changeTreePanel = JBUI.Panels.simplePanel((Component)this.myChangesTreeLoadingPanel).addToTop((Component)this.myErrorNotificationPanel);
            treePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)changeTreePanel), gb);
            ++gb.gridy;
            gb.weighty = 0.0;
            gb.fill = 0;
            gb.insets.bottom = 4;
            treePanel.add((Component)this.myCommitLegendPanel.getComponent(), gb);
            ++gb.gridy;
            ++centralGb.gridy;
            centralGb.weighty = 1.0;
            centralGb.fill = 1;
            if (this.myChangeListChooser != null) {
                Splitter splitter = new Splitter(true, 0.7f);
                splitter.setFirstComponent((JComponent)treePanel);
                splitter.setSecondComponent((JComponent)this.myChangeListChooser);
                this.myCenterPanel.add((Component)splitter, centralGb);
            } else {
                this.myCenterPanel.add((Component)treePanel, centralGb);
            }
        }
        return this.myCenterPanel;
    }

    @NotNull
    private static GridBagConstraints createConstraints() {
        return new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)1), 0, 0);
    }

    private void paintBusy(boolean isBusy) {
        if (isBusy) {
            this.myChangesTreeList.setEmptyText("");
            this.myChangesTreeLoadingPanel.startLoading();
        } else {
            this.myChangesTreeList.setEmptyText(VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]));
            this.myChangesTreeLoadingPanel.stopLoading();
        }
    }

    private static boolean sameBase(List<? extends AbstractFilePatchInProgress.PatchChange> selectedChanges) {
        VirtualFile base = null;
        for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
            VirtualFile changeBase = patchChange.getPatchInProgress().getBase();
            if (base == null) {
                base = changeBase;
                continue;
            }
            if (base.equals(changeBase)) continue;
            return false;
        }
        return true;
    }

    private void updateTree(boolean doInitCheck) {
        List<AbstractFilePatchInProgress> patchesToSelect = ApplyPatchDifferentiatedDialog.changes2patches(this.myChangesTreeList.getSelectedChanges());
        List<AbstractFilePatchInProgress.PatchChange> changes = this.getAllChanges();
        Collection<AbstractFilePatchInProgress.PatchChange> included = this.getIncluded(doInitCheck, changes);
        this.myChangesTreeList.setIncludedChanges(included);
        this.myChangesTreeList.setChangesToDisplay(changes);
        if (doInitCheck) {
            this.myChangesTreeList.expandAll();
        }
        this.myChangesTreeList.repaint();
        if (!doInitCheck) {
            ArrayList<AbstractFilePatchInProgress.PatchChange> toSelect2 = new ArrayList<AbstractFilePatchInProgress.PatchChange>(patchesToSelect.size());
            for (AbstractFilePatchInProgress.PatchChange change : changes) {
                if (!patchesToSelect.contains(change.getPatchInProgress())) continue;
                toSelect2.add(change);
            }
            this.myChangesTreeList.setSelectedChanges(toSelect2);
        }
        this.myContainBasedChanges = false;
        for (AbstractFilePatchInProgress<?> patch2 : this.myPatches) {
            if (!patch2.baseExistsOrAdded()) continue;
            this.myContainBasedChanges = true;
            break;
        }
    }

    private List<AbstractFilePatchInProgress.PatchChange> getAllChanges() {
        return ContainerUtil.map(this.myPatches, AbstractFilePatchInProgress::getChange);
    }

    private static void acceptChange(NamedLegendStatuses nameStatuses, AbstractFilePatchInProgress.PatchChange change) {
        AbstractFilePatchInProgress<?> patchInProgress = change.getPatchInProgress();
        if (FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus())) {
            nameStatuses.plusAdded();
        } else if (FilePatchStatus.DELETED.equals((Object)patchInProgress.getStatus())) {
            nameStatuses.plusDeleted();
        } else {
            nameStatuses.plusModified();
        }
        if (!patchInProgress.baseExistsOrAdded()) {
            nameStatuses.plusInapplicable();
        }
    }

    private Collection<AbstractFilePatchInProgress.PatchChange> getIncluded(boolean doInitCheck, List<? extends AbstractFilePatchInProgress.PatchChange> changes) {
        NamedLegendStatuses totalNameStatuses = new NamedLegendStatuses();
        NamedLegendStatuses includedNameStatuses = new NamedLegendStatuses();
        ArrayList<AbstractFilePatchInProgress.PatchChange> included = new ArrayList<AbstractFilePatchInProgress.PatchChange>();
        if (doInitCheck) {
            for (AbstractFilePatchInProgress.PatchChange patchChange : changes) {
                ApplyPatchDifferentiatedDialog.acceptChange(totalNameStatuses, patchChange);
                AbstractFilePatchInProgress<?> abstractFilePatchInProgress = patchChange.getPatchInProgress();
                if (!abstractFilePatchInProgress.baseExistsOrAdded() || this.myPreselectedChanges != null && !this.myPreselectedChanges.contains((Object)patchChange)) continue;
                ApplyPatchDifferentiatedDialog.acceptChange(includedNameStatuses, patchChange);
                included.add(patchChange);
            }
        } else {
            Collection includedNow = this.myChangesTreeList.getIncludedChanges();
            HashSet hashSet = new HashSet();
            for (AbstractFilePatchInProgress.PatchChange patchChange : includedNow) {
                AbstractFilePatchInProgress<?> patch2 = patchChange.getPatchInProgress();
                hashSet.add(patch2);
            }
            for (AbstractFilePatchInProgress.PatchChange patchChange : changes) {
                AbstractFilePatchInProgress<?> patch2 = patchChange.getPatchInProgress();
                ApplyPatchDifferentiatedDialog.acceptChange(totalNameStatuses, patchChange);
                if (!hashSet.contains(patch2) || !patch2.baseExistsOrAdded()) continue;
                ApplyPatchDifferentiatedDialog.acceptChange(includedNameStatuses, patchChange);
                included.add(patchChange);
            }
        }
        this.myInfoCalculator.setTotal(totalNameStatuses);
        this.myInfoCalculator.setIncluded(includedNameStatuses);
        this.myCommitLegendPanel.update();
        return included;
    }

    private static List<AbstractFilePatchInProgress> changes2patches(List<? extends AbstractFilePatchInProgress.PatchChange> selectedChanges) {
        return ContainerUtil.map(selectedChanges, AbstractFilePatchInProgress.PatchChange::getPatchInProgress);
    }

    private boolean basePathWasChanged(@NotNull AbstractFilePatchInProgress patchInProgress) {
        if (patchInProgress == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(12);
        }
        return !FileUtil.filesEqual((File)patchInProgress.myIoCurrentBase, (File)new File(this.myProject.getBasePath(), patchInProgress.getOriginalBeforePath()));
    }

    private Collection<AbstractFilePatchInProgress<?>> getIncluded() {
        return ContainerUtil.map(this.myChangesTreeList.getIncludedChanges(), AbstractFilePatchInProgress.PatchChange::getPatchInProgress);
    }

    @Nullable
    private LocalChangeList getSelectedChangeList() {
        return this.myChangeListChooser != null ? this.myChangeListChooser.getSelectedList(this.myProject) : null;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.runExecutor(this.myCallback);
    }

    @NotNull
    private static DiffRequestProducer createBaseNotFoundErrorRequest(final @NotNull AbstractFilePatchInProgress patchInProgress) {
        if (patchInProgress == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(13);
        }
        final String beforePath = patchInProgress.getPatch().getBeforeName();
        final String afterPath = patchInProgress.getPatch().getAfterName();
        return new DiffRequestProducer(){

            @NotNull
            public String getName() {
                File ioCurrentBase = patchInProgress.getIoCurrentBase();
                String string = ioCurrentBase == null ? patchInProgress.getCurrentPath() : ioCurrentBase.getPath();
                if (string == null) {
                    10.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException, ProcessCanceledException {
                if (context2 == null) {
                    10.$$$reportNull$$$0(1);
                }
                if (indicator2 == null) {
                    10.$$$reportNull$$$0(2);
                }
                throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.cannot.find.base.for.path", (Object[])new Object[]{beforePath != null ? beforePath : afterPath}));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$10";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$10";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyPatchMode";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchInProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalRemaining";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadPatches";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationAndWarn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "basePathWasChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createBaseNotFoundErrorRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeComparator
    implements Comparator<AbstractFilePatchInProgress.PatchChange> {
        private MyChangeComparator() {
        }

        @Override
        public int compare(AbstractFilePatchInProgress.PatchChange o1, AbstractFilePatchInProgress.PatchChange o2) {
            if (PropertiesComponent.getInstance((Project)ApplyPatchDifferentiatedDialog.this.myProject).isTrueValue("ChangesBrowser.SHOW_FLATTEN")) {
                return o1.getPatchInProgress().getIoCurrentBase().getName().compareTo(o2.getPatchInProgress().getIoCurrentBase().getName());
            }
            return FileUtil.compareFiles((File)o1.getPatchInProgress().getIoCurrentBase(), (File)o2.getPatchInProgress().getIoCurrentBase());
        }
    }

    private static final class MyProducerWrapper
    implements ChangeDiffRequestChain.Producer {
        private final DiffRequestProducer myProducer;
        private final Change myChange;

        private MyProducerWrapper(@NotNull DiffRequestProducer producer, @NotNull Change change) {
            if (producer == null) {
                MyProducerWrapper.$$$reportNull$$$0(0);
            }
            if (change == null) {
                MyProducerWrapper.$$$reportNull$$$0(1);
            }
            this.myChange = change;
            this.myProducer = producer;
        }

        @NotNull
        public String getName() {
            String string = this.myProducer.getName();
            if (string == null) {
                MyProducerWrapper.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
            if (context2 == null) {
                MyProducerWrapper.$$$reportNull$$$0(3);
            }
            if (indicator2 == null) {
                MyProducerWrapper.$$$reportNull$$$0(4);
            }
            DiffRequest diffRequest = this.myProducer.process(context2, indicator2);
            if (diffRequest == null) {
                MyProducerWrapper.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = ChangesUtil.getFilePath((Change)this.myChange);
            if (filePath == null) {
                MyProducerWrapper.$$$reportNull$$$0(6);
            }
            return filePath;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myChange.getFileStatus();
            if (fileStatus == null) {
                MyProducerWrapper.$$$reportNull$$$0(7);
            }
            return fileStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyProducerWrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyProducerWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyShowDiff
    extends DumbAwareAction {
        private final MyChangeComparator myMyChangeComparator;

        private MyShowDiff() {
            super(VcsBundle.message((String)"action.name.show.difference", (Object[])new Object[0]), null, AllIcons.Actions.Diff);
            this.myMyChangeComparator = new MyChangeComparator();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowDiff.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(!ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() && ApplyPatchDifferentiatedDialog.this.myContainBasedChanges);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowDiff.$$$reportNull$$$0(1);
            }
            this.showDiff();
        }

        private void showDiff() {
            if (ChangeListManager.getInstance((Project)ApplyPatchDifferentiatedDialog.this.myProject).isFreezedWithNotification(null)) {
                return;
            }
            if (ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() || !ApplyPatchDifferentiatedDialog.this.myContainBasedChanges) {
                return;
            }
            List<AbstractFilePatchInProgress.PatchChange> changes = ApplyPatchDifferentiatedDialog.this.getAllChanges();
            changes.sort(this.myMyChangeComparator);
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (changes.isEmpty()) {
                return;
            }
            AbstractFilePatchInProgress.PatchChange selectedChange = !selectedChanges.isEmpty() ? (AbstractFilePatchInProgress.PatchChange)((Object)selectedChanges.get(0)) : changes.get(0);
            int selectedIdx = 0;
            ArrayList<ChangeDiffRequestChain.Producer> diffRequestPresentableList = new ArrayList<ChangeDiffRequestChain.Producer>();
            for (AbstractFilePatchInProgress.PatchChange change : changes) {
                diffRequestPresentableList.add(this.createDiffRequestProducer(change));
                if (!change.equals((Object)selectedChange)) continue;
                selectedIdx = diffRequestPresentableList.size() - 1;
            }
            ChangeDiffRequestChain chain = new ChangeDiffRequestChain(diffRequestPresentableList, selectedIdx);
            DiffManager.getInstance().showDiff(ApplyPatchDifferentiatedDialog.this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
        }

        @NotNull
        private ChangeDiffRequestChain.Producer createDiffRequestProducer(@NotNull AbstractFilePatchInProgress.PatchChange change) {
            AbstractFilePatchInProgress<?> patchInProgress;
            if (change == null) {
                MyShowDiff.$$$reportNull$$$0(2);
            }
            DiffRequestProducer delegate2 = !(patchInProgress = change.getPatchInProgress()).baseExistsOrAdded() ? ApplyPatchDifferentiatedDialog.createBaseNotFoundErrorRequest(patchInProgress) : patchInProgress.getDiffRequestProducers(ApplyPatchDifferentiatedDialog.this.myProject, ApplyPatchDifferentiatedDialog.this.myReader);
            return new MyProducerWrapper(delegate2, change);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyShowDiff";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createDiffRequestProducer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ResetStrip
    extends StripDown {
        ResetStrip() {
            super(VcsBundle.messagePointer((String)"action.Anonymous.text.restore.all.leading.directories", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetStrip.$$$reportNull$$$0(0);
            }
            ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges().forEach(change -> change.getPatchInProgress().reset());
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$ResetStrip", "actionPerformed"));
        }
    }

    private class StripUp
    extends DumbAwareAction {
        StripUp(Supplier<String> text2) {
            super(text2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StripUp.$$$reportNull$$$0(0);
            }
            boolean isEnabled = ContainerUtil.exists(ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges(), change -> change.getPatchInProgress().canUp());
            e.getPresentation().setEnabled(isEnabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StripUp.$$$reportNull$$$0(1);
            }
            ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges().forEach(change -> change.getPatchInProgress().up());
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$StripUp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class StripDown
    extends DumbAwareAction {
        StripDown(Supplier<String> text2) {
            if (text2 == null) {
                StripDown.$$$reportNull$$$0(0);
            }
            super(text2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StripDown.$$$reportNull$$$0(1);
            }
            boolean isEnabled = ContainerUtil.exists(ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges(), change -> change.getPatchInProgress().canDown());
            e.getPresentation().setEnabled(isEnabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StripDown.$$$reportNull$$$0(2);
            }
            ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges().forEach(change -> change.getPatchInProgress().down());
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$StripDown";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ZeroStrip
    extends StripUp {
        ZeroStrip() {
            super(VcsBundle.messagePointer((String)"action.Anonymous.text.remove.all.leading.directories", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ZeroStrip.$$$reportNull$$$0(0);
            }
            ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges().forEach(change -> change.getPatchInProgress().setZero());
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$ZeroStrip", "actionPerformed"));
        }
    }

    private final class MyChangeNodeDecorator
    implements ChangeNodeDecorator {
        private MyChangeNodeDecorator() {
        }

        @Override
        public void decorate(@NotNull Change change, @NotNull SimpleColoredComponent component2, boolean isShowFlatten) {
            if (change == null) {
                MyChangeNodeDecorator.$$$reportNull$$$0(0);
            }
            if (component2 == null) {
                MyChangeNodeDecorator.$$$reportNull$$$0(1);
            }
            if (change instanceof AbstractFilePatchInProgress.PatchChange) {
                AbstractFilePatchInProgress.PatchChange patchChange = (AbstractFilePatchInProgress.PatchChange)change;
                AbstractFilePatchInProgress<?> patchInProgress = patchChange.getPatchInProgress();
                if (patchInProgress.getCurrentStrip() > 0) {
                    component2.append(VcsBundle.message((String)"patch.apply.stripped.description", (Object[])new Object[]{patchInProgress.getCurrentStrip()}), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                }
                String text2 = FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus()) ? VcsBundle.message((String)"patch.apply.added.status", (Object[])new Object[0]) : (FilePatchStatus.DELETED.equals((Object)patchInProgress.getStatus()) ? VcsBundle.message((String)"patch.apply.deleted.status", (Object[])new Object[0]) : VcsBundle.message((String)"patch.apply.modified.status", (Object[])new Object[0]));
                component2.append("   ");
                component2.append(text2, SimpleTextAttributes.GRAY_ATTRIBUTES);
                if (!patchInProgress.baseExistsOrAdded()) {
                    component2.append("  ");
                    component2.append(VcsBundle.message((String)"patch.apply.select.missing.base.link", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, () -> ApplyPatchDifferentiatedDialog.this.myChangesTreeList.handleInvalidChangesAndToggle());
                } else if (!patchInProgress.getStatus().equals((Object)FilePatchStatus.ADDED) && ApplyPatchDifferentiatedDialog.this.basePathWasChanged(patchInProgress)) {
                    component2.append("  ");
                    component2.append(VcsBundle.message((String)"patch.apply.new.base.detected.node.description", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                    component2.setToolTipText(VcsBundle.message((String)"patch.apply.old.new.base.info", (Object[])new Object[]{patchInProgress.getOriginalBeforePath(), ApplyPatchDifferentiatedDialog.this.myProject.getBasePath(), patchInProgress.getPatch().getBeforeName(), patchInProgress.getBase().getPath()}));
                }
            }
        }

        @Override
        public void preDecorate(@NotNull Change change, @NotNull ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
            if (change == null) {
                MyChangeNodeDecorator.$$$reportNull$$$0(2);
            }
            if (renderer == null) {
                MyChangeNodeDecorator.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyChangeNodeDecorator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decorate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preDecorate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ChangesLegendCalculator
    implements CommitLegendPanel.InfoCalculator {
        private NamedLegendStatuses myTotal = new NamedLegendStatuses();
        private NamedLegendStatuses myIncluded = new NamedLegendStatuses();

        private ChangesLegendCalculator() {
        }

        public void setTotal(NamedLegendStatuses nameStatuses) {
            this.myTotal = nameStatuses;
        }

        public void setIncluded(NamedLegendStatuses nameStatuses) {
            this.myIncluded = nameStatuses;
        }

        @Override
        public int getNew() {
            return this.myTotal.getAdded();
        }

        @Override
        public int getModified() {
            return this.myTotal.getModified();
        }

        @Override
        public int getDeleted() {
            return this.myTotal.getDeleted();
        }

        @Override
        public int getUnversioned() {
            return 0;
        }

        public int getInapplicable() {
            return this.myTotal.getInapplicable();
        }

        @Override
        public int getIncludedNew() {
            return this.myIncluded.getAdded();
        }

        @Override
        public int getIncludedModified() {
            return this.myIncluded.getModified();
        }

        @Override
        public int getIncludedDeleted() {
            return this.myIncluded.getDeleted();
        }

        @Override
        public int getIncludedUnversioned() {
            return 0;
        }
    }

    private static class NamedLegendStatuses {
        private int myAdded = 0;
        private int myModified = 0;
        private int myDeleted = 0;
        private int myInapplicable = 0;

        NamedLegendStatuses() {
        }

        public void plusAdded() {
            ++this.myAdded;
        }

        public void plusModified() {
            ++this.myModified;
        }

        public void plusDeleted() {
            ++this.myDeleted;
        }

        public void plusInapplicable() {
            ++this.myInapplicable;
        }

        public int getAdded() {
            return this.myAdded;
        }

        public int getModified() {
            return this.myModified;
        }

        public int getDeleted() {
            return this.myDeleted;
        }

        public int getInapplicable() {
            return this.myInapplicable;
        }
    }

    private final class MapPopup
    extends BaseListPopupStep<VirtualFile> {
        private final Runnable myNewBaseSelector;

        private MapPopup(List<? extends VirtualFile> aValues, Runnable newBaseSelector) {
            if (aValues == null) {
                MapPopup.$$$reportNull$$$0(0);
            }
            super(VcsBundle.message((String)"path.apply.select.base.directory.for.a.path.popup", (Object[])new Object[0]), aValues);
            this.myNewBaseSelector = newBaseSelector;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
            if (selectedValue == null) {
                this.myNewBaseSelector.run();
                return null;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    AbstractFilePatchInProgress<?> patch2 = patchChange.getPatchInProgress();
                    patch2.setNewBase(selectedValue);
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
            return null;
        }

        @NotNull
        public String getTextFor(VirtualFile value2) {
            String string = value2 == null ? VcsBundle.message((String)"patch.apply.select.base.for.a.path.message", (Object[])new Object[0]) : value2.getPath();
            if (string == null) {
                MapPopup.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aValues";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class NewBaseSelector
    implements Runnable {
        final boolean myDirectorySelector;

        NewBaseSelector() {
            this(true);
        }

        NewBaseSelector(boolean directorySelector) {
            this.myDirectorySelector = directorySelector;
        }

        @Override
        public void run() {
            FileChooserDescriptor descriptor2 = this.myDirectorySelector ? FileChooserDescriptorFactory.createSingleFolderDescriptor() : FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
            descriptor2.setTitle(VcsBundle.message((String)"patch.apply.select.base.title", (Object[])new Object[]{this.myDirectorySelector ? 0 : 1}));
            VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)ApplyPatchDifferentiatedDialog.this.myProject, null);
            if (selectedFile == null) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    AbstractFilePatchInProgress<?> patch2 = patchChange.getPatchInProgress();
                    if (this.myDirectorySelector) {
                        patch2.setNewBase(selectedFile);
                        continue;
                    }
                    Object filePatch = patch2.getPatch();
                    filePatch.setAfterName(selectedFile.getName());
                    filePatch.setBeforeName(selectedFile.getName());
                    patch2.setNewBase(selectedFile.getParent());
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
        }
    }

    private final class MapDirectory
    extends DumbAwareAction {
        private final NewBaseSelector myNewBaseSelector;

        private MapDirectory() {
            super(VcsBundle.message((String)"patch.apply.map.base.directory.action", (Object[])new Object[0]));
            this.myNewBaseSelector = new NewBaseSelector();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List selectedChanges;
            if (e == null) {
                MapDirectory.$$$reportNull$$$0(0);
            }
            if ((selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges()).size() >= 1 && ApplyPatchDifferentiatedDialog.sameBase(selectedChanges)) {
                AbstractFilePatchInProgress.PatchChange patchChange = (AbstractFilePatchInProgress.PatchChange)((Object)selectedChanges.get(0));
                AbstractFilePatchInProgress<?> patch2 = patchChange.getPatchInProgress();
                List<VirtualFile> autoBases = patch2.getAutoBasesCopy();
                if (autoBases.isEmpty() || autoBases.size() == 1 && autoBases.get(0).equals(patch2.getBase())) {
                    this.myNewBaseSelector.run();
                } else {
                    autoBases.add(null);
                    MapPopup step2 = new MapPopup(autoBases, this.myNewBaseSelector);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2).showCenteredInCurrentWindow(ApplyPatchDifferentiatedDialog.this.myProject);
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MapDirectory.$$$reportNull$$$0(1);
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            e.getPresentation().setEnabled(selectedChanges.size() >= 1 && ApplyPatchDifferentiatedDialog.sameBase(selectedChanges));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapDirectory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyChangeTreeList
    extends ChangesTreeImpl<AbstractFilePatchInProgress.PatchChange> {
        @Nullable
        private final ChangeNodeDecorator myChangeNodeDecorator;

        private MyChangeTreeList(@Nullable Project project, @Nullable Runnable inclusionListener, ChangeNodeDecorator decorator) {
            super(project, true, false, AbstractFilePatchInProgress.PatchChange.class);
            this.setInclusionListener(inclusionListener);
            this.myChangeNodeDecorator = decorator;
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull List<? extends AbstractFilePatchInProgress.PatchChange> changes) {
            if (changes == null) {
                MyChangeTreeList.$$$reportNull$$$0(0);
            }
            DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChanges(this.myProject, this.getGrouping(), changes, this.myChangeNodeDecorator);
            if (defaultTreeModel == null) {
                MyChangeTreeList.$$$reportNull$$$0(1);
            }
            return defaultTreeModel;
        }

        @Override
        protected boolean isInclusionEnabled(@NotNull ChangesBrowserNode<?> node) {
            if (node == null) {
                MyChangeTreeList.$$$reportNull$$$0(2);
            }
            boolean enabled = super.isInclusionEnabled(node);
            Object value2 = node.getUserObject();
            if (value2 instanceof AbstractFilePatchInProgress.PatchChange) {
                enabled &= ((AbstractFilePatchInProgress.PatchChange)((Object)value2)).isValid();
            }
            return enabled;
        }

        @NotNull
        private List<AbstractFilePatchInProgress.PatchChange> getOnlyValidChanges(@NotNull Collection<? extends AbstractFilePatchInProgress.PatchChange> changes) {
            if (changes == null) {
                MyChangeTreeList.$$$reportNull$$$0(3);
            }
            List list2 = ContainerUtil.filter(changes, AbstractFilePatchInProgress.PatchChange::isValid);
            if (list2 == null) {
                MyChangeTreeList.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Override
        protected void toggleChanges(@NotNull Collection<?> changes) {
            List patchChanges;
            if (changes == null) {
                MyChangeTreeList.$$$reportNull$$$0(5);
            }
            if ((patchChanges = ContainerUtil.findAll(changes, AbstractFilePatchInProgress.PatchChange.class)).size() == 1 && !((AbstractFilePatchInProgress.PatchChange)((Object)patchChanges.get(0))).isValid()) {
                this.handleInvalidChangesAndToggle();
            } else {
                super.toggleChanges(this.getOnlyValidChanges(patchChanges));
            }
        }

        private void handleInvalidChangesAndToggle() {
            new NewBaseSelector(false).run();
            super.toggleChanges(this.getOnlyValidChanges(this.getSelectedChanges()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyChangeTreeList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyChangeTreeList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOnlyValidChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModel";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isInclusionEnabled";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getOnlyValidChanges";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "toggleChanges";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FilePresentationModel {
        @NotNull
        private final String myPath;
        @Nullable
        private VirtualFile myVf;

        private FilePresentationModel(@NotNull String path2) {
            if (path2 == null) {
                FilePresentationModel.$$$reportNull$$$0(0);
            }
            this.myPath = path2;
            this.myVf = null;
        }

        FilePresentationModel(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FilePresentationModel.$$$reportNull$$$0(1);
            }
            this.myPath = file2.getPath();
            this.myVf = file2;
        }

        @Nullable
        public VirtualFile getVf() {
            if (this.myVf == null) {
                VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(this.myPath), (boolean)true);
                this.myVf = file2 != null && !file2.isDirectory() ? file2 : null;
            }
            return this.myVf;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$FilePresentationModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyUpdater
    implements Runnable {
        private MyUpdater() {
        }

        @Override
        public void run() {
            VcsUser author;
            VirtualFile file2;
            ApplyPatchDifferentiatedDialog.this.cleanNotifications();
            FilePresentationModel filePresentationModel = ApplyPatchDifferentiatedDialog.this.myRecentPathFileChange.get();
            VirtualFile virtualFile2 = file2 = filePresentationModel != null ? filePresentationModel.getVf() : null;
            if (file2 == null) {
                ApplicationManager.getApplication().invokeLater(ApplyPatchDifferentiatedDialog.this.myReset, ModalityState.stateForComponent((Component)ApplyPatchDifferentiatedDialog.this.myCenterPanel));
                return;
            }
            ApplyPatchDifferentiatedDialog.this.myReader = ApplyPatchDifferentiatedDialog.this.loadPatches(file2);
            PatchFileHeaderInfo patchFileInfo = ApplyPatchDifferentiatedDialog.this.myReader != null ? ApplyPatchDifferentiatedDialog.this.myReader.getPatchFileInfo() : null;
            String messageFromPatch = patchFileInfo != null ? patchFileInfo.getMessage() : null;
            VcsUser vcsUser = author = patchFileInfo != null ? patchFileInfo.getAuthor() : null;
            if (author != null && ApplyPatchDifferentiatedDialog.this.myChangeListChooser != null) {
                ApplyPatchDifferentiatedDialog.this.myChangeListChooser.setData(new ChangeListData(author));
            }
            ArrayList<FilePatch> filePatches = new ArrayList<FilePatch>();
            if (ApplyPatchDifferentiatedDialog.this.myReader != null) {
                filePatches.addAll(ApplyPatchDifferentiatedDialog.this.myReader.getAllPatches());
            }
            if (!ContainerUtil.isEmpty(ApplyPatchDifferentiatedDialog.this.myBinaryShelvedPatches)) {
                filePatches.addAll(ApplyPatchDifferentiatedDialog.this.myBinaryShelvedPatches);
            }
            List<AbstractFilePatchInProgress<?>> matchedPatches = new MatchPatchPaths(ApplyPatchDifferentiatedDialog.this.myProject).execute(filePatches, ApplyPatchDifferentiatedDialog.this.myUseProjectRootAsPredefinedBase);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (ApplyPatchDifferentiatedDialog.this.myShouldUpdateChangeListName && ApplyPatchDifferentiatedDialog.this.myChangeListChooser != null) {
                    String subject = (String)ObjectUtils.chooseNotNull((Object)ApplyPatchDifferentiatedDialog.this.getSubjectFromMessage(messageFromPatch), (Object)file2.getNameWithoutExtension().replace('_', ' ').trim());
                    ApplyPatchDifferentiatedDialog.this.myChangeListChooser.setSuggestedName(subject, messageFromPatch, false);
                }
                ApplyPatchDifferentiatedDialog.this.myPatches.clear();
                ApplyPatchDifferentiatedDialog.this.myPatches.addAll(matchedPatches);
                ApplyPatchDifferentiatedDialog.this.updateTree(true);
                ApplyPatchDifferentiatedDialog.this.paintBusy(false);
                ApplyPatchDifferentiatedDialog.this.updateOkActions();
            }, ModalityState.stateForComponent((Component)ApplyPatchDifferentiatedDialog.this.myCenterPanel));
        }
    }
}

