/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictDialog;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ChangelistConflictAccessProvider
extends WritingAccessProvider {
    private final Project myProject;

    ChangelistConflictAccessProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            ChangelistConflictAccessProvider.$$$reportNull$$$0(0);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        ChangelistConflictTracker conflictTracker = ChangelistConflictTracker.getInstance(this.myProject);
        ChangelistConflictTracker.Options options2 = conflictTracker.getOptions();
        if (!options2.SHOW_DIALOG) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                ChangelistConflictAccessProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<VirtualFile> denied = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile2 : files2) {
            if (virtualFile2 == null || conflictTracker.isWritingAllowed(virtualFile2)) continue;
            denied.add(virtualFile2);
        }
        if (!denied.isEmpty()) {
            ChangelistConflictDialog dialog2;
            HashSet<LocalChangeList> changeLists = new HashSet<LocalChangeList>();
            ArrayList<Change> arrayList = new ArrayList<Change>();
            for (VirtualFile file3 : denied) {
                changeLists.add(changeListManager.getChangeList(file3));
                arrayList.add(changeListManager.getChange(file3));
            }
            int savedEventCount = IdeEventQueue.getInstance().getEventCount();
            do {
                dialog2 = new ChangelistConflictDialog(this.myProject, new ArrayList<ChangeList>(changeLists), denied);
                dialog2.show();
            } while (dialog2.isOK() && !dialog2.getResolution().resolveConflict(this.myProject, arrayList, null));
            IdeEventQueue.getInstance().setEventCount(savedEventCount);
            if (dialog2.isOK()) {
                options2.LAST_RESOLUTION = dialog2.getResolution();
                List<VirtualFile> list3 = Collections.emptyList();
                if (list3 == null) {
                    ChangelistConflictAccessProvider.$$$reportNull$$$0(2);
                }
                return list3;
            }
        }
        ArrayList<VirtualFile> arrayList = denied;
        if (arrayList == null) {
            ChangelistConflictAccessProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWriting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

