/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalTrackerDiffUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLocalChangeListDiffViewer
extends SimpleDiffViewer {
    @NotNull
    private final LocalChangeListDiffRequest myLocalRequest;
    private final boolean myAllowExcludeChangesFromCommit;
    private final LocalTrackerDiffUtil.LocalTrackerActionProvider myTrackerActionProvider;
    private final LocalTrackerDiffUtil.ExcludeAllCheckboxPanel myExcludeAllCheckboxPanel;

    public SimpleLocalChangeListDiffViewer(@NotNull DiffContext context2, @NotNull LocalChangeListDiffRequest localRequest) {
        if (context2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(0);
        }
        if (localRequest == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(1);
        }
        super(context2, (DiffRequest)localRequest.getRequest());
        this.myLocalRequest = localRequest;
        this.myAllowExcludeChangesFromCommit = DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, new UserDataHolder[]{context2});
        this.myTrackerActionProvider = new MyLocalTrackerActionProvider(this, localRequest, this.myAllowExcludeChangesFromCommit);
        this.myExcludeAllCheckboxPanel = new LocalTrackerDiffUtil.ExcludeAllCheckboxPanel(this, this.getEditor2());
        this.myExcludeAllCheckboxPanel.init(this.myLocalRequest, this.myAllowExcludeChangesFromCommit);
        LocalTrackerDiffUtil.installTrackerListener(this, this.myLocalRequest);
    }

    @Override
    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> titles = DiffUtil.createTextTitles(this, this.myRequest, this.getEditors());
        assert (titles.size() == 2);
        BorderLayoutPanel titleWithCheckbox = JBUI.Panels.simplePanel();
        if (titles.get(1) != null) {
            titleWithCheckbox.addToCenter((Component)titles.get(1));
        }
        titleWithCheckbox.addToLeft((Component)this.myExcludeAllCheckboxPanel);
        List<JComponent> list2 = Arrays.asList(titles.get(0), titleWithCheckbox);
        if (list2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group2 = new ArrayList<AnAction>(super.createEditorPopupActions());
        group2.addAll(LocalTrackerDiffUtil.createTrackerActions(this.myTrackerActionProvider));
        ArrayList<AnAction> arrayList = group2;
        if (arrayList == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected SimpleDiffChangeUi createUi(@NotNull SimpleDiffChange change) {
        if (change == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(4);
        }
        if (change instanceof MySimpleDiffChange) {
            return new MySimpleDiffChangeUi(this, (MySimpleDiffChange)change);
        }
        SimpleDiffChangeUi simpleDiffChangeUi = super.createUi(change);
        if (simpleDiffChangeUi == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(5);
        }
        return simpleDiffChangeUi;
    }

    @NotNull
    private Runnable superComputeDifferences(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(6);
        }
        Runnable runnable2 = super.computeDifferences(indicator2);
        if (runnable2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(7);
        }
        return runnable2;
    }

    @Override
    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(8);
        }
        Runnable runnable2 = LocalTrackerDiffUtil.computeDifferences(this.myLocalRequest.getLineStatusTracker(), this.getContent1().getDocument(), this.getContent2().getDocument(), this.myLocalRequest.getChangelistId(), this.myTextDiffProvider, indicator2, new MyLocalTrackerDiffHandler(indicator2));
        if (runnable2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(9);
        }
        return runnable2;
    }

    @Override
    protected void onAfterRediff() {
        super.onAfterRediff();
        this.myExcludeAllCheckboxPanel.refresh();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRequest";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "superComputeDifferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDifferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUi";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "superComputeDifferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeDifferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyLocalTrackerActionProvider
    extends LocalTrackerDiffUtil.LocalTrackerActionProvider {
        @NotNull
        private final SimpleLocalChangeListDiffViewer myViewer;

        private MyLocalTrackerActionProvider(@NotNull SimpleLocalChangeListDiffViewer viewer, @NotNull LocalChangeListDiffRequest localRequest, boolean allowExcludeChangesFromCommit) {
            if (viewer == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(0);
            }
            if (localRequest == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(1);
            }
            super(viewer, localRequest, allowExcludeChangesFromCommit);
            this.myViewer = viewer;
        }

        @Override
        @Nullable
        public List<LocalTrackerDiffUtil.LocalTrackerChange> getSelectedTrackerChanges(@NotNull AnActionEvent e) {
            if (e == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(2);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(this.myViewer.getEditors(), (Object)editor);
            if (side == null) {
                return null;
            }
            return StreamEx.of((Collection)this.myViewer.getSelectedChanges(side)).select(MySimpleDiffChange.class).map(it -> new LocalTrackerDiffUtil.LocalTrackerChange(it.getStartLine(Side.RIGHT), it.getEndLine(Side.RIGHT), it.myChangelistId, it.myIsExcludedFromCommit)).toList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localRequest";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerActionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedTrackerChanges";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MySimpleDiffChangeUi
    extends SimpleDiffChangeUi {
        private MySimpleDiffChangeUi(@NotNull SimpleLocalChangeListDiffViewer viewer, @NotNull MySimpleDiffChange change) {
            if (viewer == null) {
                MySimpleDiffChangeUi.$$$reportNull$$$0(0);
            }
            if (change == null) {
                MySimpleDiffChangeUi.$$$reportNull$$$0(1);
            }
            super(viewer, change);
        }

        @NotNull
        private SimpleLocalChangeListDiffViewer getViewer() {
            SimpleLocalChangeListDiffViewer simpleLocalChangeListDiffViewer = (SimpleLocalChangeListDiffViewer)this.myViewer;
            if (simpleLocalChangeListDiffViewer == null) {
                MySimpleDiffChangeUi.$$$reportNull$$$0(2);
            }
            return simpleLocalChangeListDiffViewer;
        }

        @NotNull
        private MySimpleDiffChange getChange() {
            MySimpleDiffChange mySimpleDiffChange = (MySimpleDiffChange)this.myChange;
            if (mySimpleDiffChange == null) {
                MySimpleDiffChangeUi.$$$reportNull$$$0(3);
            }
            return mySimpleDiffChange;
        }

        @Override
        protected void doInstallActionHighlighters() {
            super.doInstallActionHighlighters();
            if (this.getViewer().myAllowExcludeChangesFromCommit) {
                ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createExcludeGutterOperation());
            }
        }

        @Nullable
        private DiffGutterOperation createExcludeGutterOperation() {
            if (!this.getChange().isFromActiveChangelist()) {
                return null;
            }
            final boolean isExcludedFromCommit = this.getChange().isExcludedFromCommit();
            Icon icon2 = isExcludedFromCommit ? AllIcons.Diff.GutterCheckBox : AllIcons.Diff.GutterCheckBoxSelected;
            return this.createOperation(Side.RIGHT, (ctrlPressed, shiftPressed, altPressed) -> new DiffGutterRenderer(icon2, DiffBundle.message((String)"action.presentation.diff.include.into.commit.text", (Object[])new Object[0])){

                @Override
                protected void handleMouseClick() {
                    if (!myChange.isValid()) {
                        return;
                    }
                    int line = myChange.getStartLine(Side.RIGHT);
                    LocalTrackerDiffUtil.toggleRangeAtLine(this.getViewer().myTrackerActionProvider, line, isExcludedFromCommit);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChangeUi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChangeUi";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MySimpleDiffChange
    extends SimpleDiffChange {
        @NotNull
        private final String myChangelistId;
        private final boolean myIsFromActiveChangelist;
        private final boolean myIsExcludedFromCommit;

        MySimpleDiffChange(int index2, @NotNull LineFragment fragment2, boolean isExcluded, boolean isSkipped, @NotNull String changelistId, boolean isFromActiveChangelist, boolean isExcludedFromCommit) {
            if (fragment2 == null) {
                MySimpleDiffChange.$$$reportNull$$$0(0);
            }
            if (changelistId == null) {
                MySimpleDiffChange.$$$reportNull$$$0(1);
            }
            super(index2, fragment2, isExcluded, isSkipped);
            this.myChangelistId = changelistId;
            this.myIsFromActiveChangelist = isFromActiveChangelist;
            this.myIsExcludedFromCommit = isExcludedFromCommit;
        }

        @NotNull
        public String getChangelistId() {
            String string = this.myChangelistId;
            if (string == null) {
                MySimpleDiffChange.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isFromActiveChangelist() {
            return this.myIsFromActiveChangelist;
        }

        public boolean isExcludedFromCommit() {
            return this.myIsExcludedFromCommit;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changelistId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangelistId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyLocalTrackerDiffHandler
    implements LocalTrackerDiffUtil.LocalTrackerDiffHandler {
        @NotNull
        private final ProgressIndicator myIndicator;

        private MyLocalTrackerDiffHandler(ProgressIndicator indicator2) {
            if (indicator2 == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator2;
        }

        @Override
        @NotNull
        public Runnable done(boolean isContentsEqual, CharSequence @NotNull [] texts, @NotNull List<? extends LineFragment> fragments, @NotNull List<LocalTrackerDiffUtil.LineFragmentData> fragmentsData) {
            if (fragments == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(1);
            }
            if (fragmentsData == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(2);
            }
            if (texts == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(3);
            }
            ArrayList<MySimpleDiffChange> changes = new ArrayList<MySimpleDiffChange>();
            for (int i2 = 0; i2 < fragments.size(); ++i2) {
                LineFragment fragment2 = fragments.get(i2);
                LocalTrackerDiffUtil.LineFragmentData data2 = fragmentsData.get(i2);
                boolean isExcludedFromCommit = data2.isExcludedFromCommit();
                boolean isFromActiveChangelist = data2.isFromActiveChangelist();
                boolean isSkipped = data2.isSkipped();
                boolean isExcluded = data2.isExcluded(SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit);
                changes.add(new MySimpleDiffChange(changes.size(), fragment2, isExcluded, isSkipped, data2.getChangelistId(), isFromActiveChangelist, isExcludedFromCommit));
            }
            Runnable runnable2 = SimpleLocalChangeListDiffViewer.this.apply(changes, isContentsEqual);
            if (runnable2 == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(4);
            }
            return runnable2;
        }

        @Override
        @NotNull
        public Runnable retryLater() {
            ApplicationManager.getApplication().invokeLater(() -> SimpleLocalChangeListDiffViewer.this.scheduleRediff());
            throw new ProcessCanceledException();
        }

        @Override
        @NotNull
        public Runnable fallback() {
            Runnable runnable2 = SimpleLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            if (runnable2 == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(5);
            }
            return runnable2;
        }

        @Override
        @NotNull
        public Runnable fallbackWithProgress() {
            Runnable callback2 = SimpleLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            Runnable runnable2 = () -> {
                callback2.run();
                SimpleLocalChangeListDiffViewer.this.getStatusPanel().setBusy(true);
            };
            if (runnable2 == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(6);
            }
            return runnable2;
        }

        @Override
        @NotNull
        public Runnable error() {
            Runnable runnable2 = SimpleLocalChangeListDiffViewer.this.applyNotification(DiffNotifications.createError());
            if (runnable2 == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(7);
            }
            return runnable2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragmentsData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "texts";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerDiffHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerDiffHandler";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fallback";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fallbackWithProgress";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

