/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffViewerCreatePatchActionProvider
implements AnActionExtensionProvider {
    private final boolean mySilentClipboard;

    private DiffViewerCreatePatchActionProvider(boolean silentClipboard) {
        this.mySilentClipboard = silentClipboard;
    }

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(0);
        }
        return e.getData(DiffDataKeys.DIFF_VIEWER) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        DiffRequest request;
        if (e == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(1);
        }
        boolean isEnabled = (request = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST)) != null && DiffViewerCreatePatchActionProvider.isSupported(request);
        e.getPresentation().setEnabledAndVisible(isEnabled);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(2);
        }
        DiffRequest request = Objects.requireNonNull((DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST));
        Change change = DiffViewerCreatePatchActionProvider.createChange(request);
        CreatePatchFromChangesAction.createPatch(e.getProject(), null, Collections.singletonList(change), this.mySilentClipboard);
    }

    private static boolean isSupported(@NotNull DiffRequest request) {
        if (request == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(3);
        }
        if (request.getUserData(ChangeDiffRequestProducer.CHANGE_KEY) != null) {
            return true;
        }
        ContentDiffRequest contentRequest = (ContentDiffRequest)ObjectUtils.tryCast((Object)request, ContentDiffRequest.class);
        if (contentRequest == null) {
            return false;
        }
        List contents = contentRequest.getContents();
        if (contents.size() != 2) {
            return false;
        }
        for (DiffContent content2 : contents) {
            boolean canShow2 = content2 instanceof DocumentContent || content2 instanceof EmptyContent;
            if (canShow2) continue;
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static Change createChange(@NotNull DiffRequest request) {
        Change change;
        if (request == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(4);
        }
        if ((change = (Change)request.getUserData(ChangeDiffRequestProducer.CHANGE_KEY)) != null) {
            Change change2 = change;
            if (change2 == null) {
                DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(5);
            }
            return change2;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        @Nls List titles = ((ContentDiffRequest)request).getContentTitles();
        assert (contents.size() == 2);
        String bTitle = (String)ObjectUtils.chooseNotNull((Object)((String)titles.get(0)), (Object)DiffBundle.message((String)"diff.version.title.before", (Object[])new Object[0]));
        String aTitle = (String)ObjectUtils.chooseNotNull((Object)((String)titles.get(1)), (Object)DiffBundle.message((String)"diff.version.title.after", (Object[])new Object[0]));
        ContentRevision bRev = DiffViewerCreatePatchActionProvider.createRevision((DiffContent)contents.get(0), bTitle);
        ContentRevision aRev = DiffViewerCreatePatchActionProvider.createRevision((DiffContent)contents.get(1), aTitle);
        return new Change(bRev, aRev);
    }

    @Nullable
    private static ContentRevision createRevision(@NotNull DiffContent content2, @NotNull String title2) {
        VirtualFile file2;
        if (content2 == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(6);
        }
        if (title2 == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(7);
        }
        if (content2 instanceof EmptyContent) {
            return null;
        }
        if (content2 instanceof FileContent && (file2 = ((FileContent)content2).getFile()).isInLocalFileSystem()) {
            return new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file2));
        }
        if (content2 instanceof DocumentContent) {
            String text2 = ((DocumentContent)content2).getDocument().getText();
            Pair info2 = (Pair)content2.getUserData(DiffVcsDataKeys.REVISION_INFO);
            if (info2 != null) {
                return new SimpleContentRevision(text2, (FilePath)info2.first, ((VcsRevisionNumber)info2.second).asString());
            }
            return new SimpleContentRevision(text2, DiffViewerCreatePatchActionProvider.guessFilePath(content2, title2), "");
        }
        throw new IllegalStateException(content2.toString());
    }

    @NotNull
    private static FilePath guessFilePath(@NotNull DiffContent content2, @NotNull String title2) {
        String ext;
        VirtualFile file2;
        String path2;
        if (content2 == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(8);
        }
        if (title2 == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(9);
        }
        if (content2 instanceof FileContent && (path2 = OutsidersPsiFileSupport.getOriginalFilePath(file2 = ((FileContent)content2).getFile())) != null) {
            FilePath filePath = VcsUtil.getFilePath((String)path2);
            if (filePath == null) {
                DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(10);
            }
            return filePath;
        }
        String fileName = (String)content2.getUserData(DiffUserDataKeysEx.FILE_NAME);
        if (fileName == null && content2 instanceof DocumentContent) {
            VirtualFile highlightFile = ((DocumentContent)content2).getHighlightFile();
            String string = fileName = highlightFile != null ? highlightFile.getName() : null;
        }
        if (fileName != null) {
            FilePath filePath = VcsUtil.getFilePath((String)fileName);
            if (filePath == null) {
                DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(11);
            }
            return filePath;
        }
        FileType fileType = content2.getContentType();
        String string = ext = fileType != null ? fileType.getDefaultExtension() : null;
        if (StringUtil.isEmptyOrSpaces((String)ext)) {
            ext = "tmp";
        }
        String path3 = PathUtil.suggestFileName((String)(title2 + "." + ext), (boolean)true, (boolean)false);
        FilePath filePath = VcsUtil.getFilePath((String)path3);
        if (filePath == null) {
            DiffViewerCreatePatchActionProvider.$$$reportNull$$$0(12);
        }
        return filePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/DiffViewerCreatePatchActionProvider";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/DiffViewerCreatePatchActionProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createChange";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRevision";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Clipboard
    extends DiffViewerCreatePatchActionProvider {
        public Clipboard() {
            super(true);
        }
    }

    public static class Dialog
    extends DiffViewerCreatePatchActionProvider {
        public Dialog() {
            super(false);
        }
    }
}

