/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionActionExtension;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionWithIgnoredFilesConfirmationAction;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionWithIgnoredFilesConfirmationActionKt;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Functions;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J4\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013H\u0002J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0002J!\u0010\u001d\u001a\t\u0018\u00010\u001e\u00a2\u0006\u0002\b\u001f2\u0006\u0010\b\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionWithIgnoredFilesConfirmationAction;", "Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addPathsToVcs", "project", "Lcom/intellij/openapi/project/Project;", "toAdd", "", "Lcom/intellij/openapi/vcs/FilePath;", "exceptions", "", "Lcom/intellij/openapi/vcs/VcsException;", "containsIgnored", "", "collectPathsFromChanges", "Ljava/util/stream/Stream;", "allChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "collectPathsFromFiles", "allFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "dialogMessage", "", "path", "dialogTitle", "getExtensionFor", "Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionActionExtension;", "Lorg/jetbrains/annotations/Nullable;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "isEnabled", "intellij.platform.vcs.impl"})
public final class ScheduleForAdditionWithIgnoredFilesConfirmationAction
extends ScheduleForAdditionAction {
    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        StreamEx filesStream;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.getData(CommonDataKeys.PROJECT) ?: return false");
        Project project2 = project;
        if (!UtilKt.isEmpty(ScheduleForAdditionAction.getUnversionedFiles(e, project2))) {
            return true;
        }
        Stream changeStream = UtilKt.stream((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        if (!UtilKt.isEmpty(this.collectPathsFromChanges(project2, changeStream))) {
            return true;
        }
        StreamEx streamEx = filesStream = StreamEx.of((Iterator)JBIterable.from((Iterable)((Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES))).iterator());
        Intrinsics.checkNotNullExpressionValue((Object)streamEx, (String)"filesStream");
        return !UtilKt.isEmpty(this.collectPathsFromFiles(project2, (Stream)streamEx));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        void ignored;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        ChangesBrowserBase browser2 = (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY);
        HashSet toAdd = new HashSet();
        Stream changeStream = UtilKt.stream((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        ContainerUtil.addAll((Collection)toAdd, this.collectPathsFromChanges(project, changeStream).iterator());
        StreamEx filesStream = StreamEx.of((Iterator)JBIterable.from((Iterable)((Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES))).iterator());
        Collection collection = toAdd;
        StreamEx streamEx = filesStream;
        Intrinsics.checkNotNullExpressionValue((Object)streamEx, (String)"filesStream");
        ContainerUtil.addAll((Collection)collection, this.collectPathsFromFiles(project, (Stream)streamEx).iterator());
        Stream<VirtualFile> stream = ScheduleForAdditionAction.getUnversionedFiles(e, project);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"getUnversionedFiles(e, project)");
        List unversionedFiles = StreamsKt.toList(stream);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager changeListManager2 = changeListManager;
        Iterable $this$partition$iv = toAdd;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FilePath p1 = (FilePath)element$iv;
            boolean bl = false;
            if (changeListManager2.isIgnoredFile(p1)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List list2 = (List)pair.component1();
        List toAddWithoutIgnored = (List)pair.component2();
        Function1 function1 = (Function1)new Function1<FilePath, String>(this){

            @NotNull
            public final String invoke(@NotNull FilePath p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$dialogTitle((ScheduleForAdditionWithIgnoredFilesConfirmationAction)((Object)this.receiver), p1);
            }
        };
        Function1 function12 = (Function1)new Function1<FilePath, String>(this){

            @NotNull
            public final String invoke(@NotNull FilePath p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$dialogMessage((ScheduleForAdditionWithIgnoredFilesConfirmationAction)((Object)this.receiver), p1);
            }
        };
        String string = VcsBundle.message((String)"confirmation.title.add.ignored.files.or.dirs", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"confirmation.ti\u2026d.ignored.files.or.dirs\")");
        List<FilePath> confirmedIgnored2 = ScheduleForAdditionWithIgnoredFilesConfirmationActionKt.confirmAddFilePaths(project, (List<? extends FilePath>)ignored, (Function1<? super FilePath, String>)function1, (Function1<? super FilePath, String>)function12, string);
        Collection collection2 = toAdd;
        boolean bl = false;
        PairConsumer addToVcsTask2 = !collection2.isEmpty() ? (PairConsumer)new PairConsumer(this, project, toAddWithoutIgnored, confirmedIgnored2){
            final /* synthetic */ ScheduleForAdditionWithIgnoredFilesConfirmationAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $toAddWithoutIgnored;
            final /* synthetic */ List $confirmedIgnored;

            public final void consume(ProgressIndicator $noName_0, List<VcsException> exceptions) {
                Collection collection = CollectionsKt.plus((Collection)this.$toAddWithoutIgnored, (Iterable)this.$confirmedIgnored);
                List<VcsException> list2 = exceptions;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"exceptions");
                Collection collection2 = this.$confirmedIgnored;
                boolean bl = false;
                ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$addPathsToVcs(this.this$0, this.$project, collection, list2, !collection2.isEmpty());
            }
            {
                this.this$0 = scheduleForAdditionWithIgnoredFilesConfirmationAction;
                this.$project = project;
                this.$toAddWithoutIgnored = list2;
                this.$confirmedIgnored = list3;
            }
        } : null;
        ScheduleForAdditionAction.addUnversioned(project, unversionedFiles, browser2, addToVcsTask2);
    }

    private final String dialogMessage(FilePath path2) {
        String string = path2.isDirectory() ? VcsBundle.message((String)"confirmation.message.add.ignored.single.directory", (Object[])new Object[0]) : VcsBundle.message((String)"confirmation.message.add.ignored.single.file", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (path.isDirectory) me\u2026add.ignored.single.file\")");
        String question = string;
        return question + "\n" + FileUtil.getLocationRelativeToUserHome((String)path2.getPresentableUrl());
    }

    private final String dialogTitle(FilePath path2) {
        String string;
        if (path2.isDirectory()) {
            String string2 = VcsBundle.message((String)"confirmation.title.add.ignored.single.directory", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"confirmation.ti\u2026gnored.single.directory\")");
        } else {
            String string3 = VcsBundle.message((String)"confirmation.title.add.ignored.single.file", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"confirmation.ti\u2026add.ignored.single.file\")");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void addPathsToVcs(Project project, Collection<? extends FilePath> toAdd, List<VcsException> exceptions, boolean containsIgnored) {
        Map map2 = VcsUtil.groupByRoots((Project)project, toAdd, (com.intellij.util.Function)Functions.identity());
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"VcsUtil.groupByRoots(pro\u2026ty<FilePath, FilePath>())");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Map map3 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$vcsRoot$paths = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry2 = $dstr$vcsRoot$paths;
            boolean bl3 = false;
            VcsRoot vcsRoot = (VcsRoot)entry2.getKey();
            entry2 = $dstr$vcsRoot$paths;
            bl3 = false;
            List paths = (List)entry2.getValue();
            try {
                ScheduleForAdditionActionExtension actionExtension;
                void vcsRoot2;
                void v1 = vcsRoot2;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"vcsRoot");
                if (this.getExtensionFor(project, v1.getVcs()) == null) {
                    return;
                }
                VirtualFile virtualFile2 = vcsRoot2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"vcsRoot.path");
                List list2 = paths;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"paths");
                actionExtension.doAddFiles(project, virtualFile2, list2, containsIgnored);
                VcsFileUtil.markFilesDirty(project, paths);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
            }
        }
    }

    private final Stream<FilePath> collectPathsFromChanges(Project project, Stream<Change> allChanges) {
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        Stream<Change> stream = allChanges.filter(new Predicate(this, project, vcsManager2){
            final /* synthetic */ ScheduleForAdditionWithIgnoredFilesConfirmationAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectLevelVcsManager $vcsManager;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean test(Change change) {
                ScheduleForAdditionActionExtension actionExtension = ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$getExtensionFor(this.this$0, this.$project, this.$vcsManager.getVcsFor(ChangesUtil.getFilePath((Change)change)));
                if (actionExtension == null) return false;
                Change change2 = change;
                Intrinsics.checkNotNullExpressionValue((Object)change2, (String)"change");
                FileStatus fileStatus = change2.getFileStatus();
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"change.fileStatus");
                if (!actionExtension.isStatusForAddition(fileStatus)) return false;
                return true;
            }
            {
                this.this$0 = scheduleForAdditionWithIgnoredFilesConfirmationAction;
                this.$project = project;
                this.$vcsManager = projectLevelVcsManager;
            }
        });
        Object object = collectPathsFromChanges.2.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        Stream<FilePath> stream2 = stream.map((Function)object);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"allChanges\n      .filter\u2026ChangesUtil::getFilePath)");
        return stream2;
    }

    private final Stream<FilePath> collectPathsFromFiles(Project project, Stream<VirtualFile> allFiles) {
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager changeListManager2 = changeListManager;
        Stream<VirtualFile> stream = allFiles.filter(new Predicate(this, project, vcsManager2, changeListManager2){
            final /* synthetic */ ScheduleForAdditionWithIgnoredFilesConfirmationAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectLevelVcsManager $vcsManager;
            final /* synthetic */ ChangeListManager $changeListManager;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean test(VirtualFile file2) {
                boolean bl;
                ScheduleForAdditionActionExtension actionExtension = ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$getExtensionFor(this.this$0, this.$project, this.$vcsManager.getVcsFor(file2));
                if (actionExtension == null) return false;
                FileStatus fileStatus = this.$changeListManager.getStatus(file2);
                boolean bl2 = false;
                boolean bl3 = false;
                FileStatus status = fileStatus;
                boolean bl4 = false;
                VirtualFile virtualFile2 = file2;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file");
                if (virtualFile2.isDirectory()) {
                    FileStatus fileStatus2 = status;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"status");
                    bl = actionExtension.isStatusForDirectoryAddition(fileStatus2);
                } else {
                    FileStatus fileStatus3 = status;
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus3, (String)"status");
                    bl = actionExtension.isStatusForAddition(fileStatus3);
                }
                if (!bl) return false;
                return true;
            }
            {
                this.this$0 = scheduleForAdditionWithIgnoredFilesConfirmationAction;
                this.$project = project;
                this.$vcsManager = projectLevelVcsManager;
                this.$changeListManager = changeListManager;
            }
        });
        Object object = collectPathsFromFiles.2.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new /* invalid duplicate definition of identical inner class */;
        }
        Stream<FilePath> stream2 = stream.map((Function)object);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"allFiles\n      .filter {\u2026map(VcsUtil::getFilePath)");
        return stream2;
    }

    private final ScheduleForAdditionActionExtension getExtensionFor(Project project, AbstractVcs vcs) {
        return vcs == null ? null : (ScheduleForAdditionActionExtension)ScheduleForAdditionActionExtension.Companion.getEP_NAME().findFirstSafe(new Predicate(vcs, project){
            final /* synthetic */ AbstractVcs $vcs;
            final /* synthetic */ Project $project;

            public final boolean test(ScheduleForAdditionActionExtension it) {
                return Intrinsics.areEqual((Object)it.getSupportedVcs(this.$project), (Object)this.$vcs);
            }
            {
                this.$vcs = abstractVcs;
                this.$project = project;
            }
        });
    }

    public static final /* synthetic */ String access$dialogTitle(ScheduleForAdditionWithIgnoredFilesConfirmationAction $this, FilePath path2) {
        return $this.dialogTitle(path2);
    }

    public static final /* synthetic */ String access$dialogMessage(ScheduleForAdditionWithIgnoredFilesConfirmationAction $this, FilePath path2) {
        return $this.dialogMessage(path2);
    }

    public static final /* synthetic */ void access$addPathsToVcs(ScheduleForAdditionWithIgnoredFilesConfirmationAction $this, Project project, Collection toAdd, List exceptions, boolean containsIgnored) {
        $this.addPathsToVcs(project, toAdd, exceptions, containsIgnored);
    }

    public static final /* synthetic */ ScheduleForAdditionActionExtension access$getExtensionFor(ScheduleForAdditionWithIgnoredFilesConfirmationAction $this, Project project, AbstractVcs vcs) {
        return $this.getExtensionFor(project, vcs);
    }
}

