/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.impl.projectlevelman.RecursiveFilePathSet;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsDirtyScopeImpl
extends VcsModifiableDirtyScope {
    private final Map<VirtualFile, Set<FilePath>> myDirtyFiles;
    private final Map<VirtualFile, RecursiveFilePathSet> myDirtyDirectoriesRecursively;
    private final Set<FilePath> myAllVcsRoots;
    private final Set<VirtualFile> myAffectedVcsRoots;
    @NotNull
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final AbstractVcs myVcs;
    private final boolean myWasEverythingDirty;
    @Nullable
    private final Hash.Strategy<FilePath> myHashingStrategy;
    private final boolean myCaseSensitive;

    public VcsDirtyScopeImpl(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(0);
        }
        this(vcs, false);
    }

    public VcsDirtyScopeImpl(@NotNull AbstractVcs vcs, boolean wasEverythingDirty) {
        if (vcs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(1);
        }
        this.myDirtyFiles = new HashMap<VirtualFile, Set<FilePath>>();
        this.myDirtyDirectoriesRecursively = new HashMap<VirtualFile, RecursiveFilePathSet>();
        this.myAllVcsRoots = new HashSet<FilePath>();
        this.myAffectedVcsRoots = new HashSet<VirtualFile>();
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myWasEverythingDirty = wasEverythingDirty;
        this.myHashingStrategy = VcsDirtyScopeManagerImpl.getDirtyScopeHashingStrategy(this.myVcs);
        this.myCaseSensitive = this.myVcs.needsCaseSensitiveDirtyScope() || SystemInfo.isFileSystemCaseSensitive;
        this.myAllVcsRoots.addAll(ContainerUtil.map((Collection)this.myVcsManager.getRootsUnderVcsWithoutFiltering(this.myVcs), root -> VcsUtil.getFilePath((VirtualFile)root)));
    }

    public Collection<VirtualFile> getAffectedContentRoots() {
        return this.myAffectedVcsRoots;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public AbstractVcs getVcs() {
        AbstractVcs abstractVcs = this.myVcs;
        if (abstractVcs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(3);
        }
        return abstractVcs;
    }

    public Set<FilePath> getDirtyFiles() {
        Set<FilePath> result2 = this.newFilePathsSet();
        for (Set<FilePath> paths : this.myDirtyFiles.values()) {
            result2.addAll(paths);
        }
        for (Set<FilePath> paths : this.myDirtyFiles.values()) {
            for (FilePath filePath : paths) {
                VirtualFile vFile = filePath.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child2 : vFile.getChildren()) {
                    result2.add(VcsUtil.getFilePath((VirtualFile)child2));
                }
            }
        }
        return result2;
    }

    public Set<FilePath> getDirtyFilesNoExpand() {
        Set<FilePath> paths = this.newFilePathsSet();
        for (Set<FilePath> filePaths : this.myDirtyFiles.values()) {
            paths.addAll(filePaths);
        }
        return paths;
    }

    public Set<FilePath> getRecursivelyDirtyDirectories() {
        Set<FilePath> result2 = this.newFilePathsSet();
        for (RecursiveFilePathSet dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            result2.addAll(dirsByRoot.filePaths());
        }
        return result2;
    }

    public void addDirtyPathFast(@NotNull VirtualFile vcsRoot, @NotNull FilePath filePath, boolean recursively) {
        if (vcsRoot == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(5);
        }
        this.myAffectedVcsRoots.add(vcsRoot);
        RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null && dirsByRoot.hasAncestor(filePath)) {
            return;
        }
        if (recursively) {
            if (dirsByRoot == null) {
                dirsByRoot = this.newRecursiveFilePathSet();
                this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
            }
            dirsByRoot.add(filePath);
        } else {
            Set<FilePath> dirtyFiles = this.myDirtyFiles.get(vcsRoot);
            if (dirtyFiles == null) {
                dirtyFiles = this.newFilePathsSet();
                this.myDirtyFiles.put(vcsRoot, dirtyFiles);
            }
            dirtyFiles.add(filePath);
        }
    }

    @NotNull
    public VcsDirtyScopeImpl pack() {
        VcsDirtyScopeImpl copy2 = new VcsDirtyScopeImpl(this.myVcs, this.myWasEverythingDirty);
        for (VirtualFile root : this.myAffectedVcsRoots) {
            RecursiveFilePathSet rootDirs = this.myDirtyDirectoriesRecursively.get(root);
            Set rootFiles = ContainerUtil.notNullize(this.myDirtyFiles.get(root));
            RecursiveFilePathSet filteredDirs = this.removeAncestorsRecursive(rootDirs);
            Set<FilePath> filteredFiles = this.removeAncestorsNonRecursive(filteredDirs, rootFiles);
            copy2.myAffectedVcsRoots.add(root);
            copy2.myDirtyDirectoriesRecursively.put(root, filteredDirs);
            copy2.myDirtyFiles.put(root, filteredFiles);
        }
        VcsDirtyScopeImpl vcsDirtyScopeImpl = copy2;
        if (vcsDirtyScopeImpl == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(6);
        }
        return vcsDirtyScopeImpl;
    }

    @NotNull
    private RecursiveFilePathSet removeAncestorsRecursive(@Nullable RecursiveFilePathSet dirs) {
        RecursiveFilePathSet result2 = this.newRecursiveFilePathSet();
        if (dirs == null) {
            RecursiveFilePathSet recursiveFilePathSet = result2;
            if (recursiveFilePathSet == null) {
                VcsDirtyScopeImpl.$$$reportNull$$$0(7);
            }
            return recursiveFilePathSet;
        }
        List paths = ContainerUtil.sorted(dirs.filePaths(), Comparator.comparingInt(it -> it.getPath().length()));
        for (FilePath path2 : paths) {
            if (result2.hasAncestor(path2)) continue;
            result2.add(path2);
        }
        RecursiveFilePathSet recursiveFilePathSet = result2;
        if (recursiveFilePathSet == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(8);
        }
        return recursiveFilePathSet;
    }

    @NotNull
    private Set<FilePath> removeAncestorsNonRecursive(@NotNull RecursiveFilePathSet dirs, @NotNull Set<? extends FilePath> files2) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(9);
        }
        if (files2 == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(10);
        }
        Set<FilePath> result2 = this.newFilePathsSet();
        for (FilePath filePath : files2) {
            if (dirs.hasAncestor(filePath) || !filePath.isDirectory() && files2.contains(filePath.getParentPath())) continue;
            result2.add(filePath);
        }
        Set<FilePath> set2 = result2;
        if (set2 == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(11);
        }
        return set2;
    }

    @NotNull
    private Set<FilePath> newFilePathsSet() {
        return this.myHashingStrategy == null ? new HashSet<FilePath>() : new ObjectOpenCustomHashSet(this.myHashingStrategy);
    }

    @NotNull
    private RecursiveFilePathSet newRecursiveFilePathSet() {
        return new RecursiveFilePathSet(this.myCaseSensitive);
    }

    public void addDirtyDirRecursively(FilePath newcomer) {
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedVcsRoots.add(vcsRoot);
        for (Map.Entry<VirtualFile, Set<FilePath>> entry2 : this.myDirtyFiles.entrySet()) {
            Set<FilePath> files2;
            VirtualFile groupRoot = entry2.getKey();
            if (groupRoot == null || !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)groupRoot, (boolean)false) || (files2 = entry2.getValue()) == null) continue;
            Iterator<FilePath> it = files2.iterator();
            while (it.hasNext()) {
                FilePath oldBoy2 = it.next();
                if (!VcsFileUtil.isAncestor(newcomer, oldBoy2, false)) continue;
                it.remove();
            }
        }
        RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot == null) {
            dirsByRoot = this.newRecursiveFilePathSet();
            this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
        } else {
            if (dirsByRoot.hasAncestor(newcomer)) {
                return;
            }
            List toRemove2 = ContainerUtil.filter(dirsByRoot.filePaths(), oldBoy -> VcsFileUtil.isAncestor(newcomer, oldBoy, false));
            for (FilePath path2 : toRemove2) {
                dirsByRoot.remove(path2);
            }
        }
        dirsByRoot.add(newcomer);
    }

    public void addDirtyFile(FilePath newcomer) {
        FilePath parent;
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedVcsRoots.add(vcsRoot);
        RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null && dirsByRoot.hasAncestor(newcomer)) {
            return;
        }
        Set<FilePath> dirtyFiles = this.myDirtyFiles.get(vcsRoot);
        if (dirtyFiles == null) {
            dirtyFiles = this.newFilePathsSet();
            this.myDirtyFiles.put(vcsRoot, dirtyFiles);
        } else if (newcomer.isDirectory()) {
            Iterator<FilePath> iterator2 = dirtyFiles.iterator();
            while (iterator2.hasNext()) {
                FilePath oldBoy = iterator2.next();
                if (oldBoy.isDirectory() || !(this.myHashingStrategy == null ? Objects.equals(oldBoy.getParentPath(), newcomer) : this.myHashingStrategy.equals((Object)oldBoy.getParentPath(), (Object)newcomer))) continue;
                iterator2.remove();
            }
        } else if (!dirtyFiles.isEmpty() && (parent = newcomer.getParentPath()) != null && dirtyFiles.contains(parent)) {
            return;
        }
        dirtyFiles.add(newcomer);
    }

    public void iterate(Processor<? super FilePath> iterator2) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedVcsRoots) {
            RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot.filePaths()) {
                vFile = dir.getVirtualFile();
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVcsRoot(vFile, iterator2);
            }
        }
        for (VirtualFile root : this.myAffectedVcsRoots) {
            Set<FilePath> files2 = this.myDirtyFiles.get(root);
            if (files2 == null) continue;
            for (FilePath file2 : files2) {
                iterator2.process((Object)file2);
                vFile = file2.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child2 : vFile.getChildren()) {
                    iterator2.process((Object)VcsUtil.getFilePath((VirtualFile)child2));
                }
            }
        }
    }

    public void iterateExistingInsideScope(Processor<? super VirtualFile> processor2) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedVcsRoots) {
            RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot.filePaths()) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(dir);
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVfUnderVcsRoot(vFile, processor2);
            }
        }
        for (VirtualFile root : this.myAffectedVcsRoots) {
            Set<FilePath> files2 = this.myDirtyFiles.get(root);
            if (files2 == null) continue;
            for (FilePath file2 : files2) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(file2);
                if (vFile == null || !vFile.isValid()) continue;
                processor2.process((Object)vFile);
                if (!vFile.isDirectory()) continue;
                for (VirtualFile child2 : vFile.getChildren()) {
                    processor2.process((Object)child2);
                }
            }
        }
    }

    @Nullable
    private static VirtualFile obtainVirtualFile(FilePath file2) {
        VirtualFile vFile = file2.getVirtualFile();
        return vFile == null ? VfsUtil.findFileByIoFile((File)file2.getIOFile(), (boolean)false) : vFile;
    }

    public boolean isEmpty() {
        return this.myDirtyDirectoriesRecursively.isEmpty() && this.myDirtyFiles.isEmpty();
    }

    public boolean belongsTo(FilePath path2) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path2);
        if (rootObject == null || rootObject.getVcs() != this.myVcs) {
            return false;
        }
        VirtualFile vcsRoot = rootObject.getPath();
        boolean pathIsRoot = this.myAllVcsRoots.contains(path2);
        for (VirtualFile otherRoot : this.myDirtyDirectoriesRecursively.keySet()) {
            RecursiveFilePathSet dirsByRoot;
            boolean strict;
            if (!VfsUtilCore.isAncestor((VirtualFile)otherRoot, (VirtualFile)vcsRoot, (boolean)(strict = pathIsRoot && !this.myVcs.areDirectoriesVersionedItems())) || !(dirsByRoot = this.myDirtyDirectoriesRecursively.get(otherRoot)).hasAncestor(path2)) continue;
            return true;
        }
        if (!this.myDirtyFiles.isEmpty()) {
            if (this.isInDirtyFiles(path2, vcsRoot)) {
                return true;
            }
            FilePath parent = path2.getParentPath();
            if (parent != null && (pathIsRoot ? this.isInDirtyFiles(parent) : this.isInDirtyFiles(parent, vcsRoot))) {
                return true;
            }
        }
        return false;
    }

    private boolean isInDirtyFiles(@NotNull FilePath path2) {
        VcsRoot rootObject;
        if (path2 == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(12);
        }
        if ((rootObject = this.myVcsManager.getVcsRootObjectFor(path2)) == null || !this.myVcs.equals((Object)rootObject.getVcs())) {
            return false;
        }
        return this.isInDirtyFiles(path2, rootObject.getPath());
    }

    private boolean isInDirtyFiles(@NotNull FilePath path2, @NotNull VirtualFile vcsRoot) {
        Set<FilePath> files2;
        if (path2 == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(13);
        }
        if (vcsRoot == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(14);
        }
        return (files2 = this.myDirtyFiles.get(vcsRoot)) != null && files2.contains(path2);
    }

    @NonNls
    public String toString() {
        @NonNls StringBuilder result2 = new StringBuilder("VcsDirtyScope[");
        if (!this.myDirtyFiles.isEmpty()) {
            result2.append(" files: ");
            for (Set<FilePath> paths : this.myDirtyFiles.values()) {
                for (FilePath file2 : paths) {
                    result2.append(file2).append(" ");
                }
            }
        }
        if (!this.myDirtyDirectoriesRecursively.isEmpty()) {
            result2.append("\ndirs: ");
            for (RecursiveFilePathSet dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
                for (FilePath file2 : dirsByRoot.filePaths()) {
                    result2.append(file2).append(" ");
                }
            }
        }
        result2.append("\naffected roots: ");
        for (VirtualFile root : this.myAffectedVcsRoots) {
            result2.append(root.getPath()).append(" ");
        }
        result2.append("]");
        return result2.toString();
    }

    public boolean wasEveryThingDirty() {
        return this.myWasEverythingDirty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "pack";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAncestorsRecursive";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAncestorsNonRecursive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDirtyPathFast";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeAncestorsNonRecursive";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInDirtyFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

