/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class VcsAnnotationLocalChangesListenerImpl
implements Disposable,
VcsAnnotationLocalChangesListener {
    private static final Logger LOG = Logger.getInstance(VcsAnnotationLocalChangesListenerImpl.class);
    private final ZipperUpdater myUpdater;
    private final MessageBusConnection myConnection;
    private final Runnable myUpdateStuff;
    private final Set<String> myDirtyPaths;
    private final Set<VirtualFile> myDirtyFiles;
    private final Map<String, VcsRevisionNumber> myDirtyChanges;
    private final LocalFileSystem myLocalFileSystem;
    private final ProjectLevelVcsManager myVcsManager;
    private final Set<VcsKey> myVcsKeySet;
    private final Object myLock;
    private final MultiMap<VirtualFile, FileAnnotation> myFileAnnotationMap;

    public VcsAnnotationLocalChangesListenerImpl(@NotNull Project project) {
        if (project == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myUpdateStuff = this.createUpdateStuff();
        this.myUpdater = new ZipperUpdater(ApplicationManager.getApplication().isUnitTestMode() ? 10 : 300, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        this.myConnection = project.getMessageBus().connect();
        this.myLocalFileSystem = LocalFileSystem.getInstance();
        VcsAnnotationRefresher handler2 = this.createHandler();
        this.myDirtyPaths = new HashSet<String>();
        this.myDirtyChanges = new HashMap<String, VcsRevisionNumber>();
        this.myDirtyFiles = new HashSet<VirtualFile>();
        this.myFileAnnotationMap = MultiMap.createSet();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myVcsKeySet = new HashSet<VcsKey>();
        this.myConnection.subscribe(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED, (Object)handler2);
    }

    @TestOnly
    public void calmDown() {
        this.myUpdater.waitForAllExecuted(10L, TimeUnit.SECONDS);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
    }

    private Runnable createUpdateStuff() {
        return () -> {
            HashSet<VirtualFile> files2;
            HashMap<String, VcsRevisionNumber> changes;
            HashSet<String> paths;
            HashSet<VcsKey> vcsToRefresh;
            Object object = this.myLock;
            synchronized (object) {
                vcsToRefresh = new HashSet<VcsKey>(this.myVcsKeySet);
                paths = new HashSet<String>(this.myDirtyPaths);
                changes = new HashMap<String, VcsRevisionNumber>(this.myDirtyChanges);
                files2 = new HashSet<VirtualFile>(this.myDirtyFiles);
                this.myDirtyPaths.clear();
                this.myDirtyChanges.clear();
                this.myVcsKeySet.clear();
                this.myDirtyFiles.clear();
            }
            this.closeForVcs(vcsToRefresh);
            this.checkByDirtyScope(paths, changes, files2);
        };
    }

    private void checkByDirtyScope(Set<String> removed, Map<String, VcsRevisionNumber> refresh2, Set<? extends VirtualFile> files2) {
        for (String string : removed) {
            this.refreshForPath(string, null);
        }
        for (Map.Entry entry2 : refresh2.entrySet()) {
            this.refreshForPath((String)entry2.getKey(), (VcsRevisionNumber)entry2.getValue());
        }
        for (VirtualFile virtualFile2 : files2) {
            this.processUnderFile(virtualFile2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnderFile(VirtualFile file2) {
        MultiMap annotations = new MultiMap();
        Iterator iterator2 = this.myLock;
        synchronized (iterator2) {
            for (VirtualFile virtualFile2 : this.myFileAnnotationMap.keySet()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)virtualFile2, (boolean)true)) continue;
                Collection values2 = this.myFileAnnotationMap.get((Object)virtualFile2);
                for (FileAnnotation value2 : values2) {
                    annotations.putValue((Object)virtualFile2, (Object)value2);
                }
            }
        }
        if (!annotations.isEmpty()) {
            for (Map.Entry entry2 : annotations.entrySet()) {
                VirtualFile key = (VirtualFile)entry2.getKey();
                VcsRevisionNumber number = this.fromDiffProvider(key);
                if (number == null) continue;
                Collection fileAnnotations = (Collection)entry2.getValue();
                List copy2 = ContainerUtil.filter((Collection)fileAnnotations, it -> it.isBaseRevisionChanged(number));
                VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy2, false);
            }
        }
    }

    private void refreshForPath(String path2, VcsRevisionNumber number) {
        File file2 = new File(path2);
        VirtualFile vf = this.myLocalFileSystem.findFileByIoFile(file2);
        if (vf == null) {
            vf = this.myLocalFileSystem.refreshAndFindFileByIoFile(file2);
        }
        if (vf == null) {
            return;
        }
        this.processFile(number, vf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(VcsRevisionNumber number, VirtualFile vf) {
        ArrayList annotations;
        Object object = this.myLock;
        synchronized (object) {
            annotations = new ArrayList(this.myFileAnnotationMap.get((Object)vf));
        }
        if (!annotations.isEmpty()) {
            if (number == null) {
                number = this.fromDiffProvider(vf);
            }
            if (number == null) {
                return;
            }
            VcsRevisionNumber finalNumber = number;
            List copy2 = ContainerUtil.filter(annotations, it -> it.isBaseRevisionChanged(finalNumber));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy2, false);
        }
    }

    private VcsRevisionNumber fromDiffProvider(VirtualFile vf) {
        DiffProvider diffProvider;
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(vf);
        if (vcsRoot != null && vcsRoot.getVcs() != null && (diffProvider = vcsRoot.getVcs().getDiffProvider()) != null) {
            return diffProvider.getCurrentRevision(vf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeForVcs(Set<VcsKey> refresh2) {
        if (refresh2.isEmpty()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            List copy2 = ContainerUtil.filter((Collection)this.myFileAnnotationMap.values(), it -> it.getVcsKey() != null && refresh2.contains(it.getVcsKey()));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy2, false);
        }
    }

    private static void invalidateAnnotations(@NotNull Collection<? extends FileAnnotation> annotations, boolean reload2) {
        if (annotations == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (FileAnnotation annotation : annotations) {
                try {
                    if (reload2) {
                        annotation.reload(null);
                        continue;
                    }
                    annotation.close();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAnnotation(VirtualFile file2, FileAnnotation annotation) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFileAnnotationMap.putValue((Object)file2, (Object)annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAnnotation(VirtualFile file2, FileAnnotation annotation) {
        Object object = this.myLock;
        synchronized (object) {
            Collection annotations = this.myFileAnnotationMap.get((Object)file2);
            if (!annotations.isEmpty()) {
                annotations.remove(annotation);
            }
            if (annotations.isEmpty()) {
                this.myFileAnnotationMap.remove((Object)file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAnnotationsForVcs(@NotNull VcsKey key) {
        if (key == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            List copy2 = ContainerUtil.filter((Collection)this.myFileAnnotationMap.values(), it -> key.equals((Object)it.getVcsKey()));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy2, true);
        }
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.myUpdater.stop();
    }

    private VcsAnnotationRefresher createHandler() {
        return new VcsAnnotationRefresher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dirtyUnder(VirtualFile file2) {
                if (file2 == null) {
                    return;
                }
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyFiles.add(file2);
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dirty(BaseRevision currentRevision) {
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyChanges.put(currentRevision.getPath(), currentRevision.getRevision());
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dirty(String path2) {
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myDirtyPaths.add(path2);
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void configurationChanged(VcsKey vcsKey) {
                Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
                synchronized (object) {
                    VcsAnnotationLocalChangesListenerImpl.this.myVcsKeySet.add(vcsKey);
                }
                VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(VcsAnnotationLocalChangesListenerImpl.this.myUpdateStuff);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsAnnotationLocalChangesListenerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadAnnotationsForVcs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

