/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewProcessorKt;
import com.intellij.openapi.vcs.changes.actions.diff.SelectionAwareGoToChangePopupActionProvider;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffFromLocalChangesActionProvider;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\rH\u0014J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewProcessor;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;", "isInEditor", "", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;Z)V", "createGoToChangeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "fireDiffSettingsChanged", "", "getAllChanges", "Ljava/util/stream/Stream;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "getSelectedChanges", "selectChange", "change", "setAllowExcludeFromCommit", "value", "MyGoToChangePopupProvider", "intellij.platform.vcs.impl"})
final class ChangesViewDiffPreviewProcessor
extends ChangeViewDiffRequestProcessor {
    private final ChangesListView changesView;

    @Override
    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
        Stream stream;
        if (this.changesView.isSelectionEmpty()) {
            stream = this.getAllChanges();
        } else {
            StreamEx streamEx = StreamEx.of((Iterator)this.changesView.getSelectedChanges().iterator());
            Intrinsics.checkNotNullExpressionValue((Object)streamEx, (String)"StreamEx.of(changesView.\u2026lectedChanges.iterator())");
            Stream stream2 = (Stream)streamEx;
            StreamEx streamEx2 = StreamEx.of((Iterator)this.changesView.getSelectedUnversionedFiles().iterator());
            Intrinsics.checkNotNullExpressionValue((Object)streamEx2, (String)"StreamEx.of(changesView.\u2026ersionedFiles.iterator())");
            stream = ChangesViewDiffPreviewProcessorKt.access$wrap(stream2, (Stream)streamEx2);
        }
        return stream;
    }

    @Override
    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
        StreamEx streamEx = StreamEx.of((Iterator)this.changesView.getChanges().iterator());
        Intrinsics.checkNotNullExpressionValue((Object)streamEx, (String)"StreamEx.of(changesView.changes.iterator())");
        Stream stream = (Stream)streamEx;
        Stream<FilePath> stream2 = this.changesView.getUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"changesView.unversionedFiles");
        return ChangesViewDiffPreviewProcessorKt.access$wrap(stream, stream2);
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            TreePath treePath = this.changesView.findNodePathInTree(change.getUserObject());
            if (treePath == null) break block0;
            TreePath treePath2 = treePath;
            boolean bl = false;
            boolean bl2 = false;
            TreePath it = treePath2;
            boolean bl3 = false;
            TreeUtil.selectPath((JTree)((JTree)((Object)this.changesView)), (TreePath)it, (boolean)false);
        }
    }

    @Override
    @NotNull
    protected AnAction createGoToChangeAction() {
        return new MyGoToChangePopupProvider().createGoToChangeAction();
    }

    public final void setAllowExcludeFromCommit(boolean value2) {
        if (DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder)this.getContext()) == value2) {
            return;
        }
        this.getContext().putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)value2);
        this.fireDiffSettingsChanged();
    }

    public final void fireDiffSettingsChanged() {
        this.dropCaches();
        this.updateRequest(true);
    }

    public ChangesViewDiffPreviewProcessor(@NotNull ChangesListView changesView2, boolean isInEditor) {
        Intrinsics.checkNotNullParameter((Object)changesView2, (String)"changesView");
        super(changesView2.getProject(), isInEditor ? "Default" : "ChangesView");
        this.changesView = changesView2;
        if (!isInEditor) {
            Wrapper wrapper2 = this.myContentPanel;
            Intrinsics.checkNotNullExpressionValue((Object)wrapper2, (String)"myContentPanel");
            wrapper2.setBorder(IdeBorderFactory.createBorder((int)2));
        }
        this.putContextUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewProcessor$MyGoToChangePopupProvider;", "Lcom/intellij/openapi/vcs/changes/actions/diff/SelectionAwareGoToChangePopupActionProvider;", "(Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewProcessor;)V", "getChanges", "", "Lcom/intellij/openapi/vcs/changes/ui/PresentableChange;", "getSelectedChange", "select", "", "change", "intellij.platform.vcs.impl"})
    private final class MyGoToChangePopupProvider
    extends SelectionAwareGoToChangePopupActionProvider {
        @NotNull
        public List<PresentableChange> getChanges() {
            List list2 = ChangesViewDiffPreviewProcessor.this.changesView.getSelectedChanges().toList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"changesView.selectedChanges.toList()");
            List currentChanges = list2;
            List list3 = ChangesViewDiffPreviewProcessor.this.changesView.getSelectedUnversionedFiles().toList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"changesView.selectedUnversionedFiles.toList()");
            List currentUnversioned = list3;
            ListSelection<ChangeDiffRequestChain.Producer> listSelection = ShowDiffFromLocalChangesActionProvider.collectRequestProducers(ChangesViewDiffPreviewProcessor.this.getProject(), currentChanges, currentUnversioned, ChangesViewDiffPreviewProcessor.this.changesView);
            Intrinsics.checkNotNullExpressionValue(listSelection, (String)"ShowDiffFromLocalChanges\u2026Unversioned, changesView)");
            List list4 = listSelection.getList();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"ShowDiffFromLocalChanges\u2026sioned, changesView).list");
            return list4;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void select(@NotNull PresentableChange change) {
            Change change2;
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            FilePath filePath = change.getFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"change.filePath");
            FilePath filePath2 = filePath;
            ChangeViewDiffRequestProcessor.Wrapper curChange = ChangesViewDiffPreviewProcessor.this.getCurrentChange();
            if (!(curChange instanceof ChangeViewDiffRequestProcessor.ChangeWrapper)) {
                ChangesViewDiffPreviewProcessor.this.selectFilePath(filePath2);
                return;
            }
            Change change3 = ChangesViewDiffPreviewProcessor.this.changesView.getAllChangesFromSameChangelist(((ChangeViewDiffRequestProcessor.ChangeWrapper)curChange).change);
            if (change3 == null) {
                change3 = change2 = ChangesViewDiffPreviewProcessor.this.changesView.getAllChangesFromSameAmendNode(((ChangeViewDiffRequestProcessor.ChangeWrapper)curChange).change);
            }
            if (change3 != null) {
                Object v3;
                boolean bl;
                Iterable iterable;
                block5: {
                    iterable = (Iterable)change2;
                    bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        Change it = (Change)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)ChangesUtil.getFilePath((Change)it), (Object)filePath2)) continue;
                        v3 = t;
                        break block5;
                    }
                    v3 = null;
                }
                if ((change2 = (Change)v3) != null) {
                    iterable = change2;
                    bl = false;
                    boolean bl4 = false;
                    Iterable it = iterable;
                    boolean bl5 = false;
                    ChangeViewDiffRequestProcessor.ChangeWrapper changeToSelect = new ChangeViewDiffRequestProcessor.ChangeWrapper((Change)it);
                    ChangesViewDiffPreviewProcessor.this.setCurrentChange(changeToSelect);
                    ChangesViewDiffPreviewProcessor.this.selectChange(changeToSelect);
                    return;
                }
            }
            ChangesViewDiffPreviewProcessor.this.selectFilePath(filePath2);
        }

        @Override
        @Nullable
        public PresentableChange getSelectedChange() {
            return ChangesViewDiffPreviewProcessor.this.getCurrentChange();
        }
    }
}

