/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.containers.Convertor;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationTooltipBuilder {
    @NotNull
    private final Project myProject;
    private final boolean myAsHtml;
    @Nls
    private final StringBuilder sb;

    public AnnotationTooltipBuilder(@NotNull Project project, boolean asHtml) {
        if (project == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(0);
        }
        this.sb = new StringBuilder();
        this.myProject = project;
        this.myAsHtml = asHtml;
    }

    private void append(@NotNull @Nls String text2) {
        if (text2 == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(1);
        }
        this.sb.append(this.myAsHtml ? XmlStringUtil.escapeString((String)text2) : text2);
    }

    private void appendRaw(@NotNull @Nls String text2) {
        if (text2 == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(2);
        }
        this.sb.append(text2);
    }

    public void appendRevisionLine(@NotNull VcsRevisionNumber revisionNumber, @Nullable Convertor<? super VcsRevisionNumber, String> linkBuilder) {
        String revision;
        if (revisionNumber == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(3);
        }
        this.appendNewline();
        if (this.myAsHtml) {
            String string = revision = linkBuilder != null ? (String)linkBuilder.convert((Object)revisionNumber) : null;
            if (revision == null) {
                revision = XmlStringUtil.escapeString((String)revisionNumber.asString());
            }
        } else {
            revision = revisionNumber.asString();
        }
        this.appendRaw(VcsBundle.message((String)"commit.description.tooltip.commit", (Object[])new Object[]{revision}));
    }

    public void appendLine(@NotNull @Nls String content2) {
        if (content2 == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(4);
        }
        this.appendNewline();
        this.append(content2);
    }

    public void appendCommitMessageBlock(@NotNull @Nls String message2) {
        if (message2 == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(5);
        }
        this.append("\n\n");
        this.appendTextWithLinks(message2);
    }

    public void appendTextWithLinks(@NotNull @Nls String message2) {
        if (message2 == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(6);
        }
        if (this.myAsHtml) {
            this.appendRaw(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, message2));
        } else {
            this.append(VcsUtil.trimCommitMessageToSaneSize((String)message2));
        }
    }

    private void appendNewline() {
        if (this.sb.length() != 0) {
            this.append("\n");
        }
    }

    @Nls
    public String toString() {
        return this.sb.toString();
    }

    @Nls
    @NotNull
    public static String buildSimpleTooltip(@NotNull Project project, boolean asHtml, @NotNull @Nls String prefix2, @NotNull @NlsSafe String revision, @Nullable @Nls String commitMessage2) {
        if (project == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(7);
        }
        if (prefix2 == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(8);
        }
        if (revision == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(9);
        }
        AnnotationTooltipBuilder builder2 = new AnnotationTooltipBuilder(project, asHtml);
        builder2.append(prefix2);
        builder2.append(" ");
        builder2.append(revision);
        if (commitMessage2 != null) {
            builder2.append(": ");
            builder2.appendTextWithLinks(commitMessage2);
        }
        String string = builder2.toString();
        if (string == null) {
            AnnotationTooltipBuilder.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/annotate/AnnotationTooltipBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/annotate/AnnotationTooltipBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSimpleTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendRaw";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendRevisionLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendCommitMessageBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendTextWithLinks";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildSimpleTooltip";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

