/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.CommonCheckinFilesActionKt;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0016\u001a\u00020\tH\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/actions/CommonCheckinFilesAction;", "Lcom/intellij/openapi/vcs/actions/AbstractCommonCheckinAction;", "()V", "appendSubject", "", "dataContext", "Lcom/intellij/openapi/vcs/actions/VcsContext;", "checkinActionName", "approximatelyHasRoots", "", "getActionName", "getInitiallySelectedChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "context", "project", "Lcom/intellij/openapi/project/Project;", "getRoots", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/actions/VcsContext;)[Lcom/intellij/openapi/vcs/FilePath;", "isApplicableRoot", "path", "isForceUpdateCommitStateFromContext", "intellij.platform.vcs.impl"})
public class CommonCheckinFilesAction
extends AbstractCommonCheckinAction {
    @Override
    @NotNull
    protected String getActionName(@NotNull VcsContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        AbstractVcs abstractVcs = CommonCheckinFilesActionKt.access$getCommonVcs(dataContext);
        String actionName = abstractVcs != null && (abstractVcs = abstractVcs.getCheckinEnvironment()) != null ? abstractVcs.getCheckinOperationName() : null;
        String string = actionName;
        if (string == null) {
            String string2 = VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"vcs.command.name.checkin\")");
        }
        return this.appendSubject(dataContext, string);
    }

    private final String appendSubject(VcsContext dataContext, String checkinActionName) {
        List roots = SequencesKt.toList((Sequence)SequencesKt.take((Sequence)CommonCheckinFilesActionKt.access$getRoots(dataContext), (int)2));
        if (roots.isEmpty()) {
            return checkinActionName;
        }
        if (((FilePath)roots.get(0)).isDirectory()) {
            String string = VcsBundle.message((String)"action.name.checkin.directory", (Object[])new Object[]{checkinActionName, roots.size()});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.name.che\u2026inActionName, roots.size)");
            return string;
        }
        String string = VcsBundle.message((String)"action.name.checkin.file", (Object[])new Object[]{checkinActionName, roots.size()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.name.che\u2026inActionName, roots.size)");
        return string;
    }

    @Override
    @NotNull
    protected LocalChangeList getInitiallySelectedChangeList(@NotNull VcsContext context2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager manager2 = changeListManager;
        LocalChangeList localChangeList = manager2.getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"manager.defaultChangeList");
        LocalChangeList defaultChangeList = localChangeList;
        LocalChangeList result2 = null;
        for (FilePath root : this.getRoots(context2)) {
            LocalChangeList localChangeList2;
            Collection changes;
            if (root.getVirtualFile() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)manager2.getChangesIn(root), (String)"manager.getChangesIn(root)");
            if (ContainerUtil.intersects((Collection)changes, (Collection)defaultChangeList.getChanges())) {
                return defaultChangeList;
            }
            if ((Change)CollectionsKt.firstOrNull((Iterable)changes) != null) {
                Change change;
                boolean bl = false;
                boolean bl2 = false;
                Change it = change;
                boolean bl3 = false;
                localChangeList2 = manager2.getChangeList(it);
            } else {
                localChangeList2 = null;
            }
            result2 = localChangeList2;
        }
        LocalChangeList localChangeList3 = result2;
        if (localChangeList3 == null) {
            localChangeList3 = defaultChangeList;
        }
        return localChangeList3;
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            Sequence $this$any$iv = CommonCheckinFilesActionKt.access$getRoots(dataContext);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FilePath it = (FilePath)element$iv;
                boolean bl2 = false;
                if (!this.isApplicableRoot(it, dataContext)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    protected boolean isApplicableRoot(@NotNull FilePath path2, @NotNull VcsContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = dataContext.getProject();
        Intrinsics.checkNotNull((Object)project);
        FileStatus fileStatus = ChangeListManager.getInstance((Project)project).getStatus(path2);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"ChangeListManager.getIns\u2026roject!!).getStatus(path)");
        FileStatus status = fileStatus;
        return (path2.isDirectory() || Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED) ^ true) && Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED) ^ true;
    }

    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        FilePath[] filePathArray = dataContext.getSelectedFilePaths();
        Intrinsics.checkNotNullExpressionValue((Object)filePathArray, (String)"dataContext.selectedFilePaths");
        return filePathArray;
    }

    @Override
    protected boolean isForceUpdateCommitStateFromContext() {
        return true;
    }
}

