/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.InternalPluginResults;
import com.intellij.openapi.updateSettings.impl.PlatformUpdates;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UpdateSettingsEntryPointActionProvider
implements SettingsEntryPointAction.ActionProvider {
    private static final String NEXT_RUN_KEY_BUILD = "NextRunPlatformUpdateBuild";
    private static final String NEXT_RUN_KEY_VERSION = "NextRunPlatformUpdateVersion";
    private static boolean myNewPlatformUpdate;
    @Nullable
    private static String myNextRunPlatformUpdateVersion;
    @Nullable
    private static PlatformUpdates.Loaded myPlatformUpdateInfo;
    @Nullable
    private static Collection<? extends IdeaPluginDescriptor> myIncompatiblePlugins;
    private static Set<String> myAlreadyShownPluginUpdates;
    @Nullable
    private static Collection<PluginDownloader> myUpdatedPlugins;
    @Nullable
    private static Collection<PluginNode> myCustomRepositoryPlugins;
    private static PluginUpdatesService myUpdatesService;
    private static PluginStateListener myPluginStateListener;
    private static boolean myEnableUpdateAction;

    UpdateSettingsEntryPointActionProvider() {
    }

    private static void preparePrevPlatformUpdate() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        BuildNumber newBuildForUpdate = BuildNumber.fromString((String)properties.getValue(NEXT_RUN_KEY_BUILD));
        if (newBuildForUpdate != null) {
            if (newBuildForUpdate.compareTo(ApplicationInfo.getInstance().getBuild()) > 0) {
                myNextRunPlatformUpdateVersion = properties.getValue(NEXT_RUN_KEY_VERSION);
                if (myNextRunPlatformUpdateVersion != null) {
                    myNewPlatformUpdate = true;
                    SettingsEntryPointAction.updateState();
                } else {
                    properties.unsetValue(NEXT_RUN_KEY_BUILD);
                    properties.unsetValue(NEXT_RUN_KEY_VERSION);
                }
            } else {
                properties.unsetValue(NEXT_RUN_KEY_BUILD);
                properties.unsetValue(NEXT_RUN_KEY_VERSION);
            }
        }
    }

    private static void initPluginsListeners() {
        if (myUpdatesService == null) {
            myUpdatesService = PluginUpdatesService.connectWithUpdates(descriptors2 -> {
                if (ContainerUtil.isEmpty((Collection)descriptors2)) {
                    UpdateSettingsEntryPointActionProvider.newUpdatedPlugins(null);
                    myCustomRepositoryPlugins = null;
                    return;
                }
                if (!UpdateSettings.getInstance().isPluginsCheckNeeded()) {
                    return;
                }
                ArrayList<PluginDownloader> downloaders = new ArrayList<PluginDownloader>();
                try {
                    for (IdeaPluginDescriptor descriptor2 : descriptors2) {
                        if (UpdateChecker.isIgnored(descriptor2)) continue;
                        downloaders.add(PluginDownloader.createDownloader(descriptor2));
                    }
                }
                catch (IOException e) {
                    PluginManagerCore.getLogger().error((Throwable)e);
                }
                UpdateSettingsEntryPointActionProvider.newUpdatedPlugins(downloaders);
                myCustomRepositoryPlugins = null;
            });
        }
        if (myPluginStateListener == null) {
            myPluginStateListener = new PluginStateListener(){

                @Override
                public void install(@NotNull IdeaPluginDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    UpdateSettingsEntryPointActionProvider.removePluginsUpdate(List.of(descriptor2));
                }

                @Override
                public void uninstall(@NotNull IdeaPluginDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.install(descriptor2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "descriptor";
                    objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "install";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "uninstall";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PluginStateManager.addStateListener(myPluginStateListener);
        }
    }

    private static void newPlatformUpdate() {
        UpdateSettingsEntryPointActionProvider.setPlatformUpdateInfo(null);
        UpdateSettingsEntryPointActionProvider.newPlatformUpdate(null, null, (String)null);
        SettingsEntryPointAction.updateState();
    }

    public static void newPlatformUpdate(@NotNull PlatformUpdates.Loaded platformUpdateInfo, @NotNull List<PluginDownloader> updatedPlugins, @NotNull Collection<? extends IdeaPluginDescriptor> incompatiblePlugins) {
        if (platformUpdateInfo == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(0);
        }
        if (updatedPlugins == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(1);
        }
        if (incompatiblePlugins == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(2);
        }
        UpdateSettingsEntryPointActionProvider.setPlatformUpdateInfo(platformUpdateInfo);
        UpdateSettingsEntryPointActionProvider.newPlatformUpdate(updatedPlugins, incompatiblePlugins, null);
        SettingsEntryPointAction.updateState();
    }

    private static void setPlatformUpdateInfo(@Nullable PlatformUpdates.Loaded platformUpdateInfo) {
        myPlatformUpdateInfo = platformUpdateInfo;
        myNewPlatformUpdate = platformUpdateInfo != null;
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (platformUpdateInfo == null) {
            properties.unsetValue(NEXT_RUN_KEY_BUILD);
            properties.unsetValue(NEXT_RUN_KEY_VERSION);
        } else {
            BuildInfo build2 = platformUpdateInfo.getNewBuild();
            properties.setValue(NEXT_RUN_KEY_BUILD, build2.toString());
            properties.setValue(NEXT_RUN_KEY_VERSION, build2.getVersion());
        }
    }

    private static void newPlatformUpdate(@Nullable List<PluginDownloader> updatedPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> incompatiblePlugins, @Nullable String nextRunPlatformUpdateVersion) {
        myUpdatedPlugins = updatedPlugins;
        myIncompatiblePlugins = incompatiblePlugins;
        myNextRunPlatformUpdateVersion = nextRunPlatformUpdateVersion;
    }

    public static void newPluginUpdates(@NotNull Collection<PluginDownloader> updatedPlugins, @NotNull Collection<PluginNode> customRepositoryPlugins) {
        if (updatedPlugins == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(3);
        }
        if (customRepositoryPlugins == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(4);
        }
        myUpdatedPlugins = updatedPlugins;
        myCustomRepositoryPlugins = customRepositoryPlugins;
        SettingsEntryPointAction.updateState();
    }

    private static void newUpdatedPlugins(@Nullable Collection<PluginDownloader> updatedPlugins) {
        myUpdatedPlugins = updatedPlugins == null || updatedPlugins.isEmpty() ? null : updatedPlugins;
        SettingsEntryPointAction.updateState();
    }

    static void removePluginsUpdate(@NotNull List<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(5);
        }
        if (myAlreadyShownPluginUpdates != null) {
            myAlreadyShownPluginUpdates.removeIf(name -> descriptors2.stream().anyMatch(descriptor2 -> name.equals(descriptor2.getName())));
        }
        if (myUpdatedPlugins != null) {
            Set pluginIds2 = ContainerUtil.map2Set(descriptors2, PluginDescriptor::getPluginId);
            List updatedPlugins = ContainerUtil.filter(myUpdatedPlugins, downloader -> !pluginIds2.contains(downloader.getId()));
            if (myUpdatedPlugins.size() != updatedPlugins.size()) {
                UpdateSettingsEntryPointActionProvider.newUpdatedPlugins(updatedPlugins);
            }
        }
    }

    private static boolean isAlreadyShownPluginUpdates() {
        return myUpdatedPlugins == null || ContainerUtil.isEmpty(myAlreadyShownPluginUpdates) || myUpdatedPlugins.stream().anyMatch(plugin2 -> !myAlreadyShownPluginUpdates.contains(plugin2.getPluginName()));
    }

    private static void updateAlreadyShownPluginUpdates() {
        if (myUpdatedPlugins != null) {
            if (myAlreadyShownPluginUpdates == null) {
                myAlreadyShownPluginUpdates = new HashSet<String>();
            }
            myUpdatedPlugins.forEach(plugin2 -> myAlreadyShownPluginUpdates.add(plugin2.getPluginName()));
        }
    }

    private static void setEnableUpdateAction(boolean value2) {
        myEnableUpdateAction = value2;
    }

    @Override
    @NotNull
    public Collection<SettingsEntryPointAction.UpdateAction> getUpdateActions(@NotNull DataContext context2) {
        if (context2 == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(6);
        }
        ArrayList<SettingsEntryPointAction.UpdateAction> actions2 = new ArrayList<SettingsEntryPointAction.UpdateAction>();
        if (myNextRunPlatformUpdateVersion != null) {
            actions2.add(new IdeUpdateAction(myNextRunPlatformUpdateVersion){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Project project = e.getProject();
                    Pair result2 = (Pair)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Pair<PlatformUpdates, InternalPluginResults>, RuntimeException>(project, IdeBundle.message((String)"find.ide.update.title", (Object[])new Object[0]), true){

                        @NotNull
                        protected @NotNull Pair<@NotNull PlatformUpdates, @Nullable InternalPluginResults> compute(@NotNull ProgressIndicator indicator2) {
                            PlatformUpdates platformUpdates;
                            if (indicator2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            InternalPluginResults pluginResults = (platformUpdates = UpdateChecker.getPlatformUpdates(UpdateSettings.getInstance(), indicator2)) instanceof PlatformUpdates.Loaded ? this.getInternalPluginUpdates((PlatformUpdates.Loaded)platformUpdates, indicator2) : null;
                            Pair pair = Pair.create((Object)platformUpdates, (Object)pluginResults);
                            if (pair == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return pair;
                        }

                        @NotNull
                        private InternalPluginResults getInternalPluginUpdates(@NotNull PlatformUpdates.Loaded loadedResult, @NotNull ProgressIndicator indicator2) {
                            if (loadedResult == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (indicator2 == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            InternalPluginResults internalPluginResults = UpdateChecker.getInternalPluginUpdates(loadedResult.getNewBuild().getApiVersion(), indicator2);
                            if (internalPluginResults == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            return internalPluginResults;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "indicator";
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$2$1";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "loadedResult";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$2$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "compute";
                                    break;
                                }
                                case 4: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getInternalPluginUpdates";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "compute";
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray;
                                    objectArray[2] = "getInternalPluginUpdates";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                    PlatformUpdates platformUpdateInfo = (PlatformUpdates)result2.getFirst();
                    InternalPluginResults pluginResults = (InternalPluginResults)result2.getSecond();
                    if (platformUpdateInfo instanceof PlatformUpdates.Loaded && pluginResults != null) {
                        UpdateSettingsEntryPointActionProvider.setPlatformUpdateInfo((PlatformUpdates.Loaded)platformUpdateInfo);
                        UpdateSettingsEntryPointActionProvider.newPlatformUpdate(pluginResults.getPluginUpdates().getAll(), pluginResults.getPluginNods(), null);
                        super.actionPerformed(e);
                    } else if (platformUpdateInfo instanceof PlatformUpdates.ConnectionError) {
                        String errorMessage = ((PlatformUpdates.ConnectionError)platformUpdateInfo).getError().getMessage();
                        Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{errorMessage}), (String)IdeBundle.message((String)"find.ide.update.title", (Object[])new Object[0]));
                    } else {
                        Messages.showInfoMessage((Project)project, (String)IdeBundle.message((String)"updates.no.updates.notification", (Object[])new Object[0]), (String)IdeBundle.message((String)"find.ide.update.title", (Object[])new Object[0]));
                        UpdateSettingsEntryPointActionProvider.newPlatformUpdate();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$2", "actionPerformed"));
                }
            });
        } else if (myPlatformUpdateInfo != null) {
            actions2.add(new IdeUpdateAction(myPlatformUpdateInfo.getNewBuild().getVersion()));
        } else if (myUpdatedPlugins != null) {
            int size = myUpdatedPlugins.size();
            actions2.add(new SettingsEntryPointAction.UpdateAction(size == 1 ? IdeBundle.message((String)"settings.entry.point.update.plugin.action", (Object[])new Object[]{myUpdatedPlugins.iterator().next().getPluginName()}) : IdeBundle.message((String)"settings.entry.point.update.plugins.action", (Object[])new Object[]{size})){

                @Override
                public boolean isNewAction() {
                    return UpdateSettingsEntryPointActionProvider.isAlreadyShownPluginUpdates();
                }

                @Override
                public void markAsRead() {
                    UpdateSettingsEntryPointActionProvider.updateAlreadyShownPluginUpdates();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(myEnableUpdateAction);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    PluginUpdateDialog dialog2 = new PluginUpdateDialog(e.getProject(), myUpdatedPlugins, myCustomRepositoryPlugins);
                    dialog2.setFinishCallback(() -> UpdateSettingsEntryPointActionProvider.setEnableUpdateAction(true));
                    UpdateSettingsEntryPointActionProvider.setEnableUpdateAction(false);
                    if (!dialog2.showAndGet()) {
                        UpdateSettingsEntryPointActionProvider.setEnableUpdateAction(true);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        ArrayList<SettingsEntryPointAction.UpdateAction> arrayList = actions2;
        if (arrayList == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    static {
        myEnableUpdateAction = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformUpdateInfo";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatiblePlugins";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customRepositoryPlugins";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newPlatformUpdate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newPluginUpdates";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePluginsUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateActions";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IdeUpdateAction
    extends SettingsEntryPointAction.UpdateAction {
        protected IdeUpdateAction(@NotNull String version2) {
            if (version2 == null) {
                IdeUpdateAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"settings.entry.point.update.ide.action", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), version2}));
        }

        @Override
        public boolean isIdeUpdate() {
            return true;
        }

        @Override
        public boolean isNewAction() {
            return myNewPlatformUpdate;
        }

        @Override
        public void markAsRead() {
            myNewPlatformUpdate = false;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            UpdateInfoDialog dialog2;
            if (e == null) {
                IdeUpdateAction.$$$reportNull$$$0(1);
            }
            if ((dialog2 = new UpdateInfoDialog(e.getProject(), Objects.requireNonNull(myPlatformUpdateInfo), true, myUpdatedPlugins, myIncompatiblePlugins)).showAndGet()) {
                UpdateSettingsEntryPointActionProvider.newPlatformUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$IdeUpdateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class LifecycleListener
    implements AppLifecycleListener {
        LifecycleListener() {
        }

        @Override
        public void appStarted() {
            UpdateSettingsEntryPointActionProvider.preparePrevPlatformUpdate();
            UpdateSettingsEntryPointActionProvider.initPluginsListeners();
        }
    }
}

