/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.KeyStrokeMap;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Robot;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.intellij.lang.annotations.JdkConstants;

public abstract class TypeCommand
extends AbstractCommand {
    private static final Logger LOG = Logger.getInstance(TypeCommand.class);
    private static final KeyStrokeMap ourMap = new KeyStrokeMap();
    private static boolean metaKeyPresent = true;

    public TypeCommand(String text2, int line, boolean executeInAwt) {
        super(text2, line, executeInAwt);
    }

    protected void type(Robot robot, int code, @JdkConstants.InputEventMask int modifiers) {
        this.type(robot, KeyStroke.getKeyStroke(code, modifiers));
    }

    protected void type(Robot robot, KeyStroke keyStroke) {
        boolean meta;
        assert (!SwingUtilities.isEventDispatchThread()) : "Robot playback must not be in EDT";
        boolean shift = (keyStroke.getModifiers() & 1) > 0;
        boolean alt = (keyStroke.getModifiers() & 8) > 0;
        boolean control2 = (keyStroke.getModifiers() & 2) > 0;
        boolean bl = meta = (keyStroke.getModifiers() & 4) > 0;
        if (shift) {
            robot.keyPress(16);
        } else {
            robot.keyRelease(16);
        }
        if (control2) {
            robot.keyPress(17);
        } else {
            robot.keyRelease(17);
        }
        if (alt) {
            robot.keyPress(18);
        } else {
            robot.keyRelease(18);
        }
        if (meta) {
            robot.keyPress(157);
        } else if (metaKeyPresent) {
            try {
                robot.keyRelease(157);
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Throwable)e);
                metaKeyPresent = false;
            }
        }
        if (keyStroke.getKeyCode() > 0) {
            robot.keyPress(keyStroke.getKeyCode());
            robot.delay(Registry.intValue((String)"actionSystem.playback.delay"));
            robot.keyRelease(keyStroke.getKeyCode());
        } else {
            robot.keyPress(keyStroke.getKeyChar());
            robot.delay(Registry.intValue((String)"actionSystem.playback.delay"));
            robot.keyRelease(keyStroke.getKeyChar());
        }
        if (shift) {
            robot.keyRelease(16);
        }
        if (control2) {
            robot.keyRelease(17);
        }
        if (alt) {
            robot.keyRelease(18);
        }
        if (meta) {
            robot.keyRelease(157);
        }
    }

    protected KeyStroke get(char c) {
        return ourMap.get(c);
    }

    protected KeyStroke getFromShortcut(String sc) {
        return ourMap.get(sc);
    }

    public static boolean containsUnicode(String s) {
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (ourMap.containsChar(s.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    static void inWriteSafeContext(Runnable runnable2) {
        ModalityState modality = ModalityState.current();
        ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(runnable2, modality), modality);
    }
}

