/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PathMacro;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.StageInfo;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.ui.playback.commands.AssertFocused;
import com.intellij.openapi.ui.playback.commands.CallCommand;
import com.intellij.openapi.ui.playback.commands.CdCommand;
import com.intellij.openapi.ui.playback.commands.DelayCommand;
import com.intellij.openapi.ui.playback.commands.EmptyCommand;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.openapi.ui.playback.commands.KeyShortcutCommand;
import com.intellij.openapi.ui.playback.commands.PopStage;
import com.intellij.openapi.ui.playback.commands.PrintCommand;
import com.intellij.openapi.ui.playback.commands.PushStage;
import com.intellij.openapi.ui.playback.commands.RegistryValueCommand;
import com.intellij.openapi.ui.playback.commands.StopCommand;
import com.intellij.openapi.ui.playback.commands.ToggleActionCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.StringTokenizer;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class PlaybackRunner {
    private static final Logger LOG = Logger.getInstance(PlaybackRunner.class);
    private Robot myRobot;
    private final String myScript;
    private final StatusCallback myCallback;
    private final List<CommandDescriptor> myCommands = new ArrayList<CommandDescriptor>();
    private ActionCallback myActionCallback;
    private boolean myStopRequested;
    private final boolean myUseDirectActionCall;
    private final boolean myUseTypingTargets;
    private File myScriptDir;
    private final boolean myStopOnAppDeactivation;
    private final ApplicationActivationListener myAppListener;
    private final HashSet<Class<?>> myFacadeClasses = new HashSet();
    private final ArrayList<StageInfo> myCurrentStageDepth = new ArrayList();
    private final ArrayList<StageInfo> myPassedStages = new ArrayList();
    private long myContextTimestamp;
    private final Map<String, String> myRegistryValues = new HashMap<String, String>();
    protected final Disposable myOnStop = Disposer.newDisposable();

    public PlaybackRunner(String script, StatusCallback callback2, boolean useDirectActionCall, boolean stopOnAppDeactivation, boolean useTypingTargets) {
        this.myScript = script;
        this.myCallback = callback2;
        this.myUseDirectActionCall = useDirectActionCall;
        this.myUseTypingTargets = useTypingTargets;
        this.myStopOnAppDeactivation = stopOnAppDeactivation;
        this.myAppListener = new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PlaybackRunner.this.myStopOnAppDeactivation) {
                    PlaybackRunner.this.myCallback.message(null, "App lost focus, stopping...", StatusCallback.Type.message);
                    PlaybackRunner.this.stop();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/openapi/ui/playback/PlaybackRunner$1", "applicationDeactivated"));
            }
        };
    }

    public ActionCallback run() {
        this.myStopRequested = false;
        this.myRegistryValues.clear();
        UiActivityMonitor activityMonitor = UiActivityMonitor.getInstance();
        activityMonitor.clear();
        activityMonitor.setActive(true);
        this.myCurrentStageDepth.clear();
        this.myPassedStages.clear();
        ++this.myContextTimestamp;
        this.subscribeListeners(ApplicationManager.getApplication().getMessageBus().connect(this.myOnStop));
        Disposer.register((Disposable)this.myOnStop, () -> this.onStop());
        try {
            this.myActionCallback = new ActionCallback();
            this.myActionCallback.doWhenProcessed(() -> {
                Disposer.dispose((Disposable)this.myOnStop);
                SwingUtilities.invokeLater(() -> {
                    activityMonitor.setActive(false);
                    this.restoreRegistryValues();
                });
            });
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                this.myRobot = new Robot();
            }
            try {
                this.myCommands.addAll(this.includeScript(this.myScript, this.getScriptDir()));
            }
            catch (Exception e) {
                String message2 = "Failed to parse script commands: " + this.myScript;
                LOG.error(message2, (Throwable)e);
                this.myActionCallback.reject(message2 + ": " + e.getMessage());
                return this.myActionCallback;
            }
            new Thread("playback runner"){

                @Override
                public void run() {
                    if (PlaybackRunner.this.myUseDirectActionCall) {
                        PlaybackRunner.this.executeFrom(0, PlaybackRunner.this.getScriptDir());
                    } else {
                        IdeEventQueue.getInstance().doWhenReady(() -> PlaybackRunner.this.executeFrom(0, PlaybackRunner.this.getScriptDir()));
                    }
                }
            }.start();
        }
        catch (AWTException e) {
            LOG.error((Throwable)e);
        }
        return this.myActionCallback;
    }

    private void restoreRegistryValues() {
        Set<String> storedKeys = this.myRegistryValues.keySet();
        for (String each : storedKeys) {
            Registry.get((String)each).setValue(this.myRegistryValues.get(each));
        }
    }

    private void executeFrom(int cmdIndex, File baseDir) {
        if (cmdIndex < this.myCommands.size()) {
            CommandDescriptor commandDescriptor = this.myCommands.get(cmdIndex);
            PlaybackCommand cmd = this.createCommand(commandDescriptor.fullLine, commandDescriptor.line, commandDescriptor.scriptDir);
            if (this.myStopRequested) {
                this.myCallback.message(null, "Stopped", StatusCallback.Type.message);
                this.myActionCallback.setRejected();
                return;
            }
            Set facadeClassesClone = (Set)this.myFacadeClasses.clone();
            PlaybackContext context2 = new PlaybackContext(this, this.myCallback, cmdIndex, this.myRobot, this.myUseDirectActionCall, this.myUseTypingTargets, cmd, baseDir, facadeClassesClone){
                private final long myTimeStamp;
                {
                    this.myTimeStamp = PlaybackRunner.this.myContextTimestamp;
                }

                @Override
                public void pushStage(StageInfo info2) {
                    PlaybackRunner.this.myCurrentStageDepth.add(info2);
                }

                @Override
                public StageInfo popStage() {
                    if (PlaybackRunner.this.myCurrentStageDepth.size() > 0) {
                        return PlaybackRunner.this.myCurrentStageDepth.remove(PlaybackRunner.this.myCurrentStageDepth.size() - 1);
                    }
                    return null;
                }

                @Override
                public int getCurrentStageDepth() {
                    return PlaybackRunner.this.myCurrentStageDepth.size();
                }

                @Override
                public void addPassed(StageInfo stage) {
                    PlaybackRunner.this.myPassedStages.add(stage);
                }

                @Override
                public boolean isDisposed() {
                    return this.myTimeStamp != PlaybackRunner.this.myContextTimestamp;
                }

                @Override
                public void storeRegistryValue(String key) {
                    if (!PlaybackRunner.this.myRegistryValues.containsKey(key)) {
                        PlaybackRunner.this.myRegistryValues.put(key, Registry.stringValue((String)key));
                    }
                }

                @Override
                public void setProject(@Nullable Project project) {
                    this.myRunner.setProject(project);
                }

                @Override
                @NotNull
                public Project getProject() {
                    Project project = this.myRunner.getProject();
                    if (project == null) {
                        throw new IllegalStateException("Project is null. Use a project-aware runner and check if its project has been set up properly");
                    }
                    Project project2 = project;
                    if (project2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return project2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/playback/PlaybackRunner$3", "getProject"));
                }
            };
            Promise<Object> cmdCallback = cmd.execute(context2);
            cmdCallback.onSuccess(it -> {
                if (cmd.canGoFurther()) {
                    this.executeFrom(cmdIndex + 1, context2.getBaseDir());
                } else {
                    this.myCallback.message(null, "Stopped: cannot go further", StatusCallback.Type.message);
                    this.myActionCallback.setDone();
                }
            }).onError(error2 -> {
                this.myCallback.message(null, "Stopped: " + error2, StatusCallback.Type.message);
                LOG.warn("Callback step stopped with error: " + error2, error2);
                this.myActionCallback.reject(error2.getMessage());
            });
        } else {
            this.myCallback.message(null, "Finished OK " + this.myPassedStages.size() + " tests", StatusCallback.Type.message);
            this.myActionCallback.setDone();
        }
    }

    protected void setProject(@Nullable Project project) {
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    protected void subscribeListeners(MessageBusConnection connection) {
        connection.subscribe(ApplicationActivationListener.TOPIC, (Object)this.myAppListener);
    }

    protected void onStop() {
        this.myCommands.clear();
    }

    @NotNull
    private List<CommandDescriptor> includeScript(String scriptText, File scriptDir) {
        ArrayList<CommandDescriptor> commands = new ArrayList<CommandDescriptor>();
        StringTokenizer tokens = new StringTokenizer(scriptText, "\n");
        int line = 0;
        while (tokens.hasMoreTokens()) {
            String eachLine = tokens.nextToken();
            String includeCmd = "%include";
            String importCallCmd = "%importCall";
            if (eachLine.startsWith(includeCmd)) {
                File file2 = new PathMacro().setScriptDir(scriptDir).resolveFile(eachLine.substring(includeCmd.length()).trim(), scriptDir);
                if (!file2.exists()) {
                    throw new RuntimeException("Cannot find file to include at line " + line + ": " + file2.getAbsolutePath());
                }
                try {
                    String include = FileUtil.loadFile((File)file2);
                    commands.add(new CommandDescriptor("%print " + eachLine, line, scriptDir));
                    List<CommandDescriptor> includeCommands = this.includeScript(include, file2.getParentFile());
                    commands.addAll(includeCommands);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading file at line " + line + ": " + file2.getAbsolutePath());
                }
            }
            if (eachLine.startsWith(importCallCmd)) {
                String className = eachLine.substring(importCallCmd.length()).trim();
                try {
                    Class<?> facadeClass = Class.forName(className);
                    this.myFacadeClasses.add(facadeClass);
                    commands.add(new CommandDescriptor("%print " + eachLine, line++, scriptDir));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Cannot find class at line " + line + ": " + className);
                }
            }
            commands.add(new CommandDescriptor(eachLine, line++, scriptDir));
        }
        ArrayList<CommandDescriptor> arrayList = commands;
        if (arrayList == null) {
            PlaybackRunner.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    protected PlaybackCommand createCommand(String string, int line, File scriptDir) {
        AbstractCommand cmd;
        if (string.startsWith("%set")) {
            cmd = new RegistryValueCommand(string, line);
        } else if (string.startsWith("%%")) {
            cmd = new EmptyCommand(line);
        } else if (string.startsWith("%type")) {
            cmd = new KeyCodeTypeCommand(string, line);
        } else if (string.startsWith("%delay")) {
            cmd = new DelayCommand(string, line);
        } else if (string.startsWith("%[")) {
            cmd = new KeyShortcutCommand(string, line);
        } else if (string.startsWith("%action")) {
            cmd = new ActionCommand(string, line);
        } else if (string.startsWith("%toggle")) {
            cmd = new ToggleActionCommand(string, line);
        } else if (string.startsWith("%stop")) {
            cmd = new StopCommand(string, line);
        } else {
            if (string.startsWith("%assert focused")) {
                return new AssertFocused(string, line);
            }
            if (string.startsWith("%call")) {
                cmd = new CallCommand(string, line);
            } else if (string.startsWith("%cd")) {
                cmd = new CdCommand(string, line);
            } else if (string.startsWith("%startTest")) {
                cmd = new PushStage(string, line);
            } else if (string.startsWith("%endTest")) {
                cmd = new PopStage(string, line);
            } else if (string.startsWith("%print")) {
                cmd = new PrintCommand(string.substring("%print".length() + 1), line);
            } else {
                if (string.startsWith("%")) {
                    LOG.error("Command " + string + " is not found");
                }
                cmd = new AlphaNumericTypeCommand(string, line);
            }
        }
        cmd.setScriptDir(scriptDir);
        AbstractCommand abstractCommand = cmd;
        if (abstractCommand == null) {
            PlaybackRunner.$$$reportNull$$$0(1);
        }
        return abstractCommand;
    }

    public void stop() {
        this.myStopRequested = true;
    }

    public File getScriptDir() {
        return this.myScriptDir != null ? this.myScriptDir : new File(System.getProperty("user.dir"));
    }

    public void setScriptDir(File baseDir) {
        this.myScriptDir = baseDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/ui/playback/PlaybackRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "includeScript";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static interface StatusCallback {
        public void message(@Nullable PlaybackContext var1, String var2, Type var3);

        public static abstract class Edt
        implements StatusCallback {
            @Override
            public final void message(PlaybackContext context2, String text2, Type type) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.messageEdt(context2, text2, type);
                } else {
                    SwingUtilities.invokeLater(() -> this.messageEdt(context2, text2, type));
                }
            }

            public abstract void messageEdt(@Nullable PlaybackContext var1, @NlsContexts.StatusBarText String var2, Type var3);
        }

        public static enum Type {
            message,
            error,
            code,
            test;

        }
    }

    private static class CommandDescriptor {
        public final String fullLine;
        public final int line;
        public final File scriptDir;

        private CommandDescriptor(String fullLine, int line, File scriptDir) {
            this.fullLine = fullLine;
            this.line = line;
            this.scriptDir = scriptDir;
        }
    }
}

