/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.NewFolderAction;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileChooser.impl.FileTreeBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditorListenerAdapter;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.roots.ui.configuration.actions.ToggleExcludedStateAction;
import com.intellij.openapi.roots.ui.configuration.actions.ToggleSourcesStateAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentEntryTreeEditor {
    private final Project myProject;
    private final List<ModuleSourceRootEditHandler<?>> myEditHandlers;
    protected final Tree myTree;
    private FileSystemTreeImpl myFileSystemTree;
    private final JPanel myTreePanel;
    private final TreeNode EMPTY_TREE_ROOT = new DefaultMutableTreeNode(ProjectBundle.message((String)"module.paths.empty.node", (Object[])new Object[0]));
    protected final DefaultActionGroup myEditingActionsGroup;
    private ContentEntryEditor myContentEntryEditor;
    private final MyContentEntryEditorListener myContentEntryEditorListener = new MyContentEntryEditorListener();
    private final FileChooserDescriptor myDescriptor;
    private final JTextField myExcludePatternsField;

    public ContentEntryTreeEditor(Project project, List<ModuleSourceRootEditHandler<?>> editHandlers) {
        this.myProject = project;
        this.myEditHandlers = editHandlers;
        this.myTree = new Tree();
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(true);
        this.myEditingActionsGroup = new DefaultActionGroup();
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        JPanel excludePatternsPanel = new JPanel(new GridBagLayout());
        excludePatternsPanel.setBorder(JBUI.Borders.empty((int)5));
        GridBag gridBag = new GridBag().setDefaultWeightX(1, 1.0).setDefaultPaddingX(JBUIScale.scale((int)5));
        JLabel myExcludePatternsLabel = new JLabel(ProjectBundle.message((String)"module.paths.exclude.patterns", (Object[])new Object[0]));
        excludePatternsPanel.add((Component)myExcludePatternsLabel, gridBag.nextLine().next());
        this.myExcludePatternsField = new JTextField();
        myExcludePatternsLabel.setLabelFor(this.myExcludePatternsField);
        this.myExcludePatternsField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                List patterns;
                ContentEntry entry2;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ContentEntryTreeEditor.this.myContentEntryEditor != null && (entry2 = ContentEntryTreeEditor.this.myContentEntryEditor.getContentEntry()) != null && !(patterns = StringUtil.split((String)ContentEntryTreeEditor.this.myExcludePatternsField.getText().trim(), (String)";")).equals(entry2.getExcludePatterns())) {
                    entry2.setExcludePatterns(patterns);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$1", "textChanged"));
            }
        });
        excludePatternsPanel.add((Component)this.myExcludePatternsField, gridBag.next().fillCellHorizontally());
        JBLabel excludePatternsLegendLabel = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)ProjectBundle.message((String)"label.content.entry.separate.name.patterns", (Object[])new Object[0])));
        excludePatternsLegendLabel.setForeground((Color)JBColor.GRAY);
        excludePatternsPanel.add((Component)excludePatternsLegendLabel, gridBag.nextLine().next().next().fillCellHorizontally());
        this.myTreePanel = new MyPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree, (boolean)true);
        this.myTreePanel.add((Component)scrollPane, "Center");
        this.myTreePanel.add((Component)excludePatternsPanel, "South");
        this.myTreePanel.setVisible(false);
        this.myDescriptor = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        this.myDescriptor.setShowFileSystemRoots(false);
    }

    protected void createEditingActions() {
        for (ModuleSourceRootEditHandler<?> editor : this.myEditHandlers) {
            ToggleSourcesStateAction action2 = new ToggleSourcesStateAction((JTree)this.myTree, this, editor);
            CustomShortcutSet shortcutSet = editor.getMarkRootShortcutSet();
            if (shortcutSet != null) {
                action2.registerCustomShortcutSet((ShortcutSet)shortcutSet, (JComponent)this.myTree);
            }
            this.myEditingActionsGroup.add(action2);
        }
        this.setupExcludedAction();
    }

    protected List<ModuleSourceRootEditHandler<?>> getEditHandlers() {
        return this.myEditHandlers;
    }

    protected TreeCellRenderer getContentEntryCellRenderer(@NotNull ContentEntry contentEntry) {
        if (contentEntry == null) {
            ContentEntryTreeEditor.$$$reportNull$$$0(0);
        }
        return new ContentEntryTreeCellRenderer(this, contentEntry, this.myEditHandlers);
    }

    public void setContentEntryEditor(ContentEntryEditor contentEntryEditor) {
        if (this.myContentEntryEditor != null && this.myContentEntryEditor.equals(contentEntryEditor)) {
            return;
        }
        if (this.myFileSystemTree != null) {
            Disposer.dispose((Disposable)this.myFileSystemTree);
            this.myFileSystemTree = null;
        }
        if (this.myContentEntryEditor != null) {
            this.myContentEntryEditor.removeContentEntryEditorListener(this.myContentEntryEditorListener);
            this.myContentEntryEditor = null;
        }
        if (contentEntryEditor == null) {
            ((DefaultTreeModel)this.myTree.getModel()).setRoot(this.EMPTY_TREE_ROOT);
            this.myTreePanel.setVisible(false);
            if (this.myFileSystemTree != null) {
                Disposer.dispose((Disposable)this.myFileSystemTree);
            }
            return;
        }
        this.myTreePanel.setVisible(true);
        this.myContentEntryEditor = contentEntryEditor;
        this.myContentEntryEditor.addContentEntryEditorListener(this.myContentEntryEditorListener);
        ContentEntry entry2 = contentEntryEditor.getContentEntry();
        assert (entry2 != null) : contentEntryEditor;
        VirtualFile file2 = entry2.getFile();
        if (file2 != null) {
            this.myDescriptor.setRoots(new VirtualFile[]{file2});
        } else {
            String path2 = VfsUtilCore.urlToPath((String)entry2.getUrl());
            this.myDescriptor.setTitle(FileUtil.toSystemDependentName((String)path2));
        }
        this.myExcludePatternsField.setText(StringUtil.join((Collection)entry2.getExcludePatterns(), (String)";"));
        Runnable init2 = () -> {
            this.myFileSystemTree.updateTree();
            this.myFileSystemTree.select(file2, null);
        };
        this.myFileSystemTree = new FileSystemTreeImpl(this.myProject, this.myDescriptor, this.myTree, this.getContentEntryCellRenderer(entry2), init2, null){

            @Override
            protected AbstractTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<? super NodeDescriptor<?>> comparator2, FileChooserDescriptor descriptor2, Runnable onInitialized) {
                return new MyFileTreeBuilder(tree, treeModel, treeStructure, comparator2, descriptor2, onInitialized);
            }
        };
        this.myFileSystemTree.showHiddens(true);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myFileSystemTree);
        MyNewFolderAction newFolderAction = new MyNewFolderAction();
        DefaultActionGroup mousePopupGroup = new DefaultActionGroup();
        mousePopupGroup.add((AnAction)this.myEditingActionsGroup);
        mousePopupGroup.addSeparator();
        mousePopupGroup.add((AnAction)newFolderAction);
        this.myFileSystemTree.registerMouseListener((ActionGroup)mousePopupGroup);
    }

    public ContentEntryEditor getContentEntryEditor() {
        return this.myContentEntryEditor;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ContentEntryTreeEditor.$$$reportNull$$$0(1);
        }
        return project;
    }

    public JComponent createComponent() {
        this.createEditingActions();
        return this.myTreePanel;
    }

    public void select(VirtualFile file2) {
        if (this.myFileSystemTree != null) {
            this.myFileSystemTree.select(file2, null);
        }
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTree, true));
    }

    public void update() {
        if (this.myFileSystemTree != null) {
            ContentEntry entry2;
            ContentEntry contentEntry = entry2 = this.myContentEntryEditor == null ? null : this.myContentEntryEditor.getContentEntry();
            if (entry2 != null) {
                this.myFileSystemTree.getTree().setCellRenderer(this.getContentEntryCellRenderer(entry2));
            }
            this.myFileSystemTree.updateTree();
            DefaultTreeModel model2 = (DefaultTreeModel)this.myTree.getModel();
            int visibleRowCount = TreeUtil.getVisibleRowCount((JTree)this.myTree);
            for (int row2 = 0; row2 < visibleRowCount; ++row2) {
                TreeNode node;
                TreePath pathForRow = this.myTree.getPathForRow(row2);
                if (pathForRow == null || (node = (TreeNode)pathForRow.getLastPathComponent()) == null) continue;
                model2.nodeChanged(node);
            }
        }
    }

    public DefaultActionGroup getEditingActionsGroup() {
        return this.myEditingActionsGroup;
    }

    protected void setupExcludedAction() {
        ToggleExcludedStateAction toggleExcludedAction = new ToggleExcludedStateAction((JTree)this.myTree, this);
        this.myEditingActionsGroup.add((AnAction)toggleExcludedAction);
        toggleExcludedAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(69, 8)), (JComponent)this.myTree);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContentEntryCellRenderer";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyPanel
    extends JPanel
    implements DataProvider {
        private MyPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            if (FileSystemTree.DATA_KEY.is(dataId)) {
                return ContentEntryTreeEditor.this.myFileSystemTree;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$MyPanel", "getData"));
        }
    }

    private static class MyFileTreeBuilder
    extends FileTreeBuilder {
        MyFileTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<? super NodeDescriptor<?>> comparator2, FileChooserDescriptor descriptor2, @Nullable Runnable onInitialized) {
            super(tree, treeModel, treeStructure, comparator2, descriptor2, onInitialized);
        }

        @Override
        protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
            return false;
        }
    }

    private static final class MyNewFolderAction
    extends NewFolderAction
    implements CustomComponentAction {
        private MyNewFolderAction() {
            super(ActionsBundle.messagePointer((String)"action.FileChooser.NewFolder.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.FileChooser.NewFolder.description", (Object[])new Object[0]), AllIcons.Actions.NewFolder);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                MyNewFolderAction.$$$reportNull$$$0(0);
            }
            if (place == null) {
                MyNewFolderAction.$$$reportNull$$$0(1);
            }
            JComponent jComponent = IconWithTextAction.createCustomComponentImpl(this, presentation2, place);
            if (jComponent == null) {
                MyNewFolderAction.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$MyNewFolderAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$MyNewFolderAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyContentEntryEditorListener
    extends ContentEntryEditorListenerAdapter {
        private MyContentEntryEditorListener() {
        }

        @Override
        public void sourceFolderAdded(@NotNull ContentEntryEditor editor, SourceFolder folder) {
            if (editor == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(0);
            }
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void sourceFolderRemoved(@NotNull ContentEntryEditor editor, VirtualFile file2) {
            if (editor == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(1);
            }
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void folderExcluded(@NotNull ContentEntryEditor editor, VirtualFile file2) {
            if (editor == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(2);
            }
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void folderIncluded(@NotNull ContentEntryEditor editor, String fileUrl) {
            if (editor == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(3);
            }
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void sourceRootPropertiesChanged(@NotNull ContentEntryEditor editor, @NotNull SourceFolder folder) {
            if (editor == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(4);
            }
            if (folder == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(5);
            }
            ContentEntryTreeEditor.this.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$MyContentEntryEditorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceFolderAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceFolderRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "folderExcluded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "folderIncluded";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceRootPropertiesChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

