/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.DetectedRootsChooserDialog;
import com.intellij.openapi.roots.libraries.ui.impl.SuggestedChildRootInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RootDetectionUtil {
    private static final Logger LOG = Logger.getInstance(RootDetectionUtil.class);

    private RootDetectionUtil() {
    }

    @NotNull
    public static List<OrderRoot> detectRoots(@NotNull Collection<? extends VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project, @NotNull LibraryRootsComponentDescriptor rootsComponentDescriptor) {
        if (rootCandidates == null) {
            RootDetectionUtil.$$$reportNull$$$0(0);
        }
        if (rootsComponentDescriptor == null) {
            RootDetectionUtil.$$$reportNull$$$0(1);
        }
        return RootDetectionUtil.detectRoots(rootCandidates, parentComponent, project, rootsComponentDescriptor.getRootsDetector(), rootsComponentDescriptor.getRootTypes());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<OrderRoot> detectRoots(final @NotNull Collection<? extends VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project, final @NotNull LibraryRootsDetector detector, OrderRootType @NotNull [] rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
        if (rootCandidates == null) {
            RootDetectionUtil.$$$reportNull$$$0(2);
        }
        if (detector == null) {
            RootDetectionUtil.$$$reportNull$$$0(3);
        }
        if (rootTypesAllowedToBeSelectedByUserIfNothingIsDetected == null) {
            RootDetectionUtil.$$$reportNull$$$0(4);
        }
        final ArrayList<OrderRoot> result2 = new ArrayList<OrderRoot>();
        final ArrayList<SuggestedChildRootInfo> suggestedRoots = new ArrayList<SuggestedChildRootInfo>();
        new Task.Modal(project, ProjectBundle.message((String)"progress.title.scanning.for.roots", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    for (VirtualFile rootCandidate : rootCandidates) {
                        Collection<DetectedLibraryRoot> roots = detector.detectRoots(rootCandidate, indicator2);
                        if (!roots.isEmpty() && RootDetectionUtil.allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(roots, rootCandidate)) {
                            for (DetectedLibraryRoot root : roots) {
                                LibraryRootType libraryRootType = root.getTypes().get(0);
                                result2.add(new OrderRoot(root.getFile(), libraryRootType.getType(), libraryRootType.isJarDirectory()));
                            }
                            continue;
                        }
                        for (DetectedLibraryRoot root : roots) {
                            HashMap<LibraryRootType, String> names2 = new HashMap<LibraryRootType, String>();
                            for (LibraryRootType type : root.getTypes()) {
                                String typeName = detector.getRootTypeName(type);
                                LOG.assertTrue(typeName != null, (Object)("Unexpected root type " + type.getType().name() + (type.isJarDirectory() ? " (JAR directory)" : "") + ", detectors: " + detector));
                                names2.put(type, typeName);
                            }
                            suggestedRoots.add(new SuggestedChildRootInfo(rootCandidate, root, names2));
                        }
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil$1", "run"));
            }
        }.queue();
        if (!suggestedRoots.isEmpty()) {
            DetectedRootsChooserDialog dialog2;
            DetectedRootsChooserDialog detectedRootsChooserDialog = dialog2 = parentComponent != null ? new DetectedRootsChooserDialog(parentComponent, suggestedRoots) : new DetectedRootsChooserDialog(project, suggestedRoots);
            if (!dialog2.showAndGet()) {
                List<OrderRoot> list2 = Collections.emptyList();
                if (list2 == null) {
                    RootDetectionUtil.$$$reportNull$$$0(5);
                }
                return list2;
            }
            for (SuggestedChildRootInfo suggestedChildRootInfo : dialog2.getChosenRoots()) {
                LibraryRootType selectedRootType = suggestedChildRootInfo.getSelectedRootType();
                result2.add(new OrderRoot(suggestedChildRootInfo.getDetectedRoot().getFile(), selectedRootType.getType(), selectedRootType.isJarDirectory()));
            }
        }
        if (result2.isEmpty() && rootTypesAllowedToBeSelectedByUserIfNothingIsDetected.length > 0) {
            HashMap<String, Pair> types = new HashMap<String, Pair>();
            for (OrderRootType orderRootType : rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
                for (Object object : (LibraryRootType)new boolean[]{false, true}) {
                    String string = detector.getRootTypeName(new LibraryRootType(orderRootType, (boolean)object));
                    if (string == null) continue;
                    types.put(StringUtil.capitalizeWords((String)string, (boolean)true), Pair.create((Object)orderRootType, (Object)((boolean)object)));
                }
            }
            LOG.assertTrue(!types.isEmpty(), (Object)("No allowed root types found for " + detector));
            ArrayList<String> arrayList = new ArrayList<String>(types.keySet());
            if (arrayList.size() == 1) {
                int answer;
                String title2 = LangBundle.message((String)"dialog.title.attach.roots", (Object[])new Object[0]);
                String typeName = (String)arrayList.get(0);
                String string = LangBundle.message((String)"dialog.message.cannot.determine", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), typeName});
                int n = answer = parentComponent != null ? Messages.showYesNoDialog((Component)parentComponent, (String)string, (String)title2, null) : Messages.showYesNoDialog((Project)project, (String)string, (String)title2, null);
                if (answer == 0) {
                    Pair pair = (Pair)types.get(typeName);
                    for (VirtualFile virtualFile2 : rootCandidates) {
                        result2.add(new OrderRoot(virtualFile2, (OrderRootType)pair.getFirst(), (Boolean)pair.getSecond()));
                    }
                }
            } else {
                void var11_23;
                String title3 = LangBundle.message((String)"dialog.title.choose.categories.selected.files", (Object[])new Object[0]);
                String description = XmlStringUtil.wrapInHtml((CharSequence)LangBundle.message((String)"root.detector.cannot.determine.file.kind", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
                if (parentComponent != null) {
                    ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(parentComponent, arrayList, title3, description);
                } else {
                    ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(project, (List<String>)arrayList, title3, description);
                }
                for (String rootType : var11_23.showAndGetResult()) {
                    Pair pair = (Pair)types.get(rootType);
                    for (VirtualFile virtualFile3 : rootCandidates) {
                        result2.add(new OrderRoot(virtualFile3, (OrderRootType)pair.getFirst(), (Boolean)pair.getSecond()));
                    }
                }
            }
        }
        ArrayList<OrderRoot> arrayList = result2;
        if (arrayList == null) {
            RootDetectionUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(Collection<? extends DetectedLibraryRoot> roots, VirtualFile candidate) {
        for (DetectedLibraryRoot detectedLibraryRoot : roots) {
            if (detectedLibraryRoot.getTypes().size() <= 1 && (detectedLibraryRoot.getFile().equals(candidate) || detectedLibraryRoot.getFile().equals(candidate.getParent()))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCandidates";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsComponentDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypesAllowedToBeSelectedByUserIfNothingIsDetected";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChooseRootTypeElementsDialog
    extends ChooseElementsDialog<String> {
        ChooseRootTypeElementsDialog(Project project, List<String> names2, @NlsContexts.DialogTitle String title2, @NlsContexts.Label String description) {
            super(project, names2, title2, description, true);
        }

        private ChooseRootTypeElementsDialog(Component parent, List<String> names2, @NlsContexts.DialogTitle String title2, @NlsContexts.Label String description) {
            super(parent, names2, title2, description, true);
        }

        @Override
        protected String getItemText(@NlsSafe String item) {
            return item;
        }

        @Override
        @Nullable
        protected Icon getItemIcon(String item) {
            return null;
        }
    }
}

