/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RootFileSupplier {
    private static final Logger LOG = Logger.getInstance(RootFileSupplier.class);
    static final RootFileSupplier INSTANCE = new RootFileSupplier();

    RootFileSupplier() {
    }

    @NotNull
    @NotNull List<@NotNull VirtualFile> getUnloadedContentRoots(UnloadedModuleDescription description) {
        List list2 = ContainerUtil.mapNotNull((Collection)description.getContentRoots(), VirtualFilePointer::getFile);
        if (list2 == null) {
            RootFileSupplier.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    VirtualFile correctRoot(@NotNull VirtualFile file2, @NotNull Object container, @Nullable Object containerProvider) {
        if (file2 == null) {
            RootFileSupplier.$$$reportNull$$$0(1);
        }
        if (container == null) {
            RootFileSupplier.$$$reportNull$$$0(2);
        }
        if (!RootFileSupplier.ensureValid(file2, container, containerProvider)) {
            return null;
        }
        return file2;
    }

    @Nullable
    VirtualFile findFileByUrl(String url) {
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    VirtualFile @NotNull [] getExcludedRoots(LibraryEx library2) {
        VirtualFile[] virtualFileArray = library2.getExcludedRoots();
        if (virtualFileArray == null) {
            RootFileSupplier.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    VirtualFile @NotNull [] getLibraryRoots(LibraryOrSdkOrderEntry entry2, OrderRootType type) {
        VirtualFile[] virtualFileArray = entry2.getRootFiles(type);
        if (virtualFileArray == null) {
            RootFileSupplier.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    @Nullable
    VirtualFile getContentRoot(ContentEntry contentEntry) {
        return contentEntry.getFile();
    }

    @Nullable
    VirtualFile getSourceRoot(SourceFolder sourceFolder) {
        return sourceFolder.getFile();
    }

    static RootFileSupplier forBranch(final ModelBranch branch) {
        return new RootFileSupplier(){

            @Override
            protected VirtualFile @NotNull [] getExcludedRoots(LibraryEx library2) {
                VirtualFile[] virtualFileArray = ContainerUtil.mapNotNull((Object[])library2.getExcludedRootUrls(), this::findFileByUrl).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return virtualFileArray;
            }

            @Override
            protected VirtualFile @NotNull [] getLibraryRoots(LibraryOrSdkOrderEntry entry2, OrderRootType type) {
                VirtualFile[] virtualFileArray = ContainerUtil.mapNotNull((Object[])entry2.getRootUrls(type), this::findFileByUrl).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return virtualFileArray;
            }

            @Override
            @Nullable
            protected VirtualFile getContentRoot(ContentEntry contentEntry) {
                return this.findFileByUrl(contentEntry.getUrl());
            }

            @Override
            @Nullable
            protected VirtualFile getSourceRoot(SourceFolder sourceFolder) {
                return this.findFileByUrl(sourceFolder.getUrl());
            }

            @Override
            @NotNull
            protected @NotNull List<@NotNull VirtualFile> getUnloadedContentRoots(UnloadedModuleDescription description) {
                List list2 = ContainerUtil.mapNotNull((Collection)description.getContentRoots(), p -> this.findFileByUrl(p.getUrl()));
                if (list2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list2;
            }

            @Override
            @Nullable
            protected VirtualFile correctRoot(@NotNull VirtualFile file2, @NotNull Object container, @Nullable Object containerProvider) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (container == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((file2 = super.correctRoot(file2, container, containerProvider)) != null && !(file2 = branch.findFileCopy(file2)).isValid()) {
                    return null;
                }
                return file2;
            }

            @Override
            @Nullable
            protected VirtualFile findFileByUrl(String url) {
                return branch.findFileByUrl(url);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/RootFileSupplier$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "container";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExcludedRoots";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLibraryRoots";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnloadedContentRoots";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/RootFileSupplier$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "correctRoot";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    static boolean ensureValid(@NotNull VirtualFile file2, @NotNull Object container, @Nullable Object containerProvider) {
        if (file2 == null) {
            RootFileSupplier.$$$reportNull$$$0(5);
        }
        if (container == null) {
            RootFileSupplier.$$$reportNull$$$0(6);
        }
        if (!file2.isValid()) {
            if (containerProvider != null) {
                LOG.error("Invalid root " + file2 + " in " + container + " provided by " + containerProvider.getClass());
            } else {
                LOG.error("Invalid root " + file2 + " in " + container);
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootFileSupplier";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedContentRoots";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootFileSupplier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "correctRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

