/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPackageType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPlatform;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.system.CpuArch;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J#\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003JH\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2'\u0010\u0012\u001a#\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0010J\u0017\u0010\u001e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "", "ideBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "supportedPlatforms", "", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPlatform;", "(Lcom/intellij/openapi/util/BuildNumber;Ljava/util/Set;)V", "component1", "component2", "copy", "equals", "", "other", "foldSubPredicates", "filter", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "emptyResult", "op", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "acc", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;ZLkotlin/jvm/functions/Function2;)Ljava/lang/Boolean;", "hashCode", "", "testJdkPackage", "pkg", "testJdkProduct", "product", "testPredicate", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Boolean;", "toString", "", "Companion", "intellij.platform.lang.impl"})
public final class JdkPredicate {
    private final BuildNumber ideBuildNumber;
    private final Set<JdkPlatform> supportedPlatforms;
    @NotNull
    private static final String currentOS;
    @NotNull
    private static final String currentArch;
    @NotNull
    public static final Companion Companion;

    public final boolean testJdkProduct(@NotNull ObjectNode product) {
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        JsonNode filterNode = product.get("filter");
        return Intrinsics.areEqual((Object)this.testPredicate(filterNode), (Object)true);
    }

    public final boolean testJdkPackage(@NotNull ObjectNode pkg) {
        JdkPackageType jdkPackageType;
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Object object = pkg.get("os");
        if (object == null || (object = object.asText()) == null) {
            return false;
        }
        Object os = object;
        Object object2 = pkg.get("arch");
        if (object2 == null || (object2 = object2.asText()) == null) {
            return false;
        }
        Object arch = object2;
        if (!this.supportedPlatforms.contains(new JdkPlatform((String)os, (String)arch))) {
            return false;
        }
        Object object3 = pkg.get("package_type");
        if (object3 != null && (object3 = object3.asText()) != null) {
            Object object4 = object3;
            JdkPackageType.Companion companion = JdkPackageType.Companion;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object4;
            boolean bl3 = false;
            jdkPackageType = companion.findType((String)p1);
        } else {
            jdkPackageType = null;
        }
        if (jdkPackageType == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.testPredicate(pkg.get("filter")), (Object)true);
    }

    @Nullable
    public final Boolean testPredicate(@Nullable JsonNode filter) {
        if (filter == null) {
            return true;
        }
        if (filter.isBoolean()) {
            return filter.asBoolean();
        }
        if (!(filter instanceof ObjectNode)) {
            return null;
        }
        Object object = filter.get("type");
        if (object == null || (object = object.asText()) == null) {
            return null;
        }
        Object type = object;
        if (Intrinsics.areEqual((Object)type, (Object)"or")) {
            return this.foldSubPredicates((ObjectNode)filter, false, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)testPredicate.1.INSTANCE));
        }
        if (Intrinsics.areEqual((Object)type, (Object)"and")) {
            return this.foldSubPredicates((ObjectNode)filter, true, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)testPredicate.2.INSTANCE));
        }
        if (Intrinsics.areEqual((Object)type, (Object)"not")) {
            Boolean bl = this.testPredicate(filter.get("item"));
            if (bl == null) {
                return null;
            }
            boolean subResult = bl;
            return !subResult;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"const")) {
            JsonNode jsonNode = filter.get("value");
            return jsonNode != null ? Boolean.valueOf(jsonNode.asBoolean()) : null;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"build_number_range")) {
            String untilBuild;
            JsonNode jsonNode = filter.get("since");
            String fromBuild = jsonNode != null ? jsonNode.asText() : null;
            JsonNode jsonNode2 = filter.get("until");
            String string = untilBuild = jsonNode2 != null ? jsonNode2.asText() : null;
            if (fromBuild == null && untilBuild == null) {
                return true;
            }
            if (fromBuild != null) {
                BuildNumber buildNumber = BuildNumber.fromStringOrNull((String)fromBuild);
                if (buildNumber == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromStringOr\u2026fromBuild) ?: return null");
                BuildNumber fromBuildSafe = buildNumber;
                if (fromBuildSafe.compareTo(this.ideBuildNumber) > 0) {
                    return false;
                }
            }
            if (untilBuild != null) {
                BuildNumber buildNumber = BuildNumber.fromStringOrNull((String)untilBuild);
                if (buildNumber == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromStringOr\u2026ntilBuild) ?: return null");
                BuildNumber untilBuildSafe = buildNumber;
                if (this.ideBuildNumber.compareTo(untilBuildSafe) > 0) {
                    return false;
                }
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"supports_arch")) {
            return true;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean foldSubPredicates(ObjectNode filter, boolean emptyResult, Function2<? super Boolean, ? super Boolean, Boolean> op) {
        void $this$fold$iv;
        JsonNode jsonNode = filter.get("items");
        if (!(jsonNode instanceof ArrayNode)) {
            jsonNode = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        if (arrayNode == null) {
            return null;
        }
        ArrayNode items = arrayNode;
        if (items.isEmpty()) {
            return false;
        }
        Iterable iterable = (Iterable)items;
        Boolean initial$iv = emptyResult;
        boolean $i$f$fold = false;
        Boolean accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void subFilter;
            JsonNode jsonNode2 = (JsonNode)element$iv;
            boolean acc = accumulator$iv;
            boolean bl = false;
            Boolean bl2 = this.testPredicate((JsonNode)subFilter);
            if (bl2 == null) {
                return null;
            }
            boolean subResult = bl2;
            accumulator$iv = (boolean)((Boolean)op.invoke((Object)acc, (Object)subResult));
        }
        return accumulator$iv;
    }

    public JdkPredicate(@NotNull BuildNumber ideBuildNumber, @NotNull Set<JdkPlatform> supportedPlatforms) {
        Intrinsics.checkNotNullParameter((Object)ideBuildNumber, (String)"ideBuildNumber");
        Intrinsics.checkNotNullParameter(supportedPlatforms, (String)"supportedPlatforms");
        this.ideBuildNumber = ideBuildNumber;
        this.supportedPlatforms = supportedPlatforms;
    }

    static {
        String string;
        Companion = new Companion(null);
        if (SystemInfo.isWindows) {
            string = "windows";
        } else if (SystemInfo.isMac) {
            string = "macOS";
        } else if (SystemInfo.isLinux) {
            string = "linux";
        } else {
            String string2 = "Unsupported OS";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        currentOS = string;
        currentArch = SystemInfo.isMac && CpuArch.isArm64() || Registry.is((String)"jdk.downloader.assume.m1") ? "aarch64" : "x86_64";
    }

    private final BuildNumber component1() {
        return this.ideBuildNumber;
    }

    private final Set<JdkPlatform> component2() {
        return this.supportedPlatforms;
    }

    @NotNull
    public final JdkPredicate copy(@NotNull BuildNumber ideBuildNumber, @NotNull Set<JdkPlatform> supportedPlatforms) {
        Intrinsics.checkNotNullParameter((Object)ideBuildNumber, (String)"ideBuildNumber");
        Intrinsics.checkNotNullParameter(supportedPlatforms, (String)"supportedPlatforms");
        return new JdkPredicate(ideBuildNumber, supportedPlatforms);
    }

    public static /* synthetic */ JdkPredicate copy$default(JdkPredicate jdkPredicate, BuildNumber buildNumber, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            buildNumber = jdkPredicate.ideBuildNumber;
        }
        if ((n & 2) != 0) {
            set2 = jdkPredicate.supportedPlatforms;
        }
        return jdkPredicate.copy(buildNumber, set2);
    }

    @NotNull
    public String toString() {
        return "JdkPredicate(ideBuildNumber=" + this.ideBuildNumber + ", supportedPlatforms=" + this.supportedPlatforms + ")";
    }

    public int hashCode() {
        BuildNumber buildNumber = this.ideBuildNumber;
        Set<JdkPlatform> set2 = this.supportedPlatforms;
        return (buildNumber != null ? buildNumber.hashCode() : 0) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JdkPredicate)) break block3;
                JdkPredicate jdkPredicate = (JdkPredicate)object;
                if (!Intrinsics.areEqual((Object)this.ideBuildNumber, (Object)jdkPredicate.ideBuildNumber) || !Intrinsics.areEqual(this.supportedPlatforms, jdkPredicate.supportedPlatforms)) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate$Companion;", "", "()V", "currentArch", "", "getCurrentArch", "()Ljava/lang/String;", "currentOS", "getCurrentOS", "createInstance", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "forWsl", "", "default", "forCurrentProcess", "forWSL", "none", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final JdkPredicate none() {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
            BuildNumber buildNumber = applicationInfoEx.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfoImpl.getShadowInstance().build");
            return new JdkPredicate(buildNumber, SetsKt.emptySet());
        }

        @NotNull
        public final JdkPredicate default() {
            return this.createInstance(false);
        }

        @NotNull
        public final JdkPredicate forWSL() {
            return this.createInstance(true);
        }

        @NotNull
        public final JdkPredicate forCurrentProcess() {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
            BuildNumber buildNumber = applicationInfoEx.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfoImpl.getShadowInstance().build");
            return new JdkPredicate(buildNumber, SetsKt.setOf((Object)new JdkPlatform(this.getCurrentOS(), this.getCurrentArch())));
        }

        private final JdkPredicate createInstance(boolean forWsl) {
            List list2;
            String x86_64 = "x86_64";
            JdkPlatform defaultPlatform = new JdkPlatform(this.getCurrentOS(), x86_64);
            if (SystemInfo.isMac && CpuArch.isArm64() || Registry.is((String)"jdk.downloader.assume.m1")) {
                list2 = CollectionsKt.listOf((Object[])new JdkPlatform[]{defaultPlatform, JdkPlatform.copy$default(defaultPlatform, null, "aarch64", 1, null)});
            } else if (SystemInfo.isWindows && forWsl) {
                list2 = CollectionsKt.listOf((Object)JdkPlatform.copy$default(defaultPlatform, "linux", null, 2, null));
            } else if (!SystemInfo.isWindows && forWsl) {
                boolean bl = false;
                list2 = CollectionsKt.emptyList();
            } else {
                list2 = CollectionsKt.listOf((Object)defaultPlatform);
            }
            List platforms = list2;
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
            BuildNumber buildNumber = applicationInfoEx.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfoImpl.getShadowInstance().build");
            return new JdkPredicate(buildNumber, CollectionsKt.toSet((Iterable)platforms));
        }

        static /* synthetic */ JdkPredicate createInstance$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.createInstance(bl);
        }

        @NotNull
        public final String getCurrentOS() {
            return currentOS;
        }

        @NotNull
        public final String getCurrentArch() {
            return currentArch;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

