/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.hash.Hashing;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerWSL;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListParser;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.LocallyFoundJdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.PendingJdkRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.WSLDistributionForJdkInstaller;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H&J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0004J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u0018\u001a\u00020\rH\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&J$\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u0012\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0016\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010,\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0011J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0011H\u0002J#\u0010.\u001a\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u000b\u0012\t\u0018\u00010\u001f\u00a2\u0006\u0002\b00/2\u0006\u00101\u001a\u00020\u001fJ\u0010\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00142\u0006\u00104\u001a\u00020\u0011H\u0014R\u001f\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerBase;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "myLock", "Ljava/util/concurrent/locks/ReentrantLock;", "myPendingDownloads", "Ljava/util/HashMap;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/PendingJdkRequest;", "Lkotlin/collections/HashMap;", "defaultInstallDir", "Ljava/nio/file/Path;", "newVersion", "wslDistribution", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/WSLDistributionForJdkInstaller;", "installDir", "findAlreadyInstalledJdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "feedItem", "distribution", "findHistoryRoots", "", "findJdkItemForInstalledJdk", "jdkPath", "jdkHome", "", "installJdk", "", "request", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "installJdkImpl", "markerFile", "prepareJdkInstallation", "jdkItem", "targetPath", "prepareJdkInstallationDirect", "prepareJdkInstallationImpl", "validateInstallDir", "Lkotlin/Pair;", "Lorg/jetbrains/annotations/Nls;", "selectedPath", "writeMarkerFile", "wslDistributionFromPath", "targetDir", "intellij.platform.lang.impl"})
public abstract class JdkInstallerBase {
    @NotNull
    private final Logger LOG;
    private final ReentrantLock myLock;
    private final HashMap<JdkItem, PendingJdkRequest> myPendingDownloads;

    protected static /* synthetic */ void getLOG$annotations() {
    }

    @NotNull
    protected final Logger getLOG() {
        return this.LOG;
    }

    @NotNull
    public abstract Path defaultInstallDir();

    @NotNull
    public Path defaultInstallDir(@Nullable WSLDistributionForJdkInstaller wslDistribution) {
        return this.defaultInstallDir();
    }

    @NotNull
    public final Path defaultInstallDir(@NotNull JdkItem newVersion) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        return this.defaultInstallDir(this.defaultInstallDir(), newVersion);
    }

    @NotNull
    protected final Path defaultInstallDir(@NotNull Path installDir, @NotNull JdkItem newVersion) {
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        Path targetDir = installDir.resolve(newVersion.getInstallFolderName());
        int count = 1;
        Path uniqueDir = targetDir;
        while (true) {
            Path path2 = uniqueDir;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"uniqueDir");
            if (!PathKt.exists((Path)path2)) break;
            Path path3 = targetDir;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"targetDir");
            uniqueDir = path3.getParent().resolve("" + targetDir.getFileName() + '-' + count++);
        }
        Path path4 = uniqueDir.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"uniqueDir.toAbsolutePath()");
        return path4;
    }

    @NotNull
    public final Pair<Path, String> validateInstallDir(@NotNull String selectedPath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)selectedPath, (String)"selectedPath");
        if (StringsKt.isBlank((CharSequence)selectedPath)) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.empty", (Object[])new Object[0]));
        }
        File[] fileArray = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = fileArray;
            boolean bl2 = false;
            $this$runCatching = Paths.get(FileUtil.expandUserHome((String)selectedPath), new String[0]);
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        fileArray = object;
        bl = false;
        boolean bl4 = false;
        File[] fileArray2 = Result.exceptionOrNull-impl((Object)fileArray);
        if (fileArray2 != null) {
            File[] t = fileArray2;
            boolean bl5 = false;
            this.LOG.warn("Failed to resolve user path: " + selectedPath + ". " + t.getMessage(), (Throwable)t);
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.resolving.path", (Object[])new Object[0]));
        }
        Path targetDir = (Path)fileArray;
        if (Files.isRegularFile(targetDir, new LinkOption[0])) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.file", (Object[])new Object[0]));
        }
        if (Files.isDirectory(targetDir, new LinkOption[0])) {
            File[] fileArray3 = targetDir.toFile().listFiles();
            if (fileArray3 != null) {
                fileArray = fileArray3;
                bl = false;
                fileArray2 = fileArray;
                boolean bl6 = false;
                if (!(fileArray2.length == 0)) {
                    return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.nonEmpty.dir", (Object[])new Object[0]));
                }
            }
        }
        return TuplesKt.to((Object)targetDir, null);
    }

    public final void installJdk(@NotNull JdkInstallRequest request, @Nullable ProgressIndicator indicator2, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request instanceof LocallyFoundJdk) {
            return;
        }
        if (request instanceof PendingJdkRequest) {
            ((PendingJdkRequest)request).tryStartInstallOrWait(indicator2, (Function0<Unit>)((Function0)new Function0<Unit>(this, request, indicator2, project){
                final /* synthetic */ JdkInstallerBase this$0;
                final /* synthetic */ JdkInstallRequest $request;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ Project $project;

                public final void invoke() {
                    this.this$0.installJdkImpl(this.$request, this.$indicator, this.$project);
                }
                {
                    this.this$0 = jdkInstallerBase;
                    this.$request = jdkInstallRequest;
                    this.$indicator = progressIndicator;
                    this.$project = project;
                    super(0);
                }
            }));
            return;
        }
        this.LOG.error("Unexpected JdkInstallRequest: " + request + " of type " + request.getClass().getName());
        this.installJdkImpl(request, indicator2, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void installJdkImpl(@NotNull JdkInstallRequest request, @Nullable ProgressIndicator indicator2, @Nullable Project project) {
        Object object3;
        Object sizeDiff;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        JdkItem item = request.getItem();
        ProgressIndicator progressIndicator = indicator2;
        if (progressIndicator != null) {
            progressIndicator.setText(ProjectBundle.message((String)"progress.text.installing.jdk.1", (Object[])new Object[]{item.getFullPresentationText()}));
        }
        Path targetDir = request.getInstallDir();
        Url url = Urls.parse((String)item.getUrl(), (boolean)false);
        if (url == null) {
            String string = "Cannot parse download URL: " + item.getUrl();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Url url2 = url;
        if (!StringsKt.equals((String)url2.getScheme(), (String)"https", (boolean)true)) {
            String string = "URL must use https:// protocol, but was: " + url2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        WSLDistributionForJdkInstaller wslDistribution = this.wslDistributionFromPath(targetDir);
        if (wslDistribution != null && Intrinsics.areEqual((Object)item.getOs(), (Object)"linux") ^ true) {
            String string = "Cannot install non-linux JDK into WSL environment to " + targetDir + " from " + item;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ProgressIndicator progressIndicator2 = indicator2;
        if (progressIndicator2 != null) {
            progressIndicator2.setText2(ProjectBundle.message((String)"progress.text2.downloading.jdk", (Object[])new Object[0]));
        }
        Path downloadFile = Paths.get(PathManager.getTempPath(), FileUtil.sanitizeFileName((String)("jdk-" + System.nanoTime() + '-' + item.getArchiveFileName())));
        try {
            Object $this$runCatching222222222;
            Object object;
            try {
                HttpRequests.request((String)item.getUrl()).productNameAsUserAgent().saveToFile(downloadFile.toFile(), indicator2);
                Path path2 = downloadFile;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"downloadFile");
                if (!PathKt.isFile((Path)path2)) {
                    throw (Throwable)new RuntimeException("Downloaded file does not exist: " + downloadFile);
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw (Throwable)new RuntimeException("Failed to download " + item.getFullPresentationText() + " from " + url2 + ". " + t.getMessage(), t);
                throw t;
            }
            JdkInstallerBase jdkInstallerBase = this;
            boolean bl = false;
            try {
                object = Result.Companion;
                $this$runCatching222222222 = jdkInstallerBase;
                boolean bl2 = false;
                $this$runCatching222222222 = Files.size(downloadFile) - item.getArchiveSize();
                bl2 = false;
                object = Result.constructor-impl((Object)$this$runCatching222222222);
            }
            catch (Throwable $this$runCatching222222222) {
                Result.Companion bl2 = Result.Companion;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching222222222));
            }
            jdkInstallerBase = object;
            bl = false;
            sizeDiff = (Long)((Object)(Result.isFailure-impl((Object)jdkInstallerBase) ? null : jdkInstallerBase));
            Long l = sizeDiff;
            if (l == null || l != 0L) {
                Object object2;
                StringBuilder stringBuilder = new StringBuilder().append("The downloaded ").append(item.getFullPresentationText()).append(" has incorrect file size,\n").append("the difference is ");
                Long l2 = sizeDiff;
                if (l2 != null) {
                    long l3 = l2;
                    boolean bl4 = false;
                    object2 = Math.abs(l3);
                    throw (Throwable)new RuntimeException(stringBuilder.append(object2).append(" bytes.\n").append("Check your internet connection and try again later").toString());
                }
                object2 = "unknown";
                throw (Throwable)new RuntimeException(stringBuilder.append(object2).append(" bytes.\n").append("Check your internet connection and try again later").toString());
            }
            object3 = this;
            boolean bl5 = false;
            try {
                $this$runCatching222222222 = Result.Companion;
                Object $this$runCatching3 = object3;
                boolean bl6 = false;
                $this$runCatching3 = com.google.common.io.Files.asByteSource((File)downloadFile.toFile()).hash(Hashing.sha256()).toString();
                bl6 = false;
                $this$runCatching222222222 = Result.constructor-impl((Object)$this$runCatching3);
            }
            catch (Throwable $this$runCatching3) {
                Result.Companion bl6 = Result.Companion;
                boolean bl7 = false;
                $this$runCatching222222222 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching3));
            }
            object3 = $this$runCatching222222222;
            bl5 = false;
            String actualHashCode = (String)(Result.isFailure-impl((Object)object3) ? null : object3);
            if (!StringsKt.equals((String)actualHashCode, (String)item.getSha256(), (boolean)true)) {
                StringBuilder stringBuilder = new StringBuilder().append("Failed to verify SHA-256 checksum for ").append(item.getFullPresentationText()).append("\n\n").append("The actual value is ");
                String string = actualHashCode;
                if (string != null) {
                    throw (Throwable)new RuntimeException(stringBuilder.append(string).append(",\n").append("but expected ").append(item.getSha256()).append(" was expected\n").append("Check your internet connection and try again later").toString());
                }
                string = "unknown";
                throw (Throwable)new RuntimeException(stringBuilder.append(string).append(",\n").append("but expected ").append(item.getSha256()).append(" was expected\n").append("Check your internet connection and try again later").toString());
            }
            ProgressIndicator progressIndicator3 = indicator2;
            if (progressIndicator3 != null) {
                progressIndicator3.setIndeterminate(true);
            }
            ProgressIndicator progressIndicator4 = indicator2;
            if (progressIndicator4 != null) {
                progressIndicator4.setText2(ProjectBundle.message((String)"progress.text2.unpacking.jdk", (Object[])new Object[0]));
            }
            try {
                Object $this$runCatching222222222;
                if (wslDistribution != null) {
                    JdkInstallerWSL.INSTANCE.unpackJdkOnWsl(wslDistribution, item.getPackageType(), downloadFile, targetDir, item.getPackageRootPrefix());
                } else {
                    object3 = item.getPackageType().openDecompressor(downloadFile).entryFilter(new Predicate(indicator2){
                        final /* synthetic */ ProgressIndicator $indicator;

                        public final boolean test(Decompressor.Entry it) {
                            block0: {
                                ProgressIndicator progressIndicator = this.$indicator;
                                if (progressIndicator == null) break block0;
                                progressIndicator.checkCanceled();
                            }
                            return true;
                        }
                        {
                            this.$indicator = progressIndicator;
                        }
                    });
                    bl5 = false;
                    boolean $this$runCatching222222222 = false;
                    Object it = object3;
                    boolean bl8 = false;
                    String fullMatchPath = StringsKt.trim((String)item.getPackageRootPrefix(), (char[])new char[]{'/'});
                    (StringsKt.isBlank((CharSequence)fullMatchPath) ? it : it.removePrefixPath(fullMatchPath)).extract(targetDir);
                }
                object3 = this;
                bl5 = false;
                try {
                    $this$runCatching222222222 = Result.Companion;
                    JdkInstallerBase $this$runCatching4 = (JdkInstallerBase)object3;
                    boolean bl9 = false;
                    $this$runCatching4.writeMarkerFile(request);
                    $this$runCatching4 = Unit.INSTANCE;
                    boolean bl10 = false;
                    $this$runCatching222222222 = Result.constructor-impl((Object)$this$runCatching4);
                }
                catch (Throwable $this$runCatching4) {
                    Result.Companion companion = Result.Companion;
                    boolean bl11 = false;
                    $this$runCatching222222222 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching4));
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw (Throwable)new RuntimeException("Failed to extract " + item.getFullPresentationText() + ". " + t.getMessage(), t);
                throw t;
            }
            sizeDiff = this;
            boolean bl12 = false;
        }
        catch (Throwable t) {
            try {
                PathKt.delete$default((Path)targetDir, (boolean)false, (int)1, null);
                Path path3 = this.markerFile(targetDir);
                if (path3 == null) throw t;
                PathKt.delete$default((Path)path3, (boolean)false, (int)1, null);
                throw t;
            }
            catch (Throwable throwable) {
                JdkInstallerBase jdkInstallerBase2 = this;
                boolean bl14 = false;
                try {
                    Object object4 = Result.Companion;
                    JdkInstallerBase $this$runCatching6 = jdkInstallerBase2;
                    boolean bl15 = false;
                    FileUtil.delete((Path)downloadFile);
                    Unit unit = Unit.INSTANCE;
                    boolean bl16 = false;
                    object4 = Result.constructor-impl((Object)unit);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Result.Companion companion = Result.Companion;
                    boolean bl17 = false;
                    Object object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                throw throwable;
            }
        }
        try {
            object3 = Result.Companion;
            JdkInstallerBase $this$runCatching5 = (JdkInstallerBase)sizeDiff;
            boolean bl13 = false;
            FileUtil.delete((Path)downloadFile);
            Unit unit = Unit.INSTANCE;
            bl13 = false;
            object3 = Result.constructor-impl((Object)unit);
            return;
        }
        catch (Throwable throwable) {
            Result.Companion bl13 = Result.Companion;
            boolean $this$runCatching4 = false;
            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JdkInstallRequest prepareJdkInstallation(@NotNull JdkItem jdkItem, @NotNull Path targetPath) {
        WSLDistributionForJdkInstaller distribution2;
        JdkInstallRequest existingRequest;
        Intrinsics.checkNotNullParameter((Object)jdkItem, (String)"jdkItem");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        if (Registry.is((String)"jdk.downloader.reuse.installed") && (existingRequest = this.findAlreadyInstalledJdk(jdkItem, distribution2 = this.wslDistributionFromPath(targetPath))) != null) {
            return existingRequest;
        }
        if (Registry.is((String)"jdk.downloader.reuse.downloading")) {
            PendingJdkRequest pendingJdkRequest;
            Lock lock2 = this.myLock;
            boolean bl = false;
            boolean bl2 = false;
            lock2.lock();
            try {
                boolean bl3 = false;
                PendingJdkRequest pendingJdkRequest2 = this.myPendingDownloads.computeIfAbsent(jdkItem, new Function(this, jdkItem, targetPath){
                    final /* synthetic */ JdkInstallerBase this$0;
                    final /* synthetic */ JdkItem $jdkItem$inlined;
                    final /* synthetic */ Path $targetPath$inlined;
                    {
                        this.this$0 = jdkInstallerBase;
                        this.$jdkItem$inlined = jdkItem;
                        this.$targetPath$inlined = path2;
                    }

                    @NotNull
                    public final PendingJdkRequest apply(@NotNull JdkItem it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JdkInstallerBase.access$prepareJdkInstallationImpl(this.this$0, this.$jdkItem$inlined, this.$targetPath$inlined);
                    }
                });
                pendingJdkRequest = pendingJdkRequest2;
            }
            finally {
                lock2.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)pendingJdkRequest, (String)"myLock.withLock {\n      \u2026em, targetPath) }\n      }");
            return pendingJdkRequest;
        }
        return this.prepareJdkInstallationDirect(jdkItem, targetPath);
    }

    @NotNull
    public final JdkInstallRequest prepareJdkInstallationDirect(@NotNull JdkItem jdkItem, @NotNull Path targetPath) {
        Intrinsics.checkNotNullParameter((Object)jdkItem, (String)"jdkItem");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        return this.prepareJdkInstallationImpl(jdkItem, targetPath);
    }

    /*
     * WARNING - void declaration
     */
    private final PendingJdkRequest prepareJdkInstallationImpl(JdkItem jdkItem, Path targetPath) {
        void home2;
        Pair<Path, String> pair = this.validateInstallDir(((Object)targetPath).toString());
        Path path2 = (Path)pair.component1();
        String error2 = (String)pair.component2();
        if (home2 == null || error2 != null) {
            String string = error2;
            if (string == null) {
                string = "Invalid Target Directory";
            }
            throw (Throwable)new RuntimeException(string);
        }
        Path javaHome = jdkItem.resolveJavaHome(targetPath);
        Files.createDirectories(javaHome, new FileAttribute[0]);
        PendingJdkRequest request = new PendingJdkRequest(jdkItem, targetPath, javaHome);
        this.writeMarkerFile(request);
        return request;
    }

    private final Path markerFile(Path installDir) {
        Path path2 = installDir.getParent();
        return path2 != null ? path2.resolve("" + '.' + installDir.getFileName() + ".intellij") : null;
    }

    private final void writeMarkerFile(JdkInstallRequest request) {
        Path installDir = request.getInstallDir();
        Path path2 = this.markerFile(installDir);
        if (path2 == null) {
            return;
        }
        Path markerFile2 = path2;
        try {
            request.getItem().writeMarkerFile(markerFile2);
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            this.LOG.warn("Failed to write marker file to " + markerFile2 + ". " + t.getMessage(), t);
        }
    }

    @Nullable
    public final JdkItem findJdkItemForInstalledJdk(@Nullable String jdkHome) {
        try {
            if (jdkHome == null) {
                return null;
            }
            Path jdkPath = Paths.get(jdkHome, new String[0]);
            return this.findJdkItemForInstalledJdk(jdkPath);
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JdkItem findJdkItemForInstalledJdk(@Nullable Path jdkPath) {
        try {
            Object v0;
            JdkPredicate predicate2;
            block6: {
                void $this$firstOrNull$iv;
                if (jdkPath == null) {
                    return null;
                }
                if (!PathKt.isDirectory((Path)jdkPath)) {
                    return null;
                }
                predicate2 = WslDistributionManager.isWslPath(((Object)jdkPath).toString()) ? JdkPredicate.Companion.forWSL() : JdkPredicate.Companion.default();
                Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.take((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)jdkPath, (Function1)findJdkItemForInstalledJdk.markerFile.1.INSTANCE), (Function1)findJdkItemForInstalledJdk.markerFile.2.INSTANCE), (int)5), (Function1)((Function1)new Function1<Path, Path>(this){
                    final /* synthetic */ JdkInstallerBase this$0;

                    @Nullable
                    public final Path invoke(@NotNull Path it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JdkInstallerBase.access$markerFile(this.this$0, it);
                    }
                    {
                        this.this$0 = jdkInstallerBase;
                        super(1);
                    }
                }));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    if (!PathKt.isFile((Path)it)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            Path path2 = v0;
            if (path2 == null) {
                return null;
            }
            Path markerFile2 = path2;
            ObjectNode json = JdkListParser.INSTANCE.readTree(PathKt.readBytes((Path)markerFile2));
            return (JdkItem)CollectionsKt.firstOrNull(JdkListParser.INSTANCE.parseJdkItem(json, predicate2));
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JdkInstallRequest findAlreadyInstalledJdk(JdkItem feedItem, WSLDistributionForJdkInstaller distribution2) {
        try {
            List list2;
            JdkInstallerBase jdkInstallerBase = this;
            boolean bl = false;
            boolean bl2 = false;
            JdkInstallerBase $this$run = jdkInstallerBase;
            boolean bl3 = false;
            Path defaultInstallDir = $this$run.defaultInstallDir(distribution2);
            if (!PathKt.isDirectory((Path)defaultInstallDir)) {
                boolean bl4 = false;
                list2 = CollectionsKt.emptyList();
            } else {
                AutoCloseable autoCloseable = Files.list(defaultInstallDir);
                boolean bl5 = false;
                boolean bl6 = false;
                Throwable throwable = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl7 = false;
                    Stream stream = it;
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"it");
                    List list3 = StreamsKt.toList((Stream)stream);
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            List localRoots = list2;
            List<Path> historyRoots = this.findHistoryRoots(feedItem);
            Iterator iterator2 = CollectionsKt.plus((Collection)localRoots, (Iterable)historyRoots).iterator();
            while (iterator2.hasNext()) {
                Path jdkHome;
                JdkItem item;
                Path installDir;
                Path path2 = installDir = (Path)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"installDir");
                if (!PathKt.isDirectory((Path)path2)) continue;
                if (this.findJdkItemForInstalledJdk(installDir) == null) {
                    continue;
                }
                if (Intrinsics.areEqual((Object)item, (Object)feedItem) ^ true || !PathKt.isDirectory((Path)(jdkHome = item.resolveJavaHome(installDir))) || !JdkUtil.checkForJdk((Path)jdkHome) || !Intrinsics.areEqual((Object)this.wslDistributionFromPath(jdkHome), (Object)distribution2)) continue;
                return new LocallyFoundJdk(feedItem, installDir, jdkHome);
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    @NotNull
    protected List<Path> findHistoryRoots(@NotNull JdkItem feedItem) {
        Intrinsics.checkNotNullParameter((Object)feedItem, (String)"feedItem");
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    @Nullable
    protected WSLDistributionForJdkInstaller wslDistributionFromPath(@NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        return null;
    }

    public JdkInstallerBase() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
        this.myLock = new ReentrantLock();
        this.myPendingDownloads = new HashMap();
    }

    public static final /* synthetic */ PendingJdkRequest access$prepareJdkInstallationImpl(JdkInstallerBase $this, JdkItem jdkItem, Path targetPath) {
        return $this.prepareJdkInstallationImpl(jdkItem, targetPath);
    }

    public static final /* synthetic */ Path access$markerFile(JdkInstallerBase $this, Path installDir) {
        return $this.markerFile(installDir);
    }
}

