/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerExImpl;
import com.intellij.openapi.project.impl.ProjectManagerExImplKt;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.awt.AWTEvent;
import java.awt.event.InvocationEvent;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0003\u001a&\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a8\u0006\u001d"}, d2={"checkExistingProjectOnOpen", "", "projectToClose", "Lcom/intellij/openapi/project/Project;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "projectDir", "Ljava/nio/file/Path;", "projectName", "", "projectManager", "Lcom/intellij/openapi/project/impl/ProjectManagerExImpl;", "message", "e", "", "openProject", "Ljava/util/concurrent/CompletableFuture;", "project", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runStartUpActivities", "removeProjectConfigurationAndCaches", "", "projectFile", "toCanonicalName", "filePath", "waitAndProcessInvocationEventsInIdeEventQueue", "startupManager", "Lcom/intellij/ide/startup/impl/StartupManagerImpl;", "intellij.platform.ide.impl"})
public final class ProjectManagerExImplKt {
    @NlsSafe
    private static final String message(Throwable e) {
        String message2;
        String string = e.getMessage();
        if (string == null) {
            string = message2 = e.getLocalizedMessage();
        }
        if (message2 != null) {
            return message2;
        }
        message2 = e.toString();
        Throwable throwable = e.getCause();
        if (throwable == null) {
            return message2;
        }
        String causeMessage = ProjectManagerExImplKt.message(throwable);
        return message2 + " (cause: " + causeMessage + ')';
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean checkExistingProjectOnOpen(Project projectToClose, ProjectOpenedCallback callback2, Path projectDir, String projectName, ProjectManagerExImpl projectManager) {
        void result2;
        GeneralSettings settings2 = GeneralSettings.getInstance();
        boolean isValidProject = projectDir != null && com.intellij.ide.impl.ProjectUtil.isValidProjectPath(projectDir);
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        ApplicationManager.getApplication().invokeAndWait(new Runnable(projectDir, isValidProject, settings2, (Ref.BooleanRef)result2, projectManager, projectToClose, callback2, projectName){
            final /* synthetic */ Path $projectDir;
            final /* synthetic */ boolean $isValidProject;
            final /* synthetic */ GeneralSettings $settings;
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ ProjectManagerExImpl $projectManager;
            final /* synthetic */ Project $projectToClose;
            final /* synthetic */ ProjectOpenedCallback $callback;
            final /* synthetic */ String $projectName;

            /*
             * Unable to fully structure code
             */
            public final void invoke() {
                if (this.$projectDir == null || !ProjectAttachProcessor.canAttachToProject()) ** GOTO lbl-1000
                if (!this.$isValidProject) ** GOTO lbl-1000
                v0 = this.$settings;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"settings");
                if (v0.getConfirmOpenNewProject() == -1) lbl-1000:
                // 2 sources

                {
                    if ((exitCode = com.intellij.ide.impl.ProjectUtil.confirmOpenOrAttachProject()) == -1) {
                        this.$result.element = true;
                        return;
                    }
                    if (exitCode == 1) {
                        if (!this.$projectManager.closeAndDispose(this.$projectToClose)) {
                            this.$result.element = true;
                            return;
                        }
                    } else if (exitCode == 2 && PlatformProjectOpenProcessor.Companion.attachToProject(this.$projectToClose, this.$projectDir, this.$callback)) {
                        this.$result.element = true;
                        return;
                    }
                    IdeEventQueue.getInstance().flushQueue();
                } else lbl-1000:
                // 2 sources

                {
                    v1 = GeneralSettings.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"GeneralSettings.getInstance()");
                    mode = v1.getConfirmOpenNewProject();
                    if (mode == 2 && this.$projectDir != null && PlatformProjectOpenProcessor.Companion.attachToProject(this.$projectToClose, this.$projectDir, this.$callback)) {
                        this.$result.element = true;
                        return;
                    }
                    v2 = this.$projectName;
                    if (v2 == null) {
                        v3 = this.$projectDir;
                        v2 = v3 != null && (v3 = v3.getFileName()) != null ? v3.toString() : (v4 = null);
                    }
                    if (v2 == null) {
                        v5 = this.$projectDir;
                        v4 = v5 != null ? v5.toString() : null;
                    }
                    projectNameValue = v4;
                    exitCode = com.intellij.ide.impl.ProjectUtil.confirmOpenNewProject(false, projectNameValue);
                    if (exitCode == 1) {
                        if (!this.$projectManager.closeAndDispose(this.$projectToClose)) {
                            this.$result.element = true;
                            return;
                        }
                    } else if (exitCode != 0) {
                        this.$result.element = true;
                        return;
                    }
                }
                this.$result.element = false;
            }
            {
                this.$projectDir = path2;
                this.$isValidProject = bl;
                this.$settings = generalSettings;
                this.$result = booleanRef;
                this.$projectManager = projectManagerExImpl;
                this.$projectToClose = project;
                this.$callback = projectOpenedCallback;
                this.$projectName = string;
            }
        });
        return result2.element;
    }

    private static final CompletableFuture<?> openProject(Project project, ProgressIndicator indicator2, boolean runStartUpActivities) {
        Activity activity = StartUpMeasurer.startActivity((String)"placing calling projectOpened on event queue");
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startAct\u2026ctOpened on event queue\")");
        Activity waitEdtActivity = activity;
        if (indicator2 != null) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            indicator2.setText(application.isInternal() ? "Waiting on event queue..." : ProjectBundle.message((String)"project.preparing.workspace", (Object[])new Object[0]));
            indicator2.setIndeterminate(true);
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(waitEdtActivity, indicator2, project){
            final /* synthetic */ Activity $waitEdtActivity;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Project $project;

            public final void run() {
                this.$waitEdtActivity.end();
                if (this.$indicator != null) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isInternal()) {
                        this.$indicator.setText("Running project opened tasks...");
                    }
                }
                ProjectManagerImpl.LOG.debug("projectOpened");
                LifecycleUsageTriggerCollector.onProjectOpened(this.$project);
                Activity activity = StartUpMeasurer.startActivity((String)"project opened callbacks");
                Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startAct\u2026roject opened callbacks\")");
                Activity activity2 = activity;
                String name$iv = "projectOpened event executing";
                ActivityCategory category$iv = ActivityCategory.DEFAULT;
                boolean $i$f$runActivity = false;
                Activity activity3 = StartUpMeasurer.startActivity((String)name$iv, (ActivityCategory)category$iv);
                Intrinsics.checkNotNullExpressionValue((Object)activity3, (String)"StartUpMeasurer.startActivity(name, category)");
                Activity activity$iv = activity3;
                boolean bl = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                ((ProjectManagerListener)application.getMessageBus().syncPublisher(ProjectManager.TOPIC)).projectOpened(this.$project);
                Unit result$iv = Unit.INSTANCE;
                activity$iv.end();
                Project project = this.$project;
                if (project == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                }
                ((ComponentManagerEx)project).processInitializedComponents(ProjectComponent.class, (Function2)openProject.2.INSTANCE);
                activity2.end();
                ProjectImpl.ourClassesAreLoaded = true;
            }
            {
                this.$waitEdtActivity = activity;
                this.$indicator = progressIndicator;
                this.$project = project;
            }
        });
        if (runStartUpActivities) {
            StartupManager startupManager = StartupManager.getInstance((Project)project);
            if (startupManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.startup.impl.StartupManagerImpl");
            }
            ((StartupManagerImpl)startupManager).projectOpened(indicator2);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
        return completableFuture;
    }

    public static final void waitAndProcessInvocationEventsInIdeEventQueue(@NotNull StartupManagerImpl startupManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)startupManager), (String)"startupManager");
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while (true) {
            AWTEvent event;
            if (eventQueue.peekEvent() == null) {
                if (!startupManager.postStartupActivityPassed()) continue;
                break;
            }
            IdeEventQueue ideEventQueue = eventQueue;
            Intrinsics.checkNotNullExpressionValue((Object)ideEventQueue, (String)"eventQueue");
            Intrinsics.checkNotNullExpressionValue((Object)ideEventQueue.getNextEvent(), (String)"eventQueue.nextEvent");
            if (!(event instanceof InvocationEvent)) continue;
            eventQueue.dispatchEvent(event);
        }
    }

    private static final Path toCanonicalName(String filePath) {
        Path file2 = Paths.get(filePath, new String[0]);
        try {
            if (SystemInfoRt.isWindows && FileUtil.containsWindowsShortName((String)filePath)) {
                Path path2 = file2.toRealPath(LinkOption.NOFOLLOW_LINKS);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.toRealPath(LinkOption.NOFOLLOW_LINKS)");
                return path2;
            }
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path path3 = file2;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"file");
        return path3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void removeProjectConfigurationAndCaches(Path projectFile) {
        block11: {
            try {
                if (Files.isRegularFile(projectFile, new LinkOption[0])) {
                    Files.deleteIfExists(projectFile);
                    break block11;
                }
                Closeable closeable = Files.newDirectoryStream(projectFile.resolve(".idea"));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    DirectoryStream directoryStream = (DirectoryStream)closeable;
                    boolean bl3 = false;
                    Iterator iterator2 = directoryStream.iterator();
                    while (iterator2.hasNext()) {
                        Path file2;
                        Path path2 = file2 = (Path)iterator2.next();
                        Intrinsics.checkNotNull((Object)path2);
                        PathKt.delete$default((Path)path2, (boolean)false, (int)1, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            PathKt.delete$default((Path)ProjectUtil.getProjectDataPathRoot((Path)projectFile), (boolean)false, (int)1, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final /* synthetic */ Path access$toCanonicalName(String filePath) {
        return ProjectManagerExImplKt.toCanonicalName(filePath);
    }

    public static final /* synthetic */ boolean access$checkExistingProjectOnOpen(Project projectToClose, ProjectOpenedCallback callback2, Path projectDir, String projectName, ProjectManagerExImpl projectManager) {
        return ProjectManagerExImplKt.checkExistingProjectOnOpen(projectToClose, callback2, projectDir, projectName, projectManager);
    }

    public static final /* synthetic */ CompletableFuture access$openProject(Project project, ProgressIndicator indicator2, boolean runStartUpActivities) {
        return ProjectManagerExImplKt.openProject(project, indicator2, runStartUpActivities);
    }

    public static final /* synthetic */ void access$removeProjectConfigurationAndCaches(Path projectFile) {
        ProjectManagerExImplKt.removeProjectConfigurationAndCaches(projectFile);
    }

    public static final /* synthetic */ String access$message(Throwable e) {
        return ProjectManagerExImplKt.message(e);
    }
}

