/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.idea.ApplicationLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectExImpl;
import com.intellij.openapi.project.impl.ProjectExImplKt;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.ProjectServiceContainerInitializedListener;
import com.intellij.openapi.project.impl.ProjectStoreFactory;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.TimedReference;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageBusEx;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001c\u001a\u00020\u0006H\u0007J\u0014\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\b\u0010$\u001a\u0004\u0018\u00010%J\u0006\u0010&\u001a\u00020\u0006J\b\u0010'\u001a\u00020\u0015H\u0007J\b\u0010(\u001a\u00020\u0006H\u0016J\b\u0010)\u001a\u00020\u0006H\u0016J\u0006\u0010*\u001a\u00020\u0006J\b\u0010+\u001a\u0004\u0018\u00010%J\u0006\u0010,\u001a\u00020\u0006J\b\u0010-\u001a\u00020\nH\u0004J\b\u0010.\u001a\u0004\u0018\u00010%J\u001a\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u00182\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u0006\u00103\u001a\u00020\u0018J\b\u00104\u001a\u00020\u0018H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u00105\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u00106\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\u0018H\u0007J\u0006\u00107\u001a\u00020\u0006R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u001a\u0012\u0016\u0012\u0014 \u0016*\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00120\u0015\u00a2\u0006\u0002\b\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00069"}, d2={"Lcom/intellij/openapi/project/impl/ProjectExImpl;", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "Lcom/intellij/project/ProjectStoreOwner;", "filePath", "Ljava/nio/file/Path;", "projectName", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "cachedName", "value", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "componentStore", "getComponentStore", "()Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "setComponentStore", "(Lcom/intellij/openapi/components/impl/stores/IProjectStore;)V", "componentStoreValue", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lorg/jetbrains/annotations/NotNull;", "earlyDisposable", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/Disposable;", "kotlin.jvm.PlatformType", "isLight", "", "<set-?>", "isTemporarilyDisposed", "()Z", "activityNamePrefix", "createEarlyDisposableError", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "error", "dispose", "", "disposeEarlyDisposable", "getBaseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBasePath", "getEarlyDisposable", "getLocationHash", "getName", "getPresentableUrl", "getProjectFile", "getProjectFilePath", "getStateStore", "getWorkspaceFile", "init", "preloadServices", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isDisposed", "isInitialized", "setProjectName", "setTemporarilyDisposed", "toString", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class ProjectExImpl
extends ProjectImpl
implements ProjectStoreOwner {
    private final AtomicReference<Disposable> earlyDisposable;
    private volatile boolean isTemporarilyDisposed;
    private final boolean isLight;
    private String cachedName;
    private SynchronizedClearableLazy<IProjectStore> componentStoreValue;
    @ApiStatus.Internal
    @NotNull
    private static final Key<Boolean> RUN_START_UP_ACTIVITIES;
    @NotNull
    public static final Companion Companion;

    public final boolean isTemporarilyDisposed() {
        return this.isTemporarilyDisposed;
    }

    public boolean isInitialized() {
        ComponentManagerImpl.ContainerState containerState = this.getContainerState().get();
        if (containerState.compareTo((Enum)ComponentManagerImpl.ContainerState.COMPONENT_CREATED) < 0 || containerState.compareTo((Enum)ComponentManagerImpl.ContainerState.DISPOSE_IN_PROGRESS) >= 0 || this.isTemporarilyDisposed || !this.isOpen()) {
            return false;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode() && Intrinsics.areEqual((Object)((Boolean)this.getUserData(RUN_START_UP_ACTIVITIES)), (Object)false)) {
            return true;
        }
        ProjectExImpl $this$serviceIfCreated$iv = this;
        boolean $i$f$serviceIfCreated = false;
        StartupManagerEx startupManagerEx = (StartupManagerEx)((Object)$this$serviceIfCreated$iv.getServiceIfCreated(StartupManager.class));
        return startupManagerEx != null && startupManagerEx.startupActivityPassed();
    }

    @NotNull
    public String getName() {
        String result2 = this.cachedName;
        if (result2 == null) {
            this.cachedName = result2 = this.getComponentStore().getProjectName();
        }
        return result2;
    }

    @Override
    public void setProjectName(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (Intrinsics.areEqual((Object)this.cachedName, (Object)value2)) {
            return;
        }
        this.cachedName = value2;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            StartupManager.getInstance((Project)this).runAfterOpened(new Runnable(this){
                final /* synthetic */ ProjectExImpl this$0;

                public final void run() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ setProjectName.1 this$0;

                        public final void run() {
                            JFrame jFrame = WindowManager.getInstance().getFrame((Project)this.this$0.this$0);
                            if (jFrame == null) {
                                return;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)jFrame, (String)"WindowManager.getInstanc\u2026(this) ?: return@Runnable");
                            JFrame frame = jFrame;
                            String string = FrameTitleBuilder.getInstance().getProjectTitle(this.this$0.this$0);
                            if (string == null) {
                                return;
                            }
                            String title2 = string;
                            frame.setTitle(title2);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, ModalityState.NON_MODAL, this.this$0.getDisposed());
                }
                {
                    this.this$0 = projectExImpl;
                }
            });
        }
    }

    @Override
    @NotNull
    public final IProjectStore getComponentStore() {
        Object object = this.componentStoreValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"componentStoreValue.value");
        return (IProjectStore)object;
    }

    public final void setComponentStore(@NotNull IProjectStore value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (this.componentStoreValue.isInitialized()) {
            throw (Throwable)new IllegalStateException("store is already initialized");
        }
        this.componentStoreValue.setValue((Object)value2);
    }

    @Override
    @NotNull
    protected final IProjectStore getStateStore() {
        return this.getComponentStore();
    }

    @NotNull
    public final String getProjectFilePath() {
        Path path2 = this.getComponentStore().getProjectFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"componentStore.projectFilePath");
        return PathKt.getSystemIndependentPath((Path)path2);
    }

    @Nullable
    public final VirtualFile getProjectFile() {
        return LocalFileSystem.getInstance().findFileByNioFile(this.getComponentStore().getProjectFilePath());
    }

    @Nullable
    public final VirtualFile getBaseDir() {
        return LocalFileSystem.getInstance().findFileByNioFile(this.getComponentStore().getProjectBasePath());
    }

    @NotNull
    public final String getBasePath() {
        Path path2 = this.getComponentStore().getProjectBasePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"componentStore.projectBasePath");
        return PathKt.getSystemIndependentPath((Path)path2);
    }

    @NotNull
    public final String getPresentableUrl() {
        String string;
        IProjectStore store = this.getComponentStore();
        if (store.getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
            Path path2 = store.getProjectBasePath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"store.projectBasePath");
            string = PathKt.getSystemIndependentPath((Path)path2);
        } else {
            Path path3 = store.getProjectFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"store.projectFilePath");
            string = PathKt.getSystemIndependentPath((Path)path3);
        }
        return string;
    }

    @NotNull
    public String getLocationHash() {
        IProjectStore store = this.getComponentStore();
        String prefix2 = null;
        Path path2 = null;
        if (store.getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
            Path path3 = store.getProjectBasePath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"store.projectBasePath");
            path2 = path3;
            prefix2 = "";
        } else {
            Path path4 = store.getProjectFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"store.projectFilePath");
            path2 = path4;
            prefix2 = this.getName();
        }
        return prefix2 + Integer.toHexString(PathKt.getSystemIndependentPath((Path)path2).hashCode());
    }

    @Nullable
    public final VirtualFile getWorkspaceFile() {
        return LocalFileSystem.getInstance().findFileByNioFile(this.getComponentStore().getWorkspacePath());
    }

    @Override
    public final boolean isLight() {
        return this.isLight;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public final String activityNamePrefix() {
        return "project ";
    }

    @Override
    public void init(boolean preloadServices2, @Nullable ProgressIndicator indicator2) {
        block4: {
            CompletableFuture<Void> completableFuture;
            Application app = ApplicationManager.getApplication();
            if (preloadServices2) {
                List<IdeaPluginDescriptorImpl> list2 = PluginManagerCore.getLoadedPlugins(null);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"PluginManagerCore.getLoadedPlugins(null)");
                completableFuture = ApplicationLoader.preloadServices(list2, this, "project ", this.isLight);
            } else {
                completableFuture = null;
            }
            CompletableFuture<Void> servicePreloadingFuture = completableFuture;
            this.createComponents(indicator2);
            CompletableFuture<Void> completableFuture2 = servicePreloadingFuture;
            if (completableFuture2 != null) {
                Void cfr_ignored_0 = (Void)completableFuture2.join();
            }
            Activity activity = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity((String)"projectComponentCreated event handling", (ActivityCategory)ActivityCategory.DEFAULT) : null;
            Application application = app;
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsInitialized((Project)this);
            Activity activity2 = activity;
            activity = activity2 != null ? activity2.endAndStart("projectComponentCreated") : null;
            ExtensionsArea extensionsArea = app.getExtensionArea();
            if (extensionsArea == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.extensions.impl.ExtensionsAreaImpl");
            }
            ExtensionPointImpl extensionPointImpl = ((ExtensionsAreaImpl)extensionsArea).getExtensionPoint("com.intellij.projectServiceContainerInitializedListener");
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointImpl, (String)"(app.extensionArea as Ex\u2026inerInitializedListener\")");
            ExtensionPointImpl ep$iv = extensionPointImpl;
            boolean $i$f$runOnlyCorePluginExtensions = false;
            ep$iv.processWithPluginDescriptor(true, new BiConsumer(ep$iv, this){
                final /* synthetic */ ExtensionPointImpl $ep;
                final /* synthetic */ ProjectExImpl this$0;
                {
                    this.$ep = extensionPointImpl;
                    this.this$0 = projectExImpl;
                }

                public final void accept(T handler2, PluginDescriptor pluginDescriptor) {
                    PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                    Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor2, (String)"pluginDescriptor");
                    if (Intrinsics.areEqual((Object)pluginDescriptor2.getPluginId(), (Object)PluginManagerCore.CORE_ID) ^ true && Intrinsics.areEqual((Object)pluginDescriptor.getPluginId(), (Object)PluginManagerCore.JAVA_PLUGIN_ID) ^ true) {
                        PluginId pluginId = pluginDescriptor.getPluginId();
                        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginDescriptor.pluginId");
                        if (Intrinsics.areEqual((Object)pluginId.getIdString(), (Object)"com.intellij.kotlinNative.platformDeps") ^ true) {
                            boolean $i$f$logger = false;
                            Logger logger = Logger.getInstance(ProjectImpl.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                            logger.error((Throwable)new PluginException("Plugin " + pluginDescriptor + " is not approved to add " + this.$ep.getName(), pluginDescriptor.getPluginId()));
                        }
                    }
                    try {
                        T t = handler2;
                        Intrinsics.checkNotNullExpressionValue(t, (String)"handler");
                        ProjectServiceContainerInitializedListener it = (ProjectServiceContainerInitializedListener)t;
                        boolean bl = false;
                        it.serviceCreated(this.this$0);
                    }
                    catch (ProcessCanceledException e) {
                        throw (Throwable)e;
                    }
                    catch (PluginException e) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(ProjectImpl.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.error((Throwable)e);
                    }
                    catch (Throwable e) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(ProjectImpl.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.error((Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
                    }
                }
            });
            Activity activity3 = activity;
            if (activity3 == null) break block4;
            activity3.end();
        }
    }

    @TestOnly
    public final void setTemporarilyDisposed(boolean value2) {
        if (this.isTemporarilyDisposed == value2) {
            return;
        }
        if (value2 && super.isDisposed()) {
            throw (Throwable)new IllegalStateException("Project was already disposed, flag temporarilyDisposed cannot be set to `true`");
        }
        if (!value2) {
            Disposable disposable2 = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
            Disposable newDisposable = disposable2;
            if (!this.earlyDisposable.compareAndSet(null, newDisposable)) {
                throw (Throwable)new IllegalStateException("earlyDisposable must be null on second opening of light project");
            }
        }
        MessageBus messageBus = this.getMessageBus();
        if (messageBus == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.messages.impl.MessageBusEx");
        }
        ((MessageBusEx)messageBus).clearAllSubscriberCache();
        this.isTemporarilyDisposed = value2;
    }

    @Override
    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public final Disposable getEarlyDisposable() {
        if (this.isDisposed()) {
            throw (Throwable)new AlreadyDisposedException(this + " is disposed already");
        }
        Disposable disposable2 = this.earlyDisposable.get();
        if (disposable2 == null) {
            throw (Throwable)this.createEarlyDisposableError("earlyDisposable is null for");
        }
        return disposable2;
    }

    public final void disposeEarlyDisposable() {
        block6: {
            block5: {
                Logger logger = ProjectImpl.LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) break block5;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block6;
            }
            ProjectImpl.LOG.debug("dispose early disposable: " + this.toString());
        }
        Disposable disposable2 = this.earlyDisposable.getAndSet(null);
        if (disposable2 == null) {
            throw (Throwable)this.createEarlyDisposableError("earlyDisposable was already disposed");
        }
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"earlyDisposable.getAndSe\u2026le was already disposed\")");
        Disposable disposable3 = disposable2;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            this.putUserData(ProjectExImplKt.access$getDISPOSE_EARLY_DISPOSABLE_TRACE$p(), ExceptionUtil.currentStackTrace());
        }
        Disposer.dispose((Disposable)disposable3);
    }

    private final RuntimeException createEarlyDisposableError(String error2) {
        return new IllegalStateException(error2 + " for " + this.toString() + "\n---begin of dispose trace--" + (String)this.getUserData(ProjectExImplKt.access$getDISPOSE_EARLY_DISPOSABLE_TRACE$p()) + "}---end of dispose trace---\n");
    }

    @Override
    public final boolean isDisposed() {
        return super.isDisposed() || this.isTemporarilyDisposed;
    }

    @Override
    public final synchronized void dispose() {
        Application app = ApplicationManager.getApplication();
        app.assertWriteAccessAllowed();
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.project.impl.ProjectManagerImpl");
        }
        ProjectManagerImpl projectManager2 = (ProjectManagerImpl)projectManager;
        if (projectManager2.isProjectOpened(this)) {
            throw (Throwable)new IllegalStateException("Must call .dispose() for a closed project only. See ProjectManager.closeProject() or ProjectUtil.closeAndDispose().");
        }
        super.dispose();
        IProjectStore iProjectStore = (IProjectStore)this.componentStoreValue.getValueIfInitialized();
        if (iProjectStore != null) {
            iProjectStore.release();
        }
        Application application = app;
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (!application.isDisposed()) {
            ((ProjectLifecycleListener)app.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).afterProjectClosed((Project)this);
        }
        projectManager2.updateTheOnlyProjectField();
        TimedReference.disposeTimed();
        LaterInvocator.purgeExpiredItems();
    }

    @NotNull
    public final String toString() {
        Comparable comparable;
        String containerState;
        IProjectStore store = (IProjectStore)this.componentStoreValue.getValueIfInitialized();
        String string = containerState = this.isTemporarilyDisposed ? "disposed temporarily" : this.getContainerStateName();
        if (store == null) {
            comparable = (Comparable)((Object)"<not initialized>");
        } else if (store.getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
            comparable = (Comparable)((Object)((Object)store.getProjectBasePath()).toString());
        } else {
            Path path2 = store.getProjectFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"store.projectFilePath");
            comparable = path2;
        }
        Comparable componentStore = comparable;
        String disposedStr = this.isDisposed() ? " (disposed)" : "";
        return "Project(name=" + this.cachedName + ", containerState=" + containerState + ", componentStore=" + componentStore + ')' + disposedStr;
    }

    public ProjectExImpl(@NotNull Path filePath, @Nullable String projectName) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        }
        super((ComponentManagerImpl)application);
        this.earlyDisposable = new AtomicReference<Disposable>(Disposer.newDisposable());
        this.componentStoreValue = new SynchronizedClearableLazy((Function0)new Function0<IProjectStore>(this){
            final /* synthetic */ ProjectExImpl this$0;

            @NotNull
            public final IProjectStore invoke() {
                return ((ProjectStoreFactory)ApplicationManager.getApplication().getService(ProjectStoreFactory.class)).createStore(this.this$0);
            }
            {
                this.this$0 = projectExImpl;
                super(0);
            }
        });
        this.putUserData(ProjectImpl.CREATION_TIME, System.nanoTime());
        this.registerServiceInstance(Project.class, this, (PluginDescriptor)ComponentManagerImpl.fakeCorePluginDescriptor);
        this.cachedName = projectName;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        this.isLight = application2.isUnitTestMode() && StringsKt.contains$default((CharSequence)((Object)filePath).toString(), (CharSequence)"light_temp", (boolean)false, (int)2, null);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"RUN_START_UP_ACTIVITIES");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Boolean>(\"RUN_START_UP_ACTIVITIES\")");
        RUN_START_UP_ACTIVITIES = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R)\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/project/impl/ProjectExImpl$Companion;", "", "()V", "RUN_START_UP_ACTIVITIES", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getRUN_START_UP_ACTIVITIES", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Key<Boolean> getRUN_START_UP_ACTIVITIES() {
            return RUN_START_UP_ACTIVITIES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

