/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CoreProgressManager.class);
    static final int CHECK_CANCELED_DELAY_MILLIS = 10;
    private final AtomicInteger myUnsafeProgressCount = new AtomicInteger(0);
    public static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private static CheckCanceledHook ourCheckCanceledHook;
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator;
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators;
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators;
    static final Set<Thread> threadsUnderCanceledIndicator;
    @NotNull
    private static volatile CheckCanceledBehavior ourCheckCanceledBehavior;
    private static final Map<ProgressIndicator, AtomicInteger> nonStandardIndicators;
    private static final ThreadLocal<Boolean> isInNonCancelableSection;
    private static final long MAX_PRIORITIZATION_NANOS;
    private static final Thread[] EMPTY_THREAD_ARRAY;
    private final Set<Thread> myPrioritizedThreads = ContainerUtil.newConcurrentSet();
    private volatile Thread[] myEffectivePrioritizedThreads = EMPTY_THREAD_ARRAY;
    private int myDeprioritizations;
    private final Object myPrioritizationLock = ObjectUtils.sentinel((String)"myPrioritizationLock");
    private volatile long myPrioritizingStarted;

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            return;
        }
        this.myCheckCancelledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            for (ProgressIndicator indicator2 : nonStandardIndicators.keySet()) {
                try {
                    indicator2.checkCanceled();
                }
                catch (ProcessCanceledException e) {
                    this.indicatorCanceled(indicator2);
                }
            }
        }, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    @ApiStatus.Internal
    public static List<ProgressIndicator> getCurrentIndicators() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        // MONITORENTER : map2
        ArrayList<ProgressIndicator> arrayList = new ArrayList<ProgressIndicator>(threadsUnderIndicator.keySet());
        // MONITOREXIT : map2
        if (arrayList != null) return arrayList;
        CoreProgressManager.$$$reportNull$$$0(0);
        return arrayList;
    }

    @ApiStatus.Internal
    public static boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator2) {
        CheckCanceledHook hook2 = ourCheckCanceledHook;
        return hook2 != null && hook2.runHook(indicator2);
    }

    protected void doCheckCanceled() throws ProcessCanceledException {
        CheckCanceledBehavior behavior = ourCheckCanceledBehavior;
        if (behavior == CheckCanceledBehavior.NONE) {
            return;
        }
        if (behavior == CheckCanceledBehavior.INDICATOR_PLUS_HOOKS) {
            ProgressIndicator progress2 = this.getProgressIndicator();
            if (progress2 != null) {
                progress2.checkCanceled();
            }
        } else {
            CoreProgressManager.runCheckCanceledHooks(null);
        }
    }

    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    public boolean hasUnsafeProgressIndicator() {
        return this.myUnsafeProgressCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasModalProgressIndicator() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return ContainerUtil.or(threadsUnderIndicator.keySet(), i2 -> i2.isModal());
        }
    }

    public void runProcess(@NotNull Runnable process2, @Nullable ProgressIndicator progress2) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(1);
        }
        if (progress2 != null) {
            CoreProgressManager.assertNoOtherThreadUnder(progress2);
        }
        this.executeProcessUnderProgress(() -> {
            try {
                try {
                    if (progress2 != null && !progress2.isRunning()) {
                        progress2.start();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                process2.run();
            }
            finally {
                if (progress2 != null && progress2.isRunning()) {
                    progress2.stop();
                    if (progress2 instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)progress2).processFinish();
                    }
                }
            }
        }, progress2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertNoOtherThreadUnder(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            CoreProgressManager.$$$reportNull$$$0(2);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Thread other;
            Collection threads = threadsUnderIndicator.get(progress2);
            Thread thread = other = threads == null || threads.isEmpty() ? null : (Thread)threads.iterator().next();
            if (other != null) {
                if (other == Thread.currentThread()) {
                    LOG.error("This thread is already running under this indicator, starting/stopping it here might be a data race");
                } else {
                    StringWriter dump = new StringWriter();
                    ThreadDumper.dumpCallStack((Thread)other, (Writer)dump, (StackTraceElement[])other.getStackTrace());
                    LOG.error("Other thread is already running under this indicator, starting/stopping it here might be a data race. Its thread dump:\n" + dump);
                }
            }
        }
    }

    public void executeNonCancelableSection(@NotNull Runnable runnable2) {
        block7: {
            if (runnable2 == null) {
                CoreProgressManager.$$$reportNull$$$0(3);
            }
            try {
                if (this.isInNonCancelableSection()) {
                    runnable2.run();
                    break block7;
                }
                try {
                    isInNonCancelableSection.set(Boolean.TRUE);
                    this.executeProcessUnderProgress(runnable2, (ProgressIndicator)NonCancelableIndicator.INSTANCE);
                }
                finally {
                    isInNonCancelableSection.remove();
                }
            }
            catch (ProcessCanceledException e) {
                LOG.error("PCE is not expected in non-cancellable section execution", (Throwable)new Exception(e));
            }
        }
    }

    public <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(4);
        }
        Ref result2 = new Ref();
        Ref exception = new Ref();
        this.executeNonCancelableSection(() -> {
            try {
                result2.set(computable.compute());
            }
            catch (Exception t) {
                exception.set((Object)t);
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked((Throwable)t);
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result2.get();
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull @NlsContexts.ProgressTitle String progressTitle2, boolean canBeCanceled, @Nullable Project project) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(5);
        }
        if (progressTitle2 == null) {
            CoreProgressManager.$$$reportNull$$$0(6);
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle2, canBeCanceled, project, null);
    }

    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process2, @NotNull String progressTitle2, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(7);
        }
        if (progressTitle2 == null) {
            CoreProgressManager.$$$reportNull$$$0(8);
        }
        final AtomicReference result2 = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously((Task)new Task.Modal(project, progressTitle2, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    Object compute2 = process2.compute();
                    result2.set(compute2);
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$1", "run"));
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked((Throwable)t);
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result2.get();
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process2, @NotNull @NlsContexts.DialogTitle String progressTitle2, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(9);
        }
        if (progressTitle2 == null) {
            CoreProgressManager.$$$reportNull$$$0(10);
        }
        Task.Modal task2 = new Task.Modal(project, parentComponent, progressTitle2, canBeCanceled){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$2", "run"));
            }
        };
        return this.runProcessWithProgressSynchronously((Task)task2);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @NlsContexts.ProgressTitle String progressTitle2, @NotNull Runnable process2, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(11);
        }
        if (progressTitle2 == null) {
            CoreProgressManager.$$$reportNull$$$0(12);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(13);
        }
        this.runProcessWithProgressAsynchronously(project, progressTitle2, process2, successRunnable, canceledRunnable, PerformInBackgroundOption.DEAF);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @NlsContexts.ProgressTitle String progressTitle2, final @NotNull Runnable process2, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option2) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(14);
        }
        if (progressTitle2 == null) {
            CoreProgressManager.$$$reportNull$$$0(15);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(16);
        }
        if (option2 == null) {
            CoreProgressManager.$$$reportNull$$$0(17);
        }
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle2, true, option2){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$3", "run"));
            }
        });
    }

    @ApiStatus.Internal
    public static boolean shouldKeepTasksAsynchronousInHeadlessMode() {
        return SystemProperties.getBooleanProperty((String)"intellij.progress.task.ignoreHeadless", (boolean)false);
    }

    public void run(@NotNull Task task2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(18);
        }
        if (task2.isHeadless() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.runProcessWithProgressSynchronously(task2);
            } else {
                this.runProcessWithProgressInCurrentThread(task2, (ProgressIndicator)new EmptyProgressIndicator(), ModalityState.defaultModalityState());
            }
        } else if (task2.isModal()) {
            this.runProcessWithProgressSynchronously((Task)task2.asModal());
        } else {
            Task.Backgroundable backgroundable = task2.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runProcessWithProgressSynchronously((Task)backgroundable);
            } else {
                this.runAsynchronously(backgroundable);
            }
        }
    }

    private void runAsynchronously(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(19);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressAsynchronously(task2);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = task2.getProject();
                if (project != null && project.isDisposed()) {
                    LOG.info("Task canceled because of project disposal: " + task2);
                    this.finishTask((Task)task2, true, null);
                    return;
                }
                this.runProcessWithProgressAsynchronously(task2);
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(20);
        }
        Future<?> future2 = this.runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new EmptyProgressIndicator(), null);
        if (future2 == null) {
            CoreProgressManager.$$$reportNull$$$0(21);
        }
        return future2;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(22);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(23);
        }
        Future<?> future2 = this.runProcessWithProgressAsynchronously(task2, progressIndicator, continuation, progressIndicator.getModalityState());
        if (future2 == null) {
            CoreProgressManager.$$$reportNull$$$0(24);
        }
        return future2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void startTask(@NotNull Task task2, @NotNull ProgressIndicator indicator2, @Nullable Runnable continuation) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(25);
        }
        if (indicator2 == null) {
            CoreProgressManager.$$$reportNull$$$0(26);
        }
        try {
            task2.run(indicator2);
        }
        finally {
            try {
                if (indicator2 instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)indicator2).finish((TaskInfo)task2);
                }
            }
            finally {
                if (continuation != null) {
                    continuation.run();
                }
            }
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, @NotNull ModalityState modalityState) {
        IndicatorDisposable indicatorDisposable;
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(27);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(28);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(29);
        }
        if (progressIndicator instanceof Disposable) {
            indicatorDisposable = new IndicatorDisposable(progressIndicator);
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)indicatorDisposable);
        } else {
            indicatorDisposable = null;
        }
        Future<?> future2 = this.runProcessWithProgressAsync(task2, CompletableFuture.completedFuture(progressIndicator), continuation, indicatorDisposable, modalityState);
        if (future2 == null) {
            CoreProgressManager.$$$reportNull$$$0(30);
        }
        return future2;
    }

    @NotNull
    protected Future<?> runProcessWithProgressAsync(@NotNull Task.Backgroundable task2, @NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressIndicator, @Nullable Runnable continuation, @Nullable IndicatorDisposable indicatorDisposable, @Nullable ModalityState modalityState) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(31);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(32);
        }
        AtomicLong elapsed = new AtomicLong();
        CompletionStage completionStage = new ProgressRunner<Object>(progress2 -> {
            long start2 = System.currentTimeMillis();
            try {
                this.startTask((Task)task2, (ProgressIndicator)progress2, continuation);
            }
            finally {
                elapsed.set(System.currentTimeMillis() - start2);
            }
            return null;
        }).onThread(ProgressRunner.ThreadToUse.POOLED).withProgress(progressIndicator).submit().whenComplete(ClientId.decorateBiConsumer((result2, err) -> {
            ModalityState modality;
            if (!result2.isCanceled()) {
                this.notifyTaskFinished(task2, elapsed.get());
            }
            if (modalityState != null) {
                modality = modalityState;
            } else {
                try {
                    modality = ((ProgressIndicator)progressIndicator.get()).getModalityState();
                }
                catch (Throwable e) {
                    modality = ModalityState.NON_MODAL;
                }
            }
            ApplicationUtil.invokeLaterSomewhere(task2.whereToRunCallbacks(), modality, () -> {
                this.finishTask((Task)task2, result2.isCanceled(), result2.getThrowable() instanceof ProcessCanceledException ? null : result2.getThrowable());
                if (indicatorDisposable != null) {
                    Disposer.dispose((Disposable)indicatorDisposable);
                }
            });
        }));
        if (completionStage == null) {
            CoreProgressManager.$$$reportNull$$$0(33);
        }
        return completionStage;
    }

    void notifyTaskFinished(@NotNull Task.Backgroundable task2, long elapsed) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(34);
        }
    }

    protected boolean runProcessWithProgressSynchronously(@NotNull Task task2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(35);
        }
        Ref exceptionRef = new Ref();
        Runnable taskContainer = () -> {
            try {
                this.startTask(task2, this.getProgressIndicator(), null);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                exceptionRef.set((Object)e);
            }
        };
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        boolean result2 = application.runProcessWithProgressSynchronously(taskContainer, task2.getTitle(), task2.isCancellable(), task2.isModal(), task2.getProject(), task2.getParentComponent(), task2.getCancelText());
        ApplicationUtil.invokeAndWaitSomewhere(task2.whereToRunCallbacks(), application.getDefaultModalityState(), () -> this.finishTask(task2, !result2, (Throwable)exceptionRef.get()));
        return result2;
    }

    public void runProcessWithProgressInCurrentThread(@NotNull Task task2, @NotNull ProgressIndicator progressIndicator, @NotNull ModalityState modalityState) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(36);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(37);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(38);
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        boolean processCanceled = false;
        Throwable exception = null;
        try {
            this.runProcess(() -> this.startTask(task2, progressIndicator, null), progressIndicator);
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Throwable e) {
            exception = e;
        }
        boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
        Throwable finalException = exception;
        ApplicationUtil.invokeAndWaitSomewhere(task2.whereToRunCallbacks(), modalityState, () -> this.finishTask(task2, finalCanceled, finalException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishTask(@NotNull Task task2, boolean canceled, @Nullable Throwable error2) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(39);
        }
        try {
            if (error2 != null) {
                task2.onThrowable(error2);
            } else if (canceled) {
                task2.onCancel();
            } else {
                task2.onSuccess();
            }
        }
        finally {
            task2.onFinished();
        }
    }

    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2, @NotNull ProgressIndicator progressIndicator) {
        if (task2 == null) {
            CoreProgressManager.$$$reportNull$$$0(40);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(41);
        }
        this.runProcessWithProgressAsynchronously(task2, progressIndicator, null);
    }

    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress2) throws ProcessCanceledException {
        block10: {
            if (process2 == null) {
                CoreProgressManager.$$$reportNull$$$0(42);
            }
            if (progress2 == null) {
                this.myUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set2;
                ProgressIndicator oldIndicator = null;
                boolean bl = set2 = progress2 != null && progress2 != (oldIndicator = this.getProgressIndicator());
                if (set2) {
                    Thread currentThread = Thread.currentThread();
                    long threadId = currentThread.getId();
                    CoreProgressManager.setCurrentIndicator(threadId, progress2);
                    try {
                        this.registerIndicatorAndRun(progress2, currentThread, oldIndicator, process2);
                        break block10;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(threadId, oldIndicator);
                    }
                }
                process2.run();
            }
            finally {
                if (progress2 == null) {
                    this.myUnsafeProgressCount.decrementAndGet();
                }
            }
        }
    }

    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator indicator2) {
        if (action2 == null) {
            CoreProgressManager.$$$reportNull$$$0(43);
        }
        ApplicationManager.getApplication().runReadAction(action2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndicatorAndRun(@NotNull ProgressIndicator indicator2, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process2) {
        boolean isStandard;
        Set underIndicator;
        if (indicator2 == null) {
            CoreProgressManager.$$$reportNull$$$0(44);
        }
        if (currentThread == null) {
            CoreProgressManager.$$$reportNull$$$0(45);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(46);
        }
        ArrayList<Set> threadsUnderThisIndicator = new ArrayList<Set>();
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            boolean oneOfTheIndicatorsIsCanceled = false;
            ProgressIndicator thisIndicator = indicator2;
            while (thisIndicator != null) {
                underIndicator = threadsUnderIndicator.computeIfAbsent(thisIndicator, __ -> new HashSet());
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.compute(thisIndicator, (__, count) -> {
                        if (count == null) {
                            return new AtomicInteger(1);
                        }
                        count.incrementAndGet();
                        return count;
                    });
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                oneOfTheIndicatorsIsCanceled |= thisIndicator.isCanceled();
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oneOfTheIndicatorsIsCanceled);
        }
        try {
            process2.run();
            map2 = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
            synchronized (map3) {
                ProgressIndicator thisIndicator = null;
                for (int i2 = 0; i2 < threadsUnderThisIndicator.size(); ++i2) {
                    AtomicInteger newCount;
                    boolean isStandard2;
                    boolean removed;
                    thisIndicator = i2 == 0 ? indicator2 : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                    Set underIndicator2 = (Set)threadsUnderThisIndicator.get(i2);
                    boolean bl = removed = underIndicator2 != null && underIndicator2.remove(currentThread);
                    if (removed && underIndicator2.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator);
                    }
                    if ((isStandard2 = thisIndicator instanceof StandardProgressIndicator) || (newCount = nonStandardIndicators.compute(thisIndicator, (__, count) -> {
                        if (count.decrementAndGet() == 0) {
                            return null;
                        }
                        return count;
                    })) != null) continue;
                    this.stopBackgroundNonStandardIndicatorsPing();
                }
                this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
            }
            throw throwable;
        }
        synchronized (map2) {
            ProgressIndicator thisIndicator = null;
            for (int i3 = 0; i3 < threadsUnderThisIndicator.size(); ++i3) {
                AtomicInteger newCount;
                boolean removed;
                thisIndicator = i3 == 0 ? indicator2 : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                underIndicator = (Set)threadsUnderThisIndicator.get(i3);
                boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if ((isStandard = thisIndicator instanceof StandardProgressIndicator) || (newCount = nonStandardIndicators.compute(thisIndicator, (__, count) -> {
                    if (count.decrementAndGet() == 0) {
                        return null;
                    }
                    return count;
                })) != null) continue;
                this.stopBackgroundNonStandardIndicatorsPing();
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
        }
    }

    private void updateThreadUnderCanceledIndicator(@NotNull Thread thread, boolean underCanceledIndicator) {
        boolean changed2;
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(47);
        }
        boolean bl = changed2 = underCanceledIndicator ? threadsUnderCanceledIndicator.add(thread) : threadsUnderCanceledIndicator.remove(thread);
        if (changed2) {
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateShouldCheckCanceled() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            CheckCanceledHook hook2 = this.createCheckCanceledHook();
            boolean hasCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
            ourCheckCanceledHook = hook2;
            ourCheckCanceledBehavior = hook2 == null && !hasCanceledIndicator ? CheckCanceledBehavior.NONE : (hasCanceledIndicator && ENABLED ? CheckCanceledBehavior.INDICATOR_PLUS_HOOKS : CheckCanceledBehavior.ONLY_HOOKS);
        }
    }

    @Nullable
    protected CheckCanceledHook createCheckCanceledHook() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            CoreProgressManager.$$$reportNull$$$0(48);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator2);
            if (threads != null) {
                for (Thread thread : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator2) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread);
                    this.updateShouldCheckCanceled();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static boolean isCanceledThread(@NotNull Thread thread) {
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(49);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return threadsUnderCanceledIndicator.contains(thread);
        }
    }

    public boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T computePrioritized(@NotNull ThrowableComputable<T, E> computable) throws E {
        boolean prioritize;
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(50);
        }
        Thread thread = Thread.currentThread();
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (this.isCurrentThreadPrioritized()) {
                prioritize = false;
            } else {
                prioritize = true;
                if (this.myPrioritizedThreads.isEmpty()) {
                    this.myPrioritizingStarted = System.nanoTime();
                }
                this.myPrioritizedThreads.add(thread);
                this.updateEffectivePrioritized();
            }
        }
        try {
            object = computable.compute();
            return (T)object;
        }
        finally {
            if (prioritize) {
                Object object2 = this.myPrioritizationLock;
                synchronized (object2) {
                    this.myPrioritizedThreads.remove(thread);
                    this.updateEffectivePrioritized();
                }
            }
        }
    }

    private void updateEffectivePrioritized() {
        Thread[] prev2 = this.myEffectivePrioritizedThreads;
        Thread[] current2 = this.myDeprioritizations > 0 || this.myPrioritizedThreads.isEmpty() ? EMPTY_THREAD_ARRAY : this.myPrioritizedThreads.toArray(EMPTY_THREAD_ARRAY);
        this.myEffectivePrioritizedThreads = current2;
        if (prev2.length == 0 && current2.length > 0) {
            this.prioritizingStarted();
        } else if (prev2.length > 0 && current2.length == 0) {
            this.prioritizingFinished();
        }
    }

    protected void prioritizingStarted() {
    }

    protected void prioritizingFinished() {
    }

    @ApiStatus.Internal
    public boolean isCurrentThreadPrioritized() {
        return this.myPrioritizedThreads.contains(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void suppressPrioritizing() {
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (++this.myDeprioritizations == 100 + ForkJoinPool.getCommonPoolParallelism() * 2) {
                Attachment attachment = new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString());
                attachment.setIncluded(true);
                LOG.error("A suspiciously high nesting of suppressPrioritizing, forgot to call restorePrioritizing?", new Attachment[]{attachment});
            }
            this.updateEffectivePrioritized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void restorePrioritizing() {
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (--this.myDeprioritizations < 0) {
                this.myDeprioritizations = 0;
                LOG.error("Unmatched suppressPrioritizing/restorePrioritizing");
            }
            this.updateEffectivePrioritized();
        }
    }

    protected boolean sleepIfNeededToGivePriorityToAnotherThread() {
        if (!this.isCurrentThreadEffectivelyPrioritized() && this.checkLowPriorityReallyApplicable()) {
            LockSupport.parkNanos(1000000L);
            this.avoidBlockingPrioritizingThread();
            return true;
        }
        return false;
    }

    private boolean isCurrentThreadEffectivelyPrioritized() {
        Thread current2 = Thread.currentThread();
        for (Thread prioritized : this.myEffectivePrioritizedThreads) {
            if (prioritized != current2) continue;
            return true;
        }
        return false;
    }

    private boolean checkLowPriorityReallyApplicable() {
        long time = System.nanoTime() - this.myPrioritizingStarted;
        if (time < 5000000L) {
            return false;
        }
        if (this.avoidBlockingPrioritizingThread()) {
            return false;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        if (time > MAX_PRIORITIZATION_NANOS) {
            this.stopAllPrioritization();
            return false;
        }
        return true;
    }

    private boolean avoidBlockingPrioritizingThread() {
        if (this.isAnyPrioritizedThreadBlocked()) {
            this.suppressPrioritizing();
            this.checkLaterThreadsAreUnblocked();
            return true;
        }
        return false;
    }

    private void checkLaterThreadsAreUnblocked() {
        try {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (this.isAnyPrioritizedThreadBlocked()) {
                    this.checkLaterThreadsAreUnblocked();
                } else {
                    this.restorePrioritizing();
                }
            }, 5L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllPrioritization() {
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            this.myPrioritizedThreads.clear();
            this.updateEffectivePrioritized();
        }
    }

    private boolean isAnyPrioritizedThreadBlocked() {
        for (Thread thread : this.myEffectivePrioritizedThreads) {
            Thread.State state = thread.getState();
            if (state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING && state != Thread.State.BLOCKED) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static ModalityState getCurrentThreadProgressModality() {
        ProgressIndicator indicator2 = (ProgressIndicator)threadTopLevelIndicators.get(Thread.currentThread().getId());
        ModalityState modality = indicator2 == null ? null : indicator2.getModalityState();
        ModalityState modalityState = modality != null ? modality : ModalityState.NON_MODAL;
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(51);
        }
        return modalityState;
    }

    private static void setCurrentIndicator(long threadId, ProgressIndicator indicator2) {
        if (indicator2 == null) {
            currentIndicators.remove(threadId);
            threadTopLevelIndicators.remove(threadId);
        } else {
            currentIndicators.put(threadId, (Object)indicator2);
            threadTopLevelIndicators.putIfAbsent(threadId, (Object)indicator2);
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread) {
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(52);
        }
        return (ProgressIndicator)currentIndicators.get(thread.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertUnderProgress(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            CoreProgressManager.$$$reportNull$$$0(53);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator2);
            if (threads == null || !threads.contains(Thread.currentThread())) {
                LOG.error("Must be executed under progress indicator: " + indicator2 + ". Please see e.g. ProgressManager.runProcess()");
            }
        }
    }

    static {
        threadsUnderIndicator = new HashMap<ProgressIndicator, Set<Thread>>();
        currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadTopLevelIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadsUnderCanceledIndicator = new HashSet<Thread>();
        ourCheckCanceledBehavior = CheckCanceledBehavior.NONE;
        nonStandardIndicators = new ConcurrentHashMap<ProgressIndicator, AtomicInteger>();
        isInNonCancelableSection = new ThreadLocal();
        MAX_PRIORITIZATION_NANOS = TimeUnit.SECONDS.toNanos(12L);
        EMPTY_THREAD_ARRAY = new Thread[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 23: 
            case 28: 
            case 32: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 26: 
            case 44: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentThread";
                break;
            }
            case 47: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentIndicators";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 21: 
            case 24: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsync";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentThreadProgressModality";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertNoOtherThreadUnder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeNonCancelableSection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runAsynchronously";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "startTask";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsync";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressInCurrentThread";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "finishTask";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicatorAndRun";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadUnderCanceledIndicator";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCanceled";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isCanceledThread";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "computePrioritized";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentIndicator";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "assertUnderProgress";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface CheckCanceledHook {
        public boolean runHook(@Nullable ProgressIndicator var1);
    }

    private static class IndicatorDisposable
    implements Disposable {
        @NotNull
        private final ProgressIndicator myIndicator;

        IndicatorDisposable(@NotNull ProgressIndicator indicator2) {
            if (indicator2 == null) {
                IndicatorDisposable.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator2;
        }

        public void dispose() {
            Disposer.dispose((Disposable)((Disposable)this.myIndicator), (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$IndicatorDisposable", "<init>"));
        }
    }

    private static enum CheckCanceledBehavior {
        NONE,
        ONLY_HOOKS,
        INDICATOR_PLUS_HOOKS;

    }
}

