/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.newEditor.CopySettingsPathAction;
import com.intellij.openapi.options.newEditor.SimpleBanner;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Banner
extends SimpleBanner {
    private final JLabel myProjectIcon = new JLabel();
    private final Breadcrumbs myBreadcrumbs = new Breadcrumbs(){

        protected int getFontStyle(Crumb crumb) {
            return 1;
        }
    };

    Banner(Action action2) {
        this.myProjectIcon.setMinimumSize(new Dimension(0, 0));
        this.myProjectIcon.setIcon(AllIcons.General.ProjectConfigurable);
        this.myProjectIcon.setForeground(UIUtil.getContextHelpForeground());
        this.showProject(false);
        this.myLeftPanel.removeAll();
        this.myLeftPanel.add((Component)this.myBreadcrumbs);
        this.myLeftPanel.add(this.myProjectIcon);
        this.myLeftPanel.add(this.myProgress);
        this.add("East", RelativeFont.BOLD.install((Component)new ActionLink(action2)));
    }

    void setText(@NotNull Collection<@NlsContexts.ConfigurableName String> names2) {
        if (names2 == null) {
            Banner.$$$reportNull$$$0(0);
        }
        ArrayList<Crumb.Impl> crumbs = new ArrayList<Crumb.Impl>();
        if (!names2.isEmpty()) {
            List<Action> actions2 = CopySettingsPathAction.createSwingActions(() -> names2);
            for (String name : names2) {
                crumbs.add(new Crumb.Impl(null, name, null, actions2));
            }
        }
        this.myBreadcrumbs.setCrumbs(crumbs);
    }

    void setProjectText(@Nullable @Nls String projectText) {
        boolean visible = projectText != null;
        this.showProject(visible);
        if (visible) {
            this.myProjectIcon.setToolTipText(projectText);
        }
    }

    void showProject(boolean hasProject) {
        this.myProjectIcon.setVisible(hasProject);
    }

    @Override
    void setLeftComponent(Component component2) {
        super.setLeftComponent(component2);
        this.myBreadcrumbs.setVisible(component2 == null);
    }

    @Override
    Component getBaselineTemplate() {
        return this.myBreadcrumbs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/openapi/options/newEditor/Banner", "setText"));
    }
}

