/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFocusManager;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public final class ModifierKeyDoubleClickHandler {
    private static final Logger LOG = Logger.getInstance(ModifierKeyDoubleClickHandler.class);
    private static final Int2IntMap KEY_CODE_TO_MODIFIER_MAP = new Int2IntOpenHashMap();
    private final ConcurrentMap<String, MyDispatcher> myDispatchers = new ConcurrentHashMap<String, MyDispatcher>();
    private boolean myIsRunningAction;

    public ModifierKeyDoubleClickHandler() {
        int modifierKeyCode = ModifierKeyDoubleClickHandler.getMultiCaretActionModifier();
        this.registerAction("EditorCloneCaretAbove", modifierKeyCode, 38);
        this.registerAction("EditorCloneCaretBelow", modifierKeyCode, 40);
        this.registerAction("EditorLeftWithSelection", modifierKeyCode, 37);
        this.registerAction("EditorRightWithSelection", modifierKeyCode, 39);
        this.registerAction("EditorLineStartWithSelection", modifierKeyCode, 36);
        this.registerAction("EditorLineEndWithSelection", modifierKeyCode, 35);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ModifierKeyDoubleClickHandler.this.myIsRunningAction) {
                    return;
                }
                for (MyDispatcher dispatcher : ModifierKeyDoubleClickHandler.this.myDispatchers.values()) {
                    dispatcher.resetState();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/keymap/impl/ModifierKeyDoubleClickHandler$1";
                objectArray[2] = "beforeActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        IdeEventQueue.getInstance().addDispatcher(event -> {
            if (!(event instanceof KeyEvent)) {
                return false;
            }
            boolean result2 = false;
            KeyEvent keyEvent = (KeyEvent)event;
            for (MyDispatcher dispatcher : this.myDispatchers.values()) {
                if (!dispatcher.dispatch(keyEvent)) continue;
                result2 = true;
            }
            return result2;
        }, (Disposable)ApplicationManager.getApplication());
    }

    public static ModifierKeyDoubleClickHandler getInstance() {
        return (ModifierKeyDoubleClickHandler)ApplicationManager.getApplication().getService(ModifierKeyDoubleClickHandler.class);
    }

    public static int getMultiCaretActionModifier() {
        return SystemInfoRt.isMac ? 18 : 17;
    }

    public void registerAction(@NotNull String actionId, int modifierKeyCode, int actionKeyCode, boolean skipIfActionHasShortcut) {
        if (actionId == null) {
            ModifierKeyDoubleClickHandler.$$$reportNull$$$0(0);
        }
        this.myDispatchers.put(actionId, new MyDispatcher(actionId, modifierKeyCode, actionKeyCode, skipIfActionHasShortcut));
    }

    public void registerAction(@NotNull String actionId, int modifierKeyCode, int actionKeyCode) {
        if (actionId == null) {
            ModifierKeyDoubleClickHandler.$$$reportNull$$$0(1);
        }
        this.registerAction(actionId, modifierKeyCode, actionKeyCode, true);
    }

    public void unregisterAction(@NotNull String actionId) {
        if (actionId == null) {
            ModifierKeyDoubleClickHandler.$$$reportNull$$$0(2);
        }
        this.myDispatchers.remove(actionId);
    }

    public boolean isRunningAction() {
        return this.myIsRunningAction;
    }

    static {
        KEY_CODE_TO_MODIFIER_MAP.put(18, 8);
        KEY_CODE_TO_MODIFIER_MAP.put(17, 2);
        KEY_CODE_TO_MODIFIER_MAP.put(157, 4);
        KEY_CODE_TO_MODIFIER_MAP.put(16, 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "actionId";
        objectArray2[1] = "com/intellij/openapi/keymap/impl/ModifierKeyDoubleClickHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyDispatcher {
        private final String myActionId;
        private final int myModifierKeyCode;
        private final int myActionKeyCode;
        private final boolean mySkipIfActionHasShortcut;
        private final Couple<AtomicBoolean> ourPressed;
        private final Couple<AtomicBoolean> ourReleased;
        private final AtomicBoolean ourOtherKeyWasPressed;
        private final AtomicLong ourLastTimePressed;

        MyDispatcher(String actionId, int modifierKeyCode, int actionKeyCode, boolean skipIfActionHasShortcut) {
            if (actionId == null) {
                MyDispatcher.$$$reportNull$$$0(0);
            }
            this.ourPressed = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
            this.ourReleased = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
            this.ourOtherKeyWasPressed = new AtomicBoolean(false);
            this.ourLastTimePressed = new AtomicLong(0L);
            this.myActionId = actionId;
            this.myModifierKeyCode = modifierKeyCode;
            this.myActionKeyCode = actionKeyCode;
            this.mySkipIfActionHasShortcut = skipIfActionHasShortcut;
        }

        public boolean dispatch(@NotNull KeyEvent event) {
            if (event == null) {
                MyDispatcher.$$$reportNull$$$0(1);
            }
            int keyCode = event.getKeyCode();
            LOG.debug("", new Object[]{this, event});
            if (keyCode == this.myModifierKeyCode) {
                if (this.hasOtherModifiers(event)) {
                    this.resetState();
                    return false;
                }
                if (this.myActionKeyCode == -1 && this.ourOtherKeyWasPressed.get() && event.getWhen() - this.ourLastTimePressed.get() < 100L) {
                    this.resetState();
                    return false;
                }
                this.ourOtherKeyWasPressed.set(false);
                if (((AtomicBoolean)this.ourPressed.first).get() && event.getWhen() - this.ourLastTimePressed.get() > 500L) {
                    this.resetState();
                }
                this.handleModifier(event);
                return false;
            }
            if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get() && this.myActionKeyCode != -1) {
                if (keyCode == this.myActionKeyCode && !this.hasOtherModifiers(event)) {
                    if (event.getID() == 401) {
                        return this.run(event);
                    }
                    return true;
                }
                return false;
            }
            this.ourLastTimePressed.set(event.getWhen());
            this.ourOtherKeyWasPressed.set(true);
            if (keyCode == 27 || keyCode == 9) {
                this.ourLastTimePressed.set(0L);
            }
            this.resetState();
            return false;
        }

        private boolean hasOtherModifiers(KeyEvent keyEvent) {
            int modifiers = keyEvent.getModifiers();
            for (Int2IntMap.Entry entry2 : KEY_CODE_TO_MODIFIER_MAP.int2IntEntrySet()) {
                if (entry2.getIntKey() == this.myModifierKeyCode || (modifiers & entry2.getIntValue()) == 0) continue;
                return true;
            }
            return false;
        }

        private void handleModifier(KeyEvent event) {
            if (((AtomicBoolean)this.ourPressed.first).get() && event.getWhen() - this.ourLastTimePressed.get() > 300L) {
                this.resetState();
                return;
            }
            if (event.getID() == 401) {
                if (!((AtomicBoolean)this.ourPressed.first).get()) {
                    this.resetState();
                    ((AtomicBoolean)this.ourPressed.first).set(true);
                    this.ourLastTimePressed.set(event.getWhen());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourPressed.second).set(true);
                    this.ourLastTimePressed.set(event.getWhen());
                    return;
                }
            } else if (event.getID() == 402) {
                if (((AtomicBoolean)this.ourPressed.first).get() && !((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourReleased.first).set(true);
                    this.ourLastTimePressed.set(event.getWhen());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get()) {
                    this.resetState();
                    if (this.myActionKeyCode == -1 && !this.shouldSkipIfActionHasShortcut()) {
                        this.run(event);
                    }
                    return;
                }
            }
            this.resetState();
        }

        private void resetState() {
            ((AtomicBoolean)this.ourPressed.first).set(false);
            ((AtomicBoolean)this.ourPressed.second).set(false);
            ((AtomicBoolean)this.ourReleased.first).set(false);
            ((AtomicBoolean)this.ourReleased.second).set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean run(KeyEvent event) {
            ModifierKeyDoubleClickHandler.this.myIsRunningAction = true;
            try {
                Window focusedWindow;
                ActionManagerEx ex = ActionManagerEx.getInstanceEx();
                AnAction action2 = ex.getAction(this.myActionId);
                if (action2 == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!action2.isEnabledInModalContext() && (focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) != null && IdeKeyEventDispatcher.isModalContext(focusedWindow)) {
                    boolean bl = false;
                    return bl;
                }
                DataContext context2 = this.calculateContext();
                AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)event, (String)"keyboard shortcut", (DataContext)context2);
                if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)actionEvent, (boolean)false)) {
                    boolean bl = false;
                    return bl;
                }
                ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)actionEvent);
                boolean bl = true;
                return bl;
            }
            finally {
                ModifierKeyDoubleClickHandler.this.myIsRunningAction = false;
            }
        }

        @NotNull
        private DataContext calculateContext() {
            IdeFocusManager focusManager = IdeFocusManager.findInstance();
            Component focusedComponent = focusManager.getFocusOwner();
            Window ideWindow = focusManager.getLastFocusedIdeWindow();
            DataContext dataContext = ideWindow == focusedComponent || focusedComponent == focusManager.getLastFocusedFor(ideWindow) ? DataManager.getInstance().getDataContext(focusedComponent) : DataManager.getInstance().getDataContext();
            if (dataContext == null) {
                MyDispatcher.$$$reportNull$$$0(2);
            }
            return dataContext;
        }

        private boolean shouldSkipIfActionHasShortcut() {
            return this.mySkipIfActionHasShortcut && KeymapUtil.getActiveKeymapShortcuts((String)this.myActionId).getShortcuts().length > 0;
        }

        public String toString() {
            return "modifier double-click dispatcher [modifierKeyCode=" + this.myModifierKeyCode + ",actionKeyCode=" + this.myActionKeyCode + ",actionId=" + this.myActionId + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/ModifierKeyDoubleClickHandler$MyDispatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/ModifierKeyDoubleClickHandler$MyDispatcher";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "dispatch";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

