/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.KeyboardAwareFocusOwner;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.EdtDataContext;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.keymap.impl.KeyProcessorContext;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.keymap.impl.SystemShortcuts;
import com.intellij.openapi.keymap.impl.keyGestures.KeyboardGestureProcessor;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.KeyboardLayoutUtil;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeKeyEventDispatcher {
    private static final Logger LOG = Logger.getInstance(IdeKeyEventDispatcher.class);
    private KeyStroke myFirstKeyStroke;
    private boolean myPressedWasProcessed;
    private boolean myIgnoreNextKeyTypedEvent;
    private KeyState myState = KeyState.STATE_INIT;
    private final PresentationFactory myPresentationFactory = new PresentationFactory();
    private boolean myLeftCtrlPressed;
    private boolean myRightAltPressed;
    private final KeyboardGestureProcessor myKeyGestureProcessor = new KeyboardGestureProcessor(this);
    private final KeyProcessorContext myContext = new KeyProcessorContext();
    private final IdeEventQueue myQueue;
    private final Alarm mySecondStrokeTimeout = new Alarm();
    private final Runnable mySecondStrokeTimeoutRunnable = () -> {
        if (this.myState == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE) {
            this.resetState();
            StatusBar.Info.set(null, (Project)this.myContext.getProject());
        }
    };
    private final ActionProcessor myActionProcessor = new ActionProcessor(){

        @Override
        @NotNull
        public AnActionEvent createEvent(@NotNull InputEvent inputEvent, @NotNull DataContext context2, @NotNull String place, @NotNull Presentation presentation2, @NotNull ActionManager manager2) {
            if (inputEvent == null) {
                1.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                1.$$$reportNull$$$0(1);
            }
            if (place == null) {
                1.$$$reportNull$$$0(2);
            }
            if (presentation2 == null) {
                1.$$$reportNull$$$0(3);
            }
            if (manager2 == null) {
                1.$$$reportNull$$$0(4);
            }
            return new AnActionEvent(inputEvent, context2, place, presentation2, manager2, 0);
        }

        @Override
        public void onUpdatePassed(@NotNull InputEvent inputEvent, @NotNull AnAction action2, @NotNull AnActionEvent event) {
            if (inputEvent == null) {
                1.$$$reportNull$$$0(5);
            }
            if (action2 == null) {
                1.$$$reportNull$$$0(6);
            }
            if (event == null) {
                1.$$$reportNull$$$0(7);
            }
            IdeKeyEventDispatcher.this.setState(KeyState.STATE_PROCESSED);
            IdeKeyEventDispatcher.this.setPressedWasProcessed(inputEvent.getID() == 401);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performAction(@NotNull InputEvent inputEvent, @NotNull AnAction action2, @NotNull AnActionEvent event) {
            if (inputEvent == null) {
                1.$$$reportNull$$$0(8);
            }
            if (action2 == null) {
                1.$$$reportNull$$$0(9);
            }
            if (event == null) {
                1.$$$reportNull$$$0(10);
            }
            try {
                super.performAction(inputEvent, action2, event);
            }
            finally {
                if (Registry.is((String)"actionSystem.fixLostTyping")) {
                    IdeEventQueue.getInstance().doWhenReady(() -> IdeEventQueue.getInstance().getKeyEventDispatcher().resetState());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createEvent";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onUpdatePassed";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private KeyEvent lastKeyEventForCurrentContext;
    private static final KeyboardShortcut CONTROL_ENTER = KeyboardShortcut.fromString((String)"control ENTER");
    private static final KeyboardShortcut CMD_ENTER = KeyboardShortcut.fromString((String)"meta ENTER");
    private static final String POPUP_MENU_PREFIX = "PopupMenu-";
    @NonNls
    private static final Set<String> ALT_GR_LANGUAGES = Set.of("da", "de", "es", "et", "fi", "fr", "hr", "hu", "it", "lv", "mk", "nl", "no", "pl", "pt", "ro", "sk", "sl", "sr", "sv", "tr");
    @NonNls
    private static final Set<String> ALT_GR_COUNTRIES = Set.of("DK", "DE", "FI", "NL", "SL", "SE");

    public IdeKeyEventDispatcher(@Nullable IdeEventQueue queue2) {
        this.myQueue = queue2;
    }

    public boolean isWaitingForSecondKeyStroke() {
        return this.getState() == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE || this.isPressedWasProcessed();
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        DataManager dataManager;
        MenuSelectionManager menuSelectionManager;
        MenuElement[] selectedPath;
        SpeedSearchSupply supply2;
        if (e.getID() == 401) {
            IdeKeyEventDispatcher.storeAsciiForChar(e);
        }
        if (e.isConsumed()) {
            return false;
        }
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        if (focusOwner instanceof KeyboardAwareFocusOwner && ((KeyboardAwareFocusOwner)((Object)focusOwner)).skipKeyEventDispatcher(e)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Key event not processed because %s is in focus and implements %s", focusOwner, KeyboardAwareFocusOwner.class));
            }
            return false;
        }
        int id2 = e.getID();
        if (this.myIgnoreNextKeyTypedEvent) {
            if (400 == id2) {
                return true;
            }
            this.myIgnoreNextKeyTypedEvent = false;
        }
        if (e.getKeyCode() == 8 && focusOwner instanceof JComponent && (supply2 = SpeedSearchSupply.getSupply((JComponent)((JComponent)focusOwner))) != null && supply2.isPopupActive()) {
            return false;
        }
        if (e.getKeyCode() == 17) {
            if (id2 == 401) {
                this.myLeftCtrlPressed = e.getKeyLocation() == 2;
            } else if (id2 == 402) {
                this.myLeftCtrlPressed = false;
            }
        } else if (e.getKeyCode() == 18) {
            if (id2 == 401) {
                this.myRightAltPressed = e.getKeyLocation() == 3;
            } else if (id2 == 402) {
                this.myRightAltPressed = false;
            }
        }
        if (focusOwner instanceof ShortcutTextField) {
            if (SystemInfoRt.isWindows && 401 == id2) {
                IdeKeyEventDispatcher.removeAltGraph(e);
            }
            return false;
        }
        if (this.getState() == KeyState.STATE_INIT && e.getKeyChar() != '\uffff' && focusOwner instanceof JTextComponent && ((JTextComponent)focusOwner).isEditable()) {
            if (id2 == 401 && e.getKeyCode() != 27) {
                MacUIUtil.hideCursor();
            }
            if (e.getModifiersEx() == 0 && Character.isLetterOrDigit(e.getKeyChar()) && !Boolean.TRUE.equals(((JTextComponent)focusOwner).getClientProperty(ActionUtil.ALLOW_PlAIN_LETTER_SHORTCUTS))) {
                return false;
            }
        }
        if ((selectedPath = (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath()).length > 0 && !(selectedPath[0] instanceof ComboPopup)) {
            this.setState(KeyState.STATE_PROCESSED);
            return IdeKeyEventDispatcher.processMenuActions(e, selectedPath[0]);
        }
        Window focusedWindow = focusManager.getFocusedWindow();
        boolean isModalContext = focusedWindow != null && IdeKeyEventDispatcher.isModalContext(focusedWindow);
        Application app = ApplicationManager.getApplication();
        DataManager dataManager2 = dataManager = app == null ? null : (DataManager)app.getServiceIfCreated(DataManager.class);
        if (dataManager == null) {
            return false;
        }
        DataContext dataContext = dataManager.getDataContext();
        this.myContext.setDataContext(dataContext);
        this.myContext.setFocusOwner(focusOwner);
        this.myContext.setModalContext(isModalContext);
        this.myContext.setInputEvent(e);
        this.myContext.setProject((Project)CommonDataKeys.PROJECT.getData(dataContext));
        try {
            switch (this.getState()) {
                case STATE_INIT: {
                    boolean bl = this.inInitState();
                    return bl;
                }
                case STATE_PROCESSED: {
                    boolean bl = this.inProcessedState();
                    return bl;
                }
                case STATE_WAIT_FOR_SECOND_KEYSTROKE: {
                    boolean bl = this.inWaitForSecondStrokeState();
                    return bl;
                }
                case STATE_SECOND_STROKE_IN_PROGRESS: {
                    boolean bl = this.inSecondStrokeInProgressState();
                    return bl;
                }
                case STATE_KEY_GESTURE_PROCESSOR: {
                    boolean bl = this.myKeyGestureProcessor.process();
                    return bl;
                }
                case STATE_WAIT_FOR_POSSIBLE_ALT_GR: {
                    boolean bl = this.inWaitForPossibleAltGr();
                    return bl;
                }
            }
            throw new IllegalStateException("state = " + this.getState());
        }
        finally {
            this.myContext.clear();
        }
    }

    private static void storeAsciiForChar(@NotNull KeyEvent e) {
        char aChar;
        if (e == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(0);
        }
        if ((aChar = e.getKeyChar()) == '\uffff') {
            return;
        }
        int mods = e.getModifiers();
        if ((mods & 0xFFFFFFFE & 0xFFFFFFBF) != 0) {
            return;
        }
        KeyboardLayoutUtil.storeAsciiForChar((int)e.getKeyCode(), (char)aChar, (int)65, (int)90);
    }

    public static boolean isModalContext(@NotNull Component component2) {
        JBPopup popup2;
        boolean isPopup;
        JDialog dialog2;
        Component pane2;
        Window window;
        if (component2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(1);
        }
        if ((window = ComponentUtil.getWindow((Component)component2)) instanceof IdeFrameImpl && (pane2 = ((JFrame)window).getGlassPane()) instanceof IdeGlassPaneEx) {
            return ((IdeGlassPaneEx)((Object)pane2)).isInModalContext();
        }
        if (window instanceof JDialog && !(dialog2 = (JDialog)window).isModal()) {
            Window owner = dialog2.getOwner();
            return owner != null && IdeKeyEventDispatcher.isModalContext(owner);
        }
        if (window instanceof JFrame) {
            return false;
        }
        boolean isFloatingDecorator = window instanceof FloatingDecorator;
        boolean bl = isPopup = !(component2 instanceof JFrame) && !(component2 instanceof JDialog);
        if (isPopup && component2 instanceof JWindow && (popup2 = (JBPopup)((JWindow)component2).getRootPane().getClientProperty("JBPopup")) != null) {
            return popup2.isModalContext();
        }
        return !isFloatingDecorator;
    }

    private boolean inWaitForSecondStrokeState() {
        if (401 == this.myContext.getInputEvent().getID()) {
            this.setState(KeyState.STATE_SECOND_STROKE_IN_PROGRESS);
            return this.inSecondStrokeInProgressState();
        }
        return true;
    }

    private static KeyStroke getKeyStrokeWithoutMouseModifiers(@NotNull KeyStroke originalKeyStroke) {
        if (originalKeyStroke == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(2);
        }
        int modifier = originalKeyStroke.getModifiers() & 0xFFFFFBFF & 0xFFFFFFEF & 0xFFFFF7FF & 0xFFFFFFF7 & 0xFFFFEFFF & 0xFFFFFFFB;
        try {
            return (KeyStroke)ReflectionHolder.getCachedStroke.invoke((Object)originalKeyStroke, Character.valueOf(originalKeyStroke.getKeyChar()), originalKeyStroke.getKeyCode(), modifier, originalKeyStroke.isOnKeyRelease());
        }
        catch (Exception exc) {
            throw new IllegalStateException(exc.getMessage());
        }
    }

    private boolean inWaitForPossibleAltGr() {
        KeyEvent e = this.myContext.getInputEvent();
        KeyStroke keyStroke = this.myFirstKeyStroke;
        this.myFirstKeyStroke = null;
        this.setState(KeyState.STATE_INIT);
        int eventId = e.getID();
        if (400 == eventId && e.isAltGraphDown()) {
            return false;
        }
        if (402 == eventId) {
            this.updateCurrentContext(this.myContext.getFoundComponent(), (Shortcut)new KeyboardShortcut(keyStroke, null));
            if (this.myContext.getActions().isEmpty()) {
                return false;
            }
            return this.processActionOrWaitSecondStroke(keyStroke);
        }
        return false;
    }

    private boolean inSecondStrokeInProgressState() {
        KeyEvent e = this.myContext.getInputEvent();
        if (402 == e.getID()) {
            this.myFirstKeyStroke = null;
            this.setState(KeyState.STATE_INIT);
            Project project = this.myContext.getProject();
            StatusBar.Info.set(null, (Project)project);
            return false;
        }
        KeyStroke originalKeyStroke = KeyStrokeAdapter.getDefaultKeyStroke(e);
        if (originalKeyStroke == null) {
            return false;
        }
        KeyStroke keyStroke = IdeKeyEventDispatcher.getKeyStrokeWithoutMouseModifiers(originalKeyStroke);
        this.updateCurrentContext(this.myContext.getFoundComponent(), (Shortcut)new KeyboardShortcut(this.myFirstKeyStroke, keyStroke));
        if (this.myContext.getActions().isEmpty()) {
            return true;
        }
        if (this.processAction(e, this.myActionProcessor)) {
            StatusBar.Info.set(null, (Project)this.myContext.getProject());
            return true;
        }
        return false;
    }

    private boolean inProcessedState() {
        KeyEvent e = this.myContext.getInputEvent();
        if (400 == e.getID() && this.isPressedWasProcessed()) {
            return true;
        }
        if (402 == e.getID() && 18 == e.getKeyCode() && this.isPressedWasProcessed()) {
            return true;
        }
        this.setState(KeyState.STATE_INIT);
        this.setPressedWasProcessed(false);
        return this.inInitState();
    }

    private boolean inInitState() {
        KeyStroke originalKeyStroke;
        boolean isCandidateForAltGr;
        Component focusOwner = this.myContext.getFocusOwner();
        KeyEvent e = this.myContext.getInputEvent();
        if (SystemInfoRt.isWindows && 401 == e.getID() && IdeKeyEventDispatcher.removeAltGraph(e) && e.isControlDown()) {
            this.myFirstKeyStroke = KeyStrokeAdapter.getDefaultKeyStroke(e);
            if (this.myFirstKeyStroke == null) {
                return false;
            }
            this.setState(KeyState.STATE_WAIT_FOR_POSSIBLE_ALT_GR);
            return true;
        }
        boolean bl = isCandidateForAltGr = this.myLeftCtrlPressed && this.myRightAltPressed && focusOwner != null && e.getModifiers() == 10;
        if (isCandidateForAltGr) {
            if (Registry.is((String)"actionSystem.force.alt.gr", (boolean)false)) {
                return false;
            }
            if (IdeKeyEventDispatcher.isAltGrLayout(focusOwner)) {
                return false;
            }
        }
        if ((originalKeyStroke = KeyStrokeAdapter.getDefaultKeyStroke(e)) == null) {
            return false;
        }
        KeyStroke keyStroke = IdeKeyEventDispatcher.getKeyStrokeWithoutMouseModifiers(originalKeyStroke);
        if (this.myKeyGestureProcessor.processInitState()) {
            return true;
        }
        if (512 == e.getModifiersEx() && (!SystemInfo.isMac || Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl")) && (400 == e.getID() && !IdeEventQueue.getInstance().isInputMethodEnabled() || IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, e))) {
            this.myIgnoreNextKeyTypedEvent = true;
            return false;
        }
        this.updateCurrentContext(focusOwner, (Shortcut)new KeyboardShortcut(keyStroke, null));
        if (this.myContext.getActions().isEmpty()) {
            return false;
        }
        if (isCandidateForAltGr && SystemInfo.isWindows && Registry.is((String)"actionSystem.fix.alt.gr")) {
            this.myFirstKeyStroke = keyStroke;
            this.setState(KeyState.STATE_WAIT_FOR_POSSIBLE_ALT_GR);
            return true;
        }
        return this.processActionOrWaitSecondStroke(keyStroke);
    }

    private boolean processActionOrWaitSecondStroke(KeyStroke keyStroke) {
        if (!this.myContext.getSecondStrokeActions().isEmpty()) {
            this.myFirstKeyStroke = keyStroke;
        }
        return this.processAction(this.myContext.getInputEvent(), this.myActionProcessor);
    }

    private void waitSecondStroke(@NotNull AnAction chosenAction, @NotNull Presentation presentation2) {
        if (chosenAction == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(3);
        }
        if (presentation2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(4);
        }
        StatusBar.Info.set((String)this.getSecondStrokeMessage(chosenAction, presentation2), (Project)this.myContext.getProject());
        this.mySecondStrokeTimeout.cancelAllRequests();
        this.mySecondStrokeTimeout.addRequest(this.mySecondStrokeTimeoutRunnable, Registry.intValue((String)"actionSystem.secondKeystrokeTimeout"));
        this.setState(KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE);
    }

    @NlsContexts.StatusBarText
    @NotNull
    private String getSecondStrokeMessage(@NotNull AnAction chosenAction, @NotNull Presentation presentation2) {
        if (chosenAction == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(5);
        }
        if (presentation2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(6);
        }
        @NlsContexts.StatusBarText StringBuilder message2 = new StringBuilder();
        message2.append(KeyMapBundle.message((String)"prefix.key.pressed.message", (Object[])new Object[0]));
        message2.append(": ");
        message2.append(presentation2.getText());
        message2.append(" (");
        message2.append(KeymapUtil.getKeystrokeText((KeyStroke)IdeKeyEventDispatcher.getSecondKeystroke(chosenAction, this.myFirstKeyStroke)));
        message2.append(")");
        for (AnAction action2 : this.myContext.getSecondStrokeActions()) {
            if (action2 == chosenAction) continue;
            message2.append(", ");
            message2.append(action2.getTemplatePresentation().getText());
            message2.append(" (");
            message2.append(KeymapUtil.getKeystrokeText((KeyStroke)IdeKeyEventDispatcher.getSecondKeystroke(action2, this.myFirstKeyStroke)));
            message2.append(")");
        }
        String string = message2.toString();
        if (string == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static KeyStroke getSecondKeystroke(@NotNull AnAction action2, @NotNull KeyStroke firstKeyStroke) {
        Shortcut[] shortcuts;
        if (action2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(8);
        }
        if (firstKeyStroke == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(9);
        }
        for (Shortcut shortcut : shortcuts = action2.getShortcutSet().getShortcuts()) {
            KeyStroke secondKeyStroke;
            KeyboardShortcut keyShortcut;
            if (!(shortcut instanceof KeyboardShortcut) || !firstKeyStroke.equals((keyShortcut = (KeyboardShortcut)shortcut).getFirstKeyStroke()) || (secondKeyStroke = keyShortcut.getSecondKeyStroke()) == null) continue;
            return secondKeyStroke;
        }
        return null;
    }

    public static boolean hasMnemonicInWindow(Component focusOwner, @NotNull KeyEvent event) {
        if (event == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(10);
        }
        return 400 == event.getID() && IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, event.getKeyChar()) || 401 == event.getID() && IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, event.getKeyCode());
    }

    private static boolean hasMnemonicInWindow(Component focusOwner, int keyCode) {
        ComponentWithMnemonics componentWithMnemonics;
        Container container;
        if (keyCode == 18 || keyCode == 0) {
            return false;
        }
        Window window = container = focusOwner == null ? null : ComponentUtil.getWindow((Component)focusOwner);
        if (container instanceof JFrame && (componentWithMnemonics = (ComponentWithMnemonics)ComponentUtil.getParentOfType(ComponentWithMnemonics.class, (Component)focusOwner)) instanceof Container) {
            container = (Container)((Object)componentWithMnemonics);
        }
        return IdeKeyEventDispatcher.hasMnemonic(container, keyCode) || IdeKeyEventDispatcher.hasMnemonicInBalloons(container, keyCode);
    }

    private static boolean hasMnemonic(@Nullable Container container, int keyCode) {
        Component component2 = (Component)UIUtil.uiTraverser((Component)container).traverse().filter(Component::isEnabled).filter(Component::isShowing).find(c -> !(c instanceof ActionMenu) && MnemonicHelper.hasMnemonic((Component)c, (int)keyCode));
        return component2 != null;
    }

    private static boolean hasMnemonicInBalloons(Container container, int code) {
        Component parent = UIUtil.findUltimateParent((Component)container);
        if (parent instanceof RootPaneContainer) {
            JLayeredPane pane2 = ((RootPaneContainer)((Object)parent)).getLayeredPane();
            for (Component component2 : pane2.getComponents()) {
                if (!(component2 instanceof ComponentWithMnemonics) || !(component2 instanceof Container) || !IdeKeyEventDispatcher.hasMnemonic((Container)component2, code)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean processAction(@NotNull InputEvent e, @NotNull ActionProcessor processor2) {
        boolean result2;
        if (e == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(11);
        }
        if (processor2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(12);
        }
        if (!(result2 = this.processAction(e, "keyboard shortcut", this.myContext.getDataContext(), new ArrayList<AnAction>(this.myContext.getActions()), processor2, this.myPresentationFactory))) {
            IdeEventQueue.getInstance().flushDelayedKeyEvents();
        }
        return result2;
    }

    boolean processAction(@NotNull InputEvent e, @NotNull String place, @NotNull DataContext context2, @NotNull List<AnAction> actions2, @NotNull ActionProcessor processor2, @NotNull PresentationFactory presentationFactory) {
        if (e == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(13);
        }
        if (place == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(14);
        }
        if (context2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(15);
        }
        if (actions2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(17);
        }
        if (presentationFactory == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(18);
        }
        if (actions2.isEmpty()) {
            return false;
        }
        DataContext wrappedContext = Utils.wrapDataContext(context2);
        Project project = (Project)CommonDataKeys.PROJECT.getData(wrappedContext);
        boolean dumb = project != null && DumbService.getInstance((Project)project).isDumb();
        ConcurrentHashMap events = new ConcurrentHashMap();
        List wouldBeEnabledIfNotDumb = ContainerUtil.createLockFreeCopyOnWriteList();
        Trinity chosen = Utils.runUpdateSessionForInputEvent(e, wrappedContext, place, processor2, presentationFactory, event -> events.put(event.getPresentation(), event), session2 -> Utils.tryInReadAction(() -> IdeKeyEventDispatcher.rearrangeByPromoters(actions2, Utils.freezeDataContext(wrappedContext, null))) ? IdeKeyEventDispatcher.doUpdateActionsInner(actions2, dumb, wouldBeEnabledIfNotDumb, session2, events::get) : null);
        this.doPerformActionInner((Trinity<AnAction, AnActionEvent, Long>)chosen, e, processor2, wrappedContext, project, wouldBeEnabledIfNotDumb, () -> ApplicationManager.getApplication().invokeLater(() -> DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(ctx -> this.processAction(e, place, (DataContext)ctx, actions2, processor2, presentationFactory))));
        return chosen != null;
    }

    @Nullable
    private static Trinity<AnAction, AnActionEvent, Long> doUpdateActionsInner(@NotNull List<AnAction> actions2, boolean dumb, @NotNull List<? super AnAction> wouldBeEnabledIfNotDumb, @NotNull UpdateSession session2, @NotNull Function<? super Presentation, ? extends AnActionEvent> events) {
        if (actions2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(19);
        }
        if (wouldBeEnabledIfNotDumb == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(20);
        }
        if (session2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(21);
        }
        if (events == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(22);
        }
        for (AnAction action2 : actions2) {
            long startedAt = System.currentTimeMillis();
            Presentation presentation2 = session2.presentation(action2);
            if (dumb && !action2.isDumbAware()) {
                if (!Boolean.FALSE.equals(presentation2.getClientProperty(ActionUtil.WOULD_BE_ENABLED_IF_NOT_DUMB_MODE))) {
                    wouldBeEnabledIfNotDumb.add((AnAction)action2);
                }
                IdeKeyEventDispatcher.logTimeMillis(startedAt, action2);
                continue;
            }
            if (!presentation2.isEnabled()) {
                IdeKeyEventDispatcher.logTimeMillis(startedAt, action2);
                continue;
            }
            AnActionEvent event = Objects.requireNonNull(events.apply((Presentation)presentation2));
            return Trinity.create((Object)action2, (Object)event, (Object)startedAt);
        }
        return null;
    }

    private void doPerformActionInner(@Nullable Trinity<AnAction, AnActionEvent, Long> chosen, @NotNull InputEvent e, @NotNull ActionProcessor processor2, @NotNull DataContext context2, @Nullable Project project, @NotNull List<? extends AnAction> wouldBeEnabledIfNotDumb, @NotNull Runnable retryRunnable) {
        if (e == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(23);
        }
        if (processor2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(24);
        }
        if (context2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(25);
        }
        if (wouldBeEnabledIfNotDumb == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(26);
        }
        if (retryRunnable == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(27);
        }
        if (chosen != null) {
            AnAction action2 = (AnAction)chosen.first;
            if (this.myContext.getSecondStrokeActions().contains(chosen.first)) {
                this.waitSecondStroke((AnAction)chosen.first, ((AnActionEvent)chosen.second).getPresentation());
                return;
            }
            AnActionEvent actionEvent = ((AnActionEvent)chosen.second).withDataContext(context2);
            long startedAt = (Long)chosen.third;
            if (Registry.is((String)"actionSystem.update.actions.call.beforeActionPerformedUpdate.once") && !ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)actionEvent, (boolean)false)) {
                LOG.warn("Action '" + actionEvent.getPresentation().getText() + "' (" + action2.getClass() + ") has become disabled in `beforeActionPerformedUpdate` right after successful `update`");
                return;
            }
            processor2.onUpdatePassed(e, action2, actionEvent);
            int eventCount = IdeEventQueue.getInstance().getEventCount();
            if (context2 instanceof EdtDataContext) {
                ((EdtDataContext)context2).setEventCount(eventCount);
            }
            ActionUtil.performDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)actionEvent, () -> {
                if (e.getID() == 401) {
                    this.myIgnoreNextKeyTypedEvent = true;
                }
                LOG.assertTrue(eventCount == IdeEventQueue.getInstance().getEventCount(), (Object)("Event counts do not match: " + eventCount + " != " + IdeEventQueue.getInstance().getEventCount()));
                try (AccessToken ignore = ((TransactionGuardImpl)TransactionGuard.getInstance()).startActivity(true);){
                    processor2.performAction(e, action2, actionEvent);
                }
            });
            IdeKeyEventDispatcher.logTimeMillis(startedAt, action2);
            return;
        }
        if (!wouldBeEnabledIfNotDumb.isEmpty()) {
            if (e.getID() == 401) {
                this.myIgnoreNextKeyTypedEvent = true;
            }
            IdeEventQueue.getInstance().flushDelayedKeyEvents();
            String message2 = IdeKeyEventDispatcher.getActionUnavailableMessage(wouldBeEnabledIfNotDumb);
            IdeKeyEventDispatcher.showDumbModeBalloonLaterIfNobodyConsumesEvent(project, message2, retryRunnable, (Condition<Object>)((Condition)__ -> e.isConsumed()));
        }
    }

    private static void showDumbModeBalloonLaterIfNobodyConsumesEvent(@Nullable Project project, @NotNull @Nls String message2, @NotNull Runnable retryRunnable, @NotNull Condition<Object> expired) {
        if (message2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(28);
        }
        if (retryRunnable == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(29);
        }
        if (expired == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(30);
        }
        if (project == null || expired.value(null)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (expired.value(null)) {
                return;
            }
            DumbService.getInstance((Project)project).showDumbModeActionBalloon(message2, retryRunnable);
        }, Conditions.or(expired, (Condition)project.getDisposed()));
    }

    @NotNull
    @Nls
    private static String getActionUnavailableMessage(@NotNull List<? extends AnAction> actions2) {
        if (actions2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(31);
        }
        ArrayList<String> actionNames = new ArrayList<String>();
        for (AnAction anAction2 : actions2) {
            String s = anAction2.getTemplateText();
            if (!Strings.isNotEmpty((String)s)) continue;
            actionNames.add(s);
        }
        ContainerUtil.removeDuplicates(actionNames);
        if (actionNames.isEmpty()) {
            return IdeKeyEventDispatcher.getUnavailableMessage(IdeBundle.message((String)"dumb.balloon.this.action", (Object[])new Object[0]), false);
        }
        if (actionNames.size() == 1) {
            return IdeKeyEventDispatcher.getUnavailableMessage("'" + (String)actionNames.get(0) + "'", false);
        }
        @NlsSafe String join = String.join((CharSequence)", ", actionNames);
        String string = IdeKeyEventDispatcher.getUnavailableMessage(IdeBundle.message((String)"dumb.balloon.none.of.the.following.actions", (Object[])new Object[0]), true) + ": " + join;
        if (string == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String getUnavailableMessage(@NotNull @Nls String action2, boolean plural) {
        if (action2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(33);
        }
        String string = plural ? IdeBundle.message((String)"dumb.balloon.0.are.not.available.while.indexing", (Object[])new Object[]{action2}) : IdeBundle.message((String)"dumb.balloon.0.is.not.available.while.indexing", (Object[])new Object[]{action2});
        if (string == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(34);
        }
        return string;
    }

    public void updateCurrentContext(@Nullable Component component2, @NotNull Shortcut sc) {
        if (sc == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(35);
        }
        KeyEvent keyEvent = this.myContext.getInputEvent();
        this.myContext.setFoundComponent(null);
        this.myContext.getSecondStrokeActions().clear();
        this.myContext.getActions().clear();
        if (Registry.is((String)"ide.edt.update.context.only.on.key.pressed.event")) {
            if (keyEvent == null || keyEvent.getID() != 401) {
                return;
            }
            if (keyEvent == this.lastKeyEventForCurrentContext) {
                return;
            }
            this.lastKeyEventForCurrentContext = keyEvent;
        }
        if (IdeKeyEventDispatcher.isControlEnterOnDialog(component2, sc)) {
            return;
        }
        while (component2 != null) {
            List listOfActions;
            if (component2 instanceof JComponent && !(listOfActions = ActionUtil.getActions((JComponent)((JComponent)component2))).isEmpty()) {
                for (AnAction action2 : listOfActions) {
                    this.addAction(action2, sc);
                }
                if (!this.myContext.getActions().isEmpty()) {
                    this.myContext.setFoundComponent((JComponent)component2);
                    break;
                }
            }
            component2 = component2.getParent();
        }
        this.addActionsFromActiveKeymap(sc);
        if (this.myContext.getSecondStrokeActions().isEmpty() && sc instanceof KeyboardShortcut) {
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)sc;
            KeyStroke firstKeyStroke = keyboardShortcut.getFirstKeyStroke();
            KeyStroke secondKeyStroke = keyboardShortcut.getSecondKeyStroke();
            if (secondKeyStroke != null && secondKeyStroke.getModifiers() != 0 && firstKeyStroke.getModifiers() != 0) {
                KeyboardShortcut altShortCut = new KeyboardShortcut(firstKeyStroke, KeyStroke.getKeyStroke(secondKeyStroke.getKeyCode(), 0));
                this.addActionsFromActiveKeymap((Shortcut)altShortCut);
            }
        }
    }

    private static boolean rearrangeByPromoters(@NotNull List<AnAction> actions2, @NotNull DataContext context2) {
        if (actions2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(36);
        }
        if (context2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(37);
        }
        List<AnAction> readOnlyActions = Collections.unmodifiableList(actions2);
        List promoters = ContainerUtil.concat((List)ActionPromoter.EP_NAME.getExtensionList(), (List)ContainerUtil.filterIsInstance(actions2, ActionPromoter.class));
        for (ActionPromoter promoter : promoters) {
            try {
                List suppressed;
                List promoted = promoter.promote(readOnlyActions, context2);
                if (promoted != null && !promoted.isEmpty()) {
                    actions2.removeAll(promoted);
                    actions2.addAll(0, promoted);
                }
                if ((suppressed = promoter.suppress(readOnlyActions, context2)) == null || suppressed.isEmpty()) continue;
                actions2.removeAll(suppressed);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return true;
    }

    private void addActionsFromActiveKeymap(@NotNull Shortcut shortcut) {
        String[] actionIds;
        if (shortcut == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(38);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return;
        }
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            return;
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        Keymap keymap2 = keymapManager2 == null ? null : keymapManager2.getActiveKeymap();
        for (String actionId : actionIds = keymap2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : keymap2.getActionIds(shortcut)) {
            AnAction action2 = actionManager.getAction(actionId);
            if (action2 == null || this.myContext.isModalContext() && !action2.isEnabledInModalContext()) continue;
            this.addAction(action2, shortcut);
        }
        if (keymap2 != null && actionIds.length > 0 && shortcut instanceof KeyboardShortcut) {
            SystemShortcuts.getInstance().onUserPressedShortcut(keymap2, actionIds, (KeyboardShortcut)shortcut);
        }
    }

    private static boolean isControlEnterOnDialog(Component component2, Shortcut sc) {
        return (CONTROL_ENTER.equals((Object)sc) || SystemInfo.isMac && CMD_ENTER.equals((Object)sc)) && !IdeEventQueue.getInstance().isPopupActive() && DialogWrapper.findInstance((Component)component2) != null;
    }

    private void addAction(@NotNull AnAction action2, @NotNull Shortcut sc) {
        if (action2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(39);
        }
        if (sc == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(40);
        }
        if (action2 instanceof EmptyAction) {
            return;
        }
        boolean isNotTwoStroke = sc instanceof KeyboardShortcut && ((KeyboardShortcut)sc).getSecondKeyStroke() == null;
        for (Shortcut each : action2.getShortcutSet().getShortcuts()) {
            if (each == null) {
                throw new NullPointerException("unexpected shortcut of action: " + action2);
            }
            if (!each.isKeyboard() || !each.startsWith(sc)) continue;
            if (each instanceof KeyboardShortcut && ((KeyboardShortcut)each).getSecondKeyStroke() != null && isNotTwoStroke && !this.myContext.getSecondStrokeActions().contains(action2)) {
                this.myContext.getSecondStrokeActions().add(action2);
            }
            if (this.myContext.getActions().contains(action2)) continue;
            this.myContext.getActions().add(action2);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public KeyProcessorContext getContext() {
        KeyProcessorContext keyProcessorContext = this.myContext;
        if (keyProcessorContext == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(41);
        }
        return keyProcessorContext;
    }

    public KeyState getState() {
        return this.myState;
    }

    public void setState(KeyState state) {
        this.myState = state;
        if (this.myQueue != null) {
            this.myQueue.maybeReady();
        }
    }

    private void resetState() {
        this.setState(KeyState.STATE_INIT);
        this.setPressedWasProcessed(false);
    }

    public boolean isPressedWasProcessed() {
        return this.myPressedWasProcessed;
    }

    private void setPressedWasProcessed(boolean pressedWasProcessed) {
        this.myPressedWasProcessed = pressedWasProcessed;
    }

    public boolean isReady() {
        return this.myState == KeyState.STATE_INIT || this.myState == KeyState.STATE_PROCESSED;
    }

    private static boolean processMenuActions(@NotNull KeyEvent event, MenuElement element2) {
        if (event == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(42);
        }
        if (401 != event.getID() || !Registry.is((String)"ide.popup.navigation.via.actions")) {
            return false;
        }
        KeymapManager manager2 = KeymapManager.getInstance();
        if (manager2 == null) {
            return false;
        }
        JRootPane pane2 = IdeKeyEventDispatcher.getMenuActionsHolder(element2.getComponent());
        if (pane2 == null) {
            return false;
        }
        Keymap keymap2 = manager2.getActiveKeymap();
        for (String id2 : keymap2.getActionIds(KeyStroke.getKeyStrokeForEvent(event))) {
            if (!id2.startsWith(POPUP_MENU_PREFIX)) continue;
            String actionId = id2.substring(POPUP_MENU_PREFIX.length());
            Action action2 = pane2.getActionMap().get(actionId);
            if (action2 == null) continue;
            action2.actionPerformed(new ActionEvent(pane2, 1001, actionId));
            event.consume();
            return true;
        }
        return false;
    }

    private static JRootPane getMenuActionsHolder(Component component2) {
        if (component2 instanceof JPopupMenu) {
            JPopupMenu menu = (JPopupMenu)component2;
            return SwingUtilities.getRootPane(menu.getInvoker());
        }
        return SwingUtilities.getRootPane(component2);
    }

    /*
     * WARNING - void declaration
     */
    private static void logTimeMillis(long startedAt, @NotNull AnAction anAction2) {
        EventWatcher watcher;
        if (anAction2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(43);
        }
        if ((watcher = EventWatcher.getInstance()) != null) {
            void action2;
            watcher.logTimeMillis(action2.toString(), startedAt);
        }
    }

    public static boolean removeAltGraph(@NotNull InputEvent e) {
        if (e == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(44);
        }
        if (e.isAltGraphDown()) {
            try {
                Field field = InputEvent.class.getDeclaredField("modifiers");
                field.setAccessible(true);
                field.setInt(e, 0xFFFFDFDF & field.getInt(e));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAltGrLayout(Component component2) {
        Locale locale;
        InputContext context2 = component2 == null ? null : component2.getInputContext();
        Locale locale2 = locale = context2 == null ? null : context2.getLocale();
        if (locale == null) {
            return false;
        }
        String language = locale.getLanguage();
        boolean contains = !"en".equals(language) ? ALT_GR_LANGUAGES.contains(language) : ALT_GR_COUNTRIES.contains(locale.getCountry());
        LOG.debug("AltGr", new Object[]{contains ? "" : " not", " supported for ", locale});
        return contains;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 32: 
            case 34: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 32: 
            case 34: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalKeyStroke";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenAction";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: 
            case 32: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher";
                break;
            }
            case 8: 
            case 33: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstKeyStroke";
                break;
            }
            case 10: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: 
            case 25: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 19: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationFactory";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wouldBeEnabledIfNotDumb";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retryRunnable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sc";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondStrokeMessage";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUnavailableMessage";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnavailableMessage";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "storeAsciiForChar";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModalContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokeWithoutMouseModifiers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "waitSecondStroke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSecondStrokeMessage";
                break;
            }
            case 7: 
            case 32: 
            case 34: 
            case 41: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSecondKeystroke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasMnemonicInWindow";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processAction";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateActionsInner";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doPerformActionInner";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showDumbModeBalloonLaterIfNobodyConsumesEvent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getActionUnavailableMessage";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getUnavailableMessage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentContext";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "rearrangeByPromoters";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addActionsFromActiveKeymap";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processMenuActions";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "logTimeMillis";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "removeAltGraph";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 32: 
            case 34: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ReflectionHolder {
        static final Method getCachedStroke = Objects.requireNonNull(ReflectionUtil.getDeclaredMethod(AWTKeyStroke.class, (String)"getCachedStroke", (Class[])new Class[]{Character.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}));

        private ReflectionHolder() {
        }
    }
}

