/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class IgnoredFileCache {
    private final ConcurrentBitSet myNonIgnoredIds;
    private final IgnoredPatternSet myIgnoredPatterns;
    private int myVfsEventNesting;

    IgnoredFileCache(@NotNull IgnoredPatternSet ignoredPatterns) {
        if (ignoredPatterns == null) {
            IgnoredFileCache.$$$reportNull$$$0(0);
        }
        this.myNonIgnoredIds = ConcurrentBitSet.create();
        this.myIgnoredPatterns = ignoredPatterns;
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect();
        connect.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                ++IgnoredFileCache.this.myVfsEventNesting;
                this.clearCacheForChangedFiles(events);
            }

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.clearCacheForChangedFiles(events);
                --IgnoredFileCache.this.myVfsEventNesting;
            }

            private void clearCacheForChangedFiles(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2;
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename() || !((file2 = vFileEvent.getFile()) instanceof NewVirtualFile)) continue;
                    int id2 = ((NewVirtualFile)file2).getId();
                    IgnoredFileCache.this.myNonIgnoredIds.clear(id2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/IgnoredFileCache$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "clearCacheForChangedFiles";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    void clearCache() {
        this.myNonIgnoredIds.clear();
    }

    boolean isFileIgnored(@NotNull VirtualFile file2) {
        boolean idable;
        if (file2 == null) {
            IgnoredFileCache.$$$reportNull$$$0(1);
        }
        boolean bl = idable = this.myVfsEventNesting == 0 && file2 instanceof NewVirtualFile;
        if (!idable) {
            return this.calcIgnored(file2);
        }
        int id2 = ((NewVirtualFile)file2).getId();
        if (this.myNonIgnoredIds.get(id2)) {
            return false;
        }
        return this.calcAndCache(file2, id2);
    }

    private boolean calcAndCache(VirtualFile file2, int id2) {
        boolean result2 = this.calcIgnored(file2);
        if (!result2) {
            this.myNonIgnoredIds.set(id2);
        }
        return result2;
    }

    private boolean calcIgnored(VirtualFile file2) {
        return this.myIgnoredPatterns.isIgnored(file2.getNameSequence());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredPatterns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/IgnoredFileCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileIgnored";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

