/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRenderer {
    private static final Color GRAYED = SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
    private static final Color HIDDEN = SimpleTextAttributes.DARK_TEXT.getFgColor();

    public <T> ColoredListCellRenderer<T> forList() {
        return new ColoredListCellRenderer<T>(){

            protected void customizeCellRenderer(@NotNull JList<? extends T> list2, T value2, int index2, boolean selected2, boolean focused) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileRenderer.this.customize((SimpleColoredComponent)this, value2, selected2, focused);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileChooser/tree/FileRenderer$1", "customizeCellRenderer"));
            }
        };
    }

    public ColoredTableCellRenderer forTable() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected2, boolean focused, int row2, int column2) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileRenderer.this.customize((SimpleColoredComponent)this, value2, selected2, focused);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/fileChooser/tree/FileRenderer$2", "customizeCellRenderer"));
            }
        };
    }

    public ColoredTreeCellRenderer forTree() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean focused) {
                if (tree == null) {
                    3.$$$reportNull$$$0(0);
                }
                FileRenderer.this.customize((SimpleColoredComponent)this, value2, selected2, focused);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/fileChooser/tree/FileRenderer$3", "customizeCellRenderer"));
            }
        };
    }

    protected void customize(SimpleColoredComponent renderer, Object value2, boolean selected2, boolean focused) {
        int style = 0;
        Color color = null;
        Icon icon2 = null;
        String name = null;
        String comment = null;
        boolean hidden = false;
        boolean valid = true;
        if (value2 instanceof FileNode) {
            FileNode node = (FileNode)value2;
            icon2 = node.getIcon();
            name = node.getName();
            comment = node.getComment();
            hidden = node.isHidden();
            valid = node.isValid();
        } else if (value2 instanceof VirtualFile) {
            VirtualFile file2 = (VirtualFile)value2;
            name = file2.getName();
            hidden = FileElement.isFileHidden((VirtualFile)file2);
            valid = file2.isValid();
        } else if (value2 != null) {
            name = value2.toString();
            color = GRAYED;
        }
        if (!valid) {
            style |= 4;
        }
        if (hidden) {
            color = HIDDEN;
        }
        renderer.setIcon(!hidden || icon2 == null ? icon2 : IconLoader.getTransparentIcon((Icon)icon2));
        SimpleTextAttributes attributes2 = new SimpleTextAttributes(style, color);
        if (name != null) {
            renderer.append(name, attributes2);
        }
        if (comment != null) {
            renderer.append(comment, attributes2);
        }
    }
}

