/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.CrcCache;
import com.intellij.openapi.externalSystem.util.DefaultCrcCalculator;
import com.intellij.openapi.externalSystem.util.ExternalSystemCrcCalculator;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a1\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u000f\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u000f2\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a-\u0010\u0014\u001a\u0004\u0018\u00010\u0007*\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0015\u001a%\u0010\u0014\u001a\u0004\u0018\u00010\u0007*\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u0016\u001a1\u0010\u0017\u001a\u00020\u0007\"\b\b\u0000\u0010\u0018*\u00020\u0019*\u0002H\u00182\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0002\u00a2\u0006\u0002\u0010\u001d\u001a\u001b\u0010\u001e\u001a\u0004\u0018\u00010\u0007*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u001c\u0010 \u001a\u00020!*\u00020\u00192\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"CRC_CACHE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/externalSystem/util/CrcCache;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "calculateCrc", "", "project", "Lcom/intellij/openapi/project/Project;", "charSequence", "", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/CharSequence;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Long;", "getCrcCalculator", "Lcom/intellij/openapi/externalSystem/util/ExternalSystemCrcCalculator;", "Lcom/intellij/openapi/editor/Document;", "doCalculateCrc", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Long;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;)Ljava/lang/Long;", "findOrCalculateCrc", "T", "Lcom/intellij/openapi/util/UserDataHolder;", "modificationStamp", "calculate", "Lkotlin/Function0;", "(Lcom/intellij/openapi/util/UserDataHolder;JLkotlin/jvm/functions/Function0;)J", "getCachedCrc", "(Lcom/intellij/openapi/util/UserDataHolder;J)Ljava/lang/Long;", "setCachedCrc", "", "value", "intellij.platform.externalSystem.impl"})
@JvmName(name="CrcUtils")
public final class CrcUtils {
    private static final Logger LOG;
    private static final Key<CrcCache> CRC_CACHE;

    public static final long calculateCrc(@NotNull Document $this$calculateCrc, @NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"$this$calculateCrc");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return CrcUtils.calculateCrc($this$calculateCrc, project, null, file2);
    }

    public static final long calculateCrc(@NotNull Document $this$calculateCrc, @NotNull Project project, @Nullable ProjectSystemId systemId2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"$this$calculateCrc");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Long l = CrcUtils.getCachedCrc((UserDataHolder)file2, $this$calculateCrc.getModificationStamp());
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            return it;
        }
        return CrcUtils.findOrCalculateCrc((UserDataHolder)$this$calculateCrc, $this$calculateCrc.getModificationStamp(), (Function0<Long>)((Function0)new Function0<Long>($this$calculateCrc, project, systemId2, file2){
            final /* synthetic */ Document $this_calculateCrc;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectSystemId $systemId;
            final /* synthetic */ VirtualFile $file;

            public final long invoke() {
                Long l = CrcUtils.access$doCalculateCrc(this.$this_calculateCrc, this.$project, this.$systemId, this.$file);
                return l != null ? l : CrcUtils.calculateCrc(this.$file);
            }
            {
                this.$this_calculateCrc = document;
                this.$project = project;
                this.$systemId = projectSystemId;
                this.$file = virtualFile2;
                super(0);
            }
        }));
    }

    public static final long calculateCrc(@NotNull VirtualFile $this$calculateCrc, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"$this$calculateCrc");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CrcUtils.calculateCrc($this$calculateCrc, project, null);
    }

    public static final long calculateCrc(@NotNull VirtualFile $this$calculateCrc, @NotNull Project project, @Nullable ProjectSystemId systemId2) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"$this$calculateCrc");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CrcUtils.findOrCalculateCrc((UserDataHolder)$this$calculateCrc, $this$calculateCrc.getModificationStamp(), (Function0<Long>)((Function0)new Function0<Long>($this$calculateCrc, project, systemId2){
            final /* synthetic */ VirtualFile $this_calculateCrc;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectSystemId $systemId;

            public final long invoke() {
                Long l = CrcUtils.access$doCalculateCrc(this.$this_calculateCrc, this.$project, this.$systemId);
                return l != null ? l : CrcUtils.calculateCrc(this.$this_calculateCrc);
            }
            {
                this.$this_calculateCrc = virtualFile2;
                this.$project = project;
                this.$systemId = projectSystemId;
                super(0);
            }
        }));
    }

    public static final long calculateCrc(@NotNull VirtualFile $this$calculateCrc) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"$this$calculateCrc");
        CRC32 crc32 = new CRC32();
        crc32.update($this$calculateCrc.contentsToByteArray());
        return crc32.getValue();
    }

    private static final <T extends UserDataHolder> long findOrCalculateCrc(T $this$findOrCalculateCrc, long modificationStamp, Function0<Long> calculate) {
        long l;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Long cachedCrc = CrcUtils.getCachedCrc($this$findOrCalculateCrc, modificationStamp);
        if (cachedCrc != null) {
            return cachedCrc;
        }
        try {
            l = ((Number)calculate.invoke()).longValue();
        }
        catch (IOException ex) {
            LOG.warn((Throwable)ex);
            l = modificationStamp;
        }
        long crc = l;
        CrcUtils.setCachedCrc($this$findOrCalculateCrc, crc, modificationStamp);
        return crc;
    }

    private static final Long calculateCrc(Project project, CharSequence charSequence, ProjectSystemId systemId2, VirtualFile file2) {
        ExternalSystemCrcCalculator crcCalculator = CrcUtils.getCrcCalculator(systemId2, file2);
        return crcCalculator.calculateCrc(project, file2, charSequence);
    }

    private static final ExternalSystemCrcCalculator getCrcCalculator(ProjectSystemId systemId2, VirtualFile file2) {
        if (systemId2 != null) {
            ExternalSystemCrcCalculator externalSystemCrcCalculator = ExternalSystemCrcCalculator.Companion.getInstance(systemId2, file2);
            if (externalSystemCrcCalculator == null) {
                externalSystemCrcCalculator = DefaultCrcCalculator.INSTANCE;
            }
            return externalSystemCrcCalculator;
        }
        return DefaultCrcCalculator.INSTANCE;
    }

    private static final Long doCalculateCrc(Document $this$doCalculateCrc, Project project, ProjectSystemId systemId2, VirtualFile file2) {
        Long l;
        FileType fileType = file2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
        if (fileType.isBinary()) {
            l = null;
        } else {
            CharSequence charSequence = $this$doCalculateCrc.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"immutableCharSequence");
            l = CrcUtils.calculateCrc(project, charSequence, systemId2, file2);
        }
        return l;
    }

    private static final Long doCalculateCrc(VirtualFile $this$doCalculateCrc, Project project, ProjectSystemId systemId2) {
        Long l;
        if ($this$doCalculateCrc.isDirectory()) {
            l = null;
        } else {
            FileType fileType = $this$doCalculateCrc.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"fileType");
            if (fileType.isBinary()) {
                l = null;
            } else {
                CharSequence charSequence = LoadTextUtil.loadText($this$doCalculateCrc);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"LoadTextUtil.loadText(this)");
                l = CrcUtils.calculateCrc(project, charSequence, systemId2, $this$doCalculateCrc);
            }
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private static final Long getCachedCrc(UserDataHolder $this$getCachedCrc, long modificationStamp) {
        CrcCache crcCache = (CrcCache)$this$getCachedCrc.getUserData(CRC_CACHE);
        if (crcCache == null) {
            return null;
        }
        CrcCache crcCache2 = crcCache;
        long l = crcCache2.component1();
        long stamp = crcCache2.component2();
        if (stamp == modificationStamp) {
            void value2;
            return (long)value2;
        }
        return null;
    }

    private static final void setCachedCrc(UserDataHolder $this$setCachedCrc, long value2, long modificationStamp) {
        $this$setCachedCrc.putUserData(CRC_CACHE, (Object)new CrcCache(value2, modificationStamp));
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.util.CRC");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026externalSystem.util.CRC\")");
        LOG = logger;
        CRC_CACHE = new Key("com.intellij.openapi.externalSystem.util.CRC_CACHE");
    }

    public static final /* synthetic */ Long access$doCalculateCrc(Document $this$access_u24doCalculateCrc, Project project, ProjectSystemId systemId2, VirtualFile file2) {
        return CrcUtils.doCalculateCrc($this$access_u24doCalculateCrc, project, systemId2, file2);
    }

    public static final /* synthetic */ Long access$doCalculateCrc(VirtualFile $this$access_u24doCalculateCrc, Project project, ProjectSystemId systemId2) {
        return CrcUtils.doCalculateCrc($this$access_u24doCalculateCrc, project, systemId2);
    }
}

