/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.DeduplicateVisitorsSupplier;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger LOG = Logger.getInstance(ProjectDataManagerImpl.class);
    private static final Function<ProjectDataService<?, ?>, Key<?>> KEY_MAPPER = ProjectDataService::getTargetDataKey;

    public static ProjectDataManagerImpl getInstance() {
        ProjectDataManager service = (ProjectDataManager)ApplicationManager.getApplication().getService(ProjectDataManager.class);
        return (ProjectDataManagerImpl)service;
    }

    @NotNull
    public List<ProjectDataService<?, ?>> findService(@NotNull Key<?> key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(0);
        }
        ArrayList result2 = new ArrayList(ProjectDataService.EP_NAME.getByGroupingKey(key, ProjectDataManagerImpl.class, KEY_MAPPER));
        ExternalSystemApiUtil.orderAwareSort(result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(@NotNull Collection<? extends DataNode<?>> nodes, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        PerformanceTrace trace;
        ProjectSystemId projectSystemId;
        ProjectData projectData2;
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(3);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(4);
        }
        if (project.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData2 = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData2 = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project, projectSystemId);
        }
        SmartList onSuccessImportTasks = new SmartList();
        SmartList onFailureImportTasks = new SmartList();
        Collection traceNodes = grouped.get(PerformanceTrace.TRACE_NODE_KEY);
        if (traceNodes.size() > 0) {
            trace = (PerformanceTrace)((DataNode)traceNodes.iterator().next()).getData();
        } else {
            trace = new PerformanceTrace();
            grouped.putValue(PerformanceTrace.TRACE_NODE_KEY, (Object)new DataNode(PerformanceTrace.TRACE_NODE_KEY, (Object)trace, null));
        }
        long allStartTime = System.currentTimeMillis();
        Activity activity = StartUpMeasurer.startActivity((String)"project data importing total", (ActivityCategory)ActivityCategory.GRADLE_IMPORT);
        try {
            TreeSet allKeys = new TreeSet(grouped.keySet());
            ProjectDataService.EP_NAME.forEachExtensionSafe(dataService -> allKeys.add(dataService.getTargetDataKey()));
            ProgressIndicator indicator2 = ProgressManager.getInstance().getProgressIndicator();
            if (indicator2 != null) {
                indicator2.setIndeterminate(false);
            }
            int size = allKeys.size();
            int count = 0;
            SmartList postImportTasks = new SmartList();
            for (Key key : allKeys) {
                if (indicator2 != null) {
                    String message2 = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", ExternalSystemBundle.message((String)"progress.update.refresh", (Object[])new Object[]{ProjectDataManagerImpl.getReadableText(key)})});
                    indicator2.setText(message2);
                    indicator2.setFraction((double)count++ / (double)size);
                }
                long startTime = System.currentTimeMillis();
                this.doImportData(key, grouped.get((Object)key), projectData2, project, modelsProvider, (List<Runnable>)postImportTasks, (List<Runnable>)onSuccessImportTasks, (List<Runnable>)onFailureImportTasks);
                trace.logPerformance("Data import by " + key.toString(), System.currentTimeMillis() - startTime);
            }
            for (Runnable postImportTask : postImportTasks) {
                postImportTask.run();
            }
            ProjectDataManagerImpl.commit(modelsProvider, project, synchronous, "Imported data");
            if (indicator2 != null) {
                indicator2.setIndeterminate(true);
            }
            ((ProjectDataImportListener)project.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC)).onImportFinished(projectData2 != null ? projectData2.getLinkedExternalProjectPath() : null);
            activity.end();
            trace.logPerformance("Data import total", System.currentTimeMillis() - allStartTime);
        }
        catch (Throwable t) {
            ((ProjectDataImportListener)project.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC)).onImportFailed(projectData2 != null ? projectData2.getLinkedExternalProjectPath() : null);
            try {
                ProjectDataManagerImpl.runFinalTasks(project, synchronous, (List<? extends Runnable>)onFailureImportTasks);
                ProjectDataManagerImpl.dispose(modelsProvider, project, synchronous);
            }
            finally {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
            }
        }
        ProjectDataManagerImpl.runFinalTasks(project, synchronous, (List<? extends Runnable>)onSuccessImportTasks);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        StartUpPerformanceService.getInstance().reportStatistics(project);
    }

    private static void runFinalTasks(@NotNull Project project, boolean synchronous, final List<? extends Runnable> tasks) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(5);
        }
        DisposeAwareProjectChange runnable2 = new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                for (Runnable task2 : ContainerUtil.reverse((List)tasks)) {
                    task2.run();
                }
            }
        };
        if (synchronous) {
            try {
                runnable2.run();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        } else {
            ApplicationManager.getApplication().invokeLater((Runnable)runnable2);
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key<?> key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(6);
        }
        StringBuilder buffer = new StringBuilder();
        String s = key.toString();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char currChar = s.charAt(i2);
            if (Character.isUpperCase(currChar)) {
                if (i2 != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase((char)currChar));
                continue;
            }
            buffer.append(currChar);
        }
        String string = buffer.toString();
        if (string == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public <T> void importData(@NotNull Collection<? extends DataNode<T>> nodes, @NotNull Project project, boolean synchronous) {
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(8);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(9);
        }
        SmartList dummy = new SmartList();
        dummy.addAll(nodes);
        this.importData((Collection<? extends DataNode<?>>)dummy, project, this.createModifiableModelsProvider(project), synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(11);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(12);
        }
        SmartList dummy = new SmartList();
        dummy.add(node);
        this.importData((Collection<? extends DataNode<?>>)dummy, project, modelsProvider, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(14);
        }
        this.importData(node, project, this.createModifiableModelsProvider(project), synchronous);
    }

    private <T> void doImportData(@NotNull Key<T> key, @NotNull Collection<? extends DataNode<?>> nodes, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks, @NotNull List<Runnable> onFailureImportTasks) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(15);
        }
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(16);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(17);
        }
        if (modifiableModelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(18);
        }
        if (postImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(19);
        }
        if (onSuccessImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(20);
        }
        if (onFailureImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(21);
        }
        if (project.isDisposed()) {
            return;
        }
        SmartList toImport = new SmartList();
        SmartList toIgnore = new SmartList();
        for (DataNode<?> node : nodes) {
            if (!key.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse((Collection<? extends DataNode<?>>)toImport);
        @NotNull List<ProjectDataService<?, ?>> services = this.findService(key);
        if (services.isEmpty()) {
            LOG.debug(String.format("No data service is registered for %s", key));
        } else {
            for (ProjectDataService<?, ?> service : services) {
                long importStartTime = System.currentTimeMillis();
                service.importData((Collection)toImport, projectData2, project, modifiableModelsProvider);
                if (LOG.isDebugEnabled()) {
                    long importTimeInMs = System.currentTimeMillis() - importStartTime;
                    LOG.debug(String.format("Service %s imported data in %d ms", service.getClass().getSimpleName(), importTimeInMs));
                }
                if (projectData2 == null) continue;
                this.ensureTheDataIsReadyToUse((Collection<? extends DataNode<?>>)toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = service.computeOrphanData((Collection)toImport, projectData2, project, modifiableModelsProvider);
                service.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData2, project, modifiableModelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
        }
        if (!services.isEmpty() && projectData2 != null) {
            postImportTasks.add(() -> ProjectDataManagerImpl.lambda$doImportData$1(services, (Collection)toImport, projectData2, project, modifiableModelsProvider));
            onFailureImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    long taskStartTime = System.currentTimeMillis();
                    service.onFailureImport(project);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run failure import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onSuccessImportTasks.add(() -> ProjectDataManagerImpl.lambda$doImportData$3(project, services, (Collection)toImport, projectData2));
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode startNode) {
        if (startNode == null || startNode.isReady()) {
            return;
        }
        DeduplicateVisitorsSupplier supplier2 = new DeduplicateVisitorsSupplier();
        startNode.visit(dataNode -> {
            if (dataNode.validateData()) {
                dataNode.visitData(supplier2.getVisitor(dataNode.getKey()));
            }
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(22);
        }
        if (toRemove2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(23);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(24);
        }
        if (projectData2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(25);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(26);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(27);
        }
        try {
            List<ProjectDataService<?, ?>> services = this.findService(key);
            for (ProjectDataService<?, ?> service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData((Computable)new Computable.PredefinedValueComputable(toRemove2), toIgnore, projectData2, project, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManagerImpl.commit(modelsProvider, project, synchronous, "Removed data");
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.dispose(modelsProvider, project, synchronous);
            ExceptionUtil.rethrow((Throwable)t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(28);
        }
        if (toRemove2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(29);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(30);
        }
        if (projectData2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(31);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(32);
        }
        this.removeData(key, toRemove2, toIgnore, projectData2, project, this.createModifiableModelsProvider(project), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(33);
        }
        if (externalProjectInfo == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(34);
        }
        if (!project.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(35);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(36);
        }
        if (externalProjectPath == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(37);
        }
        return !project.isDisposed() ? ExternalProjectsDataStorage.getInstance(project).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(38);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(39);
        }
        if (!project.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project).list(projectSystemId);
            if (collection == null) {
                ProjectDataManagerImpl.$$$reportNull$$$0(40);
            }
            return collection;
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(41);
        }
        return list2;
    }

    @NotNull
    public IdeModifiableModelsProvider createModifiableModelsProvider(@NotNull Project project) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(42);
        }
        return new IdeModifiableModelsProviderImpl(project);
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<? extends DataNode<?>> nodes) {
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(43);
        }
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private static void commit(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous, final @NotNull String commitDesc) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(44);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(45);
        }
        if (commitDesc == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(46);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                long startTime = System.currentTimeMillis();
                modelsProvider.commit();
                long timeInMs = System.currentTimeMillis() - startTime;
                LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
            }
        });
    }

    private static void dispose(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(47);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(48);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }

    private static /* synthetic */ void lambda$doImportData$3(Project project, List services, Collection toImport, ProjectData projectData2) {
        IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project);
        for (ProjectDataService service : services) {
            long taskStartTime = System.currentTimeMillis();
            service.onSuccessImport(toImport, projectData2, project, (IdeModelsProvider)modelsProvider);
            if (!LOG.isDebugEnabled()) continue;
            long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
            LOG.debug(String.format("Service %s run success import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
        }
    }

    private static /* synthetic */ void lambda$doImportData$1(List services, Collection toImport, ProjectData projectData2, Project project, IdeModifiableModelsProvider modifiableModelsProvider) {
        for (ProjectDataService service : services) {
            long taskStartTime = System.currentTimeMillis();
            service.postProcess(toImport, projectData2, project, modifiableModelsProvider);
            if (!LOG.isDebugEnabled()) continue;
            long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
            LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 7: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 26: 
            case 32: 
            case 33: 
            case 35: 
            case 38: 
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 12: 
            case 27: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postImportTasks";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessImportTasks";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailureImportTasks";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableText";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 1: 
            case 7: 
            case 40: 
            case 41: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runFinalTasks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReadableText";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doImportData";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateExternalProjectData";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectData";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsData";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createModifiableModelsProvider";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "ensureTheDataIsReadyToUse";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

