/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.service.project.manage.LibraryDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483618)
public class LibraryDependencyDataService
extends AbstractDependencyDataService<LibraryDependencyData, LibraryOrderEntry> {
    private static final Logger LOG = Logger.getInstance(LibraryDependencyDataService.class);

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    @NotNull
    public Class<LibraryOrderEntry> getOrderEntryType() {
        return LibraryOrderEntry.class;
    }

    @Override
    protected Map<OrderEntry, OrderAware> importData(@NotNull Collection<? extends DataNode<LibraryDependencyData>> nodesToImport, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (nodesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(1);
        }
        if (module == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(3);
        }
        HashMap<Set<String>, LibraryDependencyData> moduleLibrariesToImport = new HashMap<Set<String>, LibraryDependencyData>();
        HashMap<String, LibraryDependencyData> projectLibrariesToImport = new HashMap<String, LibraryDependencyData>();
        LinkedHashSet<LibraryDependencyData> toImport = new LinkedHashSet<LibraryDependencyData>();
        LinkedHashMap<OrderEntry, OrderAware> orderEntryDataMap = new LinkedHashMap<OrderEntry, OrderAware>();
        boolean hasUnresolved = false;
        for (DataNode<LibraryDependencyData> dataNode : nodesToImport) {
            LibraryDependencyData dependencyData = (LibraryDependencyData)dataNode.getData();
            LibraryData libraryData = (LibraryData)dependencyData.getTarget();
            hasUnresolved |= libraryData.isUnresolved();
            switch (dependencyData.getLevel()) {
                case MODULE: {
                    HashSet<CallSite> paths = new HashSet<CallSite>();
                    for (String path2 : libraryData.getPaths(LibraryPathType.BINARY)) {
                        paths.add((CallSite)((Object)(ExternalSystemApiUtil.toCanonicalPath((String)path2) + dependencyData.getScope().name())));
                    }
                    moduleLibrariesToImport.put(paths, dependencyData);
                    toImport.add(dependencyData);
                    break;
                }
                case PROJECT: {
                    projectLibrariesToImport.put(libraryData.getInternalName() + dependencyData.getScope().name(), dependencyData);
                    toImport.add(dependencyData);
                }
            }
        }
        boolean finalHasUnresolved = hasUnresolved;
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        LibraryTable moduleLibraryTable = modifiableRootModel.getModuleLibraryTable();
        LibraryDependencyDataService.syncExistingAndRemoveObsolete(modelsProvider, moduleLibrariesToImport, projectLibrariesToImport, toImport, orderEntryDataMap, modifiableRootModel, finalHasUnresolved);
        if (!toImport.isEmpty()) {
            LibraryDependencyDataService.importMissing(modelsProvider, toImport, orderEntryDataMap, modifiableRootModel, moduleLibraryTable, module);
        }
        return orderEntryDataMap;
    }

    private static void importMissing(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Set<LibraryDependencyData> toImport, @NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel moduleRootModel, @NotNull LibraryTable moduleLibraryTable, @NotNull Module module) {
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(4);
        }
        if (toImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(5);
        }
        if (orderEntryDataMap == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(6);
        }
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(7);
        }
        if (moduleLibraryTable == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(8);
        }
        if (module == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(9);
        }
        for (LibraryDependencyData dependencyData : toImport) {
            LibraryData libraryData = (LibraryData)dependencyData.getTarget();
            String libraryName = libraryData.getInternalName();
            switch (dependencyData.getLevel()) {
                case MODULE: {
                    Library moduleLib = libraryName.isEmpty() ? moduleLibraryTable.createLibrary() : moduleLibraryTable.createLibrary(libraryName);
                    LibraryOrderEntry existingLibraryDependency = LibraryDependencyDataService.syncExistingLibraryDependency(modelsProvider, dependencyData, moduleLib, moduleRootModel, module);
                    orderEntryDataMap.put((OrderEntry)existingLibraryDependency, (OrderAware)dependencyData);
                    break;
                }
                case PROJECT: {
                    Library projectLib = modelsProvider.getLibraryByName(libraryName);
                    if (projectLib == null) {
                        LibraryOrderEntry existingProjectLibraryDependency = LibraryDependencyDataService.syncExistingLibraryDependency(modelsProvider, dependencyData, moduleLibraryTable.createLibrary(libraryName), moduleRootModel, module);
                        orderEntryDataMap.put((OrderEntry)existingProjectLibraryDependency, (OrderAware)dependencyData);
                        break;
                    }
                    LibraryOrderEntry orderEntry = moduleRootModel.addLibraryEntry(projectLib);
                    LibraryDependencyDataService.setLibraryScope(orderEntry, projectLib, module, dependencyData);
                    ModuleOrderEntry substitutionEntry = modelsProvider.trySubstitute(module, orderEntry, (ProjectCoordinate)libraryData);
                    if (substitutionEntry != null) {
                        orderEntryDataMap.put((OrderEntry)substitutionEntry, (OrderAware)dependencyData);
                        break;
                    }
                    orderEntryDataMap.put((OrderEntry)orderEntry, (OrderAware)dependencyData);
                }
            }
        }
    }

    private static void setLibraryScope(@NotNull LibraryOrderEntry orderEntry, @NotNull Library lib, @NotNull Module module, @NotNull LibraryDependencyData dependencyData) {
        if (orderEntry == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(10);
        }
        if (lib == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(11);
        }
        if (module == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(12);
        }
        if (dependencyData == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(13);
        }
        orderEntry.setExported(dependencyData.isExported());
        orderEntry.setScope(dependencyData.getScope());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Configuring library '%s' of module '%s' to be%s exported and have scope %s", lib, module.getName(), dependencyData.isExported() ? " not" : "", dependencyData.getScope()));
        }
    }

    private static void syncExistingAndRemoveObsolete(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<Set<String>, LibraryDependencyData> moduleLibrariesToImport, @NotNull Map<String, LibraryDependencyData> projectLibrariesToImport, @NotNull Set<LibraryDependencyData> toImport, @NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel moduleRootModel, boolean hasUnresolvedLibraries) {
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(14);
        }
        if (moduleLibrariesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(15);
        }
        if (projectLibrariesToImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(16);
        }
        if (toImport == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(17);
        }
        if (orderEntryDataMap == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(18);
        }
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(19);
        }
        for (OrderEntry entry2 : moduleRootModel.getOrderEntries()) {
            if (OrderEntryUtil.isModuleLibraryOrderEntry(entry2)) {
                LibraryOrderEntry moduleLibraryOrderEntry = (LibraryOrderEntry)entry2;
                Library library2 = moduleLibraryOrderEntry.getLibrary();
                VirtualFile[] libraryFiles = library2.getFiles(OrderRootType.CLASSES);
                HashSet<CallSite> moduleLibraryKey = new HashSet<CallSite>(libraryFiles.length);
                for (VirtualFile file2 : libraryFiles) {
                    moduleLibraryKey.add((CallSite)((Object)(ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2) + moduleLibraryOrderEntry.getScope().name())));
                }
                LibraryDependencyData existing = moduleLibrariesToImport.remove(moduleLibraryKey);
                if (existing == null || !StringUtil.equals((CharSequence)StringUtil.nullize((String)existing.getInternalName()), (CharSequence)library2.getName())) {
                    moduleRootModel.removeOrderEntry(entry2);
                    continue;
                }
                orderEntryDataMap.put(entry2, (OrderAware)existing);
                LibraryDependencyDataService.syncExistingLibraryDependency(modelsProvider, existing, library2, moduleRootModel, moduleLibraryOrderEntry.getOwnerModule());
                toImport.remove(existing);
                continue;
            }
            if (!(entry2 instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry2;
            String libraryName = libraryOrderEntry.getLibraryName();
            LibraryDependencyData existing = projectLibrariesToImport.remove(libraryName + libraryOrderEntry.getScope().name());
            if (existing != null) {
                String module = modelsProvider.findModuleByPublication((ProjectCoordinate)existing.getTarget());
                if (module == null) {
                    toImport.remove(existing);
                    orderEntryDataMap.put(entry2, (OrderAware)existing);
                    libraryOrderEntry.setExported(existing.isExported());
                    libraryOrderEntry.setScope(existing.getScope());
                    continue;
                }
                moduleRootModel.removeOrderEntry(entry2);
                continue;
            }
            if (hasUnresolvedLibraries) continue;
            moduleRootModel.removeOrderEntry(entry2);
        }
    }

    private static LibraryOrderEntry syncExistingLibraryDependency(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependencyData libraryDependencyData, @NotNull Library library2, @NotNull ModifiableRootModel moduleRootModel, @NotNull Module module) {
        if (modelsProvider == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(20);
        }
        if (libraryDependencyData == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(21);
        }
        if (library2 == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(22);
        }
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(23);
        }
        if (module == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(24);
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library2);
        String libraryName = libraryDependencyData.getInternalName();
        LibraryData libraryDependencyDataTarget = (LibraryData)libraryDependencyData.getTarget();
        Map<OrderRootType, Collection<File>> files2 = ((LibraryDataService)((Object)ProjectDataService.EP_NAME.findExtensionOrFail(LibraryDataService.class))).prepareLibraryFiles(libraryDependencyDataTarget);
        Set excludedPaths = libraryDependencyDataTarget.getPaths(LibraryPathType.EXCLUDED);
        LibraryDataService.registerPaths(libraryDependencyDataTarget.isUnresolved(), files2, excludedPaths, libraryModel, libraryName);
        LibraryOrderEntry orderEntry = LibraryDependencyDataService.findLibraryOrderEntry(moduleRootModel, library2, libraryDependencyData.getScope());
        assert (orderEntry != null);
        LibraryDependencyDataService.setLibraryScope(orderEntry, library2, module, libraryDependencyData);
        return orderEntry;
    }

    @Nullable
    private static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModifiableRootModel moduleRootModel, @NotNull Library library2, @NotNull DependencyScope scope2) {
        if (moduleRootModel == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(25);
        }
        if (library2 == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(26);
        }
        if (scope2 == null) {
            LibraryDependencyDataService.$$$reportNull$$$0(27);
        }
        LibraryOrderEntry candidate = null;
        for (OrderEntry orderEntry : moduleRootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            if (library2 == libraryOrderEntry.getLibrary()) {
                return libraryOrderEntry;
            }
            if (!library2.equals(libraryOrderEntry.getLibrary()) || candidate != null && libraryOrderEntry.getScope() != scope2) continue;
            candidate = libraryOrderEntry;
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToImport";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryDataMap";
                break;
            }
            case 7: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRootModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLibraryTable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyData";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLibrariesToImport";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLibrariesToImport";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDependencyData";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "importMissing";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setLibraryScope";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "syncExistingAndRemoveObsolete";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "syncExistingLibraryDependency";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryOrderEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

