/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483618)
public abstract class AbstractDependencyDataService<E extends AbstractDependencyData<?>, I extends ExportableOrderEntry>
extends AbstractProjectDataService<E, I> {
    private static final Logger LOG = Logger.getInstance((String)AbstractDependencyDataService.class.getName());

    public void importData(@NotNull Collection<? extends DataNode<E>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(2);
        }
        if (toImport.isEmpty()) {
            return;
        }
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        for (Map.Entry entry2 : byModule.entrySet()) {
            DataNode moduleDataNode = (DataNode)entry2.getKey();
            Module module = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            if (module == null) {
                LOG.warn(String.format("Can't import dependencies %s. Reason: target module (%s) is not found at the ide and can't be imported", entry2.getValue(), moduleDataNode));
                continue;
            }
            Map<OrderEntry, OrderAware> moduleDependenciesOrder = this.importData((Collection)entry2.getValue(), module, modelsProvider);
            Map orderEntryDataMap = (Map)moduleDataNode.getUserData(AbstractModuleDataService.ORDERED_DATA_MAP_KEY);
            if (orderEntryDataMap != null) {
                orderEntryDataMap.putAll(moduleDependenciesOrder);
                continue;
            }
            moduleDataNode.putUserData(AbstractModuleDataService.ORDERED_DATA_MAP_KEY, moduleDependenciesOrder);
        }
    }

    protected abstract Map<OrderEntry, OrderAware> importData(@NotNull Collection<? extends DataNode<E>> var1, @NotNull Module var2, @NotNull IdeModifiableModelsProvider var3);

    @NotNull
    public Computable<Collection<I>> computeOrphanData(@NotNull Collection<? extends DataNode<E>> toImport, @NotNull ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(3);
        }
        if (projectData2 == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(4);
        }
        if (project == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(6);
        }
        Computable computable = () -> {
            MultiMap byModuleName = MultiMap.create();
            for (DataNode node : toImport) {
                String depName;
                AbstractDependencyData data2 = (AbstractDependencyData)node.getData();
                Module ownerModule = modelsProvider.findIdeModule(data2.getOwnerModule());
                if (ownerModule == null && modelsProvider.getUnloadedModuleDescription(data2.getOwnerModule()) != null) continue;
                assert (ownerModule != null);
                if (data2 instanceof ModuleDependencyData) {
                    Module targetModule = modelsProvider.findIdeModule((ModuleData)((ModuleDependencyData)data2).getTarget());
                    if (targetModule == null && modelsProvider.getUnloadedModuleDescription((ModuleData)((ModuleDependencyData)data2).getTarget()) != null) continue;
                    assert (targetModule != null);
                    depName = targetModule.getName();
                } else {
                    depName = AbstractDependencyDataService.getInternalName(data2);
                }
                byModuleName.putValue((Object)ownerModule.getName(), (Object)depName);
            }
            ModifiableModuleModel modifiableModuleModel = modelsProvider.getModifiableModuleModel();
            SmartList orphanEntries = new SmartList();
            for (Module module : modelsProvider.getModules(projectData2)) {
                for (OrderEntry entry2 : modelsProvider.getOrderEntries(module)) {
                    String moduleName;
                    if (entry2 instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry2).getLibraryName() == null && entry2.getUrls(OrderRootType.CLASSES).length == 0 || !this.getOrderEntryType().isInstance(entry2) || byModuleName.get((Object)(moduleName = modifiableModuleModel.getActualName(entry2.getOwnerModule()))).contains(this.getOrderEntryName(modelsProvider, (ExportableOrderEntry)entry2))) continue;
                    orphanEntries.add((ExportableOrderEntry)entry2);
                }
            }
            return orphanEntries;
        };
        if (computable == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(7);
        }
        return computable;
    }

    @NotNull
    protected abstract Class<I> getOrderEntryType();

    protected String getOrderEntryName(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull I orderEntry) {
        if (modelsProvider == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(8);
        }
        if (orderEntry == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(9);
        }
        return orderEntry.getPresentableName();
    }

    public void removeData(Computable<? extends Collection<? extends I>> toRemoveComputable, @NotNull Collection<? extends DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toIgnore == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(10);
        }
        if (projectData2 == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(11);
        }
        if (project == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(12);
        }
        if (modelsProvider == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(13);
        }
        Map<Module, Collection<ExportableOrderEntry>> byModule = AbstractDependencyDataService.groupByModule((Collection)toRemoveComputable.compute());
        for (Map.Entry<Module, Collection<ExportableOrderEntry>> entry2 : byModule.entrySet()) {
            this.removeData(entry2.getValue(), entry2.getKey(), modelsProvider);
        }
    }

    @NotNull
    private static Map<Module, Collection<ExportableOrderEntry>> groupByModule(@NotNull Collection<? extends ExportableOrderEntry> data2) {
        if (data2 == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(14);
        }
        HashMap<Module, Collection<ExportableOrderEntry>> result2 = new HashMap<Module, Collection<ExportableOrderEntry>>();
        for (ExportableOrderEntry exportableOrderEntry : data2) {
            ArrayList<ExportableOrderEntry> entries2 = (ArrayList<ExportableOrderEntry>)result2.get(exportableOrderEntry.getOwnerModule());
            if (entries2 == null) {
                entries2 = new ArrayList<ExportableOrderEntry>();
                result2.put(exportableOrderEntry.getOwnerModule(), entries2);
            }
            entries2.add(exportableOrderEntry);
        }
        HashMap<Module, Collection<ExportableOrderEntry>> hashMap = result2;
        if (hashMap == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    protected void removeData(@NotNull Collection<? extends ExportableOrderEntry> toRemove2, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove2 == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(16);
        }
        if (module == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(17);
        }
        if (modelsProvider == null) {
            AbstractDependencyDataService.$$$reportNull$$$0(18);
        }
        if (toRemove2.isEmpty()) {
            return;
        }
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        for (ExportableOrderEntry exportableOrderEntry : toRemove2) {
            modifiableRootModel.removeOrderEntry((OrderEntry)exportableOrderEntry);
        }
    }

    private static String getInternalName(AbstractDependencyData<?> data2) {
        if (data2 instanceof LibraryDependencyData) {
            String name = data2.getInternalName();
            if (StringUtil.isNotEmpty((String)name)) {
                return name;
            }
            Set paths = ((LibraryData)((LibraryDependencyData)data2).getTarget()).getPaths(LibraryPathType.BINARY);
            if (!paths.isEmpty()) {
                String url = (String)paths.iterator().next();
                return PathUtil.toPresentableUrl((String)url);
            }
            return ProjectModelBundle.message((String)"empty.library.title", (Object[])new Object[0]);
        }
        return data2.getInternalName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOrphanData";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeOrphanData";
                break;
            }
            case 7: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntryName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "groupByModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

