/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.externalSystem.service.project.ModifiableModel;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.facet.FacetManagerBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModuleRootComponentBridge;
import com.intellij.workspaceModel.ide.legacyBridge.LibraryModifiableModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableFacetModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableModuleModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableRootModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ProjectLibraryTableBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ProjectModifiableLibraryTableBridge;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModifiableModelsProviderImpl
extends AbstractIdeModifiableModelsProvider {
    public static final Key<IdeModifiableModelsProviderImpl> MODIFIABLE_MODELS_PROVIDER_KEY = Key.create((String)"IdeModelsProvider");
    private LibraryTable.ModifiableModel myLibrariesModel;
    private WorkspaceEntityStorage initialStorage;
    private WorkspaceEntityStorageBuilder diff;

    public IdeModifiableModelsProviderImpl(Project project) {
        super(project);
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableProjectLibrariesModel() {
        if (this.myLibrariesModel != null) {
            LibraryTable.ModifiableModel modifiableModel = this.myLibrariesModel;
            if (modifiableModel == null) {
                IdeModifiableModelsProviderImpl.$$$reportNull$$$0(0);
            }
            return modifiableModel;
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        this.myLibrariesModel = ((ProjectLibraryTableBridge)libraryTable).getModifiableModel(this.getActualStorageBuilder());
        if (this.myLibrariesModel == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(1);
        }
        return this.myLibrariesModel;
    }

    @Override
    protected ModifiableModuleModel doGetModifiableModuleModel() {
        return (ModifiableModuleModel)ReadAction.compute(() -> {
            Module[] modules2;
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            ModifiableModuleModel modifiableModel = ((ModuleManagerBridgeImpl)moduleManager).getModifiableModel(this.getActualStorageBuilder());
            for (Module module : modules2 = modifiableModel.getModules()) {
                this.setIdeModelsProviderForModule(module);
            }
            return modifiableModel;
        });
    }

    @Override
    @NotNull
    protected ModifiableRootModel doGetModifiableRootModel(@NotNull Module module) {
        if (module == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(2);
        }
        RootConfigurationAccessor rootConfigurationAccessor = new RootConfigurationAccessor(){

            @Override
            @Nullable
            public Library getLibrary(Library library2, String libraryName, String libraryLevel) {
                if ("project".equals(libraryLevel)) {
                    return IdeModifiableModelsProviderImpl.this.getModifiableProjectLibrariesModel().getLibraryByName(libraryName);
                }
                return library2;
            }
        };
        ModifiableRootModel modifiableRootModel = (ModifiableRootModel)ReadAction.compute(() -> {
            ModuleRootManagerEx rootManager = ModuleRootManagerEx.getInstanceEx(module);
            return ((ModuleRootComponentBridge)rootManager).getModifiableModel(this.getActualStorageBuilder(), this.initialStorage, rootConfigurationAccessor);
        });
        if (modifiableRootModel == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(3);
        }
        return modifiableRootModel;
    }

    @Override
    protected ModifiableFacetModel doGetModifiableFacetModel(Module module) {
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        return ((FacetManagerBridge)facetManager).createModifiableModel(this.getActualStorageBuilder());
    }

    @Override
    protected Library.ModifiableModel doGetModifiableLibraryModel(Library library2) {
        return ((LibraryBridge)library2).getModifiableModel(this.getActualStorageBuilder());
    }

    @Override
    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(4);
        }
        Module module = super.newModule(filePath, moduleTypeId);
        this.setIdeModelsProviderForModule(module);
        Module module2 = module;
        if (module2 == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(5);
        }
        return module2;
    }

    @Override
    @NotNull
    public Module newModule(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(6);
        }
        Module module = super.newModule(moduleData);
        this.setIdeModelsProviderForModule(module);
        Module module2 = module;
        if (module2 == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(7);
        }
        return module2;
    }

    @Override
    public void commit() {
        this.workspaceModelCommit();
    }

    private void workspaceModelCommit() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            ModifiableRootModel[] rootModels;
            if (ExternalProjectsWorkspaceImpl.isDependencySubstitutionEnabled()) {
                this.updateSubstitutions();
            }
            LibraryTable.ModifiableModel projectLibrariesModel = this.getModifiableProjectLibrariesModel();
            for (Map.Entry entry3 : this.myModifiableLibraryModels.entrySet()) {
                Library library2 = (Library)entry3.getKey();
                String libraryName = library2.getName();
                Library.ModifiableModel modifiableModel = (Library.ModifiableModel)entry3.getValue();
                if (library2 instanceof LibraryEx && ((LibraryEx)library2).isDisposed() || library2.getTable() != null && libraryName != null && projectLibrariesModel.getLibraryByName(libraryName) == null || this.getModifiableWorkspace() != null && this.getModifiableWorkspace().isSubstituted(library2.getName())) {
                    Disposer.dispose((Disposable)modifiableModel);
                    continue;
                }
                ((LibraryModifiableModelBridge)modifiableModel).prepareForCommit();
            }
            ((ProjectModifiableLibraryTableBridge)projectLibrariesModel).prepareForCommit();
            if (this.myModifiableModuleModel != null) {
                Object[] modules2;
                for (Object module : modules2 = this.myModifiableModuleModel.getModules()) {
                    module.putUserData(MODIFIABLE_MODELS_PROVIDER_KEY, null);
                }
                Set set2 = ContainerUtil.set((Object[])modules2);
                rootModels = (ModifiableRootModel[])this.myModifiableRootModels.entrySet().stream().filter(entry2 -> existingModules.contains(entry2.getKey())).map(Map.Entry::getValue).toArray(ModifiableRootModel[]::new);
                ((ModifiableModuleModelBridge)this.myModifiableModuleModel).prepareForCommit();
            } else {
                rootModels = this.myModifiableRootModels.values().toArray(new ModifiableRootModel[0]);
            }
            for (ModifiableRootModel model2 : rootModels) {
                assert (!model2.isDisposed()) : "Already disposed: " + model2;
            }
            for (ModifiableRootModel model3 : rootModels) {
                ((ModifiableRootModelBridge)model3).prepareForCommit();
            }
            for (Map.Entry entry3 : this.myProductionModulesForTestModules.entrySet()) {
                TestModuleProperties.getInstance((Module)entry3.getKey()).setProductionModuleName((String)entry3.getValue());
            }
            for (Map.Entry entry4 : this.myModifiableFacetModels.entrySet()) {
                if (((Module)entry4.getKey()).isDisposed()) continue;
                ((ModifiableFacetModelBridge)entry4.getValue()).prepareForCommit();
            }
            this.myModifiableModels.values().forEach(ModifiableModel::commit);
            WorkspaceModel.getInstance(this.myProject).updateProjectModel(builder2 -> {
                builder2.addDiff(this.getActualStorageBuilder());
                return null;
            });
            for (ModifiableRootModel model4 : rootModels) {
                ((ModifiableRootModelBridge)model4).postCommit();
            }
        });
        this.myUserData.clear();
    }

    @Override
    public void dispose() {
        if (this.myModifiableModuleModel != null) {
            Module[] modules2;
            for (Module module : modules2 = this.myModifiableModuleModel.getModules()) {
                module.putUserData(MODIFIABLE_MODELS_PROVIDER_KEY, null);
            }
        }
        super.dispose();
    }

    public WorkspaceEntityStorageBuilder getActualStorageBuilder() {
        if (this.diff != null) {
            return this.diff;
        }
        this.initialStorage = WorkspaceModel.getInstance(this.myProject).getEntityStorage().getCurrent();
        this.diff = WorkspaceEntityStorageBuilder.from(this.initialStorage);
        return this.diff;
    }

    private void setIdeModelsProviderForModule(@NotNull Module module) {
        if (module == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(8);
        }
        module.putUserData(MODIFIABLE_MODELS_PROVIDER_KEY, (Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProviderImpl";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableProjectLibrariesModel";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProviderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetModifiableRootModel";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGetModifiableRootModel";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setIdeModelsProviderForModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

