/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectRefreshListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemSettingsFilesReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ProjectSettingsTracker;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.changes.AsyncFilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.NewFilesListener;
import com.intellij.openapi.externalSystem.autoimport.settings.CachingAsyncSupplier;
import com.intellij.openapi.externalSystem.autoimport.settings.EdtAsyncSupplier;
import com.intellij.openapi.externalSystem.autoimport.settings.ReadAsyncSupplier;
import com.intellij.openapi.externalSystem.util.CrcUtils;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.operations.AnonymousParallelOperationTrace;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 <2\u00020\u0001:\u0005<=>?@B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aJ\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\u0014\u0010\u001d\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&H\u0002J0\u0010'\u001a\u00020\u00112\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0#2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0#H\u0002J\b\u0010*\u001a\u0004\u0018\u00010+J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020/J\u0006\u00104\u001a\u00020\u0018J0\u00105\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u00012\u001e\u00107\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0#\u0012\u0004\u0012\u00020\u001808H\u0002J>\u00105\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u00012\f\u00109\u001a\b\u0012\u0004\u0012\u00020$0&2\u001e\u00107\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0#\u0012\u0004\u0012\u00020\u001808H\u0002J\"\u0010:\u001a\u00020\u00182\u0018\u00107\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0&\u0012\u0004\u0012\u00020\u001808H\u0002J0\u0010;\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u00012\u001e\u00107\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0#\u0012\u0004\u0012\u00020\u001808H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "projectTracker", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;", "backgroundExecutor", "Ljava/util/concurrent/Executor;", "projectAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;Ljava/util/concurrent/Executor;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;Lcom/intellij/openapi/Disposable;)V", "applyChangesOperation", "Lcom/intellij/openapi/observable/operations/AnonymousParallelOperationTrace;", "settingsFilesStatus", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesStatus;", "kotlin.jvm.PlatformType", "settingsProvider", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$ProjectSettingsProvider;", "status", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;", "afterApplyChanges", "", "listener", "Lkotlin/Function0;", "applyChanges", "applyUnknownChanges", "beforeApplyChanges", "calculateCrc", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "calculateSettingsFilesCRC", "", "", "settingsFiles", "", "createSettingsFilesStatus", "oldSettingsFilesCRC", "newSettingsFilesCRC", "getModificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "getSettingsContext", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesReloadContext;", "getState", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "isUpToDate", "", "loadState", "state", "refreshChanges", "submitSettingsFilesCRCCalculation", "id", "callback", "Lkotlin/Function1;", "settingsPaths", "submitSettingsFilesRefresh", "submitSettingsFilesRefreshAndCRCCalculation", "Companion", "ProjectSettingsListener", "ProjectSettingsProvider", "SettingsFilesStatus", "State", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class ProjectSettingsTracker {
    private final ProjectStatus status;
    private final AtomicReference<SettingsFilesStatus> settingsFilesStatus;
    private final AnonymousParallelOperationTrace applyChangesOperation;
    private final ProjectSettingsProvider settingsProvider;
    private final Project project;
    private final AutoImportProjectTracker projectTracker;
    private final Executor backgroundExecutor;
    private final ExternalSystemProjectAware projectAware;
    private final Disposable parentDisposable;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final Map<String, Long> calculateSettingsFilesCRC(Set<String> settingsFiles) {
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        Iterable $this$mapNotNull$iv = settingsFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<VirtualFile> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile virtualFile2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (localFileSystem2.findFileByPath(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            VirtualFile it$iv$iv = virtualFile2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
            Pair pair = TuplesKt.to((Object)virtualFile3.getPath(), (Object)this.calculateCrc(it));
            boolean bl6 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private final long calculateCrc(VirtualFile file2) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document = fileDocumentManager2.getCachedDocument(file2);
        if (document != null) {
            return CrcUtils.calculateCrc(document, this.project, this.projectAware.getProjectId().getSystemId(), file2);
        }
        return CrcUtils.calculateCrc(file2, this.project, this.projectAware.getProjectId().getSystemId());
    }

    public final boolean isUpToDate() {
        return this.status.isUpToDate();
    }

    @Nullable
    public final ProjectStatus.ModificationType getModificationType() {
        return this.status.getModificationType();
    }

    @NotNull
    public final ExternalSystemSettingsFilesReloadContext getSettingsContext() {
        SettingsFilesStatus settingsFilesStatus2 = this.settingsFilesStatus.get();
        Intrinsics.checkNotNullExpressionValue((Object)settingsFilesStatus2, (String)"settingsFilesStatus.get()");
        return settingsFilesStatus2;
    }

    /*
     * WARNING - void declaration
     */
    private final SettingsFilesStatus createSettingsFilesStatus(Map<String, Long> oldSettingsFilesCRC, Map<String, Long> newSettingsFilesCRC) {
        void $this$filterTo$iv;
        Iterable iterable = CollectionsKt.intersect((Iterable)oldSettingsFilesCRC.keySet(), (Iterable)newSettingsFilesCRC.keySet());
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)oldSettingsFilesCRC.get(it), (Object)newSettingsFilesCRC.get(it)) ^ true)) continue;
            destination$iv.add(element$iv);
        }
        HashSet updatedFiles = (HashSet)destination$iv;
        Set createdFiles = SetsKt.minus(newSettingsFilesCRC.keySet(), (Iterable)oldSettingsFilesCRC.keySet());
        Set deletedFiles = SetsKt.minus(oldSettingsFilesCRC.keySet(), (Iterable)newSettingsFilesCRC.keySet());
        return new SettingsFilesStatus(oldSettingsFilesCRC, newSettingsFilesCRC, updatedFiles, createdFiles, deletedFiles);
    }

    private final void applyChanges() {
        this.applyChangesOperation.startTask();
        this.submitSettingsFilesRefreshAndCRCCalculation("applyChanges", (Function1<? super Map<String, Long>, Unit>)((Function1)new Function1<Map<String, ? extends Long>, Unit>(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            public final void invoke(@NotNull Map<String, Long> newSettingsFilesCRC) {
                Intrinsics.checkNotNullParameter(newSettingsFilesCRC, (String)"newSettingsFilesCRC");
                ProjectSettingsTracker.access$getSettingsFilesStatus$p(this.this$0).set(new SettingsFilesStatus(newSettingsFilesCRC));
                ProjectSettingsTracker.access$getStatus$p(this.this$0).markSynchronized(LocalTimeCounter.currentTime());
                ProjectSettingsTracker.access$getApplyChangesOperation$p(this.this$0).finishTask();
            }
            {
                this.this$0 = projectSettingsTracker;
                super(1);
            }
        }));
    }

    private final void applyUnknownChanges() {
        this.applyChangesOperation.startTask();
        this.submitSettingsFilesRefreshAndCRCCalculation("applyUnknownChanges", (Function1<? super Map<String, Long>, Unit>)((Function1)new Function1<Map<String, ? extends Long>, Unit>(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            public final void invoke(@NotNull Map<String, Long> newSettingsFilesCRC) {
                Intrinsics.checkNotNullParameter(newSettingsFilesCRC, (String)"newSettingsFilesCRC");
                SettingsFilesStatus settingsFilesStatus2 = (SettingsFilesStatus)ProjectSettingsTracker.access$getSettingsFilesStatus$p(this.this$0).updateAndGet(new UnaryOperator(this, newSettingsFilesCRC){
                    final /* synthetic */ applyUnknownChanges.1 this$0;
                    final /* synthetic */ Map $newSettingsFilesCRC;

                    public final SettingsFilesStatus apply(SettingsFilesStatus it) {
                        return ProjectSettingsTracker.access$createSettingsFilesStatus(this.this$0.this$0, MapsKt.plus((Map)this.$newSettingsFilesCRC, it.getOldCRC()), this.$newSettingsFilesCRC);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$newSettingsFilesCRC = map2;
                    }
                });
                if (!settingsFilesStatus2.hasChanges()) {
                    ProjectSettingsTracker.access$getStatus$p(this.this$0).markSynchronized(LocalTimeCounter.currentTime());
                }
                ProjectSettingsTracker.access$getApplyChangesOperation$p(this.this$0).finishTask();
            }
            {
                this.this$0 = projectSettingsTracker;
                super(1);
            }
        }));
    }

    public final void refreshChanges() {
        this.submitSettingsFilesRefreshAndCRCCalculation("refreshChanges", (Function1<? super Map<String, Long>, Unit>)((Function1)new Function1<Map<String, ? extends Long>, Unit>(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            public final void invoke(@NotNull Map<String, Long> newSettingsFilesCRC) {
                Intrinsics.checkNotNullParameter(newSettingsFilesCRC, (String)"newSettingsFilesCRC");
                SettingsFilesStatus settingsFilesStatus2 = (SettingsFilesStatus)ProjectSettingsTracker.access$getSettingsFilesStatus$p(this.this$0).updateAndGet(new UnaryOperator(this, newSettingsFilesCRC){
                    final /* synthetic */ refreshChanges.1 this$0;
                    final /* synthetic */ Map $newSettingsFilesCRC;

                    public final SettingsFilesStatus apply(SettingsFilesStatus it) {
                        return ProjectSettingsTracker.access$createSettingsFilesStatus(this.this$0.this$0, it.getOldCRC(), this.$newSettingsFilesCRC);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$newSettingsFilesCRC = map2;
                    }
                });
                ProjectSettingsTracker.access$getLOG$cp().info("Settings file status: " + settingsFilesStatus2);
                boolean bl = settingsFilesStatus2.hasChanges();
                if (bl) {
                    ProjectSettingsTracker.access$getStatus$p(this.this$0).markDirty(LocalTimeCounter.currentTime(), ProjectStatus.ModificationType.EXTERNAL);
                } else {
                    ProjectSettingsTracker.access$getStatus$p(this.this$0).markReverted(LocalTimeCounter.currentTime());
                }
                ProjectSettingsTracker.access$getProjectTracker$p(this.this$0).scheduleChangeProcessing();
            }
            {
                this.this$0 = projectSettingsTracker;
                super(1);
            }
        }));
    }

    @NotNull
    public final State getState() {
        return new State(this.status.isDirty(), MapsKt.toMap(this.settingsFilesStatus.get().getOldCRC()));
    }

    public final void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.isDirty()) {
            this.status.markDirty(LocalTimeCounter.currentTime(), ProjectStatus.ModificationType.EXTERNAL);
        }
        this.settingsFilesStatus.set(new SettingsFilesStatus(MapsKt.toMap(state.getSettingsFiles())));
    }

    private final void submitSettingsFilesRefreshAndCRCCalculation(Object id2, Function1<? super Map<String, Long>, Unit> callback2) {
        this.submitSettingsFilesRefresh((Function1<? super Set<String>, Unit>)((Function1)new Function1<Set<? extends String>, Unit>(this, id2, callback2){
            final /* synthetic */ ProjectSettingsTracker this$0;
            final /* synthetic */ Object $id;
            final /* synthetic */ Function1 $callback;

            public final void invoke(@NotNull Set<String> settingsPaths) {
                Intrinsics.checkNotNullParameter(settingsPaths, (String)"settingsPaths");
                ProjectSettingsTracker.access$submitSettingsFilesCRCCalculation(this.this$0, this.$id, settingsPaths, this.$callback);
            }
            {
                this.this$0 = projectSettingsTracker;
                this.$id = object;
                this.$callback = function1;
                super(1);
            }
        }));
    }

    private final void submitSettingsFilesCRCCalculation(Object id2, Function1<? super Map<String, Long>, Unit> callback2) {
        this.settingsProvider.supply((Function1<? super Set<String>, Unit>)((Function1)new Function1<Set<? extends String>, Unit>(this, id2, callback2){
            final /* synthetic */ ProjectSettingsTracker this$0;
            final /* synthetic */ Object $id;
            final /* synthetic */ Function1 $callback;

            public final void invoke(@NotNull Set<String> settingsPaths) {
                Intrinsics.checkNotNullParameter(settingsPaths, (String)"settingsPaths");
                ProjectSettingsTracker.access$submitSettingsFilesCRCCalculation(this.this$0, this.$id, settingsPaths, this.$callback);
            }
            {
                this.this$0 = projectSettingsTracker;
                this.$id = object;
                this.$callback = function1;
                super(1);
            }
        }), this.parentDisposable);
    }

    private final void submitSettingsFilesRefresh(Function1<? super Set<String>, Unit> callback2) {
        EdtAsyncSupplier.Companion.invokeOnEdt((Function0<Boolean>)((Function0)new Function0<Boolean>(this.settingsProvider){

            public final boolean invoke() {
                return ((ProjectSettingsProvider)this.receiver).isBlocking();
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this, callback2){
            final /* synthetic */ ProjectSettingsTracker this$0;
            final /* synthetic */ Function1 $callback;

            public final void invoke() {
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
                FileDocumentManager fileDocumentManager2 = fileDocumentManager;
                fileDocumentManager2.saveAllDocuments();
                ProjectSettingsTracker.access$getSettingsProvider$p(this.this$0).invalidate();
                ProjectSettingsTracker.access$getSettingsProvider$p(this.this$0).supply((Function1<? super Set<String>, Unit>)((Function1)new Function1<Set<? extends String>, Unit>(this){
                    final /* synthetic */ submitSettingsFilesRefresh.2 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Set<String> settingsPaths) {
                        void $this$mapTo$iv$iv;
                        Intrinsics.checkNotNullParameter(settingsPaths, (String)"settingsPaths");
                        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
                        Iterable $this$map$iv = settingsPaths;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Path path2 = Path.of((String)it, new String[0]);
                            collection.add(path2);
                        }
                        List settingsFiles = (List)destination$iv$iv;
                        localFileSystem2.refreshNioFiles((Iterable)settingsFiles, ProjectSettingsTracker.access$getProjectTracker$p(this.this$0.this$0).isAsyncChangesProcessing(), false, new Runnable(this, settingsPaths){
                            final /* synthetic */ submitSettingsFilesRefresh.1 this$0;
                            final /* synthetic */ Set $settingsPaths;

                            public final void run() {
                                this.this$0.this$0.$callback.invoke((Object)this.$settingsPaths);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$settingsPaths = set2;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), ProjectSettingsTracker.access$getParentDisposable$p(this.this$0));
            }
            {
                this.this$0 = projectSettingsTracker;
                this.$callback = function1;
                super(0);
            }
        }), this.parentDisposable);
    }

    private final void submitSettingsFilesCRCCalculation(Object id2, Set<String> settingsPaths, Function1<? super Map<String, Long>, Unit> callback2) {
        ReadAsyncSupplier.Companion.readAction((Function0<Boolean>)((Function0)new Function0<Boolean>(this.settingsProvider){

            public final boolean invoke() {
                return ((ProjectSettingsProvider)this.receiver).isBlocking();
            }
        }), (Function0)new Function0<Map<String, ? extends Long>>(this, settingsPaths){
            final /* synthetic */ ProjectSettingsTracker this$0;
            final /* synthetic */ Set $settingsPaths;

            @NotNull
            public final Map<String, Long> invoke() {
                return ProjectSettingsTracker.access$calculateSettingsFilesCRC(this.this$0, this.$settingsPaths);
            }
            {
                this.this$0 = projectSettingsTracker;
                this.$settingsPaths = set2;
                super(0);
            }
        }, this.backgroundExecutor, this, id2).supply(callback2, this.parentDisposable);
    }

    public final void beforeApplyChanges(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.applyChangesOperation.beforeOperation(listener2);
    }

    public final void afterApplyChanges(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.applyChangesOperation.afterOperation(listener2);
    }

    public ProjectSettingsTracker(@NotNull Project project, @NotNull AutoImportProjectTracker projectTracker, @NotNull Executor backgroundExecutor, @NotNull ExternalSystemProjectAware projectAware, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectTracker, (String)"projectTracker");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        Intrinsics.checkNotNullParameter((Object)projectAware, (String)"projectAware");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.projectTracker = projectTracker;
        this.backgroundExecutor = backgroundExecutor;
        this.projectAware = projectAware;
        this.parentDisposable = parentDisposable;
        this.status = new ProjectStatus("Settings " + this.projectAware.getProjectId().getReadableName());
        this.settingsFilesStatus = new AtomicReference<SettingsFilesStatus>(new SettingsFilesStatus(null, null, null, null, null, 31, null));
        this.applyChangesOperation = new AnonymousParallelOperationTrace("Apply changes operation");
        this.settingsProvider = new ProjectSettingsProvider();
        ExternalSystemProjectRefreshListener projectRefreshListener2 = new ExternalSystemProjectRefreshListener(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            public void beforeProjectRefresh() {
                ProjectSettingsTracker.access$getApplyChangesOperation$p(this.this$0).startTask();
                ProjectSettingsTracker.access$applyChanges(this.this$0);
            }

            public void afterProjectRefresh(@NotNull ExternalSystemRefreshStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                ProjectSettingsTracker.access$applyUnknownChanges(this.this$0);
                ProjectSettingsTracker.access$getApplyChangesOperation$p(this.this$0).finishTask();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.projectAware.subscribe(projectRefreshListener2, this.parentDisposable);
        NewFilesListener.Companion.whenNewFilesCreated((Function0<Unit>)((Function0)new Function0<Unit>(this.settingsProvider){

            public final void invoke() {
                ((ProjectSettingsProvider)this.receiver).invalidate();
            }
        }), this.parentDisposable);
        AsyncFilesChangesListener.Companion.subscribeOnDocumentsAndVirtualFilesChanges(this.settingsProvider, new ProjectSettingsListener(), this.parentDisposable);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026ternalSystem.autoimport\")");
        LOG = logger;
    }

    public static final /* synthetic */ AtomicReference access$getSettingsFilesStatus$p(ProjectSettingsTracker $this) {
        return $this.settingsFilesStatus;
    }

    public static final /* synthetic */ SettingsFilesStatus access$createSettingsFilesStatus(ProjectSettingsTracker $this, Map oldSettingsFilesCRC, Map newSettingsFilesCRC) {
        return $this.createSettingsFilesStatus(oldSettingsFilesCRC, newSettingsFilesCRC);
    }

    public static final /* synthetic */ void access$submitSettingsFilesCRCCalculation(ProjectSettingsTracker $this, Object id2, Set settingsPaths, Function1 callback2) {
        $this.submitSettingsFilesCRCCalculation(id2, settingsPaths, (Function1<? super Map<String, Long>, Unit>)callback2);
    }

    public static final /* synthetic */ ProjectSettingsProvider access$getSettingsProvider$p(ProjectSettingsTracker $this) {
        return $this.settingsProvider;
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(ProjectSettingsTracker $this) {
        return $this.parentDisposable;
    }

    public static final /* synthetic */ Map access$calculateSettingsFilesCRC(ProjectSettingsTracker $this, Set settingsFiles) {
        return $this.calculateSettingsFilesCRC(settingsFiles);
    }

    public static final /* synthetic */ void access$applyChanges(ProjectSettingsTracker $this) {
        $this.applyChanges();
    }

    public static final /* synthetic */ void access$applyUnknownChanges(ProjectSettingsTracker $this) {
        $this.applyUnknownChanges();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "", "isDirty", "", "settingsFiles", "", "", "", "(ZLjava/util/Map;)V", "()Z", "setDirty", "(Z)V", "getSettingsFiles", "()Ljava/util/Map;", "setSettingsFiles", "(Ljava/util/Map;)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    public static final class State {
        private boolean isDirty;
        @NotNull
        private Map<String, Long> settingsFiles;

        public final boolean isDirty() {
            return this.isDirty;
        }

        public final void setDirty(boolean bl) {
            this.isDirty = bl;
        }

        @NotNull
        public final Map<String, Long> getSettingsFiles() {
            return this.settingsFiles;
        }

        public final void setSettingsFiles(@NotNull Map<String, Long> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.settingsFiles = map2;
        }

        public State(boolean isDirty, @NotNull Map<String, Long> settingsFiles) {
            Intrinsics.checkNotNullParameter(settingsFiles, (String)"settingsFiles");
            this.isDirty = isDirty;
            this.settingsFiles = settingsFiles;
        }

        public /* synthetic */ State(boolean bl, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                map2 = MapsKt.emptyMap();
            }
            this(bl, map2);
        }

        public State() {
            this(false, null, 3, null);
        }

        public final boolean component1() {
            return this.isDirty;
        }

        @NotNull
        public final Map<String, Long> component2() {
            return this.settingsFiles;
        }

        @NotNull
        public final State copy(boolean isDirty, @NotNull Map<String, Long> settingsFiles) {
            Intrinsics.checkNotNullParameter(settingsFiles, (String)"settingsFiles");
            return new State(isDirty, settingsFiles);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.isDirty;
            }
            if ((n & 2) != 0) {
                map2 = state.settingsFiles;
            }
            return state.copy(bl, map2);
        }

        @NotNull
        public String toString() {
            return "State(isDirty=" + this.isDirty + ", settingsFiles=" + this.settingsFiles + ")";
        }

        public int hashCode() {
            int n = this.isDirty ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            Map<String, Long> map2 = this.settingsFiles;
            return n * 31 + (map2 != null ? ((Object)map2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (this.isDirty != state.isDirty || !Intrinsics.areEqual(this.settingsFiles, state.settingsFiles)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006Ba\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u00c6\u0003Je\u0010\u001a\u001a\u00020\u00002\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\u0006\u0010\u001f\u001a\u00020\u001cJ\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0004H\u00d6\u0001R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesStatus;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesReloadContext;", "CRC", "", "", "", "(Ljava/util/Map;)V", "oldCRC", "newCRC", "updated", "", "created", "deleted", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getCreated", "()Ljava/util/Set;", "getDeleted", "getNewCRC", "()Ljava/util/Map;", "getOldCRC", "getUpdated", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hasChanges", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    private static final class SettingsFilesStatus
    implements ExternalSystemSettingsFilesReloadContext {
        @NotNull
        private final Map<String, Long> oldCRC;
        @NotNull
        private final Map<String, Long> newCRC;
        @NotNull
        private final Set<String> updated;
        @NotNull
        private final Set<String> created;
        @NotNull
        private final Set<String> deleted;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasChanges() {
            Collection collection = this.getUpdated();
            boolean bl = false;
            if (!collection.isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            collection = this.getCreated();
            bl = false;
            if (!collection.isEmpty()) {
                return true;
            }
            boolean bl3 = false;
            if (bl3) return true;
            collection = this.getDeleted();
            bl = false;
            if (collection.isEmpty()) return false;
            return true;
        }

        @NotNull
        public final Map<String, Long> getOldCRC() {
            return this.oldCRC;
        }

        @NotNull
        public final Map<String, Long> getNewCRC() {
            return this.newCRC;
        }

        @NotNull
        public Set<String> getUpdated() {
            return this.updated;
        }

        @NotNull
        public Set<String> getCreated() {
            return this.created;
        }

        @NotNull
        public Set<String> getDeleted() {
            return this.deleted;
        }

        public SettingsFilesStatus(@NotNull Map<String, Long> oldCRC, @NotNull Map<String, Long> newCRC, @NotNull Set<String> updated, @NotNull Set<String> created, @NotNull Set<String> deleted) {
            Intrinsics.checkNotNullParameter(oldCRC, (String)"oldCRC");
            Intrinsics.checkNotNullParameter(newCRC, (String)"newCRC");
            Intrinsics.checkNotNullParameter(updated, (String)"updated");
            Intrinsics.checkNotNullParameter(created, (String)"created");
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
            this.oldCRC = oldCRC;
            this.newCRC = newCRC;
            this.updated = updated;
            this.created = created;
            this.deleted = deleted;
        }

        public /* synthetic */ SettingsFilesStatus(Map map2, Map map3, Set set2, Set set3, Set set4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 2) != 0) {
                map3 = MapsKt.emptyMap();
            }
            if ((n & 4) != 0) {
                set2 = SetsKt.emptySet();
            }
            if ((n & 8) != 0) {
                set3 = SetsKt.emptySet();
            }
            if ((n & 0x10) != 0) {
                set4 = SetsKt.emptySet();
            }
            this(map2, map3, set2, set3, set4);
        }

        public SettingsFilesStatus() {
            this(null, null, null, null, null, 31, null);
        }

        public SettingsFilesStatus(@NotNull Map<String, Long> CRC) {
            Intrinsics.checkNotNullParameter(CRC, (String)"CRC");
            this(CRC, null, null, null, null, 30, null);
        }

        @NotNull
        public final Map<String, Long> component1() {
            return this.oldCRC;
        }

        @NotNull
        public final Map<String, Long> component2() {
            return this.newCRC;
        }

        @NotNull
        public final Set<String> component3() {
            return this.getUpdated();
        }

        @NotNull
        public final Set<String> component4() {
            return this.getCreated();
        }

        @NotNull
        public final Set<String> component5() {
            return this.getDeleted();
        }

        @NotNull
        public final SettingsFilesStatus copy(@NotNull Map<String, Long> oldCRC, @NotNull Map<String, Long> newCRC, @NotNull Set<String> updated, @NotNull Set<String> created, @NotNull Set<String> deleted) {
            Intrinsics.checkNotNullParameter(oldCRC, (String)"oldCRC");
            Intrinsics.checkNotNullParameter(newCRC, (String)"newCRC");
            Intrinsics.checkNotNullParameter(updated, (String)"updated");
            Intrinsics.checkNotNullParameter(created, (String)"created");
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
            return new SettingsFilesStatus(oldCRC, newCRC, updated, created, deleted);
        }

        public static /* synthetic */ SettingsFilesStatus copy$default(SettingsFilesStatus settingsFilesStatus2, Map map2, Map map3, Set set2, Set set3, Set set4, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = settingsFilesStatus2.oldCRC;
            }
            if ((n & 2) != 0) {
                map3 = settingsFilesStatus2.newCRC;
            }
            if ((n & 4) != 0) {
                set2 = settingsFilesStatus2.getUpdated();
            }
            if ((n & 8) != 0) {
                set3 = settingsFilesStatus2.getCreated();
            }
            if ((n & 0x10) != 0) {
                set4 = settingsFilesStatus2.getDeleted();
            }
            return settingsFilesStatus2.copy(map2, map3, set2, set3, set4);
        }

        @NotNull
        public String toString() {
            return "SettingsFilesStatus(oldCRC=" + this.oldCRC + ", newCRC=" + this.newCRC + ", updated=" + this.getUpdated() + ", created=" + this.getCreated() + ", deleted=" + this.getDeleted() + ")";
        }

        public int hashCode() {
            Map<String, Long> map2 = this.oldCRC;
            Map<String, Long> map3 = this.newCRC;
            Set<String> set2 = this.getUpdated();
            Set<String> set3 = this.getCreated();
            Set<String> set4 = this.getDeleted();
            return ((((map2 != null ? ((Object)map2).hashCode() : 0) * 31 + (map3 != null ? ((Object)map3).hashCode() : 0)) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0)) * 31 + (set3 != null ? ((Object)set3).hashCode() : 0)) * 31 + (set4 != null ? ((Object)set4).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SettingsFilesStatus)) break block3;
                    SettingsFilesStatus settingsFilesStatus2 = (SettingsFilesStatus)object;
                    if (!Intrinsics.areEqual(this.oldCRC, settingsFilesStatus2.oldCRC) || !Intrinsics.areEqual(this.newCRC, settingsFilesStatus2.newCRC) || !Intrinsics.areEqual(this.getUpdated(), settingsFilesStatus2.getUpdated()) || !Intrinsics.areEqual(this.getCreated(), settingsFilesStatus2.getCreated()) || !Intrinsics.areEqual(this.getDeleted(), settingsFilesStatus2.getDeleted())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$ProjectSettingsListener;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;)V", "apply", "", "logModificationAsDebug", "path", "", "modificationStamp", "", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "onFileChange", "modificationType", "intellij.platform.externalSystem.impl"})
    private final class ProjectSettingsListener
    implements FilesChangesListener {
        @Override
        public void onFileChange(@NotNull String path2, long modificationStamp, @NotNull ProjectStatus.ModificationType modificationType) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)((Object)modificationType), (String)"modificationType");
            this.logModificationAsDebug(path2, modificationStamp, modificationType);
            if (ProjectSettingsTracker.this.applyChangesOperation.isOperationCompleted()) {
                ProjectSettingsTracker.this.status.markModified(LocalTimeCounter.currentTime(), modificationType);
            } else {
                ProjectSettingsTracker.this.status.markDirty(LocalTimeCounter.currentTime(), modificationType);
            }
        }

        @Override
        public void apply() {
            ProjectSettingsTracker.this.submitSettingsFilesCRCCalculation("apply", (Function1<? super Map<String, Long>, Unit>)((Function1)new Function1<Map<String, ? extends Long>, Unit>(this){
                final /* synthetic */ ProjectSettingsListener this$0;

                public final void invoke(@NotNull Map<String, Long> newSettingsFilesCRC) {
                    Intrinsics.checkNotNullParameter(newSettingsFilesCRC, (String)"newSettingsFilesCRC");
                    SettingsFilesStatus settingsFilesStatus2 = (SettingsFilesStatus)ProjectSettingsTracker.access$getSettingsFilesStatus$p(this.this$0.ProjectSettingsTracker.this).updateAndGet(new UnaryOperator(this, newSettingsFilesCRC){
                        final /* synthetic */ apply.1 this$0;
                        final /* synthetic */ Map $newSettingsFilesCRC;

                        public final SettingsFilesStatus apply(SettingsFilesStatus it) {
                            return ProjectSettingsTracker.access$createSettingsFilesStatus(this.this$0.this$0.ProjectSettingsTracker.this, it.getOldCRC(), this.$newSettingsFilesCRC);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$newSettingsFilesCRC = map2;
                        }
                    });
                    if (!settingsFilesStatus2.hasChanges()) {
                        ProjectSettingsTracker.access$getStatus$p(this.this$0.ProjectSettingsTracker.this).markReverted(LocalTimeCounter.currentTime());
                    }
                    ProjectSettingsTracker.access$getProjectTracker$p(this.this$0.ProjectSettingsTracker.this).scheduleChangeProcessing();
                }
                {
                    this.this$0 = projectSettingsListener;
                    super(1);
                }
            }));
        }

        private final void logModificationAsDebug(String path2, long modificationStamp, ProjectStatus.ModificationType type) {
            if (LOG.isDebugEnabled()) {
                String projectPath = ProjectSettingsTracker.this.projectAware.getProjectId().getExternalProjectPath();
                String string = FileUtil.getRelativePath((String)projectPath, (String)path2, (char)'/');
                if (string == null) {
                    string = path2;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.getRelativePath\u2026tPath, path, '/') ?: path");
                String relativePath = string;
                LOG.debug("File " + relativePath + " is modified at " + modificationStamp + " as " + (Object)((Object)type));
            }
        }

        @Override
        public void init() {
            FilesChangesListener.DefaultImpls.init(this);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$ProjectSettingsProvider;", "Lcom/intellij/openapi/externalSystem/autoimport/settings/CachingAsyncSupplier;", "", "", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;)V", "get", "isBlocking", "", "supply", "", "callback", "Lkotlin/Function1;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.externalSystem.impl"})
    private final class ProjectSettingsProvider
    extends CachingAsyncSupplier<Set<? extends String>> {
        @Override
        @NotNull
        public Set<String> get() {
            return ProjectSettingsTracker.this.projectAware.getSettingsFiles();
        }

        @Override
        public boolean isBlocking() {
            return !ProjectSettingsTracker.this.projectTracker.isAsyncChangesProcessing();
        }

        @Override
        public void supply(@NotNull Function1<? super Set<String>, Unit> callback2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            super.supply((Function1)new Function1<Set<? extends String>, Unit>(this, callback2){
                final /* synthetic */ ProjectSettingsProvider this$0;
                final /* synthetic */ Function1 $callback;

                public final void invoke(@NotNull Set<String> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.$callback.invoke((Object)SetsKt.plus(it, (Iterable)((SettingsFilesStatus)ProjectSettingsTracker.access$getSettingsFilesStatus$p(this.this$0.ProjectSettingsTracker.this).get()).getOldCRC().keySet()));
                }
                {
                    this.this$0 = projectSettingsProvider;
                    this.$callback = function1;
                    super(1);
                }
            }, parentDisposable);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

