/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineFragment;
import java.awt.Graphics2D;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

class TabFragment
implements LineFragment {
    private final EditorView myView;
    private final Editor myEditor;

    TabFragment(EditorView view) {
        this.myView = view;
        this.myEditor = view.getEditor();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        int tabSize = this.myView.getTabSize();
        return tabSize - startColumn % tabSize;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        float x = this.getNextTabStop(startX);
        return EditorUtil.columnsNumber(x - startX, this.myView.getPlainSpaceWidth());
    }

    @Override
    public Consumer<Graphics2D> draw(float x, float y, int startColumn, int endColumn) {
        return g -> {};
    }

    @Override
    @NotNull
    public LineFragment subFragment(int startOffset, int endOffset) {
        TabFragment tabFragment = this;
        if (tabFragment == null) {
            TabFragment.$$$reportNull$$$0(0);
        }
        return tabFragment;
    }

    @Override
    public float offsetToX(float startX, int startOffset, int offset) {
        return TabFragment.trimOffset(offset) <= TabFragment.trimOffset(startOffset) ? startX : this.getNextTabStop(startX);
    }

    @Override
    public int logicalToVisualColumn(float startX, int startColumn, int column2) {
        int visualColumnCount = this.getVisualColumnCount(startX);
        int logicalColumnCount = this.getLogicalColumnCount(startColumn);
        return column2 == logicalColumnCount ? visualColumnCount : Math.min(column2, visualColumnCount - 1);
    }

    @Override
    public int visualToLogicalColumn(float startX, int startColumn, int column2) {
        int visualColumnCount = this.getVisualColumnCount(startX);
        int logicalColumnCount = this.getLogicalColumnCount(startColumn);
        return column2 == visualColumnCount ? logicalColumnCount : Math.min(column2, logicalColumnCount - 1);
    }

    @Override
    public int visualColumnToOffset(float startX, int column2) {
        int visualColumnCount = this.getVisualColumnCount(startX);
        return column2 == visualColumnCount ? 1 : 0;
    }

    @Override
    public int[] xToVisualColumn(float startX, float x) {
        boolean closerToLargerColumns;
        int column2;
        if (x <= startX) {
            return new int[]{0, 0};
        }
        float nextTabStop = this.getNextTabStop(startX);
        if (x > nextTabStop) {
            return new int[]{this.getVisualColumnCount(startX), 1};
        }
        if (this.myEditor.getSettings().isCaretInsideTabs()) {
            float plainSpaceWidth = this.myView.getPlainSpaceWidth();
            column2 = Math.round((x - startX) / plainSpaceWidth);
            closerToLargerColumns = x - startX > (float)column2 * plainSpaceWidth;
        } else {
            column2 = x > (startX + nextTabStop) / 2.0f ? this.getVisualColumnCount(startX) : 0;
            closerToLargerColumns = column2 == 0;
        }
        return new int[]{column2, closerToLargerColumns ? 1 : 0};
    }

    @Override
    public float visualColumnToX(float startX, int column2) {
        if (column2 <= 0) {
            return startX;
        }
        if (column2 >= this.getVisualColumnCount(startX)) {
            return this.getNextTabStop(startX);
        }
        return startX + this.myView.getPlainSpaceWidth() * (float)column2;
    }

    private static int trimOffset(int offset) {
        return offset <= 0 ? 0 : 1;
    }

    private float getNextTabStop(float x) {
        int leftInset = this.myView.getInsets().left;
        return EditorUtil.nextTabStop(x - (float)leftInset, this.myView.getPlainSpaceWidth(), this.myView.getTabSize()) + (float)leftInset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TabFragment", "subFragment"));
    }
}

