/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.FilteringMarkupIterator;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.TextRange;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

final class RangeHighlighterTree
extends RangeMarkerTree<RangeHighlighterEx> {
    private final MarkupModelEx myMarkupModel;

    RangeHighlighterTree(@NotNull Document document, @NotNull MarkupModelEx markupModel) {
        if (document == null) {
            RangeHighlighterTree.$$$reportNull$$$0(0);
        }
        if (markupModel == null) {
            RangeHighlighterTree.$$$reportNull$$$0(1);
        }
        super(document);
        this.myMarkupModel = markupModel;
    }

    @Override
    protected boolean keepIntervalsOnWeakReferences() {
        return false;
    }

    @NotNull
    MarkupIterator<RangeHighlighterEx> overlappingIterator(@NotNull TextRange rangeInterval, boolean onlyRenderedInGutter) {
        if (rangeInterval == null) {
            RangeHighlighterTree.$$$reportNull$$$0(2);
        }
        MarkupIterator iterator2 = this.overlappingIterator(rangeInterval, node -> !onlyRenderedInGutter || node.isFlagSet((byte)64));
        return new FilteringMarkupIterator<RangeHighlighterEx>(iterator2, highlighter -> !onlyRenderedInGutter || highlighter.isRenderedInGutter());
    }

    void updateRenderedFlags(RangeHighlighterEx highlighter) {
        RHNode node = (RHNode)this.lookupNode(highlighter);
        if (node != null) {
            node.recalculateRenderFlagsUp();
        }
    }

    @Override
    void correctMax(@NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> node, int deltaUpToRoot) {
        if (node == null) {
            RangeHighlighterTree.$$$reportNull$$$0(3);
        }
        super.correctMax(node, deltaUpToRoot);
        ((RHNode)node).recalculateRenderFlags();
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i1, @NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i2) {
        boolean persistent2;
        if (i1 == null) {
            RangeHighlighterTree.$$$reportNull$$$0(4);
        }
        if (i2 == null) {
            RangeHighlighterTree.$$$reportNull$$$0(5);
        }
        RHNode o1 = (RHNode)i1;
        RHNode o2 = (RHNode)i2;
        int d = o2.myLayer - o1.myLayer;
        if (d != 0) {
            return d;
        }
        int result2 = super.compareEqualStartIntervals(i1, i2);
        if (result2 != 0) {
            return result2;
        }
        boolean persistent1 = o1.isFlagSet((byte)-128);
        return persistent1 == (persistent2 = o2.isFlagSet((byte)-128)) ? 0 : (persistent1 ? -1 : 1);
    }

    @NotNull
    protected RHNode createNewNode(@NotNull RangeHighlighterEx key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (key == null) {
            RangeHighlighterTree.$$$reportNull$$$0(6);
        }
        return new RHNode(this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight, layer);
    }

    @Override
    void fireBeforeRemoved(@NotNull RangeHighlighterEx markerEx, @NotNull Object reason) {
        if (markerEx == null) {
            RangeHighlighterTree.$$$reportNull$$$0(7);
        }
        if (reason == null) {
            RangeHighlighterTree.$$$reportNull$$$0(8);
        }
        this.myMarkupModel.fireBeforeRemoved(markerEx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInterval";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerEx";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/RangeHighlighterTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "overlappingIterator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "correctMax";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "compareEqualStartIntervals";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewNode";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBeforeRemoved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class RHNode
    extends RangeMarkerTree.RMNode<RangeHighlighterEx> {
        private static final byte RENDERED_IN_GUTTER_FLAG = 64;
        static final byte IS_PERSISTENT = -128;
        final int myLayer;

        RHNode(@NotNull RangeHighlighterTree rangeMarkerTree, @NotNull RangeHighlighterEx key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            if (rangeMarkerTree == null) {
                RHNode.$$$reportNull$$$0(0);
            }
            if (key == null) {
                RHNode.$$$reportNull$$$0(1);
            }
            super(rangeMarkerTree, key, start2, end, greedyToLeft, greedyToRight, stickingToRight);
            this.myLayer = layer;
            this.setFlag((byte)-128, key.isPersistent());
        }

        private void recalculateRenderFlags() {
            RedBlackTree.Node right;
            boolean renderedInGutter = false;
            for (Supplier getter : this.intervals) {
                RangeHighlighterEx h = (RangeHighlighterEx)getter.get();
                renderedInGutter |= h.isRenderedInGutter();
            }
            RedBlackTree.Node left = this.getLeft();
            if (left != null) {
                renderedInGutter |= left.isFlagSet((byte)64);
            }
            if ((right = this.getRight()) != null) {
                renderedInGutter |= right.isFlagSet((byte)64);
            }
            this.setFlag((byte)64, renderedInGutter);
        }

        private void recalculateRenderFlagsUp() {
            for (RHNode n = this; n != null; n = (RHNode)n.getParent()) {
                boolean prevInGutter = n.isFlagSet((byte)64);
                n.recalculateRenderFlags();
                if (n.isFlagSet((byte)64) == prevInGutter) break;
            }
        }

        @Override
        void addInterval(@NotNull RangeHighlighterEx h) {
            if (h == null) {
                RHNode.$$$reportNull$$$0(2);
            }
            super.addInterval(h);
            if (!this.isFlagSet((byte)64) && h.isRenderedInGutter()) {
                this.recalculateRenderFlagsUp();
            }
        }

        @Override
        void removeIntervalInternal(int i2) {
            RangeHighlighterEx h = (RangeHighlighterEx)((Supplier)this.intervals.get(i2)).get();
            boolean recalculateFlags = h.isRenderedInGutter();
            super.removeIntervalInternal(i2);
            if (recalculateFlags) {
                this.recalculateRenderFlagsUp();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeMarkerTree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "h";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/RangeHighlighterTree$RHNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addInterval";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

