/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModelManager;
import com.intellij.openapi.editor.impl.EmptyMarkupModel;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocumentMarkupModel {
    private static final Key<MarkupModelEx> MARKUP_MODEL_KEY = Key.create((String)"DocumentMarkupModel.MarkupModel");
    private static final Key<ConcurrentMap<Project, MarkupModelImpl>> MARKUP_MODEL_MAP_KEY = Key.create((String)"DocumentMarkupModel.MarkupModelMap");

    private DocumentMarkupModel() {
    }

    @Contract(value="_,_,true -> !null")
    public static MarkupModel forDocument(@NotNull Document document, @Nullable Project project, boolean create2) {
        DocumentMarkupModelManager documentMarkupModelManager;
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(0);
        }
        if (document instanceof DocumentWindow) {
            Document delegate2 = ((DocumentWindow)document).getDelegate();
            MarkupModelEx baseMarkupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(delegate2, project, true);
            return new MarkupModelWindow(baseMarkupModel, (DocumentWindow)document);
        }
        if (project == null) {
            MarkupModelImpl newModel;
            MarkupModelEx markupModel = (MarkupModelEx)document.getUserData(MARKUP_MODEL_KEY);
            if (create2 && markupModel == null && (markupModel = (MarkupModelEx)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_KEY, (Object)(newModel = new MarkupModelImpl((DocumentEx)document)))) != newModel) {
                newModel.dispose();
            }
            return markupModel;
        }
        DocumentMarkupModelManager documentMarkupModelManager2 = documentMarkupModelManager = project.isDisposed() ? null : DocumentMarkupModelManager.getInstance(project);
        if (documentMarkupModelManager == null || documentMarkupModelManager.isDisposed() || project.isDisposed()) {
            return new EmptyMarkupModel(document);
        }
        ConcurrentMap<Project, MarkupModelImpl> markupModelMap = DocumentMarkupModel.getMarkupModelMap(document);
        MarkupModelImpl model2 = (MarkupModelImpl)markupModelMap.get(project);
        if (create2 && model2 == null) {
            MarkupModelImpl newModel = new MarkupModelImpl((DocumentEx)document);
            model2 = (MarkupModelImpl)ConcurrencyUtil.cacheOrGet(markupModelMap, (Object)project, (Object)newModel);
            if (model2 == newModel) {
                documentMarkupModelManager.registerDocument(document);
            } else {
                newModel.dispose();
            }
        }
        return model2;
    }

    @NotNull
    private static ConcurrentMap<Project, MarkupModelImpl> getMarkupModelMap(@NotNull Document document) {
        ConcurrentMap markupModelMap;
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(1);
        }
        if ((markupModelMap = (ConcurrentMap)document.getUserData(MARKUP_MODEL_MAP_KEY)) == null) {
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            markupModelMap = (ConcurrentMap)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_MAP_KEY, newMap);
        }
        ConcurrentMap concurrentMap = markupModelMap;
        if (concurrentMap == null) {
            DocumentMarkupModel.$$$reportNull$$$0(2);
        }
        return concurrentMap;
    }

    static void removeMarkupModel(@NotNull Document document, @NotNull Project project) {
        MarkupModelImpl removed;
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DocumentMarkupModel.$$$reportNull$$$0(4);
        }
        if ((removed = (MarkupModelImpl)DocumentMarkupModel.getMarkupModelMap(document).remove(project)) != null) {
            removed.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/DocumentMarkupModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/DocumentMarkupModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkupModelMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forDocument";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMarkupModelMap";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeMarkupModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

