/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class DefaultRawTypedHandler
implements TypedActionHandlerEx {
    private final TypedAction myAction;
    private CommandToken myCurrentCommandToken;
    private boolean myInOuterCommand;

    DefaultRawTypedHandler(TypedAction action2) {
        this.myAction = action2;
    }

    public void beforeExecute(@NotNull Editor editor, char c, @NotNull DataContext context2, @NotNull ActionPlan plan) {
        if (editor == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(1);
        }
        if (plan == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(2);
        }
        if (editor.isViewer() || !editor.getDocument().isWritable()) {
            return;
        }
        TypedActionHandler handler2 = this.myAction.getHandler();
        if (handler2 instanceof TypedActionHandlerEx) {
            ((TypedActionHandlerEx)handler2).beforeExecute(editor, c, context2, plan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final @NotNull Editor editor, final char charTyped, final @NotNull DataContext dataContext) {
        if (editor == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            DefaultRawTypedHandler.$$$reportNull$$$0(4);
        }
        CommandProcessorEx commandProcessorEx = (CommandProcessorEx)CommandProcessor.getInstance();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (this.myCurrentCommandToken != null) {
            throw new IllegalStateException("Unexpected reentrancy of DefaultRawTypedHandler");
        }
        this.myCurrentCommandToken = commandProcessorEx.startCommand(project, "", editor.getDocument(), UndoConfirmationPolicy.DEFAULT);
        this.myInOuterCommand = this.myCurrentCommandToken == null;
        try {
            if (!EditorModificationUtil.requestWriting((Editor)editor)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new DocumentRunnable(editor.getDocument(), editor.getProject()){

                public void run() {
                    Document doc = editor.getDocument();
                    doc.startGuardedBlockChecking();
                    try {
                        DefaultRawTypedHandler.this.myAction.getHandler().execute(editor, charTyped, dataContext);
                    }
                    catch (ReadOnlyFragmentModificationException e) {
                        EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                    }
                    finally {
                        doc.stopGuardedBlockChecking();
                    }
                }
            });
        }
        finally {
            if (!this.myInOuterCommand) {
                commandProcessorEx.finishCommand(this.myCurrentCommandToken, null);
                this.myCurrentCommandToken = null;
            }
            this.myInOuterCommand = false;
        }
    }

    public void beginUndoablePostProcessing() {
        if (this.myInOuterCommand) {
            return;
        }
        if (this.myCurrentCommandToken == null) {
            throw new IllegalStateException("Not in a typed action at this time");
        }
        CommandProcessorEx commandProcessorEx = (CommandProcessorEx)CommandProcessor.getInstance();
        Project project = this.myCurrentCommandToken.getProject();
        commandProcessorEx.finishCommand(this.myCurrentCommandToken, null);
        this.myCurrentCommandToken = commandProcessorEx.startCommand(project, "", null, UndoConfirmationPolicy.DEFAULT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plan";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/DefaultRawTypedHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeExecute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

